/*
 * Decompiled with CFR 0.152.
 */
package net.xstopho.resourceconfigapi.builder;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.xstopho.resourceconfigapi.builder.IResourceConfigBuilder;
import net.xstopho.resourceconfigapi.config.entry.ConfigEntry;
import net.xstopho.resourceconfigapi.config.values.ConfigValue;

public abstract class ResourceConfigBuilderBase
implements IResourceConfigBuilder {
    private String category;
    private String comment;
    private boolean sync;
    private String translation;
    private Map<String, ConfigEntry<?>> entries = new LinkedHashMap();
    private Map<String, String> categoryComments = new LinkedHashMap<String, String>();

    @Override
    public Map<String, ConfigEntry<?>> getEntries() {
        return this.entries;
    }

    @Override
    public Map<String, String> getCategoryComment() {
        return this.categoryComments;
    }

    public String getComment() {
        return this.comment;
    }

    @Override
    public IResourceConfigBuilder push(String category) {
        if (!this.isEmpty(this.category)) {
            throw new IllegalArgumentException("Category '" + this.category + "' is already set! Use pop() before pushing a new Category.");
        }
        this.categoryComments.put(category, this.comment);
        this.category = category;
        this.comment = null;
        return this;
    }

    @Override
    public IResourceConfigBuilder pop() {
        if (this.isEmpty(this.category)) {
            throw new IllegalArgumentException("Failed to remove Category, because there isn't a Category to remove!");
        }
        this.category = null;
        return this;
    }

    @Override
    public IResourceConfigBuilder comment(String comment) {
        this.comment = this.isEmpty(this.comment) ? " " + comment : this.comment + "\n " + comment;
        return this;
    }

    @Override
    public IResourceConfigBuilder translation(String key) {
        if (this.translation == null) {
            throw new IllegalArgumentException("You already defined an translation key!");
        }
        this.translation = key;
        return this;
    }

    @Override
    public IResourceConfigBuilder sync() {
        this.sync = true;
        return this;
    }

    <T> Supplier<T> createEntry(String path, ConfigValue<T> configValue) {
        if (this.entries.containsKey(path)) {
            throw new IllegalStateException("Key '" + path + "' is already defined!");
        }
        ConfigEntry<T> entry = new ConfigEntry<T>(path, configValue, this.translation, this.sync);
        this.addEntry(path, entry);
        return entry::getValue;
    }

    private void addEntry(String path, ConfigEntry<?> configEntry) {
        this.entries.put(path, configEntry);
        this.sync = false;
        this.comment = null;
    }

    protected String createKey(String key) {
        if (this.isEmpty(key)) {
            throw new IllegalArgumentException("Key can't be null or empty!");
        }
        if (!this.isEmpty(this.category)) {
            return this.category + "." + key;
        }
        return key;
    }
}

