/*
 * Decompiled with CFR 0.152.
 */
package net.xstopho.resourceconfigapi.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.InMemoryCommentedFormat;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.core.io.ParsingException;
import com.electronwill.nightconfig.core.io.WritingMode;
import com.electronwill.nightconfig.toml.TomlParser;
import com.electronwill.nightconfig.toml.TomlWriter;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import net.xstopho.resourceconfigapi.ResourceConfigConstants;
import net.xstopho.resourceconfigapi.builder.IResourceConfigBuilder;
import net.xstopho.resourceconfigapi.config.entry.ConfigEntry;
import net.xstopho.resourceconfigapi.config.values.ConfigValue;

public class ResourceModConfig {
    private final String modId;
    private final File file;
    private final IResourceConfigBuilder builder;
    private final TomlWriter writer = new TomlWriter();
    private final boolean disableRangedComments;
    private CommentedConfig config = CommentedConfig.inMemory();

    public ResourceModConfig(String modId, String fileName, IResourceConfigBuilder builder, Path configPath, boolean disableRangedComments) {
        this.file = new File(String.valueOf(configPath) + "/" + fileName + ".toml");
        this.disableRangedComments = disableRangedComments;
        this.createFilePathIfNeeded(configPath);
        this.builder = builder;
        this.modId = modId;
        this.readConfigFile();
        ArrayList entries = new ArrayList(builder.getEntries().values());
        entries.forEach(this::readConfigValues);
        this.config = CommentedConfig.of(LinkedHashMap::new, InMemoryCommentedFormat.withUniversalSupport());
        entries.forEach(this::writeConfigValues);
        this.writeConfigFile();
        entries.forEach(ConfigEntry::setLoaded);
    }

    void readConfigFile() {
        if (!this.file.exists()) {
            return;
        }
        try (FileReader reader = new FileReader(this.file);){
            this.config = new TomlParser().parse(reader);
        }
        catch (ParsingException | IOException e) {
            ResourceConfigConstants.LOG.error("Reading '{}' from mod '{}' failed!\nError: {}", new Object[]{this.file.getName(), this.modId, e.getMessage()});
        }
    }

    void writeConfigFile() {
        this.writeCategoryComments();
        this.writer.setIndentArrayElementsPredicate(objects -> true);
        this.writer.write((UnmodifiableConfig)this.config, this.file, WritingMode.REPLACE);
    }

    <T> void readConfigValues(ConfigEntry<T> entry) {
        String path = entry.getPath();
        T defaultValue = entry.getConfigValue().get();
        if (!this.config.contains(path) || !entry.getConfigValue().isValid(this.config.get(path))) {
            entry.setValue(defaultValue);
            ResourceConfigConstants.LOG.error("Config Entry key '{}' isn't correct and is set to its default value '{}'!", (Object)path, defaultValue);
        } else {
            entry.setValue(this.config.get(path));
        }
    }

    void writeConfigValues(ConfigEntry<?> entry) {
        this.writeValueComment(entry);
        this.config.set(entry.getPath(), entry.value());
    }

    void writeValueComment(ConfigEntry<?> entry) {
        ConfigValue<?> value = entry.getConfigValue();
        if (value.isRanged() && !this.disableRangedComments) {
            this.config.setComment(entry.getPath(), value.getRangedComment());
        } else if (value.hasComment()) {
            this.config.setComment(entry.getPath(), value.getComment());
        }
    }

    void writeCategoryComments() {
        for (Map.Entry<String, String> comment : this.builder.getCategoryComment().entrySet()) {
            this.config.setComment(comment.getKey(), comment.getValue());
        }
    }

    void createFilePathIfNeeded(Path path) {
        if (new File(path.toString()).mkdirs()) {
            ResourceConfigConstants.LOG.info("Created custom Config Path: '{}' for Mod: '{}'", (Object)path, (Object)this.modId);
        }
    }

    public IResourceConfigBuilder getBuilder() {
        return this.builder;
    }
}

