/*
 * Decompiled with CFR 0.152.
 */
package net.xstopho.resourceconfigapi.config.entry;

import net.xstopho.resourceconfigapi.config.values.ConfigValue;

public class ConfigEntry<T> {
    protected final String path;
    protected final String translation;
    protected final ConfigValue<T> configValue;
    protected final boolean sync;
    protected boolean isLoaded;
    protected boolean isSynced;
    private T value;
    private T serverValue;

    public ConfigEntry(String path, ConfigValue<T> configValue, String translation, boolean sync) {
        this.path = path;
        this.configValue = configValue;
        this.translation = translation;
        this.sync = sync;
    }

    public T getValue() {
        if (!this.isLoaded) {
            throw new IllegalStateException("Config isn't loaded yet!");
        }
        return this.isSynced ? this.serverValue : this.value;
    }

    public void setValue(T value) {
        this.value = value;
    }

    public void setServerValue(T value) {
        this.serverValue = value;
    }

    public String getPath() {
        return this.path;
    }

    public ConfigValue<T> getConfigValue() {
        return this.configValue;
    }

    public boolean syncWithServer() {
        return this.sync;
    }

    public void setLoaded() {
        this.isLoaded = true;
    }

    public void setSynced() {
        this.isSynced = true;
    }

    public T value() {
        return this.value;
    }

    public String getTranslation() {
        return this.translation;
    }
}

