/*
 * Decompiled with CFR 0.152.
 */
package net.xstopho.resourceconfigapi.config.values.primitive;

import java.util.function.Predicate;
import net.xstopho.resourceconfigapi.config.values.ConfigValue;

public class DoubleConfigValue
extends ConfigValue<Double> {
    private Double min;
    private Double max;

    public DoubleConfigValue(Double defaultValue, String comment) {
        super(defaultValue, comment);
    }

    public DoubleConfigValue(Double defaultValue, String comment, double min, double max) {
        this(defaultValue, comment);
        this.min = min;
        this.max = max;
        this.rangedComment = "Ranged: " + this.min + " ~ " + this.max;
    }

    @Override
    public boolean isValid(Object value) {
        Predicate<Object> predicate = o -> o instanceof Double;
        if (this.isRanged() && predicate.test(value)) {
            return (Double)value >= this.min && (Double)value <= this.max;
        }
        return !this.isRanged() && predicate.test(value);
    }
}

