/*
 * Decompiled with CFR 0.152.
 */
package net.xstopho.resourceconfigapi.config.values.primitive;

import java.util.function.Predicate;
import net.xstopho.resourceconfigapi.config.values.ConfigValue;

public class IntegerConfigValue
extends ConfigValue<Integer> {
    private Integer min;
    private Integer max;

    public IntegerConfigValue(Integer defaultValue, String comment) {
        super(defaultValue, comment);
    }

    public IntegerConfigValue(Integer defaultValue, String comment, int min, int max) {
        this(defaultValue, comment);
        this.min = min;
        this.max = max;
        this.rangedComment = "Ranged " + this.min + " ~ " + this.max;
    }

    @Override
    public boolean isValid(Object value) {
        Predicate<Object> predicate = o -> o instanceof Integer;
        if (this.isRanged() && predicate.test(value)) {
            return (Integer)value >= this.min && (Integer)value <= this.max;
        }
        return !this.isRanged() && predicate.test(value);
    }
}

