/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.inventory;

import com.tom.storagemod.inventory.IInventoryAccess;
import com.tom.storagemod.inventory.InventoryChangeTracker;
import com.tom.storagemod.inventory.PlatformInventoryAccess;
import java.util.Collections;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;

public class PlatformProxyInventoryAccess
implements PlatformInventoryAccess,
Storage<ItemVariant> {
    private boolean calling;
    private IInventoryAccess access;

    public PlatformProxyInventoryAccess(IInventoryAccess access) {
        this.access = access;
    }

    private Storage<ItemVariant> getP() {
        return (Storage)this.access.getPlatformHandler();
    }

    @Override
    public Storage<ItemVariant> get() {
        return this;
    }

    public long insert(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        StoragePreconditions.notNegative((long)maxAmount);
        if (this.calling) {
            return 0L;
        }
        this.calling = true;
        long v = this.getP().insert((Object)resource, maxAmount, transaction);
        this.calling = false;
        return v;
    }

    public long extract(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        StoragePreconditions.notNegative((long)maxAmount);
        if (this.calling) {
            return 0L;
        }
        this.calling = true;
        long v = this.getP().extract((Object)resource, maxAmount, transaction);
        this.calling = false;
        return v;
    }

    public Iterator<StorageView<ItemVariant>> iterator() {
        if (this.calling) {
            return Collections.emptyIterator();
        }
        this.calling = true;
        Iterator i = this.getP().iterator();
        this.calling = false;
        return i;
    }

    public void forEach(Consumer<? super StorageView<ItemVariant>> action) {
        if (this.calling) {
            return;
        }
        this.calling = true;
        this.getP().forEach(action);
        this.calling = false;
    }

    public Spliterator<StorageView<ItemVariant>> spliterator() {
        if (this.calling) {
            return Spliterators.emptySpliterator();
        }
        this.calling = true;
        Spliterator i = this.getP().spliterator();
        this.calling = false;
        return i;
    }

    public boolean supportsInsertion() {
        if (this.calling) {
            return false;
        }
        this.calling = true;
        boolean v = this.getP().supportsInsertion();
        this.calling = false;
        return v;
    }

    public boolean supportsExtraction() {
        if (this.calling) {
            return false;
        }
        this.calling = true;
        boolean v = this.getP().supportsExtraction();
        this.calling = false;
        return v;
    }

    public Iterator<StorageView<ItemVariant>> nonEmptyIterator() {
        if (this.calling) {
            return Collections.emptyIterator();
        }
        this.calling = true;
        Iterator i = this.getP().nonEmptyIterator();
        this.calling = false;
        return i;
    }

    public Iterable<StorageView<ItemVariant>> nonEmptyViews() {
        if (this.calling) {
            return Collections.emptyList();
        }
        this.calling = true;
        Iterable i = this.getP().nonEmptyViews();
        this.calling = false;
        return i;
    }

    public long getVersion() {
        if (this.calling) {
            return 0L;
        }
        this.calling = true;
        long i = this.getP().getVersion();
        this.calling = false;
        return i;
    }

    @Override
    public IInventoryAccess getRootHandler() {
        return this.access.getRootHandler();
    }

    @Override
    public IInventoryAccess.IInventoryChangeTracker tracker() {
        if (this.calling) {
            return InventoryChangeTracker.NULL;
        }
        this.calling = true;
        IInventoryAccess.IInventoryChangeTracker c = this.access.tracker();
        this.calling = false;
        return c;
    }
}

