/*
 * Decompiled with CFR 0.152.
 */
package com.boyonk.regenerativesleep;

import com.boyonk.regenerativesleep.RegenerativeSleep;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2248;
import net.minecraft.class_3481;
import net.minecraft.class_4239;
import net.minecraft.class_5321;
import net.minecraft.class_5699;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_6895;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import org.slf4j.Logger;

public class RegenerativeSleepConfig {
    public static final Codec<RegenerativeSleepConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Entry.CODEC.listOf().fieldOf("entries").forGetter(config -> config.entries)).apply((Applicative)instance, RegenerativeSleepConfig::new));
    private static final Logger LOGGER = RegenerativeSleep.LOGGER;
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final List<Entry> entries;
    private final Map<class_2248, Float> cache = new HashMap<class_2248, Float>();

    private RegenerativeSleepConfig(List<Entry> entries) {
        this.entries = entries;
    }

    private static RegenerativeSleepConfig createDefault(class_7225.class_7874 wrapperLookup) {
        class_7225.class_7226 blockRegistry = wrapperLookup.method_46762(class_7924.field_41254);
        ArrayList<Entry> entries = new ArrayList<Entry>();
        blockRegistry.method_46733(class_3481.field_16443).ifPresent(blocks -> entries.add(new Entry((class_6885<class_2248>)blocks, 6.0f)));
        return new RegenerativeSleepConfig(entries);
    }

    public static RegenerativeSleepConfig load(class_7225.class_7874 wrapperLookup) {
        Path path = FabricLoader.getInstance().getConfigDir().resolve("bed_regen.json");
        class_6903 ops = class_6903.method_46632((DynamicOps)JsonOps.INSTANCE, (class_7225.class_7874)wrapperLookup);
        if (Files.isRegularFile(path, new LinkOption[0])) {
            block17: {
                RegenerativeSleepConfig regenerativeSleepConfig;
                JsonReader reader = new JsonReader((Reader)Files.newBufferedReader(path, StandardCharsets.UTF_8));
                try {
                    reader.setLenient(false);
                    JsonElement json = Streams.parse((JsonReader)reader);
                    regenerativeSleepConfig = (RegenerativeSleepConfig)CODEC.parse((DynamicOps)ops, (Object)json).getOrThrow(JsonParseException::new);
                }
                catch (Throwable json) {
                    try {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable) {
                            json.addSuppressed(throwable);
                        }
                        throw json;
                    }
                    catch (JsonParseException exception) {
                        LOGGER.error("Couldn't parse config {}", (Object)path.getFileName(), (Object)exception);
                        break block17;
                    }
                    catch (IOException exception) {
                        LOGGER.error("Couldn't access config {}", (Object)path.getFileName(), (Object)exception);
                    }
                }
                reader.close();
                return regenerativeSleepConfig;
            }
            return RegenerativeSleepConfig.createDefault(wrapperLookup);
        }
        RegenerativeSleepConfig config = RegenerativeSleepConfig.createDefault(wrapperLookup);
        try {
            class_4239.method_47525((Path)path.getParent());
            try (BufferedWriter writer = Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);){
                GSON.toJson((JsonElement)CODEC.encodeStart((DynamicOps)ops, (Object)config).getOrThrow(IOException::new), (Appendable)writer);
            }
        }
        catch (IOException exception) {
            LOGGER.error("Failed to save config {}", (Object)path, (Object)exception);
        }
        return config;
    }

    public float get(class_2248 block) {
        return this.cache.computeIfAbsent(block, this::lookup).floatValue();
    }

    private float lookup(class_2248 block) {
        for (Entry entry : this.entries) {
            if (!entry.blocks().method_40241((class_6880)block.method_40142())) continue;
            return entry.amount();
        }
        return 0.0f;
    }

    record Entry(class_6885<class_2248> blocks, float amount) {
        public static final Codec<Entry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_6895.method_40340((class_5321)class_7924.field_41254).fieldOf("blocks").forGetter(Entry::blocks), (App)class_5699.field_34387.fieldOf("amount").forGetter(Entry::amount)).apply((Applicative)instance, Entry::new));
    }
}

