/*
 * Decompiled with CFR 0.152.
 */
package net.fryc.imbleeding.mixin;

import java.util.concurrent.ThreadLocalRandom;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fryc.imbleeding.effects.ModEffects;
import net.fryc.imbleeding.network.payloads.CreateBloodParticlePayload;
import net.fryc.imbleeding.tags.ModEntityTypeTags;
import net.fryc.imbleeding.tags.ModItemTags;
import net.fryc.imbleeding.util.BleedingHelper;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_8149;
import net.minecraft.class_8710;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class})
abstract class LivingEntityMixin
extends class_1297
implements class_8149 {
    public LivingEntityMixin(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    @Inject(method={"canHaveStatusEffect(Lnet/minecraft/entity/effect/StatusEffectInstance;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void undeadCantBleed(class_1293 effect, CallbackInfoReturnable<Boolean> ret) {
        class_1309 dys = (class_1309)this;
        if (effect.method_5579() == ModEffects.BLEED_EFFECT || effect.method_5579() == ModEffects.BLEEDOUT) {
            if (dys.method_5864().method_20210(ModEntityTypeTags.BLEED_RESISTANT_TO)) {
                ret.setReturnValue((Object)false);
            }
        } else if (effect.method_5579() == ModEffects.HEALTH_LOSS && dys.method_5864().method_20210(ModEntityTypeTags.HEALTH_LOSS_RESISTANT_TO)) {
            ret.setReturnValue((Object)false);
        }
    }

    @Inject(method={"setSprinting(Z)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void dontSprintWhenBroken(boolean sprinting, CallbackInfo info) {
        class_1309 dys = (class_1309)this;
        if (sprinting && dys.method_6059(ModEffects.BROKEN)) {
            info.cancel();
        }
    }

    @Inject(method={"consumeItem()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;spawnConsumptionEffects(Lnet/minecraft/item/ItemStack;I)V", shift=At.Shift.AFTER)})
    private void removeEffectsAfterUsingItem(CallbackInfo info) {
        class_1309 dys = (class_1309)this;
        if (!dys.method_37908().method_8608()) {
            if (dys.method_6030().method_31573(ModItemTags.ITEMS_REMOVE_BLEEDING)) {
                dys.method_6016(ModEffects.BLEED_EFFECT);
            }
            if (dys.method_6030().method_31573(ModItemTags.ITEMS_REMOVE_HEALTH_LOSS)) {
                dys.method_6016(ModEffects.HEALTH_LOSS);
            }
            if (dys.method_6030().method_31573(ModItemTags.ITEMS_REMOVE_BROKEN) && dys.method_6059(ModEffects.BROKEN)) {
                int duration = ((class_1293)dys.method_6088().get(ModEffects.BROKEN)).method_5584();
                dys.method_6092(new class_1293(class_1294.field_5909, duration, 0, false, false, true));
                dys.method_6016(ModEffects.BROKEN);
            }
            if (dys.method_6030().method_31573(ModItemTags.ITEMS_REMOVE_BLEEDOUT)) {
                dys.method_6016(ModEffects.BLEEDOUT);
            }
        }
    }

    @Inject(method={"applyDamage(Lnet/minecraft/entity/damage/DamageSource;F)V"}, at={@At(value="TAIL")})
    public void applyDamageEffects(class_1282 source, float amount, CallbackInfo ci) {
        class_1309 dys = (class_1309)this;
        if (BleedingHelper.shouldApplyDarkness(dys)) {
            BleedingHelper.applyDarkness(dys);
        }
        if (BleedingHelper.canGetBleeding(dys) && BleedingHelper.canApplyBleeding(source, amount)) {
            BleedingHelper.applyBleeding(dys, source, amount);
        }
        if (BleedingHelper.canGetHealthLoss(dys) && BleedingHelper.canApplyHealthLoss(source)) {
            BleedingHelper.applyHealthLoss(dys, source, amount);
        }
        if (BleedingHelper.shouldReduceBleedingWithFire(source, dys.method_37908())) {
            BleedingHelper.reduceBleedingWithFire(dys);
        }
        if (BleedingHelper.shouldApplyBrokenEffect(source, amount, dys)) {
            BleedingHelper.applyBrokenEffect(dys, amount);
        }
    }

    @Inject(method={"tick()V"}, at={@At(value="TAIL")})
    private void spawnBloodParticles(CallbackInfo info) {
        class_1309 dys = (class_1309)this;
        if (!dys.method_37908().method_8608() && dys.method_6059(ModEffects.BLEED_EFFECT) && ThreadLocalRandom.current().nextInt(100) < 5 + ((class_1293)dys.method_6088().get(ModEffects.BLEED_EFFECT)).method_5578() * 5) {
            class_243 vec3d = this.method_18798();
            for (class_3222 pl : PlayerLookup.tracking((class_3218)((class_3218)dys.method_37908()), (class_1923)dys.method_31476())) {
                ServerPlayNetworking.send((class_3222)pl, (class_8710)new CreateBloodParticlePayload(dys.method_23317(), dys.method_23318(), dys.method_23321(), vec3d.method_10214() - 0.05));
            }
        }
    }
}

