/*
 * Decompiled with CFR 0.152.
 */
package net.fryc.unremovableeffects.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.InputStream;
import java.util.HashSet;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.fryc.unremovableeffects.UnremovableEffects;
import net.fryc.unremovableeffects.interfaces.Unremovable;
import net.fryc.unremovableeffects.json.StatusEffectJsonHelper;
import net.minecraft.class_1291;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_7923;

public class UnremovableStatusEffectsResourceReloadListener
implements SimpleSynchronousResourceReloadListener {
    private static final String UNREMOVABLE_STATUS_EFFECTS_PATH = "unremovable_status_effects";
    public static final HashSet<class_1291> UNREMOVABLE_STATUS_EFFECTS = new HashSet();

    public class_2960 getFabricId() {
        return class_2960.method_60655((String)"unremovableeffects", (String)UNREMOVABLE_STATUS_EFFECTS_PATH);
    }

    public void method_14491(class_3300 manager) {
        UNREMOVABLE_STATUS_EFFECTS.clear();
        int currentReplacePriority = 0;
        boolean isReplacePresent = false;
        for (class_2960 id : manager.method_14488(UNREMOVABLE_STATUS_EFFECTS_PATH, path -> path.method_12832().endsWith(".json")).keySet()) {
            try {
                InputStream stream = ((class_3298)manager.method_14486(id).get()).method_14482();
                try {
                    boolean shouldGo;
                    JsonObject jsonObject = JsonParser.parseString((String)new String(stream.readAllBytes())).getAsJsonObject();
                    boolean replace = class_3518.method_15258((JsonObject)jsonObject, (String)"replace", (boolean)false);
                    boolean bl = shouldGo = !isReplacePresent || replace;
                    if (replace) {
                        int replacePriority = class_3518.method_15282((JsonObject)jsonObject, (String)"replace_priority", (int)0);
                        if (isReplacePresent) {
                            if (replacePriority > currentReplacePriority) {
                                currentReplacePriority = replacePriority;
                                UNREMOVABLE_STATUS_EFFECTS.clear();
                            } else {
                                if (currentReplacePriority == replacePriority) {
                                    UnremovableEffects.LOGGER.warn("Found two Json files with the same replace priority! Consider changing priority in one of the files");
                                    UnremovableEffects.LOGGER.warn("'" + id.method_12832() + "' was ignored - other file was loaded first");
                                }
                                shouldGo = false;
                            }
                        } else {
                            UNREMOVABLE_STATUS_EFFECTS.clear();
                            isReplacePresent = true;
                            currentReplacePriority = replacePriority;
                        }
                    }
                    if (!shouldGo) continue;
                    JsonArray array = class_3518.method_15261((JsonObject)jsonObject, (String)"status_effects");
                    for (JsonElement jsonElement : array) {
                        class_1291 effect = (class_1291)StatusEffectJsonHelper.asStatusEffect(jsonElement, "status_effects_array_element").comp_349();
                        UNREMOVABLE_STATUS_EFFECTS.add(effect);
                    }
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (Exception e) {
                UnremovableEffects.LOGGER.error("Error occurred while loading resource json" + id.toString(), (Throwable)e);
            }
        }
        for (class_1291 effect : class_7923.field_41174) {
            ((Unremovable)effect).setUnremovable(UNREMOVABLE_STATUS_EFFECTS.contains(effect));
        }
    }
}

