/*
 * Decompiled with CFR 0.152.
 */
package net.robofox.copperrails.mixin;

import net.minecraft.class_1688;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_243;
import net.minecraft.class_2442;
import net.minecraft.class_2680;
import net.minecraft.class_2768;
import net.minecraft.class_2769;
import net.robofox.copperrails.CopperRails;
import net.robofox.copperrails.CopperRailsConfig;
import net.robofox.copperrails.block.ModBlocks;
import net.robofox.copperrails.block.custom.GenericCopperRailBlock;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={class_1688.class})
public abstract class AbstractMinecartMixin {
    @Redirect(method={"moveAlongTrack"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/BlockState;is(Lnet/minecraft/world/level/block/Block;)Z"))
    public boolean isPoweringRail(class_2680 state, class_2248 block) {
        if (block == class_2246.field_10425) {
            class_2248 unknownRail = state.method_26204();
            return unknownRail instanceof GenericCopperRailBlock || unknownRail == class_2246.field_10425;
        }
        CopperRails.LOGGER.warn("isOf() Mixin called with something else than Blocks.POWERED_RAIL");
        return state.method_27852(block);
    }

    @Unique
    public double getMaxRailSpeed(class_2680 blockState) {
        class_2248 block = blockState.method_26204();
        if (block == ModBlocks.COPPER_RAIL || block == ModBlocks.WAXED_COPPER_RAIL) {
            return CopperRailsConfig.COPPER_SPEED;
        }
        if (block == ModBlocks.EXPOSED_COPPER_RAIL || block == ModBlocks.WAXED_EXPOSED_COPPER_RAIL) {
            return CopperRailsConfig.EXPOSED_COPPER_SPEED;
        }
        if (block == ModBlocks.WEATHERED_COPPER_RAIL || block == ModBlocks.WAXED_WEATHERED_COPPER_RAIL) {
            return CopperRailsConfig.WEATHERED_COPPER_SPEED;
        }
        if (block == ModBlocks.OXIDIZED_COPPER_RAIL || block == ModBlocks.WAXED_OXIDIZED_COPPER_RAIL) {
            return CopperRailsConfig.OXIDIZED_COPPER_SPEED;
        }
        if (block == class_2246.field_10425) {
            return CopperRailsConfig.GOLD_SPEED;
        }
        return CopperRailsConfig.NORMAL_RAIL_SPEED;
    }

    @Overwrite
    public double method_7504() {
        class_1688 minecart = (class_1688)this;
        return minecart.method_5799() ? (double)CopperRailsConfig.NORMAL_RAIL_SPEED / 2.0 : (double)CopperRailsConfig.NORMAL_RAIL_SPEED;
    }

    @Unique
    private double convergeAbs(double speed, double targetSpeed) {
        if (Math.abs(speed) > targetSpeed) {
            return Math.signum(speed) * Math.max(Math.abs(speed) * 0.7, targetSpeed);
        }
        return speed;
    }

    @Redirect(method={"moveAlongTrack"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/vehicle/AbstractMinecart;setDeltaMovement(Lnet/minecraft/world/phys/Vec3;)V", ordinal=9))
    public void setVelocityClamp(class_1688 minecart, class_243 velocity) {
        double maxSpeed = this.getMaxRailSpeed(minecart.method_55667());
        minecart.method_18800(this.convergeAbs(velocity.field_1352, maxSpeed), velocity.field_1351, this.convergeAbs(velocity.field_1350, maxSpeed));
    }

    @Redirect(method={"moveAlongTrack"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/vehicle/AbstractMinecart;setDeltaMovement(Lnet/minecraft/world/phys/Vec3;)V", ordinal=0))
    public void setVelocityAscendingEast(class_1688 minecart, class_243 velocity_adder) {
        class_243 velocity = minecart.method_18798();
        double v_x = velocity_adder.field_1352;
        double v_y = velocity_adder.field_1351;
        double v_z = velocity_adder.field_1350;
        if (velocity.field_1352 > (double)CopperRailsConfig.MAX_ASCENDING_SPEED) {
            v_x = CopperRailsConfig.MAX_ASCENDING_SPEED;
        }
        minecart.method_18800(v_x, v_y, v_z);
    }

    @Redirect(method={"moveAlongTrack"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/vehicle/AbstractMinecart;setDeltaMovement(Lnet/minecraft/world/phys/Vec3;)V", ordinal=1))
    public void setVelocityAscendingWest(class_1688 minecart, class_243 velocity_adder) {
        class_243 velocity = minecart.method_18798();
        double v_x = velocity_adder.field_1352;
        double v_y = velocity_adder.field_1351;
        double v_z = velocity_adder.field_1350;
        if (velocity.field_1352 < (double)(-CopperRailsConfig.MAX_ASCENDING_SPEED)) {
            v_x = -CopperRailsConfig.MAX_ASCENDING_SPEED;
        }
        minecart.method_18800(v_x, v_y, v_z);
    }

    @Redirect(method={"moveAlongTrack"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/vehicle/AbstractMinecart;setDeltaMovement(Lnet/minecraft/world/phys/Vec3;)V", ordinal=2))
    public void setVelocityAscendingNorth(class_1688 minecart, class_243 velocity_adder) {
        class_243 velocity = minecart.method_18798();
        double v_x = velocity_adder.field_1352;
        double v_y = velocity_adder.field_1351;
        double v_z = velocity_adder.field_1350;
        if (velocity.field_1350 < (double)(-CopperRailsConfig.MAX_ASCENDING_SPEED)) {
            v_z = -CopperRailsConfig.MAX_ASCENDING_SPEED;
        }
        minecart.method_18800(v_x, v_y, v_z);
    }

    @Redirect(method={"moveAlongTrack"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/vehicle/AbstractMinecart;setDeltaMovement(Lnet/minecraft/world/phys/Vec3;)V", ordinal=3))
    public void setVelocityAscendingSouth(class_1688 minecart, class_243 velocity_adder) {
        class_243 velocity = minecart.method_18798();
        double v_x = velocity_adder.field_1352;
        double v_y = velocity_adder.field_1351;
        double v_z = velocity_adder.field_1350;
        if (velocity.field_1350 > (double)CopperRailsConfig.MAX_ASCENDING_SPEED) {
            v_z = CopperRailsConfig.MAX_ASCENDING_SPEED;
        }
        minecart.method_18800(v_x, v_y, v_z);
    }

    @Unique
    private class_2768 getRailShape(class_2680 blockState, class_2769<class_2768> property) {
        boolean isPowered;
        class_2768 railShape = (class_2768)blockState.method_11654(property);
        if (blockState.method_27852(ModBlocks.RAIL_CROSSING) && (isPowered = ((Boolean)blockState.method_11654((class_2769)class_2442.field_11364)).booleanValue())) {
            switch (railShape) {
                case field_12665: {
                    return class_2768.field_12674;
                }
                case field_12674: {
                    return class_2768.field_12665;
                }
            }
            CopperRails.LOGGER.error("Crossing rail has invalid shape");
        }
        return railShape;
    }

    @Redirect(method={"moveAlongTrack"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/BlockState;getValue(Lnet/minecraft/world/level/block/state/properties/Property;)Ljava/lang/Comparable;", ordinal=1))
    public <T extends Comparable<T>> T getMoveAlongTrackMixin(class_2680 blockState, class_2769<class_2768> property) {
        return (T)this.getRailShape(blockState, property);
    }

    @Redirect(method={"getPosOffs"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/BlockState;getValue(Lnet/minecraft/world/level/block/state/properties/Property;)Ljava/lang/Comparable;", ordinal=0))
    public <T extends Comparable<T>> T getSnapPositionToRailWithOffsetMixin(class_2680 blockState, class_2769<class_2768> property) {
        return (T)this.getRailShape(blockState, property);
    }

    @Redirect(method={"getPos"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/BlockState;getValue(Lnet/minecraft/world/level/block/state/properties/Property;)Ljava/lang/Comparable;", ordinal=0))
    public <T extends Comparable<T>> T getSnapPositionToRailMixin(class_2680 blockState, class_2769<class_2768> property) {
        return (T)this.getRailShape(blockState, property);
    }
}

