/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.client;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2396;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_322;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_5614;
import net.minecraft.class_702;
import net.minecraft.class_7923;
import umpaz.brewinandchewin.BrewinAndChewin;
import umpaz.brewinandchewin.client.particle.DrunkBubbleParticle;
import umpaz.brewinandchewin.client.particle.RagingParticle;
import umpaz.brewinandchewin.client.renderer.CoasterBlockEntityRenderer;
import umpaz.brewinandchewin.client.renderer.texture.modifier.TextureModifier;
import umpaz.brewinandchewin.client.utility.BnCFluidItemDisplays;
import umpaz.brewinandchewin.client.utility.IdentifiableListener;
import umpaz.brewinandchewin.common.block.entity.CoasterBlockEntity;
import umpaz.brewinandchewin.common.registry.BnCBlockEntityTypes;
import umpaz.brewinandchewin.common.registry.BnCBlocks;
import umpaz.brewinandchewin.common.registry.BnCParticleTypes;
import vectorwing.farmersdelight.client.particle.SteamParticle;

public class BnCClientSetup {
    public static final Set<class_2960> MODELS = new HashSet<class_2960>();

    public static void registerBlockEntityRenderers(BiConsumer<class_2591<?>, class_5614> consumer) {
        consumer.accept(BnCBlockEntityTypes.COASTER, CoasterBlockEntityRenderer::new);
    }

    public static void registerParticles(BiConsumer<class_2396<?>, class_702.class_4091> consumer) {
        consumer.accept((class_2396<?>)BnCParticleTypes.FOG, SteamParticle.Factory::new);
        consumer.accept(BnCParticleTypes.DRUNK_BUBBLE, DrunkBubbleParticle.Factory::new);
        consumer.accept(BnCParticleTypes.RAGING_STAGE_1, RagingParticle.Factory::new);
        consumer.accept(BnCParticleTypes.RAGING_STAGE_2, RagingParticle.Factory::new);
        consumer.accept(BnCParticleTypes.RAGING_STAGE_3, RagingParticle.Factory::new);
        consumer.accept(BnCParticleTypes.RAGING_STAGE_4, RagingParticle.Factory::new);
    }

    public static void registerReloadListeners(Consumer<IdentifiableListener> consumer) {
        consumer.accept(BnCFluidItemDisplays.Loader.INSTANCE);
    }

    public static void registerColorHandlers(BiConsumer<class_322, class_2248> consumer) {
        consumer.accept((state, level, pos, pTintIndex) -> {
            class_2586 patt0$temp;
            if (level != null && pos != null && (patt0$temp = level.method_8321(pos)) instanceof CoasterBlockEntity) {
                CoasterBlockEntity blockEntity = (CoasterBlockEntity)patt0$temp;
                int tintIndex = -1;
                int count = (int)blockEntity.getItems().stream().filter(i -> !i.method_7960()).count();
                for (int i2 = 0; i2 < count; ++i2) {
                    class_1799 stack = (class_1799)blockEntity.getItems().get(i2);
                    class_2960 itemId = class_7923.field_41178.method_10221((Object)stack.method_7909());
                    List<CoasterBlockEntityRenderer.ModelEntry> modelEntries = CoasterBlockEntityRenderer.getModelEntries(itemId);
                    if (modelEntries == null) continue;
                    for (CoasterBlockEntityRenderer.ModelEntry modelEntry : modelEntries) {
                        int color = -1;
                        for (int j = 0; j < modelEntry.modifiers().size(); ++j) {
                            for (TextureModifier textureModifier : modelEntry.modifiers()) {
                                color = textureModifier.color(level, state, pos, stack, color);
                            }
                        }
                        if (color == -1 || ++tintIndex != pTintIndex) continue;
                        return color;
                    }
                }
            }
            return -1;
        }, BnCBlocks.COASTER);
    }

    public static CompletableFuture<List<class_2960>> getModels(class_3300 manager, Executor executor) {
        return CompletableFuture.supplyAsync(() -> {
            ArrayList models = new ArrayList();
            for (Map.Entry resourceEntry : manager.method_14488("brewinandchewin/coaster", fileName -> fileName.method_12832().endsWith(".json")).entrySet()) {
                models.addAll(CompletableFuture.supplyAsync(() -> {
                    try {
                        BufferedReader reader = ((class_3298)resourceEntry.getValue()).method_43039();
                        JsonElement json = JsonParser.parseReader((Reader)reader);
                        ((Reader)reader).close();
                        if (json instanceof JsonObject) {
                            JsonObject jsonObject = (JsonObject)json;
                            class_2960 itemId = (class_2960)((Pair)class_2960.field_25139.decode((DynamicOps)JsonOps.INSTANCE, (Object)jsonObject.get("item")).getOrThrow()).getFirst();
                            List modelEntries = (List)((Pair)CoasterBlockEntityRenderer.ModelEntry.LIST_CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)jsonObject.get("models")).getOrThrow()).getFirst();
                            CoasterBlockEntityRenderer.addToModelMap(itemId, modelEntries);
                            return modelEntries.stream().map(CoasterBlockEntityRenderer.ModelEntry::model).toList();
                        }
                    }
                    catch (Exception ex) {
                        BrewinAndChewin.LOG.error("Unexpected error in Brewin' And Chewin' coaster model JSON \"{}\". {}", resourceEntry.getKey(), (Object)ex);
                        return List.of();
                    }
                    BrewinAndChewin.LOG.error("Unexpected error in Brewin' And Chewin' coaster model JSON: {}.", resourceEntry.getKey());
                    return List.of();
                }, executor).join());
            }
            List<class_2960> modelPaths = models.stream().filter(Objects::nonNull).toList();
            MODELS.addAll(modelPaths);
            return modelPaths;
        });
    }
}

