/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.client.utility;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2491;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_9323;
import net.minecraft.class_9326;
import net.minecraft.class_9331;
import umpaz.brewinandchewin.BrewinAndChewin;
import umpaz.brewinandchewin.client.utility.TagReference;
import umpaz.brewinandchewin.common.utility.AbstractedFluidStack;

public record FluidItemComponentRemapper(class_1799 baseItem, Map<class_9331<?>, Pair<class_9331<?>, Map<List<TagReference>, List<TagReference>>>> map) {
    public static final Codec<FluidItemComponentRemapper> DIRECT_CODEC = RecordCodecBuilder.create(inst -> inst.group((App)class_1799.field_51398.fieldOf("base").forGetter(FluidItemComponentRemapper::baseItem), (App)Codec.unboundedMap((Codec)class_7923.field_49658.method_39673(), (Codec)ValueCodec.INSTANCE).optionalFieldOf("remaps", Map.of()).forGetter(FluidItemComponentRemapper::map)).apply((Applicative)inst, FluidItemComponentRemapper::new));
    public static final Codec<FluidItemComponentRemapper> CODEC = Codec.withAlternative(DIRECT_CODEC, (Codec)Codec.withAlternative((Codec)class_1799.field_51398, (Codec)class_7923.field_41178.method_39673(), class_1799::new), stack -> new FluidItemComponentRemapper((class_1799)stack, Map.of()));

    public class_1799 convert(class_7225.class_7874 lookup, AbstractedFluidStack fluid) throws IllegalStateException {
        class_1799 stack = this.baseItem.method_7972();
        if (fluid.components().method_57837()) {
            return stack;
        }
        class_6903 registryOps = class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)lookup);
        class_2487 fluidTag = (class_2487)class_9323.field_50234.encodeStart((DynamicOps)registryOps, (Object)fluid.components()).getOrThrow();
        class_2487 itemTag = (class_2487)class_9323.field_50234.encodeStart((DynamicOps)registryOps, (Object)stack.method_57353()).getOrThrow();
        class_9326 patch = (class_9326)((Pair)class_9326.field_49589.decode((DynamicOps)registryOps, (Object)this.encodeTag(fluidTag, itemTag)).getOrThrow()).getFirst();
        stack.method_57366(patch);
        return stack;
    }

    private class_2487 encodeTag(class_2487 fluidTag, class_2487 itemTag) {
        if (this.map.isEmpty()) {
            return itemTag;
        }
        for (Map.Entry<class_9331<?>, Pair<class_9331<?>, Map<List<TagReference>, List<TagReference>>>> entry : this.map.entrySet()) {
            class_2487 current;
            if (((Map)entry.getValue().getSecond()).isEmpty() && (current = itemTag) instanceof class_2487) {
                class_2520 innerFluidTag;
                class_2487 tag = current;
                class_2960 id = class_7923.field_49658.method_10221((Object)((class_9331)entry.getValue().getFirst()));
                if (id == null || (innerFluidTag = fluidTag.method_10580(id.toString())) == null) continue;
                tag.method_10566(id.toString(), innerFluidTag);
            }
            for (int i = 0; i < ((Map)entry.getValue().getSecond()).size(); ++i) {
                current = itemTag.method_10553();
                block2: for (Map.Entry referenceEntry : ((Map)entry.getValue().getSecond()).entrySet()) {
                    List fluidKeys = (List)referenceEntry.getKey();
                    List itemKeys = (List)referenceEntry.getValue();
                    for (int j = 0; j < itemKeys.size(); ++j) {
                        class_2487 compoundTag;
                        TagReference key = (TagReference)itemKeys.get(j);
                        if (i == itemKeys.size() - 1) {
                            class_2520 newElement = this.getTag((class_2520)fluidTag, fluidKeys);
                            if (newElement instanceof class_2499) {
                                if (current instanceof class_2499) {
                                    class_2499 listTag = (class_2499)current;
                                    listTag.method_10606(key.index(), newElement);
                                    continue block2;
                                }
                                BrewinAndChewin.LOG.error("Unable to map tag {}. Tag {} is not a list tag.", (Object)String.join((CharSequence)".", fluidKeys.stream().map(TagReference::key).toList()), (Object)String.join((CharSequence)".", itemKeys.stream().map(TagReference::key).toList()));
                                continue block2;
                            }
                            if (current instanceof class_2487) {
                                compoundTag = current;
                                compoundTag.method_10566(key.key(), newElement);
                                continue block2;
                            }
                            BrewinAndChewin.LOG.error("Unable to map tag {}. Tag {} is not a compound tag.", (Object)String.join((CharSequence)".", fluidKeys.stream().map(TagReference::key).toList()), (Object)String.join((CharSequence)".", itemKeys.stream().map(TagReference::key).toList()));
                            continue block2;
                        }
                        if (key.isArrayValue()) {
                            if (current instanceof class_2499) {
                                class_2499 listTag = (class_2499)current;
                                if (listTag.size() < key.index()) {
                                    current = listTag.method_10534(key.index());
                                    continue;
                                }
                                BrewinAndChewin.LOG.error("Unable to find tag {} in output json.", (Object)String.join((CharSequence)".", itemKeys.stream().map(TagReference::key).toList()));
                                continue;
                            }
                            BrewinAndChewin.LOG.error("Unable to map tag {}. Tag {} is not a list tag.", (Object)String.join((CharSequence)".", fluidKeys.stream().map(TagReference::key).toList()), (Object)String.join((CharSequence)".", itemKeys.subList(0, i).stream().map(TagReference::key).toList()));
                            continue;
                        }
                        if (current instanceof class_2487) {
                            compoundTag = current;
                            if (compoundTag.method_10545(key.key())) {
                                current = compoundTag.method_10580(key.key());
                                continue;
                            }
                            BrewinAndChewin.LOG.error("Unable to find tag {} in output json.", (Object)String.join((CharSequence)".", itemKeys.stream().map(TagReference::key).toList()));
                            continue;
                        }
                        BrewinAndChewin.LOG.error("Unable to map tag {}. Tag {} is not a compound tag.", (Object)String.join((CharSequence)".", fluidKeys.stream().map(TagReference::key).toList()), (Object)String.join((CharSequence)".", String.join((CharSequence)".", itemKeys.subList(0, i).stream().map(TagReference::key).toList())));
                    }
                }
            }
        }
        return itemTag;
    }

    private class_2520 getTag(class_2520 keyTag, List<TagReference> references) {
        class_2491 tag = class_2491.field_21033;
        for (int i = 0; i < references.size(); ++i) {
            class_2499 listTag;
            TagReference key = references.get(i);
            if (i == references.size() - 1) {
                if (key.isArrayValue()) {
                    if (keyTag instanceof class_2499) {
                        listTag = (class_2499)keyTag;
                        if (listTag.size() < key.index()) {
                            tag = listTag.method_10534(key.index());
                            break;
                        }
                        throw new RuntimeException("Unable to find tag " + String.join((CharSequence)".", references.stream().map(TagReference::key).toList()) + " in fluid stack.");
                    }
                    throw new RuntimeException("Unable to map tag " + String.join((CharSequence)".", references.stream().map(TagReference::key).toList()) + ". Tag " + String.join((CharSequence)".", references.stream().map(TagReference::key).toList()) + " is not a list tag.");
                }
                if (keyTag instanceof class_2487) {
                    class_2487 compoundTag = (class_2487)keyTag;
                    if (compoundTag.method_10545(key.key())) {
                        tag = compoundTag.method_10580(key.key());
                        break;
                    }
                    throw new RuntimeException("Unable to find tag " + String.join((CharSequence)".", references.stream().map(TagReference::key).toList()) + " in fluid stack.");
                }
                throw new RuntimeException("Unable to map tag " + String.join((CharSequence)".", references.stream().map(TagReference::key).toList()) + ". Tag " + String.join((CharSequence)".", references.stream().map(TagReference::key).toList()) + " is not a compound tag.");
            }
            if (key.isArrayValue()) {
                if (keyTag instanceof class_2499) {
                    listTag = (class_2499)keyTag;
                    if (listTag.size() < key.index()) {
                        tag = listTag.method_10534(key.index());
                        continue;
                    }
                    throw new RuntimeException("Unable to find tag " + String.join((CharSequence)".", references.subList(0, i).stream().map(TagReference::key).toList()) + " in fluid stack.");
                }
                throw new RuntimeException("Unable to map tag " + String.join((CharSequence)".", references.subList(0, i).stream().map(TagReference::key).toList()) + ". Tag " + String.join((CharSequence)".", references.subList(0, i).stream().map(TagReference::key).toList()) + " is not a list tag.");
            }
            if (keyTag instanceof class_2487) {
                class_2487 compoundTag = (class_2487)keyTag;
                if (compoundTag.method_10545(key.key())) {
                    tag = compoundTag.method_10580(key.key());
                    continue;
                }
                throw new RuntimeException("Unable to find tag " + String.join((CharSequence)".", references.subList(0, i).stream().map(TagReference::key).toList()) + " in fluid stack.");
            }
            throw new RuntimeException("Unable to map tag " + String.join((CharSequence)".", references.subList(0, i).stream().map(TagReference::key).toList()) + ". Tag " + String.join((CharSequence)".", references.subList(0, i).stream().map(TagReference::key).toList()) + " is not a compound tag.");
        }
        return tag;
    }

    static class ValueCodec
    implements Codec<Pair<class_9331<?>, Map<List<TagReference>, List<TagReference>>>> {
        private static final ValueCodec INSTANCE = new ValueCodec();

        protected ValueCodec() {
        }

        public <T> DataResult<Pair<Pair<class_9331<?>, Map<List<TagReference>, List<TagReference>>>, T>> decode(DynamicOps<T> ops, T input) {
            MapLike map = (MapLike)ops.getMap(input).getOrThrow();
            DataResult componentTypeResult = class_7923.field_49658.method_39673().decode(ops, map.get("component"));
            if (componentTypeResult.isError()) {
                return DataResult.error(() -> "Failed to decode 'component' field within fluid to item remapping.");
            }
            class_9331 componentType = (class_9331)((Pair)componentTypeResult.getOrThrow()).getFirst();
            HashMap references = new HashMap();
            if (map.entries().anyMatch(p -> p.getFirst() == ops.createString("functions"))) {
                if (!ops.getStream(map.get("functions")).isError()) {
                    List functions = ((Stream)ops.getStream(map.get("functions")).getOrThrow()).toList();
                    for (Object innerFunction : functions) {
                        DataResult<Map<List<TagReference>, List<TagReference>>> dataResult = ValueCodec.getReferences(ops, innerFunction);
                        if (dataResult.isError()) {
                            BrewinAndChewin.LOG.error("Failed to decode remap value within fluid to item remapping: {}", (Object)((DataResult.Error)dataResult.error().get()).message());
                            continue;
                        }
                        references.putAll((Map)dataResult.getOrThrow());
                    }
                } else {
                    DataResult<Map<List<TagReference>, List<TagReference>>> dataResult = ValueCodec.getReferences(ops, map.get("functions"));
                    if (dataResult.isSuccess()) {
                        references.putAll((Map)dataResult.getOrThrow());
                    } else {
                        BrewinAndChewin.LOG.error("Failed to decode remap value within fluid to item remapping: {}", (Object)((DataResult.Error)dataResult.error().get()).message());
                    }
                }
            }
            return DataResult.success((Object)Pair.of((Object)Pair.of((Object)componentType, references), input));
        }

        private static <T> DataResult<Map<List<TagReference>, List<TagReference>>> getReferences(DynamicOps<T> ops, T input) {
            HashMap<List<TagReference>, List<TagReference>> map = new HashMap<List<TagReference>, List<TagReference>>();
            if (!ops.getMap(input).isError()) {
                MapLike innerMap = (MapLike)ops.getMap(input).getOrThrow();
                Object from = innerMap.get("from");
                if (ops.getStringValue(from).isError()) {
                    return DataResult.error(() -> "Failed to decode 'from' value. Must be a string that points to a NBT path.\n\nObjects are denoted with '.' (for example 'root.substring') and array values are denoted with '[<index_number>]' (for example '[0]').");
                }
                List<TagReference> fromValues = TagReference.createFromString((String)ops.getStringValue(from).getOrThrow());
                Object to = innerMap.get("to");
                if (!ops.getStringValue(to).isError()) {
                    map.put(fromValues, TagReference.createFromString((String)ops.getStringValue(to).getOrThrow()));
                } else {
                    return DataResult.error(() -> "Failed to decode 'to' value. Must be a string that points to a NBT path.\n\nObjects are denoted with '.' (for example 'root.substring') and array values are denoted with '[<index_number>]' (for example '[0]').");
                }
            }
            return DataResult.success((Object)ImmutableMap.copyOf(map));
        }

        public <T> DataResult<T> encode(Pair<class_9331<?>, Map<List<TagReference>, List<TagReference>>> input, DynamicOps<T> ops, T prefix) {
            HashMap<Object, Object> map = new HashMap<Object, Object>();
            map.put(ops.createString("component"), class_7923.field_49658.method_39673().encodeStart(ops, (Object)((class_9331)input.getFirst())).getOrThrow());
            ArrayList<Object> functionList = new ArrayList<Object>();
            for (Map.Entry entry : ((Map)input.getSecond()).entrySet()) {
                HashMap functionMap = new HashMap();
                map.put(ops.createString("from"), ops.createString(((List)entry.getKey()).stream().map(TagReference::key).collect(Collectors.joining("."))));
                map.put(ops.createString("to"), ops.createString(((List)entry.getValue()).stream().map(TagReference::key).collect(Collectors.joining("."))));
                functionList.add(ops.createMap(functionMap));
            }
            if (!functionList.isEmpty()) {
                map.put(ops.createString("functions"), ops.createList(functionList.stream()));
            }
            return DataResult.success((Object)ops.createMap(map));
        }
    }
}

