/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.common;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import house.greenhouse.greenhouseconfig.api.GreenhouseConfigHolder;
import house.greenhouse.greenhouseconfig.api.codec.GreenhouseConfigCodecs;
import house.greenhouse.greenhouseconfig.api.lang.ConfigLang;
import house.greenhouse.greenhouseconfig.toml.TomlLang;
import io.netty.buffer.ByteBuf;
import net.minecraft.class_3542;
import net.minecraft.class_5699;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;
import umpaz.brewinandchewin.BrewinAndChewin;
import umpaz.brewinandchewin.common.utility.FluidUnit;
import umpaz.brewinandchewin.platform.BnCPlatform;

public class BnCConfiguration {
    public static final GreenhouseConfigHolder<Common> COMMON_CONFIG = GreenhouseConfigHolder.builder((String)"brewinandchewin-common", (ConfigLang)TomlLang.INSTANCE).common(Common.CODEC, (Object)Common.DEFAULT).networkSerializable(Common.STREAM_CODEC.method_56430()).buildAndRegister();
    public static final GreenhouseConfigHolder<Client> CLIENT_CONFIG = GreenhouseConfigHolder.builder((String)"brewinandchewin-client", (ConfigLang)TomlLang.INSTANCE).client(Client.CODEC, (Object)Client.DEFAULT).buildAndRegister();

    public static void init() {
    }

    private static <T> T platformSpecificValue(T neoForge, T fabric) {
        return BrewinAndChewin.getHelper().getPlatform() == BnCPlatform.NEOFORGE ? neoForge : fabric;
    }

    public record Common(Root root, Keg keg, RecipeBook recipeBook) {
        public static final Common DEFAULT = new Common(Root.DEFAULT, Keg.DEFAULT, RecipeBook.DEFAULT);
        private static final Codec<Common> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Root.CODEC.forGetter(Common::root), (App)Keg.CODEC.fieldOf("keg").forGetter(Common::keg), (App)RecipeBook.CODEC.fieldOf("recipe_book").forGetter(Common::recipeBook)).apply((Applicative)inst, Common::new));
        public static final class_9139<ByteBuf, Common> STREAM_CODEC = class_9139.method_56436(Root.STREAM_CODEC, Common::root, Keg.STREAM_CODEC, Common::keg, RecipeBook.STREAM_CODEC, Common::recipeBook, Common::new);

        public record Root(int levelChatScramble, int levelSignScramble, int levelNameScramble) {
            public static final Root DEFAULT = new Root(3, 3, 3);
            public static final MapCodec<Root> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)GreenhouseConfigCodecs.defaultFieldCodec((Codec)GreenhouseConfigCodecs.commentedCodec((Codec)Codec.intRange((int)1, (int)10), (String[])new String[]{"At what amplifier of Tipsy should the chat scramble?", "Default: " + DEFAULT.levelChatScramble()}), (String)"levelChatScramble", (Object)DEFAULT.levelChatScramble()).forGetter(Root::levelChatScramble), (App)GreenhouseConfigCodecs.defaultFieldCodec((Codec)GreenhouseConfigCodecs.commentedCodec((Codec)Codec.intRange((int)1, (int)10), (String[])new String[]{"At what amplifier of Tipsy should signs scramble?", "Default: " + DEFAULT.levelSignScramble()}), (String)"levelSignScramble", (Object)DEFAULT.levelSignScramble()).forGetter(Root::levelSignScramble), (App)GreenhouseConfigCodecs.defaultFieldCodec((Codec)GreenhouseConfigCodecs.commentedCodec((Codec)Codec.intRange((int)1, (int)10), (String[])new String[]{"At what amplifier of Tipsy should nametags scramble?", "Default: " + DEFAULT.levelNameScramble()}), (String)"levelNameScramble", (Object)DEFAULT.levelNameScramble()).forGetter(Root::levelNameScramble)).apply((Applicative)inst, Root::new));
            public static final class_9139<ByteBuf, Root> STREAM_CODEC = class_9139.method_56436((class_9139)class_9135.field_49675, Root::levelChatScramble, (class_9139)class_9135.field_49675, Root::levelSignScramble, (class_9139)class_9135.field_49675, Root::levelNameScramble, Root::new);
        }

        public record Keg(FluidUnit capacityUnit, long capacity, int cold, int chilly, int warm, int hot, boolean biomeTemp, boolean dimTemp) {
            public static final Keg DEFAULT = new Keg(BnCConfiguration.platformSpecificValue(FluidUnit.MILLIBUCKET, FluidUnit.DROPLET), BnCConfiguration.platformSpecificValue(1000L, 81000L), 2, 1, 1, 2, true, true);
            public static final Codec<Keg> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)GreenhouseConfigCodecs.defaultFieldCodec((Codec)GreenhouseConfigCodecs.commentedCodec(FluidUnit.CODEC, (String[])new String[]{"Which unit the capacity field should use.", "Should be 'liters', 'millibuckets' or 'droplets'", "1 L = 1 mB = 81 d", "Default: " + DEFAULT.capacityUnit().method_15434()}), (String)"kegCapacityUnit", (Object)((Object)DEFAULT.capacityUnit())).forGetter(Keg::capacityUnit), (App)GreenhouseConfigCodecs.defaultFieldCodec((Codec)GreenhouseConfigCodecs.commentedCodec((Codec)Codec.LONG.validate(l -> {
                if (l < 0L) {
                    return DataResult.error(() -> "Keg capacity cannot be below 0.");
                }
                return DataResult.success((Object)l);
            }), (String[])new String[]{"How much fluid (unit specified by capacityUnit) can the Keg hold?", "Range: 1 ~ " + FluidUnit.convert(10000L, FluidUnit.MILLIBUCKET, DEFAULT.capacityUnit()), "Default: " + DEFAULT.capacity() + "(" + DEFAULT.capacityUnit().method_15434() + ")"}), (String)"kegCapacity", (Object)DEFAULT.capacity()).forGetter(Keg::capacity), (App)GreenhouseConfigCodecs.defaultFieldCodec((Codec)GreenhouseConfigCodecs.commentedCodec((Codec)class_5699.field_33442, (String[])new String[]{"How many cold blocks are required for a cold temperature in the Keg?", "Default: " + DEFAULT.cold()}), (String)"kegCold", (Object)DEFAULT.cold()).forGetter(Keg::cold), (App)GreenhouseConfigCodecs.defaultFieldCodec((Codec)GreenhouseConfigCodecs.commentedCodec((Codec)class_5699.field_33442, (String[])new String[]{"How many cold blocks are required for a chilly temperature in the Keg?", "Default: " + DEFAULT.chilly()}), (String)"kegChilly", (Object)DEFAULT.chilly()).forGetter(Keg::chilly), (App)GreenhouseConfigCodecs.defaultFieldCodec((Codec)GreenhouseConfigCodecs.commentedCodec((Codec)class_5699.field_33442, (String[])new String[]{"How many hot blocks are required for a warm temperature in the Keg?", "Default: " + DEFAULT.warm()}), (String)"kegWarm", (Object)DEFAULT.warm()).forGetter(Keg::warm), (App)GreenhouseConfigCodecs.defaultFieldCodec((Codec)GreenhouseConfigCodecs.commentedCodec((Codec)class_5699.field_33442, (String[])new String[]{"How many hot blocks are required for a hot temperature in the Keg?", "Default: " + DEFAULT.hot()}), (String)"kegHot", (Object)DEFAULT.hot()).forGetter(Keg::hot), (App)GreenhouseConfigCodecs.defaultFieldCodec((Codec)GreenhouseConfigCodecs.commentedCodec((Codec)Codec.BOOL, (String[])new String[]{"Should the biome temperature influence the temperature in the Keg?", "Default: " + DEFAULT.biomeTemp()}), (String)"kegBiomeTemp", (Object)DEFAULT.biomeTemp()).forGetter(Keg::biomeTemp), (App)GreenhouseConfigCodecs.defaultFieldCodec((Codec)GreenhouseConfigCodecs.commentedCodec((Codec)Codec.BOOL, (String[])new String[]{"Should the dimension temperature influence the temperature in the Keg?", "Default: " + DEFAULT.dimTemp()}), (String)"kegDimTemp", (Object)DEFAULT.dimTemp()).forGetter(Keg::dimTemp)).apply((Applicative)inst, Keg::new));
            public static final class_9139<ByteBuf, Keg> STREAM_CODEC = class_9139.method_56437(Keg::encode, Keg::new);

            public Keg(ByteBuf buf) {
                this((FluidUnit)((Object)FluidUnit.STREAM_CODEC.decode((Object)buf)), buf.readLong(), buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt(), buf.readBoolean(), buf.readBoolean());
            }

            public long localizedCapacity() {
                return this.capacityUnit.convertToLoader(this.capacity);
            }

            public static void encode(ByteBuf buf, Keg keg) {
                FluidUnit.STREAM_CODEC.encode((Object)buf, (Object)keg.capacityUnit());
                buf.writeLong(keg.capacity);
                buf.writeInt(keg.cold);
                buf.writeInt(keg.chilly);
                buf.writeInt(keg.warm);
                buf.writeInt(keg.hot);
                buf.writeBoolean(keg.biomeTemp);
                buf.writeBoolean(keg.dimTemp);
            }
        }

        public record RecipeBook(boolean enabled) {
            public static final RecipeBook DEFAULT = new RecipeBook(true);
            public static final Codec<RecipeBook> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)GreenhouseConfigCodecs.defaultFieldCodec((Codec)GreenhouseConfigCodecs.commentedCodec((Codec)Codec.BOOL, (String[])new String[]{"Should the Keg have a Recipe Book available on its interface?", "Default: " + DEFAULT.enabled()}), (String)"enableRecipeBookKeg", (Object)DEFAULT.enabled()).forGetter(RecipeBook::enabled)).apply((Applicative)inst, RecipeBook::new));
            public static final class_9139<ByteBuf, RecipeBook> STREAM_CODEC = class_9135.field_48547.method_56432(RecipeBook::new, RecipeBook::enabled);
        }
    }

    public record Client(FluidUnit displayUnit, DisplaySettings oppositeFluidDisplay, boolean numbedHeartFlickering, boolean intoxicationFoodOverlay, boolean scrambleChat, boolean scrambleName, boolean scrambleSign, boolean renderFluidInKeg) {
        public static final Client DEFAULT = new Client(BnCConfiguration.platformSpecificValue(FluidUnit.MILLIBUCKET, FluidUnit.LITER), BnCConfiguration.platformSpecificValue(DisplaySettings.NEVER, DisplaySettings.ADVANCED_TOOLTIPS), true, true, true, true, true, true);
        private static final Codec<Client> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)GreenhouseConfigCodecs.defaultFieldCodec((Codec)GreenhouseConfigCodecs.commentedCodec(FluidUnit.CODEC, (String[])new String[]{"Which unit the fluid display in the keg should use.", "Should be 'liters', 'millibuckets' or 'droplets'", "1 L = 1 mB = 81 d", "Default: " + DEFAULT.displayUnit().method_15434()}), (String)"fluidDisplayUnit", (Object)((Object)DEFAULT.displayUnit())).forGetter(Client::displayUnit), (App)GreenhouseConfigCodecs.defaultFieldCodec((Codec)GreenhouseConfigCodecs.commentedCodec(DisplaySettings.CODEC, (String[])new String[]{"When the opposite fluid display unit should be shown.", "Should be one of 'never', 'advanced_tooltips' or 'always'", "Default: " + DEFAULT.oppositeFluidDisplay().method_15434()}), (String)"oppositeFluidDisplay", (Object)((Object)DEFAULT.oppositeFluidDisplay())).forGetter(Client::oppositeFluidDisplay), (App)GreenhouseConfigCodecs.defaultFieldCodec((Codec)GreenhouseConfigCodecs.commentedCodec((Codec)Codec.BOOL, (String[])new String[]{"Should the numbed hearts obtained from being damaged when Tipsy flicker when you are about to take damage?", "Default: " + DEFAULT.numbedHeartFlickering()}), (String)"numbedHeartFlickering", (Object)DEFAULT.numbedHeartFlickering()).forGetter(Client::numbedHeartFlickering), (App)GreenhouseConfigCodecs.defaultFieldCodec((Codec)GreenhouseConfigCodecs.commentedCodec((Codec)Codec.BOOL, (String[])new String[]{"Should the food bar have a yellow overlay when the player has the Intoxication effect?", "Default: " + DEFAULT.intoxicationFoodOverlay()}), (String)"intoxicationFoodOverlay", (Object)DEFAULT.intoxicationFoodOverlay()).forGetter(Client::intoxicationFoodOverlay), (App)GreenhouseConfigCodecs.defaultFieldCodec((Codec)GreenhouseConfigCodecs.commentedCodec((Codec)Codec.BOOL, (String[])new String[]{"Should the chat scramble when the player has the Tipsy effect?", "Default: " + DEFAULT.scrambleChat()}), (String)"scrambleChat", (Object)DEFAULT.scrambleChat()).forGetter(Client::scrambleChat), (App)GreenhouseConfigCodecs.defaultFieldCodec((Codec)GreenhouseConfigCodecs.commentedCodec((Codec)Codec.BOOL, (String[])new String[]{"Should other player's nametags scramble when the player has the Tipsy effect?", "Default: " + DEFAULT.scrambleName()}), (String)"scrambleName", (Object)DEFAULT.scrambleName()).forGetter(Client::scrambleName), (App)GreenhouseConfigCodecs.defaultFieldCodec((Codec)GreenhouseConfigCodecs.commentedCodec((Codec)Codec.BOOL, (String[])new String[]{"Should signs scramble when the player has the Tipsy effect?", "Default: " + DEFAULT.scrambleSign()}), (String)"scrambleSign", (Object)DEFAULT.scrambleSign()).forGetter(Client::scrambleSign), (App)GreenhouseConfigCodecs.defaultFieldCodec((Codec)GreenhouseConfigCodecs.commentedCodec((Codec)Codec.BOOL, (String[])new String[]{"Should kegs render the fluid texture in the background of the fluid slot?", "Default: " + DEFAULT.renderFluidInKeg()}), (String)"renderFluidInKeg", (Object)DEFAULT.renderFluidInKeg()).forGetter(Client::scrambleSign)).apply((Applicative)inst, Client::new));

        public static enum DisplaySettings implements class_3542
        {
            NEVER("never"),
            ADVANCED_TOOLTIPS("advanced_tooltips"),
            ALWAYS("always");

            public static final Codec<DisplaySettings> CODEC;
            final String name;

            private DisplaySettings(String name) {
                this.name = name;
            }

            @NotNull
            public String method_15434() {
                return this.name;
            }

            static {
                CODEC = class_3542.method_28140(DisplaySettings::values);
            }
        }
    }
}

