/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.common.block.entity.container;

import it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_1662;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_8786;
import org.jetbrains.annotations.Nullable;
import umpaz.brewinandchewin.BrewinAndChewin;
import umpaz.brewinandchewin.common.block.entity.KegBlockEntity;
import umpaz.brewinandchewin.common.block.entity.container.KegMenu;
import umpaz.brewinandchewin.common.container.AbstractedFluidTank;
import umpaz.brewinandchewin.common.crafting.KegFermentingRecipe;
import umpaz.brewinandchewin.common.mixin.StackedContentsRecipePickerAccessor;
import umpaz.brewinandchewin.common.registry.BnCRecipeTypes;
import umpaz.brewinandchewin.common.utility.FluidUnit;

public class KegStackedContents
extends class_1662 {
    public final KegMenu menu;
    public final class_1863 recipeManager;
    private boolean ignoreItems = false;
    private boolean ignoreFluids = false;

    public KegStackedContents(KegMenu menu, class_1863 manager) {
        this.menu = menu;
        this.recipeManager = manager;
    }

    public void setIgnoreItems(boolean value) {
        this.ignoreItems = value;
    }

    public void setIgnoreFluids(boolean value) {
        this.ignoreFluids = value;
    }

    public boolean shouldIgnoreItems() {
        return this.ignoreItems;
    }

    public boolean isFluidItem(class_1860<?> recipe, int itemIndex) {
        return new RecipePicker(recipe).isFluidItem(itemIndex);
    }

    public boolean method_7406(class_1860<?> recipe, @Nullable IntList stackingIndexList, int amount) {
        if (recipe instanceof KegFermentingRecipe) {
            KegFermentingRecipe fermentingRecipe = (KegFermentingRecipe)recipe;
            if (!KegBlockEntity.isValidTemp(this.menu.getKegTemperature(), fermentingRecipe.getTemperature())) {
                return false;
            }
        }
        return new RecipePicker(recipe).method_7417(amount, stackingIndexList);
    }

    public int method_7403(class_8786<?> recipe, int amount, @Nullable IntList stackingIndexList) {
        return new RecipePicker(recipe.comp_1933()).method_7427(amount, stackingIndexList);
    }

    public class RecipePicker
    extends class_1662.class_1663 {
        private final Int2IntMap stackCountRequirements;

        public RecipePicker(class_1860<?> recipe) {
            super((class_1662)KegStackedContents.this, recipe);
            this.stackCountRequirements = new Int2IntArrayMap();
            if (recipe instanceof KegFermentingRecipe) {
                KegFermentingRecipe fermentingRecipe = (KegFermentingRecipe)recipe;
                boolean modified = false;
                AbstractedFluidTank kegTank = KegStackedContents.this.menu.kegTank;
                StackedContentsRecipePickerAccessor accessor = (StackedContentsRecipePickerAccessor)((Object)this);
                if (KegStackedContents.this.ignoreItems) {
                    accessor.brewinandchewin$getIngredients().clear();
                    modified = true;
                }
                if (!KegStackedContents.this.ignoreFluids) {
                    if (fermentingRecipe.getFluidIngredient().isEmpty() && !kegTank.isEmpty()) {
                        List<PouringEntry> fluidContainerStacks = KegStackedContents.this.recipeManager.method_30027(BnCRecipeTypes.KEG_POURING).stream().map(class_8786::comp_1933).filter(kegPouringRecipe -> kegPouringRecipe.getRawFluid().fluid().method_15780(kegTank.getAbstractedFluid().fluid())).map(r -> new PouringEntry(r.getContainer(), r.getRawFluid().amount(), r.getUnit(), r.isStrict())).toList();
                        if (!fluidContainerStacks.isEmpty()) {
                            for (PouringEntry entry : fluidContainerStacks) {
                                int itemAmount = (int)(kegTank.getAbstractedFluid().amount() / entry.fluidUnit().convertToLoader(entry.fluidAmount()));
                                this.stackCountRequirements.put(class_1662.method_7408((class_1799)entry.stack()), itemAmount);
                            }
                            class_1856 extractIngredient = class_1856.method_8101((class_1799[])((class_1799[])fluidContainerStacks.stream().map(PouringEntry::stack).toArray(class_1799[]::new)));
                            extractIngredient.method_8105();
                            extractIngredient.method_8100();
                            accessor.brewinandchewin$getIngredients().add(extractIngredient);
                            modified = true;
                        }
                    } else if (fermentingRecipe.getFluidIngredient().isPresent()) {
                        Object fluidContainerStacks;
                        List fluidOutputStacks = KegStackedContents.this.recipeManager.method_30027(BnCRecipeTypes.KEG_POURING).stream().map(class_8786::comp_1933).filter(kegPouringRecipe -> kegPouringRecipe.canFill() && fermentingRecipe.getFluidIngredient().get().ingredient().matches(kegPouringRecipe.getRawFluid())).map(r -> new PouringEntry(r.getOutput(), r.getRawFluid().amount(), r.getUnit(), r.isStrict())).collect(Collectors.toCollection(ArrayList::new));
                        long tankAmount = kegTank.getAbstractedFluid().amount();
                        if (!(kegTank.isEmpty() || fermentingRecipe.getFluidIngredient().get().ingredient().matches(kegTank.getAbstractedFluid()) || (fluidContainerStacks = KegStackedContents.this.recipeManager.method_30027(BnCRecipeTypes.KEG_POURING).stream().map(class_8786::comp_1933).filter(kegPouringRecipe -> kegPouringRecipe.getRawFluid().fluid().method_15780(kegTank.getAbstractedFluid().fluid())).map(r -> new PouringEntry(r.getContainer(), r.getRawFluid().amount(), r.getUnit(), r.isStrict())).toList()).isEmpty())) {
                            Iterator iterator = fluidContainerStacks.iterator();
                            while (iterator.hasNext()) {
                                PouringEntry entry = (PouringEntry)iterator.next();
                                int itemAmount = (int)(kegTank.getAbstractedFluid().amount() / entry.fluidUnit().convertToLoader(entry.fluidAmount()));
                                tankAmount -= (long)itemAmount * entry.fluidUnit().convertToLoader(entry.fluidAmount());
                                this.stackCountRequirements.put(class_1662.method_7408((class_1799)entry.stack()), itemAmount);
                            }
                            class_1856 extractIngredient = class_1856.method_8101((class_1799[])((class_1799[])fluidContainerStacks.stream().map(PouringEntry::stack).toArray(class_1799[]::new)));
                            extractIngredient.method_8105();
                            extractIngredient.method_8100();
                            accessor.brewinandchewin$getIngredients().add(extractIngredient);
                            modified = true;
                        }
                        if (kegTank.isEmpty() || !fermentingRecipe.getFluidIngredient().get().ingredient().matches(kegTank.getAbstractedFluid()) || tankAmount < fermentingRecipe.getFluidIngredient().get().amount()) {
                            for (PouringEntry entry : List.copyOf(fluidOutputStacks)) {
                                int itemAmount = (int)(Math.max(fermentingRecipe.getFluidIngredient().get().loaderAmount(), entry.fluidUnit().convertToLoader(entry.fluidAmount()) - tankAmount) / entry.fluidUnit().convertToLoader(entry.fluidAmount()) - tankAmount % fermentingRecipe.getFluidIngredient().get().loaderAmount() / entry.fluidUnit().convertToLoader(entry.fluidAmount()));
                                if (itemAmount <= 0 || (long)itemAmount * entry.fluidUnit().convertToLoader(entry.fluidAmount()) + tankAmount > kegTank.getFluidCapacity()) {
                                    fluidOutputStacks.remove(entry);
                                    continue;
                                }
                                this.stackCountRequirements.put(class_1662.method_7408((class_1799)entry.stack()), itemAmount);
                            }
                            if (!fluidOutputStacks.isEmpty()) {
                                class_1856 fillIngredient = class_1856.method_8101((class_1799[])((class_1799[])fluidOutputStacks.stream().map(PouringEntry::stack).toArray(class_1799[]::new)));
                                if (fluidOutputStacks.stream().anyMatch(PouringEntry::strict)) {
                                    fillIngredient = BrewinAndChewin.getHelper().createStrictFillPickerIngredient(fluidOutputStacks);
                                }
                                fillIngredient.method_8105();
                                fillIngredient.method_8100();
                                accessor.brewinandchewin$getIngredients().add(fillIngredient);
                                modified = true;
                            }
                        }
                    }
                }
                if (!modified) {
                    return;
                }
                accessor.brewinandchewin$getIngredients().removeIf(class_1856::method_8103);
                accessor.brewinandchewin$setIngredientCount(accessor.brewinandchewin$getIngredients().size());
                accessor.brewinandchewin$setItems(accessor.brewinandchewin$invokeGetUniqueAvailableIngredientItems());
                accessor.brewinandchewin$setItemCount(accessor.brewinandchewin$getItems().length);
                accessor.brewinandchewin$setData(new BitSet(accessor.brewinandchewin$getIngredientCount() + accessor.brewinandchewin$getItemCount() + accessor.brewinandchewin$getIngredientCount() + accessor.brewinandchewin$getIngredientCount() * accessor.brewinandchewin$getItemCount()));
                for (int i = 0; i < accessor.brewinandchewin$getIngredients().size(); ++i) {
                    IntList intlist = accessor.brewinandchewin$getIngredients().get(i).method_8100();
                    for (int j = 0; j < accessor.brewinandchewin$getItemCount(); ++j) {
                        if (!intlist.contains(accessor.brewinandchewin$getItems()[j])) continue;
                        int bitIndex = accessor.brewinandchewin$invokeGetIndex(true, j, i);
                        accessor.brewinandchewin$getData().set(bitIndex);
                    }
                }
            }
        }

        public boolean isFluidItem(int itemIndex) {
            return this.stackCountRequirements.containsKey(itemIndex);
        }

        public boolean hasFluidAmount(int originalAmount, int itemIndex) {
            return !this.isFluidItem(itemIndex) || originalAmount >= this.stackCountRequirements.get(itemIndex);
        }

        public KegStackedContents getOuter() {
            return KegStackedContents.this;
        }
    }

    public record PouringEntry(class_1799 stack, long fluidAmount, FluidUnit fluidUnit, boolean strict) {
    }
}

