/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.common.utility;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.function.Function;
import java.util.function.IntFunction;
import net.minecraft.class_3542;
import net.minecraft.class_7995;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import umpaz.brewinandchewin.BrewinAndChewin;
import umpaz.brewinandchewin.platform.BnCPlatform;

public enum FluidUnit implements class_3542
{
    LITER("liters", l -> l + " L", l -> l + " liters", 1L),
    MILLIBUCKET("millibuckets", l -> l + " mB", l -> l + " millibuckets", 1L),
    DROPLET("droplets", l -> l + " d", l -> l + " droplets", 81L);

    private final String name;
    private final Function<String, String> shortFormFormatFunc;
    private final Function<String, String> longFormFormatFunc;
    private final long oneL;
    public static final Codec<FluidUnit> CODEC;
    public static final IntFunction<FluidUnit> BY_ID;
    public static final class_9139<ByteBuf, FluidUnit> STREAM_CODEC;

    private FluidUnit(String name, Function<String, String> shortFormFormatFunc, Function<String, String> longFormFormatFunc, long oneL) {
        this.name = name;
        this.shortFormFormatFunc = shortFormFormatFunc;
        this.longFormFormatFunc = longFormFormatFunc;
        this.oneL = oneL;
    }

    public long convert(long value, FluidUnit unit) {
        return FluidUnit.convert(value, this, unit);
    }

    public long convertToLoader(long value) {
        return FluidUnit.convertToLoader(value, this);
    }

    public static FluidUnit getOpposite(FluidUnit unit) {
        if (unit == DROPLET) {
            return BrewinAndChewin.getHelper().getPlatform() == BnCPlatform.NEOFORGE ? MILLIBUCKET : LITER;
        }
        return DROPLET;
    }

    public static FluidUnit getLoaderUnit() {
        return BrewinAndChewin.getHelper().getPlatform() == BnCPlatform.NEOFORGE ? MILLIBUCKET : DROPLET;
    }

    public static long convertToLoader(long value, FluidUnit unit) {
        return FluidUnit.convert(value, unit, FluidUnit.getLoaderUnit());
    }

    public static long convert(long value, FluidUnit originalUnit, FluidUnit newUnit) {
        if (originalUnit.oneL == newUnit.oneL) {
            return value;
        }
        return value / originalUnit.oneL * newUnit.oneL;
    }

    public String shortFormat(String value) {
        return this.shortFormFormatFunc.apply(value);
    }

    public String longFormat(String value) {
        return this.longFormFormatFunc.apply(value);
    }

    public String method_15434() {
        return this.name;
    }

    static {
        CODEC = class_3542.method_28140(FluidUnit::values);
        BY_ID = class_7995.method_47914(Enum::ordinal, (Object[])FluidUnit.values(), (class_7995.class_7996)class_7995.class_7996.field_41664);
        STREAM_CODEC = class_9135.method_56375(BY_ID, Enum::ordinal);
    }
}

