/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.fabric.container;

import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.SlottedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1799;
import net.minecraft.class_3611;
import net.minecraft.class_9323;
import net.minecraft.class_9326;
import net.minecraft.class_9335;
import umpaz.brewinandchewin.common.container.AbstractedFluidTank;
import umpaz.brewinandchewin.common.utility.AbstractedFluidStack;
import umpaz.brewinandchewin.common.utility.FluidUnit;
import umpaz.brewinandchewin.fabric.utility.AmountedFluidVariant;

public class KegFluidItemStorageFabric
implements AbstractedFluidTank {
    private final Storage<FluidVariant> storage;
    private final ContainerItemContext context;
    private long capacity = -1L;

    public KegFluidItemStorageFabric(class_1799 stack) {
        this.context = ContainerItemContext.withConstant((class_1799)stack);
        this.storage = (Storage)FluidStorage.ITEM.find(stack, (Object)this.context);
    }

    @Override
    public long getFluidCapacity(int slot) {
        block0: {
            Object object;
            block2: {
                block1: {
                    if (this.capacity >= 0L) break block0;
                    object = this.storage;
                    if (!(object instanceof SlottedStorage)) break block1;
                    SlottedStorage view = (SlottedStorage)object;
                    this.capacity = view.getSlot(slot).getCapacity();
                    break block0;
                }
                object = this.storage;
                if (!(object instanceof StorageView)) break block2;
                StorageView view = (StorageView)object;
                this.capacity = view.getCapacity();
                break block0;
            }
            object = this.storage.iterator();
            if (!object.hasNext()) break block0;
            StorageView view = (StorageView)object.next();
            this.capacity = view.getCapacity();
        }
        return this.capacity;
    }

    @Override
    public AbstractedFluidStack getAbstractedFluid() {
        Storage<FluidVariant> storage = this.storage;
        if (storage instanceof StorageView) {
            StorageView view = (StorageView)storage;
            FluidVariant variant = (FluidVariant)view.getResource();
            AmountedFluidVariant amounted = new AmountedFluidVariant(variant, view.getAmount(), FluidUnit.DROPLET);
            return new AbstractedFluidStack(variant.getFluid(), view.getAmount(), variant.getComponentMap(), FluidUnit.DROPLET, amounted);
        }
        return AbstractedFluidStack.EMPTY;
    }

    @Override
    public void setAbstractedFluid(AbstractedFluidStack stack) {
        if (this.storage.supportsInsertion()) {
            try (Transaction t = Transaction.openOuter();){
                class_9326 class_93262;
                class_3611 class_36112 = stack.fluid();
                class_9323 class_93232 = stack.components();
                if (class_93232 instanceof class_9335) {
                    class_9335 patched = (class_9335)class_93232;
                    class_93262 = patched.method_57940();
                } else {
                    class_93262 = class_9326.field_49588;
                }
                FluidVariant variant = FluidVariant.of((class_3611)class_36112, (class_9326)class_93262);
                this.storage.insert((Object)variant, this.capacity, (TransactionContext)t);
                t.commit();
            }
        }
    }

    @Override
    public AbstractedFluidStack fill(AbstractedFluidStack stack, boolean simulate) {
        if (this.storage.supportsInsertion()) {
            try (Transaction t = Transaction.openOuter();){
                class_9326 class_93262;
                class_3611 class_36112 = stack.fluid();
                class_9323 class_93232 = stack.components();
                if (class_93232 instanceof class_9335) {
                    class_9335 patched = (class_9335)class_93232;
                    class_93262 = patched.method_57940();
                } else {
                    class_93262 = class_9326.field_49588;
                }
                FluidVariant variant = FluidVariant.of((class_3611)class_36112, (class_9326)class_93262);
                long newFill = this.storage.insert((Object)variant, this.capacity, (TransactionContext)t);
                if (!simulate) {
                    t.commit();
                }
                AbstractedFluidStack abstractedFluidStack = new AbstractedFluidStack(variant.getFluid(), newFill, variant.getComponentMap(), FluidUnit.DROPLET, new AmountedFluidVariant(variant, newFill, FluidUnit.DROPLET));
                return abstractedFluidStack;
            }
        }
        return this.getAbstractedFluid();
    }

    @Override
    public AbstractedFluidStack drain(int slot, long maxDrain, FluidUnit unit, boolean simulate) {
        Storage<FluidVariant> storage;
        if (this.storage.supportsExtraction() && (storage = this.storage) instanceof SlottedStorage) {
            SlottedStorage slottedStorage = (SlottedStorage)storage;
            try (Transaction t = Transaction.openOuter();){
                SingleSlotStorage singleSlot = slottedStorage.getSlot(slot);
                long extractedAmount = this.storage.extract((Object)((FluidVariant)singleSlot.getResource()), unit.convertToLoader(maxDrain), (TransactionContext)t);
                AbstractedFluidStack stack = new AbstractedFluidStack(((FluidVariant)singleSlot.getResource()).getFluid(), extractedAmount, ((FluidVariant)singleSlot.getResource()).getComponentMap(), FluidUnit.DROPLET, new AmountedFluidVariant((FluidVariant)singleSlot.getResource(), extractedAmount, FluidUnit.DROPLET));
                if (!simulate) {
                    t.commit();
                }
                AbstractedFluidStack abstractedFluidStack = stack;
                return abstractedFluidStack;
            }
        }
        return AbstractedFluidStack.EMPTY;
    }

    @Override
    public class_1799 getContainer() {
        return this.context.getItemVariant().toStack();
    }

    @Override
    public boolean isEmpty() {
        return this.storage.nonEmptyIterator().hasNext();
    }

    @Override
    public boolean isFluidValid(int slot, AbstractedFluidStack stack) {
        try (Transaction t = Transaction.openOuter();){
            boolean bl = this.storage.insert((Object)((AmountedFluidVariant)stack.loaderSpecific()).variant(), this.getFluidCapacity(), (TransactionContext)t) > 0L;
            return bl;
        }
    }
}

