/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.fabric.container;

import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import org.jetbrains.annotations.Nullable;
import umpaz.brewinandchewin.common.block.entity.container.SidedKegWrapper;
import umpaz.brewinandchewin.common.container.AbstractedItemHandler;
import vectorwing.farmersdelight.refabricated.inventory.ItemHandler;
import vectorwing.farmersdelight.refabricated.inventory.ItemStackHandler;
import vectorwing.farmersdelight.refabricated.inventory.ItemStackStorage;

public class SidedKegWrapperFabric
extends SidedKegWrapper
implements ItemHandler {
    public SidedKegWrapperFabric(AbstractedItemHandler itemHandler, @Nullable class_2350 side) {
        super(itemHandler, side);
    }

    public SingleSlotStorage<ItemVariant> getSlot(int slot) {
        return ((ItemHandler)this.itemHandler).getSlot(slot);
    }

    public long insert(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        ItemStackStorage slot;
        StoragePreconditions.notBlankNotNegative((TransferVariant)resource, (long)maxAmount);
        long inserted = 0L;
        Iterator<ItemStackStorage> itr = this.getInsertableSlotsFor(resource);
        while (itr.hasNext() && (inserted += (slot = itr.next()).insert((TransferVariant)resource, maxAmount - inserted, transaction)) < maxAmount) {
        }
        return inserted;
    }

    public long extract(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        ItemStackStorage slot;
        StoragePreconditions.notBlankNotNegative((TransferVariant)resource, (long)maxAmount);
        long extracted = 0L;
        Iterator iterator = this.getSlotsContaining(resource, true).iterator();
        while (iterator.hasNext() && (extracted += (slot = (ItemStackStorage)iterator.next()).extract((TransferVariant)resource, maxAmount - extracted, transaction)) < maxAmount) {
        }
        return extracted;
    }

    public long insertSlot(int slot, ItemVariant resource, long maxAmount, TransactionContext transaction) {
        if (!this.isValidSlot(slot, false)) {
            return 0L;
        }
        return ((ItemStackHandler)this.itemHandler).extractSlot(slot, resource, maxAmount, transaction);
    }

    public long extractSlot(int slot, ItemVariant resource, long maxAmount, TransactionContext transaction) {
        if (!this.isValidSlot(slot, true)) {
            return 0L;
        }
        return ((ItemStackHandler)this.itemHandler).extractSlot(slot, resource, maxAmount, transaction);
    }

    @Override
    public void commitModifiedStacks() {
        ((ItemStackHandler)this.itemHandler).commitModifiedStacks();
    }

    public class_1799 removeItem(int slot, int amount) {
        return this.extractItem(slot, amount, false);
    }

    public Iterator<StorageView<ItemVariant>> iterator() {
        ItemStackHandler handler = (ItemStackHandler)this.itemHandler;
        return this.side != null && !this.side.equals((Object)class_2350.field_11036) ? handler.getSlots().subList(4, 6).iterator() : handler.getSlots().subList(0, 4).iterator();
    }

    public SortedSet<ItemStackStorage> getSlotsContaining(ItemVariant resource, boolean output) {
        ItemStackHandler handler = (ItemStackHandler)this.itemHandler;
        List slots = this.side != null && !this.side.equals((Object)class_2350.field_11036) ? List.of(output ? (SingleSlotStorage)handler.getSlots().get(5) : (SingleSlotStorage)handler.getSlots().get(4)) : handler.getSlots().subList(0, 4);
        return (SortedSet)slots.stream().map(storageView -> (ItemStackStorage)storageView).filter(storageView -> ((ItemVariant)storageView.getResource()).equals((Object)resource)).collect(Collectors.toCollection(ObjectLinkedOpenHashSet::new));
    }

    public Iterator<ItemStackStorage> getInsertableSlotsFor(ItemVariant resource) {
        ItemStackHandler handler = (ItemStackHandler)this.itemHandler;
        List slots = this.side != null && !this.side.equals((Object)class_2350.field_11036) ? List.of((SingleSlotStorage)handler.getSlots().get(4)) : handler.getSlots().subList(0, 4);
        return slots.stream().map(storageView -> (ItemStackStorage)storageView).filter(storageView -> ((ItemVariant)storageView.getResource()).equals((Object)resource)).filter(views -> views.isResourceBlank() || ((ItemVariant)views.getResource()).equals((Object)resource)).iterator();
    }

    private boolean isValidSlot(int slot, boolean extract) {
        if (this.side == null || this.side.equals((Object)class_2350.field_11036)) {
            return slot < 3;
        }
        return extract ? slot == 5 : slot == 4;
    }
}

