/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterendisland.world;

import com.google.common.collect.ImmutableList;
import com.yungnickyoung.minecraft.betterendisland.BetterEndIslandCommon;
import com.yungnickyoung.minecraft.betterendisland.world.IDragonFight;
import com.yungnickyoung.minecraft.betterendisland.world.IEndSpike;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1511;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2881;
import net.minecraft.class_3031;
import net.minecraft.class_3037;
import net.minecraft.class_3218;
import net.minecraft.class_3310;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3542;
import net.minecraft.class_3666;
import net.minecraft.class_5281;
import net.minecraft.class_5819;

public enum DragonRespawnStage implements class_3542
{
    START("start"){

        @Override
        public void tick(class_3218 level, class_2881 dragonFight, List<class_1511> summoningCrystals, int phaseTimer, class_2338 portalPos) {
            class_2338 beamTargetPos = new class_2338(0, 128, 0);
            summoningCrystals.forEach(crystal -> crystal.method_6837(beamTargetPos));
            ((IDragonFight)dragonFight).betterendisland$setDragonRespawnStage(PREPARING_TO_SUMMON_PILLARS);
        }
    }
    ,
    PREPARING_TO_SUMMON_PILLARS("preparing_to_summon_pillars"){

        @Override
        public void tick(class_3218 level, class_2881 dragonFight, List<class_1511> summoningCrystals, int phaseTimer, class_2338 portalPos) {
            int totalPhaseTime = 100;
            if (phaseTimer < totalPhaseTime) {
                if (phaseTimer == 0 || phaseTimer == 50 || phaseTimer == 51 || phaseTimer == 52 || phaseTimer >= 95) {
                    DragonRespawnStage.broadcastDragonGrowlSound(level);
                }
            } else {
                ((IDragonFight)dragonFight).betterendisland$setDragonRespawnStage(SUMMONING_PILLARS);
            }
        }
    }
    ,
    SUMMONING_PILLARS("summoning_pillars"){

        @Override
        public void tick(class_3218 level, class_2881 dragonFight, List<class_1511> summoningCrystals, int phaseTimer, class_2338 portalPos) {
            boolean isLastTickForSpike;
            int ticksPerSpike = 40;
            boolean isFirstTickForSpike = phaseTimer % ticksPerSpike == 0;
            boolean bl = isLastTickForSpike = phaseTimer % ticksPerSpike == 39;
            if (isFirstTickForSpike || isLastTickForSpike) {
                int spikeIndex = phaseTimer / ticksPerSpike;
                List allSpikes = class_3310.method_14506((class_5281)level);
                if (spikeIndex < allSpikes.size()) {
                    class_3310.class_3181 spike = (class_3310.class_3181)allSpikes.get(spikeIndex);
                    int pillarHeight = (spike.method_13964() - 73) / 3;
                    if (pillarHeight == 10) {
                        pillarHeight = 9;
                    }
                    ((IEndSpike)spike).betterendisland$setCrystalYOffsetFromPillarHeight(pillarHeight);
                    int topY = BetterEndIslandCommon.betterEnd ? 70 : 60;
                    int crystalY = topY + ((IEndSpike)spike).betterendisland$getCrystalYOffset() - 1;
                    if (isFirstTickForSpike) {
                        for (class_1511 crystal : summoningCrystals) {
                            crystal.method_6837(new class_2338(spike.method_13966(), crystalY, spike.method_13967()));
                        }
                    } else {
                        level.method_8437(null, (double)((float)spike.method_13966() + 0.5f), (double)crystalY, (double)((float)spike.method_13967() + 0.5f), 5.0f, class_1937.class_7867.field_40889);
                        level.method_18456().forEach(player -> {
                            level.method_14166(player, (class_2394)class_2398.field_11221, true, (double)((float)spike.method_13966() - 5.0f), (double)crystalY, (double)((float)spike.method_13967() - 5.0f), 1, 0.0, 0.0, 0.0, 0.0);
                            level.method_14166(player, (class_2394)class_2398.field_11221, true, (double)((float)spike.method_13966() - 5.0f), (double)crystalY, (double)((float)spike.method_13967() + 5.0f), 1, 0.0, 0.0, 0.0, 0.0);
                            level.method_14166(player, (class_2394)class_2398.field_11221, true, (double)((float)spike.method_13966() + 5.0f), (double)crystalY, (double)((float)spike.method_13967() - 5.0f), 1, 0.0, 0.0, 0.0, 0.0);
                            level.method_14166(player, (class_2394)class_2398.field_11221, true, (double)((float)spike.method_13966() + 5.0f), (double)crystalY, (double)((float)spike.method_13967() + 5.0f), 1, 0.0, 0.0, 0.0, 0.0);
                            if (player.method_5649((double)spike.method_13966(), (double)crystalY, (double)spike.method_13967()) > 32.0) {
                                level.method_8396(null, new class_2338(spike.method_13966(), crystalY, spike.method_13967()), (class_3414)class_3417.field_15152.comp_349(), class_3419.field_15254, 24.0f, 1.0f);
                            }
                        });
                        int resetRadius = 11;
                        int verticalRadius = BetterEndIslandCommon.betterEnd ? 40 : 30;
                        for (class_2338 blockPos : class_2338.method_10097((class_2338)new class_2338(spike.method_13966() - resetRadius, spike.method_13964() - verticalRadius, spike.method_13967() - resetRadius), (class_2338)new class_2338(spike.method_13966() + resetRadius, spike.method_13964() + verticalRadius, spike.method_13967() + resetRadius))) {
                            if (level.method_8320(blockPos).method_27852(class_2246.field_10471)) continue;
                            level.method_8650(blockPos, false);
                        }
                        class_3666 spikeConfig = new class_3666(true, (List)ImmutableList.of((Object)spike), new class_2338(0, 128, 0));
                        class_3031.field_13522.method_40163((class_3037)spikeConfig, (class_5281)level, level.method_14178().method_12129(), class_5819.method_43047(), new class_2338(spike.method_13966(), 45, spike.method_13967()));
                    }
                } else if (isFirstTickForSpike) {
                    ((IDragonFight)dragonFight).betterendisland$setDragonRespawnStage(SUMMONING_DRAGON);
                }
            }
        }
    }
    ,
    SUMMONING_DRAGON("summoning_dragon"){

        @Override
        public void tick(class_3218 level, class_2881 dragonFight, List<class_1511> summoningCrystals, int phaseTimer, class_2338 portalPos) {
            int totalPhaseTime = 100;
            if (phaseTimer >= totalPhaseTime) {
                ((IDragonFight)dragonFight).betterendisland$setDragonRespawnStage(END);
                dragonFight.method_12524();
                for (class_1511 crystal : summoningCrystals) {
                    crystal.method_6837(null);
                    level.method_8437((class_1297)crystal, crystal.method_23317(), crystal.method_23318(), crystal.method_23321(), 6.0f, class_1937.class_7867.field_40888);
                    crystal.method_31472();
                }
            } else if (phaseTimer >= 80) {
                DragonRespawnStage.broadcastDragonGrowlSound(level);
            } else if (phaseTimer == 0) {
                for (class_1511 crystal : summoningCrystals) {
                    crystal.method_6837(new class_2338(0, 128, 0));
                }
            } else if (phaseTimer < 5) {
                DragonRespawnStage.broadcastDragonGrowlSound(level);
            }
        }
    }
    ,
    END("end"){

        @Override
        public void tick(class_3218 level, class_2881 dragonFight, List<class_1511> summoningCrystals, int phaseTimer, class_2338 portalPos) {
        }
    };

    public static final class_3542.class_7292<DragonRespawnStage> CODEC;
    private final String name;

    @Nullable
    public static DragonRespawnStage byName(@Nullable String name) {
        return (DragonRespawnStage)CODEC.method_42633(name);
    }

    private DragonRespawnStage(String name) {
        this.name = name.toLowerCase();
    }

    public String method_15434() {
        return this.name;
    }

    private static void broadcastDragonGrowlSound(class_3218 level) {
        level.method_20290(3001, new class_2338(0, 128, 0), 0);
    }

    public abstract void tick(class_3218 var1, class_2881 var2, List<class_1511> var3, int var4, class_2338 var5);

    static {
        CODEC = class_3542.method_28140(DragonRespawnStage::values);
    }
}

