/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.enchantonce.events;

import com.mojang.logging.LogUtils;
import com.pekar.enchantonce.events.IEventHandler;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import net.minecraft.core.Holder;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.AnvilUpdateEvent;
import net.neoforged.neoforge.event.entity.living.LivingEvent;
import org.slf4j.Logger;

public class WorldEvents
implements IEventHandler {
    private static final int EQUIPMENT_REPAIR_PORTIONS = 4;
    private static final int TOOL_REPAIR_PORTIONS = 4;
    private static final int ELYTRA_REPAIR_PORTIONS = 1;
    private static final int SHIELD_REPAIR_PORTIONS = 2;
    private static final int FLINT_AND_STEEL_REPAIR_PORTIONS = 1;
    private static final int SHEARS_REPAIR_PORTIONS = 1;
    private static final int ELYTRA_REPAIR_AMOUNT = Items.ELYTRA.getDefaultInstance().getMaxDamage() / 1;
    private static final int SHIELD_REPAIR_AMOUNT = Items.SHIELD.getDefaultInstance().getMaxDamage() / 2;
    private static final int BOW_REPAIR_AMOUNT = Items.BOW.getDefaultInstance().getMaxDamage() / 4;
    private static final int FISHING_ROD_REPAIR_AMOUNT = Items.FISHING_ROD.getDefaultInstance().getMaxDamage() / 4;
    private static final int FLINT_AND_STEEL_REPAIR_AMOUNT = Items.FLINT_AND_STEEL.getDefaultInstance().getMaxDamage() / 1;
    private static final int CROSSBOW_REPAIR_AMOUNT = Items.CROSSBOW.getDefaultInstance().getMaxDamage() / 4;
    private static final int TRIDENT_REPAIR_AMOUNT = Items.TRIDENT.getDefaultInstance().getMaxDamage() / 4;
    private static final int SHEARS_REPAIR_AMOUNT = Items.SHEARS.getDefaultInstance().getMaxDamage() / 1;
    private static final int BRUSH_REPAIR_AMOUNT = Items.BRUSH.getDefaultInstance().getMaxDamage() / 4;
    private static final int MACE_REPAIR_AMOUNT = Items.MACE.getDefaultInstance().getMaxDamage() / 4;
    private static final int REPAIR_COST = 2;
    private static final int COPY_ENCHANTS_COST = 25;
    private static final int COPY_ENCHANTS_TO_BOOK_COST = 1;
    private static final int MAX_BOOK_COPIES = 4;
    private static final Logger LOGGER = LogUtils.getLogger();

    public void onLivingJump(LivingEvent.LivingJumpEvent event) {
        ItemStack mainHandItem = event.getEntity().getMainHandItem();
        if (mainHandItem.isDamageableItem()) {
            mainHandItem.setDamageValue(mainHandItem.getMaxDamage() - 4);
            LivingEntity livingEntity = event.getEntity();
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                player.giveExperienceLevels(50);
            }
        }
    }

    @SubscribeEvent
    public void onAnvilUpdateEvent(AnvilUpdateEvent event) {
        boolean areItemsTheSame;
        ItemStack rightItemStack = event.getRight();
        Item rightItem = rightItemStack.getItem();
        ItemStack leftItemStack = event.getLeft();
        Item leftItem = leftItemStack.getItem();
        if (rightItem == Items.PHANTOM_MEMBRANE) {
            if (leftItem == Items.ELYTRA) {
                this.setAndRepair(leftItemStack, ELYTRA_REPAIR_AMOUNT, event);
                return;
            }
        } else if (rightItemStack.is(ItemTags.PLANKS) && leftItem == Items.SHIELD) {
            this.setAndRepair(leftItemStack, SHIELD_REPAIR_AMOUNT, event);
            return;
        }
        if (leftItemStack.isDamageableItem() && this.validateAndRepair(event, leftItemStack, rightItem)) {
            return;
        }
        if (rightItem == Items.IRON_INGOT) {
            if (leftItem == Items.SHEARS) {
                this.setAndRepair(leftItemStack, SHEARS_REPAIR_AMOUNT, event);
                return;
            }
        } else if (rightItem == Items.STRING) {
            if (leftItem == Items.BOW) {
                this.setAndRepair(leftItemStack, BOW_REPAIR_AMOUNT, event);
                return;
            }
            if (leftItem == Items.FISHING_ROD) {
                this.setAndRepair(leftItemStack, FISHING_ROD_REPAIR_AMOUNT, event);
                return;
            }
            if (leftItem == Items.CROSSBOW) {
                this.setAndRepair(leftItemStack, CROSSBOW_REPAIR_AMOUNT, event);
                return;
            }
        } else if (rightItem == Items.FEATHER) {
            if (leftItem == Items.BRUSH) {
                this.setAndRepair(leftItemStack, BRUSH_REPAIR_AMOUNT, event);
                return;
            }
        } else if (rightItem == Items.FLINT) {
            if (leftItem == Items.FLINT_AND_STEEL) {
                this.setAndRepair(leftItemStack, FLINT_AND_STEEL_REPAIR_AMOUNT, event);
                return;
            }
        } else if (rightItem == Items.PRISMARINE_SHARD) {
            if (leftItem == Items.TRIDENT) {
                this.setAndRepair(leftItemStack, TRIDENT_REPAIR_AMOUNT, event);
                return;
            }
        } else if (rightItem == Items.BOOK) {
            int rightItemStackCount = event.getRight().getCount();
            int booksToCopyAmount = Math.min(rightItemStackCount, 4);
            if (leftItem == Items.ENCHANTED_BOOK) {
                ItemStack output = leftItemStack.copy();
                output.setCount(booksToCopyAmount + 1);
                event.setOutput(output);
                event.setMaterialCost(booksToCopyAmount);
                ItemEnchantments enchantments = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)leftItemStack);
                int cost = 0;
                for (Object2IntMap.Entry ench : enchantments.entrySet()) {
                    Enchantment key = (Enchantment)((Holder)ench.getKey()).value();
                    int value = ench.getIntValue();
                    if (((Holder)ench.getKey()).is(EnchantmentTags.CURSE)) continue;
                    cost += key.getMinCost(value) / 17;
                }
                if (cost < 1) {
                    cost = 1;
                }
                event.setXpCost(booksToCopyAmount * cost);
            } else if (leftItemStack.isDamageableItem()) {
                if (!leftItemStack.isEnchanted() || leftItemStack.isDamaged() || rightItemStack.isEnchanted()) {
                    return;
                }
                ItemStack result = new ItemStack((ItemLike)Items.ENCHANTED_BOOK);
                ItemEnchantments enchantments = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)leftItemStack);
                EnchantmentHelper.setEnchantments((ItemStack)result, (ItemEnchantments)enchantments);
                event.setOutput(result);
                event.setXpCost(1);
                event.setMaterialCost(1);
                return;
            }
            return;
        }
        if (leftItemStack.isDamageableItem() && leftItemStack.getDamageValue() == 0 && rightItemStack.isEnchantable() && !rightItemStack.isEnchanted() && rightItemStack.getDamageValue() == 0 && (areItemsTheSame = rightItem.getName(rightItemStack).equals((Object)leftItem.getName(leftItemStack)))) {
            ItemStack result = rightItemStack.copy();
            ItemEnchantments enchantments = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)leftItemStack);
            EnchantmentHelper.setEnchantments((ItemStack)result, (ItemEnchantments)enchantments);
            result.setCount(2);
            event.setOutput(result);
            event.setXpCost(25);
            return;
        }
    }

    private boolean validateAndRepair(AnvilUpdateEvent event, ItemStack itemStack, Item repairItem) {
        if (!this.isValidRepairItem(itemStack, repairItem)) {
            return false;
        }
        int repairAmount = itemStack.getMaxDamage() / 4;
        this.setAndRepair(itemStack, repairAmount, event);
        return true;
    }

    private void setAndRepair(ItemStack leftItemStack, int repairAmount, AnvilUpdateEvent event) {
        ItemStack result = leftItemStack.copy();
        this.repair(result, repairAmount);
        event.setOutput(result);
        event.setXpCost(2);
        event.setMaterialCost(1);
    }

    private void repair(ItemStack itemStack, int damageDecrement) {
        int newDamage = itemStack.getDamageValue() - damageDecrement;
        itemStack.setDamageValue(Math.max(newDamage, 0));
    }

    private boolean isValidRepairItem(ItemStack itemToRepair, Item repairItem) {
        return itemToRepair.isValidRepairItem(new ItemStack((ItemLike)repairItem));
    }
}

