/*
 * Decompiled with CFR 0.152.
 */
package com.raspix.snekcraft;

import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="snekcraft", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Config {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    private static final ForgeConfigSpec.BooleanValue SNAKES_DROP_ITEMS = BUILDER.comment("Whether the snakes should drop sheds and teeth").define("snakes_drop_items", true);
    private static final ForgeConfigSpec.IntValue HOGNOSE_SPAWN_WEIGHT = BUILDER.comment("The spawn weight of hognoses not in deserts, higher is more common").defineInRange("hognose_spawn_weight", 30, 0, 1000);
    private static final ForgeConfigSpec.IntValue HOGNOSE_DESERT_SPAWN_WEIGHT = BUILDER.comment("The spawn weight of hognoses in deserts, higher is more common").defineInRange("hognose_desert_spawn_weight", 60, 0, 1000);
    private static final ForgeConfigSpec.IntValue BALLPYTHON_SPAWN_WEIGHT = BUILDER.comment("The spawn weight of ball pythons, higher is more common").defineInRange("ballpython_spawn_weight", 30, 0, 1000);
    private static final ForgeConfigSpec.IntValue CORNSNAKE_SPAWN_WEIGHT = BUILDER.comment("The spawn weight of corn snakes, higher is more common").defineInRange("corn_snake_spawn_weight", 30, 0, 1000);
    static final ForgeConfigSpec SPEC = BUILDER.build();
    public static boolean snakesDropItems;
    public static int hognoseSpawnWeight;
    public static int hognoseDesertSpawnWeight;
    public static int ballpythonSpawnWeight;
    public static int cornSnakeSpawnWeight;

    private static boolean validateItemName(Object obj) {
        String itemName;
        return obj instanceof String && ForgeRegistries.ITEMS.containsKey(new ResourceLocation(itemName = (String)obj));
    }

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
        snakesDropItems = (Boolean)SNAKES_DROP_ITEMS.get();
        hognoseSpawnWeight = (Integer)HOGNOSE_SPAWN_WEIGHT.get();
        hognoseDesertSpawnWeight = (Integer)HOGNOSE_DESERT_SPAWN_WEIGHT.get();
        ballpythonSpawnWeight = (Integer)BALLPYTHON_SPAWN_WEIGHT.get();
        cornSnakeSpawnWeight = (Integer)CORNSNAKE_SPAWN_WEIGHT.get();
    }
}

