/*
 * Decompiled with CFR 0.152.
 */
package com.raspix.snekcraft.packets;

import com.raspix.snekcraft.entity.generics.SnakeBase;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;

public class ServerboundShoulderUpdate {
    public final int snekId;

    public ServerboundShoulderUpdate(int snekId) {
        this.snekId = snekId;
    }

    public static ServerboundShoulderUpdate decode(FriendlyByteBuf buf) {
        return new ServerboundShoulderUpdate(buf.readInt());
    }

    public static void encode(ServerboundShoulderUpdate packet, FriendlyByteBuf buf) {
        buf.writeInt(packet.snekId);
    }

    public static class Handler {
        public static void handle(ServerboundShoulderUpdate packet, Supplier<NetworkEvent.Context> context) {
            context.get().enqueueWork(() -> {
                Entity entity;
                ServerPlayer player = ((NetworkEvent.Context)context.get()).getSender();
                if (player != null && (entity = player.m_9236_().m_6815_(packet.snekId)) instanceof SnakeBase) {
                    SnakeBase snek = (SnakeBase)entity;
                    snek.m_8127_();
                    Vec3 dismountPos = snek.m_7688_((LivingEntity)player);
                    snek.m_6034_(dismountPos.m_7096_(), dismountPos.m_7098_(), dismountPos.m_7094_());
                }
            });
            context.get().setPacketHandled(true);
        }
    }
}

