/*
 * Decompiled with CFR 0.152.
 */
package com.raspix.snekcraft;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.raspix.snekcraft.SnekCraft;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;

public class SnekCraftConfig {
    private static File configFile = new File(FabricLoader.getInstance().getConfigDir().toFile(), "snekcraft_config.json");
    private static Map<String, Object> defaultValues = new HashMap<String, Object>(){
        {
            this.put("snakes_drop_items", true);
            this.put("hognose_spawn_weight", 30);
            this.put("hognose_desert_spawn_weight", 60);
            this.put("ballpython_spawn_weight", 30);
            this.put("cornsnake_spawn_weight", 30);
        }
    };
    public static boolean SNAKES_DROP_ITEMS = true;
    public static int HOGNOSE_SPAWN_WEIGHT;
    public static int HOGNOSE_DESERT_SPAWN_WEIGHT;
    public static int BALLPYTHON_SPAWN_WEIGHT;
    public static int CORNSNAKE_SPAWN_WEIGHT;

    public static void loadConfig() {
        try {
            System.out.println(configFile.getAbsolutePath());
            SnekCraft.logger.debug("File Name: ");
            if (!configFile.exists()) {
                SnekCraftConfig.createDefaultConfig();
            }
            JsonObject config = JsonParser.parseReader((Reader)new FileReader(configFile)).getAsJsonObject();
            SNAKES_DROP_ITEMS = SnekCraftConfig.getOrCreateValue("snakes_drop_items", config).getAsBoolean();
            HOGNOSE_SPAWN_WEIGHT = SnekCraftConfig.getOrCreateValue("hognose_spawn_weight", config).getAsInt();
            HOGNOSE_DESERT_SPAWN_WEIGHT = SnekCraftConfig.getOrCreateValue("hognose_desert_spawn_weight", config).getAsInt();
            BALLPYTHON_SPAWN_WEIGHT = SnekCraftConfig.getOrCreateValue("ballpython_spawn_weight", config).getAsInt();
            CORNSNAKE_SPAWN_WEIGHT = SnekCraftConfig.getOrCreateValue("cornsnake_spawn_weight", config).getAsInt();
            try (FileWriter writer = new FileWriter(configFile);){
                writer.write(config.toString());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static JsonElement getOrCreateValue(String valueName, JsonObject config) {
        if (config.has(valueName)) {
            return config.get(valueName);
        }
        config.addProperty(valueName, defaultValues.get(valueName).toString());
        return config.get(valueName);
    }

    public static void createDefaultConfig() {
        JsonObject config = new JsonObject();
        config.addProperty("snakes_drop_items", Boolean.valueOf(true));
        config.addProperty("hognose_spawn_weight", (Number)30);
        config.addProperty("hognose_desert_spawn_weight", (Number)60);
        config.addProperty("ballpython_spawn_weight", (Number)30);
        config.addProperty("cornsnake_spawn_weight", (Number)30);
        try (FileWriter writer = new FileWriter(configFile);){
            writer.write(config.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

