/*
 * Decompiled with CFR 0.152.
 */
package com.raspix.snekcraft.blocks.entity.eggs;

import com.raspix.snekcraft.blocks.entity.SnakeEggBlockEntity;
import com.raspix.snekcraft.entity.generics.SnakeBase;
import java.util.Random;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1922;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2464;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3726;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public abstract class SnakeEggBlock
extends class_2237 {
    public static final int MAX_HATCH_LEVEL = 2;
    public static final int MIN_EGGS = 1;
    public static final int MAX_EGGS = 4;
    public static final String NBT_KEY_BLOCK_STATE_TAG = "BlockStateTag";
    protected final Random random = new Random();
    private static final class_265 ONE_EGG_AABB = class_2248.method_9541((double)3.0, (double)0.0, (double)3.0, (double)12.0, (double)7.0, (double)12.0);
    private static final class_265 MULTIPLE_EGGS_AABB = class_2248.method_9541((double)1.0, (double)0.01, (double)1.0, (double)15.0, (double)7.0, (double)15.0);
    public static final class_2758 HATCH = class_2741.field_12530;
    public static final class_2758 EGGS = class_2741.field_12509;

    public SnakeEggBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)this.method_9595().method_11664()).method_11657((class_2769)HATCH, (Comparable)Integer.valueOf(0))).method_11657((class_2769)EGGS, (Comparable)Integer.valueOf(1)));
    }

    private float nextPitch(class_5819 random) {
        return 0.9f + random.method_43057() * 0.2f;
    }

    private void decreaseEggs(class_1937 world, class_2338 blockPos, class_2680 blockState) {
        world.method_8396(null, blockPos, class_3417.field_14687, class_3419.field_15245, 0.7f, this.nextPitch(world.field_9229));
        int eggs = (Integer)blockState.method_11654((class_2769)EGGS);
        if (eggs <= 1) {
            world.method_22352(blockPos, false);
        } else {
            class_2487 oldNbt = ((SnakeEggBlockEntity)world.method_8321(blockPos)).getPersistentData();
            world.method_8652(blockPos, (class_2680)blockState.method_11657((class_2769)EGGS, (Comparable)Integer.valueOf(eggs - 1)), 2);
            world.method_20290(2001, blockPos, class_2248.method_9507((class_2680)blockState));
            SnakeEggBlockEntity blockEntity = (SnakeEggBlockEntity)world.method_8321(blockPos);
            blockEntity.setStats(oldNbt.method_10550("color"), oldNbt.method_10550("color_p2"), oldNbt.method_10550("pattern"), oldNbt.method_10550("pattern_p2"));
        }
    }

    public void method_9514(class_2680 blockState, class_3218 world, class_2338 blockPos, class_5819 random) {
        if (this.shouldUpdateHatchLevel((class_1937)world) && SnakeEggBlock.onSand((class_1922)world, blockPos)) {
            int hatchLevel = (Integer)blockState.method_11654((class_2769)HATCH);
            if (hatchLevel < 2) {
                world.method_8396(null, blockPos, class_3417.field_15109, class_3419.field_15245, 0.7f, this.nextPitch(random));
                world.method_8652(blockPos, (class_2680)blockState.method_11657((class_2769)HATCH, (Comparable)Integer.valueOf(hatchLevel + 1)), 2);
            } else {
                class_2586 class_25862 = world.method_8321(blockPos);
                if (class_25862 instanceof SnakeEggBlockEntity) {
                    SnakeEggBlockEntity blockEntity = (SnakeEggBlockEntity)class_25862;
                    world.method_8396(null, blockPos, class_3417.field_14902, class_3419.field_15245, 0.7f, this.nextPitch(random));
                    class_2487 nbtCompound = blockEntity.getPersistentData();
                    world.method_22352(blockPos, false);
                    for (int i = 0; i < (Integer)blockState.method_11654((class_2769)EGGS); ++i) {
                        world.method_20290(2001, blockPos, class_2248.method_9507((class_2680)blockState));
                        SnakeBase snake = (SnakeBase)this.getSnakeType().method_5883((class_1937)world);
                        snake.method_5614(-24000);
                        snake.method_5808((double)blockPos.method_10263() + 0.3 + (double)i * 0.2, blockPos.method_10264(), (double)blockPos.method_10260() + 0.3, 0.0f, 0.0f);
                        snake.setColor(this.getOffspringColor(nbtCompound));
                        snake.setPattern(this.getOffspringPattern(nbtCompound));
                        world.method_8649((class_1297)snake);
                    }
                }
            }
        }
    }

    public abstract class_1299<?> getSnakeType();

    public static boolean onSand(class_1922 blockView, class_2338 blockPos) {
        return blockView.method_8320(blockPos.method_10074()).method_26164(class_3481.field_29822) || blockView.method_8320(blockPos.method_10074()).method_26164(class_3481.field_15466);
    }

    public void method_9615(class_2680 blockState, class_1937 world, class_2338 blockPos, class_2680 oldState, boolean isMoving) {
        if (SnakeEggBlock.onSand((class_1922)world, blockPos) && !world.method_8608()) {
            world.method_20290(2005, blockPos, 0);
        }
    }

    private boolean shouldUpdateHatchLevel(class_1937 world) {
        double f = world.method_30274(1.0f);
        return f < 0.69 && f > 0.65 || world.field_9229.method_43048(4) == 0;
    }

    public void method_9556(class_1937 world, class_1657 player, class_2338 blockPos, class_2680 blockState, @Nullable class_2586 blockEntity, class_1799 itemStack) {
        if (!world.method_8608() && world.method_8450().method_8355(class_1928.field_19392) && class_1890.method_8225((class_1887)class_1893.field_9099, (class_1799)itemStack) != 0 && blockEntity instanceof SnakeEggBlockEntity) {
            SnakeEggBlockEntity snakeEggBlockEntity = (SnakeEggBlockEntity)blockEntity;
            class_1799 newItemStack = new class_1799((class_1935)this);
            class_2487 nbtCompoundBlock = snakeEggBlockEntity.getPersistentData();
            int color1 = nbtCompoundBlock.method_10550("color");
            int color2 = nbtCompoundBlock.method_10550("color_p2");
            int pattern1 = nbtCompoundBlock.method_10550("pattern");
            int pattern2 = nbtCompoundBlock.method_10550("pattern_p2");
            class_2487 nbtCompound = new class_2487();
            if (color1 > 0) {
                nbtCompound.method_10569("color", color1);
            }
            if (color2 > 0) {
                nbtCompound.method_10569("color_p2", color2);
            }
            if (pattern1 > 0) {
                nbtCompound.method_10569("pattern", pattern1);
            }
            if (pattern2 > 0) {
                nbtCompound.method_10569("pattern_p2", pattern2);
            }
            newItemStack.method_7959(NBT_KEY_BLOCK_STATE_TAG, (class_2520)nbtCompound);
            class_1542 itemEntity = new class_1542(world, (double)blockPos.method_10263(), (double)blockPos.method_10264(), (double)blockPos.method_10260(), newItemStack);
            itemEntity.method_6988();
            world.method_8649((class_1297)itemEntity);
        }
        super.method_9556(world, player, blockPos, blockState, blockEntity, itemStack);
    }

    public boolean method_9616(class_2680 blockState, class_1750 context) {
        class_2586 class_25862;
        class_1799 handItem = context.method_8041();
        class_2487 nbtCompound = handItem.method_7969();
        boolean isSameEggType = handItem.method_31574(this.method_8389());
        boolean areSameValues = false;
        class_2338 blockPos = context.method_8037();
        if (isSameEggType && nbtCompound != null && !context.method_8045().method_8608() && (class_25862 = context.method_8045().method_8321(blockPos)) instanceof SnakeEggBlockEntity) {
            SnakeEggBlockEntity blockEntity = (SnakeEggBlockEntity)class_25862;
            class_2487 blockNbt = blockEntity.getPersistentData();
            for (String nbtInfo : nbtCompound.method_10541()) {
                if (!nbtInfo.contains(NBT_KEY_BLOCK_STATE_TAG)) continue;
                class_2487 itemNbt = nbtCompound.method_10562(NBT_KEY_BLOCK_STATE_TAG);
                areSameValues = this.areGeneticsSame(blockNbt, itemNbt);
            }
        }
        return !context.method_8046() && isSameEggType && areSameValues && (Integer)blockState.method_11654((class_2769)EGGS) < 4 || super.method_9616(blockState, context);
    }

    public boolean areGeneticsSame(class_2487 blockNbt, class_2487 itemNbt) {
        boolean colorMatch = blockNbt.method_10550("color") == itemNbt.method_10550("color");
        boolean color2Match = blockNbt.method_10550("color_p2") == itemNbt.method_10550("color_p2");
        boolean patternMatch = blockNbt.method_10550("pattern") == itemNbt.method_10550("pattern");
        boolean pattern2Match = blockNbt.method_10550("pattern_p2") == itemNbt.method_10550("pattern_p2");
        return colorMatch && color2Match && patternMatch && pattern2Match;
    }

    @Nullable
    public class_2680 method_9605(class_1750 context) {
        class_2680 blockState = context.method_8045().method_8320(context.method_8037());
        return blockState.method_27852((class_2248)this) ? (class_2680)blockState.method_11657((class_2769)EGGS, (Comparable)Integer.valueOf(Math.min(4, (Integer)blockState.method_11654((class_2769)EGGS) + 1))) : super.method_9605(context);
    }

    @Nullable
    public void method_9567(class_1937 world, class_2338 blockPos, class_2680 blockState, @Nullable class_1309 placer, class_1799 itemStack) {
        class_2487 itemNbt;
        super.method_9567(world, blockPos, blockState, placer, itemStack);
        class_2487 nbtCompound = itemStack.method_7969();
        if (nbtCompound != null && (itemNbt = nbtCompound.method_10562(NBT_KEY_BLOCK_STATE_TAG)) != null) {
            int color1 = itemNbt.method_10550("color");
            int color2 = itemNbt.method_10550("color_p2");
            int pattern1 = itemNbt.method_10550("pattern");
            int pattern2 = itemNbt.method_10550("pattern_p2");
            SnakeEggBlockEntity blockEntity = (SnakeEggBlockEntity)world.method_8321(blockPos);
            if (blockEntity != null) {
                class_2487 persistentData = blockEntity.getPersistentData();
                persistentData.method_10569("color", color1);
                persistentData.method_10569("color_p2", color2);
                persistentData.method_10569("pattern", pattern1);
                persistentData.method_10569("pattern_p2", pattern2);
            }
        }
    }

    public class_265 method_9530(class_2680 blockState, class_1922 blockView, class_2338 blockPos, class_3726 shapeContext) {
        return (Integer)blockState.method_11654((class_2769)EGGS) > 1 ? MULTIPLE_EGGS_AABB : ONE_EGG_AABB;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{HATCH, EGGS});
    }

    public abstract int getOffspringColor(class_2487 var1);

    public abstract int getOffspringPattern(class_2487 var1);

    @Nullable
    public class_2586 method_10123(class_2338 blockPos, class_2680 blockState) {
        return new SnakeEggBlockEntity(blockPos, blockState);
    }

    public class_2464 method_9604(class_2680 blockState) {
        return class_2464.field_11458;
    }

    public void method_9536(class_2680 blockState, class_1937 world, class_2338 blockPos, class_2680 newState, boolean isMoving) {
        if (!(!blockState.method_31709() || blockState.method_27852(newState.method_26204()) && newState.method_31709())) {
            world.method_8544(blockPos);
        }
    }

    public void method_9576(class_1937 world, class_2338 blockPos, class_2680 blockState, class_1657 player) {
        super.method_9576(world, blockPos, blockState, player);
        this.decreaseEggs(world, blockPos, blockState);
    }
}

