/*
 * Decompiled with CFR 0.152.
 */
package com.raspix.snekcraft.blocks.terrariums;

import com.raspix.snekcraft.SnekCraft;
import com.raspix.snekcraft.blocks.SnekBlockStateProperties;
import com.raspix.snekcraft.items.ItemInit;
import java.util.Objects;
import net.minecraft.class_10;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2368;
import net.minecraft.class_2464;
import net.minecraft.class_247;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TerrariumBlock
extends class_2368 {
    public static final class_2758 UP = SnekBlockStateProperties.UP;
    public static final class_2758 DOWN = SnekBlockStateProperties.DOWN;
    public static final class_2758 NORTH = SnekBlockStateProperties.NORTH;
    public static final class_2758 EAST = SnekBlockStateProperties.EAST;
    public static final class_2758 SOUTH = SnekBlockStateProperties.SOUTH;
    public static final class_2758 WEST = SnekBlockStateProperties.WEST;
    public static final class_2746 PATHFIND = class_2746.method_11825((String)"pathfind");
    private static final class_265 TOP_AABB = class_2248.method_9541((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final class_265 BOTTOM_AABB = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    private static final class_265 NORTH_AABB = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
    private static final class_265 SOUTH_AABB = class_2248.method_9541((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);
    private static final class_265 EAST_AABB = class_2248.method_9541((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final class_265 WEST_AABB = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);

    public TerrariumBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)NORTH, (Comparable)Integer.valueOf(0))).method_11657((class_2769)EAST, (Comparable)Integer.valueOf(0))).method_11657((class_2769)SOUTH, (Comparable)Integer.valueOf(0))).method_11657((class_2769)WEST, (Comparable)Integer.valueOf(0))).method_11657((class_2769)UP, (Comparable)Integer.valueOf(0))).method_11657((class_2769)DOWN, (Comparable)Integer.valueOf(0)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{NORTH, EAST, SOUTH, WEST, UP, DOWN, PATHFIND});
    }

    @Nullable
    public class_2680 method_9605(class_1750 context) {
        class_1937 world = context.method_8045();
        class_2338 blockPos = context.method_8037();
        class_2680 blockState = world.method_8320(blockPos);
        return (class_2680)((class_2680)((class_2680)((class_2680)Objects.requireNonNull(super.method_9605(context)).method_11657((class_2769)NORTH, (Comparable)Integer.valueOf(this.canFenceConnectTo(world.method_8320(blockPos.method_10095()), blockState, class_2350.field_11035, null)))).method_11657((class_2769)EAST, (Comparable)Integer.valueOf(this.canFenceConnectTo(world.method_8320(blockPos.method_10078()), blockState, class_2350.field_11039, null)))).method_11657((class_2769)SOUTH, (Comparable)Integer.valueOf(this.canFenceConnectTo(world.method_8320(blockPos.method_10072()), blockState, class_2350.field_11043, null)))).method_11657((class_2769)WEST, (Comparable)Integer.valueOf(this.canFenceConnectTo(world.method_8320(blockPos.method_10067()), blockState, class_2350.field_11034, null)));
    }

    public class_2680 method_9559(class_2680 blockState, class_2350 facing, class_2680 facingState, class_1936 worldAccess, class_2338 blockPos, class_2338 facingPos) {
        return (class_2680)this.updateBlockShape(blockState, facing, facingState, worldAccess, blockPos, facingPos).method_11657((class_2769)PATHFIND, (Comparable)Boolean.valueOf(this.updatePathfinding(blockState, worldAccess, blockPos)));
    }

    public boolean updatePathfinding(class_2680 blockState, class_1936 worldAccess, class_2338 blockPos) {
        return (Integer)blockState.method_11654((class_2769)NORTH) != 0 && (Integer)blockState.method_11654((class_2769)EAST) != 0 && (Integer)blockState.method_11654((class_2769)SOUTH) != 0 && (Integer)blockState.method_11654((class_2769)WEST) != 0;
    }

    public class_2680 updateBlockShape(class_2680 blockState, class_2350 facing, class_2680 facingState, class_1936 worldAccess, class_2338 blockPos, class_2338 facingPos) {
        switch (facing) {
            case field_11043: {
                return (class_2680)((class_2680)blockState.method_11657((class_2769)NORTH, (Comparable)Integer.valueOf(this.isWallConnectedTo(facingState, blockState, NORTH, worldAccess, class_2350.field_11043, blockPos)))).method_11657((class_2769)WEST, (Comparable)Integer.valueOf(this.isWallConnectedTo(worldAccess.method_8320(blockPos.method_10067()), blockState, WEST, worldAccess, class_2350.field_11039, blockPos)));
            }
            case field_11035: {
                return (class_2680)((class_2680)blockState.method_11657((class_2769)SOUTH, (Comparable)Integer.valueOf(this.isWallConnectedTo(facingState, blockState, SOUTH, worldAccess, class_2350.field_11035, blockPos)))).method_11657((class_2769)EAST, (Comparable)Integer.valueOf(this.isWallConnectedTo(worldAccess.method_8320(blockPos.method_10078()), blockState, EAST, worldAccess, class_2350.field_11034, blockPos)));
            }
            case field_11034: {
                return (class_2680)((class_2680)blockState.method_11657((class_2769)EAST, (Comparable)Integer.valueOf(this.isWallConnectedTo(facingState, blockState, EAST, worldAccess, class_2350.field_11034, blockPos)))).method_11657((class_2769)NORTH, (Comparable)Integer.valueOf(this.isWallConnectedTo(worldAccess.method_8320(blockPos.method_10095()), blockState, NORTH, worldAccess, class_2350.field_11043, blockPos)));
            }
            case field_11039: {
                return (class_2680)((class_2680)blockState.method_11657((class_2769)WEST, (Comparable)Integer.valueOf(this.isWallConnectedTo(facingState, blockState, WEST, worldAccess, class_2350.field_11039, blockPos)))).method_11657((class_2769)SOUTH, (Comparable)Integer.valueOf(this.isWallConnectedTo(worldAccess.method_8320(blockPos.method_10072()), blockState, SOUTH, worldAccess, class_2350.field_11035, blockPos)));
            }
            case field_11033: {
                return (class_2680)blockState.method_11657((class_2769)DOWN, (Comparable)Integer.valueOf(this.canFenceConnectTo(facingState, blockState, facing.method_10153(), DOWN)));
            }
        }
        return (class_2680)blockState.method_11657((class_2769)UP, (Comparable)Integer.valueOf(this.canFenceConnectTo(facingState, blockState, facing.method_10153(), UP)));
    }

    public class_1269 method_9534(class_2680 blockState, class_1937 world, class_2338 blockPos, class_1657 player, class_1268 hand, class_3965 hitResult) {
        if (!world.method_8608() && hand == class_1268.field_5808) {
            class_1799 heldItem = player.method_5998(hand);
            if (heldItem.method_31574(class_1802.field_8600)) {
                // empty if block
            }
            if (!heldItem.method_31574(ItemInit.TERRARIUM_KEY)) {
                return class_1269.field_5814;
            }
            this.setSideEntrance(blockState, world, blockPos, player, hand, hitResult);
            return class_1269.field_5812;
        }
        return class_1269.field_5814;
    }

    public void setSideEntrance(class_2680 blockState, class_1937 world, class_2338 blockPos, class_1657 player, class_1268 hand, class_3965 hitResult) {
        class_2350 hitWall = hitResult.method_17780();
        int sideValue = (Integer)blockState.method_11654((class_2769)this.getDirStateFromDir(hitWall));
        if (sideValue == 1 || sideValue == 3) {
            hitWall = hitWall.method_10153();
        }
        if (hitWall == null) {
            return;
        }
        if (hitWall.equals((Object)class_2350.field_11043) && (Integer)blockState.method_11654((class_2769)NORTH) != 1) {
            world.method_8652(blockPos, (class_2680)((class_2680)blockState.method_11657((class_2769)NORTH, (Comparable)Integer.valueOf((Integer)blockState.method_11654((class_2769)NORTH) == 2 ? 0 : 2))).method_11657((class_2769)PATHFIND, (Comparable)Boolean.valueOf(this.updatePathfinding(blockState, (class_1936)world, blockPos))), 3);
        } else if (hitWall.equals((Object)class_2350.field_11035) && (Integer)blockState.method_11654((class_2769)SOUTH) != 1) {
            world.method_8652(blockPos, (class_2680)((class_2680)blockState.method_11657((class_2769)SOUTH, (Comparable)Integer.valueOf((Integer)blockState.method_11654((class_2769)SOUTH) == 2 ? 0 : 2))).method_11657((class_2769)PATHFIND, (Comparable)Boolean.valueOf(this.updatePathfinding(blockState, (class_1936)world, blockPos))), 3);
        } else if (hitWall.equals((Object)class_2350.field_11034) && (Integer)blockState.method_11654((class_2769)EAST) != 1) {
            world.method_8652(blockPos, (class_2680)((class_2680)blockState.method_11657((class_2769)EAST, (Comparable)Integer.valueOf((Integer)blockState.method_11654((class_2769)EAST) == 2 ? 0 : 2))).method_11657((class_2769)PATHFIND, (Comparable)Boolean.valueOf(this.updatePathfinding(blockState, (class_1936)world, blockPos))), 3);
        } else if (hitWall.equals((Object)class_2350.field_11039) && (Integer)blockState.method_11654((class_2769)WEST) != 1) {
            world.method_8652(blockPos, (class_2680)((class_2680)blockState.method_11657((class_2769)WEST, (Comparable)Integer.valueOf((Integer)blockState.method_11654((class_2769)WEST) == 2 ? 0 : 2))).method_11657((class_2769)PATHFIND, (Comparable)Boolean.valueOf(this.updatePathfinding(blockState, (class_1936)world, blockPos))), 3);
        } else if (hitWall.equals((Object)class_2350.field_11036) && (Integer)blockState.method_11654((class_2769)UP) != 1) {
            world.method_8652(blockPos, (class_2680)blockState.method_11657((class_2769)UP, (Comparable)Integer.valueOf((Integer)blockState.method_11654((class_2769)UP) == 2 ? 0 : 2)), 3);
        } else if (hitWall.equals((Object)class_2350.field_11033) && (Integer)blockState.method_11654((class_2769)DOWN) != 1) {
            world.method_8652(blockPos, (class_2680)blockState.method_11657((class_2769)DOWN, (Comparable)Integer.valueOf((Integer)blockState.method_11654((class_2769)DOWN) == 2 ? 0 : 2)), 3);
        }
    }

    public void updateCornerOnChangeDelete(class_2680 blockState, class_1937 world, class_2350 wallChanged, class_2338 blockPos) {
        if (wallChanged == class_2350.field_11043) {
            class_2680 eastState = world.method_8320(blockPos.method_10078());
            world.method_8652(blockPos.method_10078(), (class_2680)eastState.method_11657((class_2769)SOUTH, (Comparable)Integer.valueOf(this.isWallConnectedTo(world.method_8320(blockPos.method_10078().method_10072()), eastState, SOUTH, (class_1936)world, class_2350.field_11035, blockPos.method_10078()))), 3);
        }
    }

    public class_2758 getDirStateFromDir(class_2350 direction) {
        switch (direction) {
            case field_11035: {
                return SOUTH;
            }
            case field_11034: {
                return EAST;
            }
            case field_11039: {
                return WEST;
            }
            case field_11036: {
                return UP;
            }
            case field_11033: {
                return DOWN;
            }
            default: {
                SnekCraft.logger.error("something went wrong");
            }
            case field_11043: 
        }
        return NORTH;
    }

    public int canFenceConnectTo(class_2680 sideState, class_2680 thisState, class_2350 facing, class_2758 property) {
        if (sideState.method_26204() instanceof TerrariumBlock) {
            return 1;
        }
        if (thisState != null && property != null && (Integer)thisState.method_11654((class_2769)property) == 2) {
            return 2;
        }
        return 0;
    }

    public int isWallConnectedTo(class_2680 facingState, class_2680 thisState, class_2758 property, class_1936 worldAccess, class_2350 facing, class_2338 blockPos) {
        if (facingState.method_26204() instanceof TerrariumBlock) {
            if (this.areSiliconeSidesSolid(worldAccess, facing, blockPos)) {
                return 3;
            }
            return 1;
        }
        if (thisState != null && property != null && (Integer)thisState.method_11654((class_2769)property) == 2) {
            return 2;
        }
        return 0;
    }

    public boolean areSiliconeSidesSolid(class_1936 worldAccess, class_2350 facing, class_2338 blockPos) {
        class_2758 clockwiseWallDir;
        class_2758 facingWallDir;
        class_2680 diagonalState;
        class_2680 clockwiseState;
        class_2680 facingState;
        switch (facing) {
            case field_11043: {
                facingState = worldAccess.method_8320(blockPos.method_10095());
                clockwiseState = worldAccess.method_8320(blockPos.method_10078());
                diagonalState = worldAccess.method_8320(blockPos.method_10095().method_10078());
                facingWallDir = EAST;
                clockwiseWallDir = NORTH;
                break;
            }
            case field_11034: {
                facingState = worldAccess.method_8320(blockPos.method_10078());
                clockwiseState = worldAccess.method_8320(blockPos.method_10072());
                diagonalState = worldAccess.method_8320(blockPos.method_10078().method_10072());
                facingWallDir = SOUTH;
                clockwiseWallDir = EAST;
                break;
            }
            case field_11035: {
                facingState = worldAccess.method_8320(blockPos.method_10072());
                clockwiseState = worldAccess.method_8320(blockPos.method_10067());
                diagonalState = worldAccess.method_8320(blockPos.method_10072().method_10067());
                facingWallDir = WEST;
                clockwiseWallDir = SOUTH;
                break;
            }
            case field_11039: {
                facingState = worldAccess.method_8320(blockPos.method_10067());
                clockwiseState = worldAccess.method_8320(blockPos.method_10095());
                diagonalState = worldAccess.method_8320(blockPos.method_10067().method_10095());
                facingWallDir = NORTH;
                clockwiseWallDir = WEST;
                break;
            }
            default: {
                return false;
            }
        }
        return facingState.method_26204() instanceof TerrariumBlock && clockwiseState.method_26204() instanceof TerrariumBlock && !(diagonalState.method_26204() instanceof TerrariumBlock) && ((Integer)facingState.method_11654((class_2769)facingWallDir) != 2 || (Integer)clockwiseState.method_11654((class_2769)clockwiseWallDir) != 2);
    }

    public int hasInnerCorner(class_2680 diagonalState, class_2680 sideState1, class_2680 sideState2) {
        if (diagonalState.method_26204() instanceof TerrariumBlock || !(sideState1.method_26204() instanceof TerrariumBlock) || !(sideState2.method_26204() instanceof TerrariumBlock)) {
            return 1;
        }
        return 0;
    }

    @NotNull
    public class_265 method_9549(class_2680 blockState, class_1922 blockView, class_2338 blockPos, class_3726 shapeContext) {
        class_265 shape = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
        if (blockState.method_26204() instanceof TerrariumBlock) {
            if ((Integer)blockState.method_11654((class_2769)UP) == 0) {
                shape = class_259.method_1072((class_265)shape, (class_265)TOP_AABB, (class_247)class_247.field_1366);
            }
            if ((Integer)blockState.method_11654((class_2769)DOWN) == 0) {
                shape = class_259.method_1072((class_265)shape, (class_265)BOTTOM_AABB, (class_247)class_247.field_1366);
            }
            if ((Integer)blockState.method_11654((class_2769)NORTH) == 0) {
                shape = class_259.method_1072((class_265)shape, (class_265)NORTH_AABB, (class_247)class_247.field_1366);
            }
            if ((Integer)blockState.method_11654((class_2769)SOUTH) == 0) {
                shape = class_259.method_1072((class_265)shape, (class_265)SOUTH_AABB, (class_247)class_247.field_1366);
            }
            if ((Integer)blockState.method_11654((class_2769)EAST) == 0) {
                shape = class_259.method_1072((class_265)shape, (class_265)EAST_AABB, (class_247)class_247.field_1366);
            }
            if ((Integer)blockState.method_11654((class_2769)WEST) == 0) {
                shape = class_259.method_1072((class_265)shape, (class_265)WEST_AABB, (class_247)class_247.field_1366);
            }
        }
        return shape;
    }

    public class_265 method_9530(class_2680 blockState, class_1922 blockView, class_2338 blockPos, class_3726 shapeContext) {
        class_265 shape = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
        boolean hasItem = shapeContext.method_17785(ItemInit.TERRARIUM_KEY);
        if (blockState.method_26204() instanceof TerrariumBlock) {
            if ((Integer)blockState.method_11654((class_2769)UP) == 0 || (Integer)blockState.method_11654((class_2769)UP) == 2 && hasItem) {
                shape = class_259.method_1072((class_265)shape, (class_265)TOP_AABB, (class_247)class_247.field_1366);
            }
            if ((Integer)blockState.method_11654((class_2769)DOWN) == 0 || (Integer)blockState.method_11654((class_2769)DOWN) == 2 && hasItem) {
                shape = class_259.method_1072((class_265)shape, (class_265)BOTTOM_AABB, (class_247)class_247.field_1366);
            }
            if ((Integer)blockState.method_11654((class_2769)NORTH) == 0 || (Integer)blockState.method_11654((class_2769)NORTH) == 2 && hasItem) {
                shape = class_259.method_1072((class_265)shape, (class_265)NORTH_AABB, (class_247)class_247.field_1366);
            }
            if ((Integer)blockState.method_11654((class_2769)SOUTH) == 0 || (Integer)blockState.method_11654((class_2769)SOUTH) == 2 && hasItem) {
                shape = class_259.method_1072((class_265)shape, (class_265)SOUTH_AABB, (class_247)class_247.field_1366);
            }
            if ((Integer)blockState.method_11654((class_2769)WEST) == 0 || (Integer)blockState.method_11654((class_2769)WEST) == 2 && hasItem) {
                shape = class_259.method_1072((class_265)shape, (class_265)WEST_AABB, (class_247)class_247.field_1366);
            }
            if ((Integer)blockState.method_11654((class_2769)EAST) == 0 || (Integer)blockState.method_11654((class_2769)EAST) == 2 && hasItem) {
                shape = class_259.method_1072((class_265)shape, (class_265)EAST_AABB, (class_247)class_247.field_1366);
            }
        }
        return shape;
    }

    @NotNull
    public class_2464 method_9604(class_2680 blockState) {
        return class_2464.field_11458;
    }

    public boolean method_37403(class_2680 blockState, class_1922 blockView, class_2338 blockPos) {
        return false;
    }

    protected boolean isEntityInsideContent(class_2680 blockState, class_2338 blockPos, class_1297 entity) {
        return entity.method_23318() < (double)blockPos.method_10264() + this.getContentHeight(blockState) && entity.method_5829().field_1325 > (double)blockPos.method_10264() + 0.25;
    }

    protected double getContentHeight(class_2680 blockState) {
        return 0.0;
    }

    public boolean method_9516(class_2680 blockState, class_1922 blockView, class_2338 blockPos, class_10 navigationType) {
        if (navigationType == class_10.field_48) {
            return super.method_9516(blockState, blockView, blockPos, navigationType);
        }
        return (Boolean)blockState.method_11654((class_2769)PATHFIND);
    }
}

