/*
 * Decompiled with CFR 0.152.
 */
package com.raspix.snekcraft.entity.generics;

import com.raspix.snekcraft.SnekCraft;
import com.raspix.snekcraft.SnekCraftConfig;
import com.raspix.snekcraft.entity.generics.GenePool;
import com.raspix.snekcraft.entity.goal.CurlGoal;
import com.raspix.snekcraft.entity.goal.FindRestSpotGoal;
import com.raspix.snekcraft.entity.goal.SnakeBreedGoal;
import com.raspix.snekcraft.entity.goal.SnakeLayEggGoal;
import com.raspix.snekcraft.items.ItemInit;
import com.raspix.snekcraft.items.SnakeBagItem;
import com.raspix.snekcraft.sounds.SoundInit;
import com.raspix.snekcraft.util.KeyInit;
import java.util.Random;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1292;
import net.minecraft.class_1294;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1374;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2616;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3481;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5131;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5712;
import net.minecraft.class_7094;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SnakeBase
extends class_1429 {
    public final class_7094 slitherAnimationState = new class_7094();
    public final class_7094 idleAnimationState = new class_7094();
    public final class_7094 bleleleAnimationState = new class_7094();
    public final class_7094 strikeAnimationState = new class_7094();
    public final class_7094 hideAnimationState = new class_7094();
    public final class_7094 shoulderAnimationState = new class_7094();
    public static final String NBT_KEY_COLOR = "Color";
    public static final String NBT_KEY_PATTERN = "Pattern";
    public static final String NBT_KEY_SHED_TIME = "ShedTime";
    public static final String NBT_KEY_HAS_EGG = "HasEgg";
    public static final String NBT_KEY_RESTING = "Resting";
    private static final class_2940<Integer> COLOR = class_2945.method_12791(SnakeBase.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> PATTERN = class_2945.method_12791(SnakeBase.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> RESTING = class_2945.method_12791(SnakeBase.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> HAS_EGG = class_2945.method_12791(SnakeBase.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> LAYING_EGG = class_2945.method_12791(SnakeBase.class, (class_2941)class_2943.field_13323);
    public static final int BREEDING_RANGE = 100;
    public int layEggCounter;
    public int partnerColor = 0;
    public int partnerPattern = 0;
    public int shedTime = this.field_5974.method_43048(24000) + 12000;
    public int bleleleTime = this.field_5974.method_43048(500) + 500;
    public boolean isSittingOnShoulder;
    private final class_4048 size;
    private static GenePool[][] colorGenetics;
    private static GenePool[][] patternGenetics;

    protected SnakeBase(class_1299<? extends class_1429> entityType, class_1937 world, class_4048 size) {
        super(entityType, world);
        this.size = size;
    }

    public class_5131 method_6127() {
        return super.method_6127();
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new class_1374((class_1314)this, 1.25));
        this.field_6201.method_6277(1, (class_1352)new SnakeBreedGoal(this, 1.0));
        this.field_6201.method_6277(1, (class_1352)new SnakeLayEggGoal(this, 1.0));
        this.field_6201.method_6277(5, (class_1352)new class_1366((class_1314)this, 1.0, true));
        this.field_6201.method_6277(6, (class_1352)new FindRestSpotGoal(this, 1.0));
        this.field_6201.method_6277(7, (class_1352)new CurlGoal(this));
        this.field_6201.method_6277(8, (class_1352)new class_1394((class_1314)this, 1.0));
        this.field_6201.method_6277(9, (class_1352)new class_1361((class_1308)this, class_1657.class, 6.0f));
        this.field_6201.method_6277(10, (class_1352)new class_1376((class_1308)this));
    }

    public static class_5132.class_5133 createLivingAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 20.0).method_26868(class_5134.field_23721, 3.0).method_26868(class_5134.field_23723, 1.0).method_26868(class_5134.field_23719, 0.25);
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        if (itemStack.method_7909() == ItemInit.SNAKE_BAG) {
            class_2487 compound = itemStack.method_7969();
            if (compound == null) {
                compound = new class_2487();
                itemStack.method_7980(compound);
            }
            class_2487 snakeNbt = new class_2487();
            this.method_5652(snakeNbt);
            this.addSpeciesSaveData(snakeNbt);
            int numSnakesInSack = SnakeBagItem.getSnakesInStack(itemStack);
            if (numSnakesInSack > 0) {
                return class_1269.field_5814;
            }
            int currentSnake = numSnakesInSack + 1;
            compound.method_10566("Snake_" + currentSnake, (class_2520)snakeNbt);
            this.method_31472();
            player.method_6104(hand);
            return class_1269.field_5812;
        }
        if (this.method_6481(itemStack) && this.method_6032() < this.method_6063()) {
            this.method_6025(itemStack.method_7909().method_19264().method_19230());
            if (!player.method_31549().field_7477) {
                itemStack.method_7934(1);
            }
            this.method_32875(class_5712.field_28735, (class_1297)this);
            return class_1269.field_5812;
        }
        if (player.method_5715() && !this.method_5765()) {
            if (player.method_5685().size() < 1) {
                this.method_5873((class_1297)player, true);
                if (player.method_37908().method_8608()) {
                    player.method_7353((class_2561)class_2561.method_43469((String)"component.snekcraft.drop_instructions", (Object[])new Object[]{KeyInit.shoulderKey.method_16007()}), true);
                }
                this.setSittingOnShoulder(true);
            }
            return class_1269.method_29236((boolean)this.method_37908().method_8608());
        }
        return super.method_5992(player, hand);
    }

    public void aiStep() {
    }

    public void method_6007() {
        super.method_6007();
        this.method_6119();
        if (!this.method_37908().method_8608() && SnekCraftConfig.SNAKES_DROP_ITEMS && this.method_5805() && --this.shedTime <= 0) {
            this.method_5706((class_1935)ItemInit.SNAKE_SKIN);
            if (this.field_5974.method_43048(5) == 0) {
                this.method_5706((class_1935)ItemInit.SNAKE_TOOTH);
            }
            this.shedTime = !this.method_6109() ? this.field_5974.method_43048(24000) + 24000 : this.field_5974.method_43048(480000) + 48000;
        }
    }

    public static boolean canMobSpawn(class_1299<? extends class_1308> entityType, class_1936 worldAccess, class_3730 spawnReason, class_2338 position, Random random) {
        return worldAccess.method_8320(position.method_10074()).method_26164(class_3481.field_36266) && SnakeBase.method_39448((class_1920)worldAccess, (class_2338)position);
    }

    @Nullable
    public class_1315 method_5943(class_5425 worldAccess, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData, @Nullable class_2487 nbt) {
        this.setColor(0);
        this.setPattern(0);
        return super.method_5943(worldAccess, difficulty, spawnReason, entityData, nbt);
    }

    @Nullable
    public class_1296 method_5613(class_3218 world, class_1296 otherEntity) {
        SnakeBase snake = (SnakeBase)this.method_5864().method_5883((class_1937)world);
        if (snake == null) {
            SnekCraft.logger.error("FAILED TO GET SNAKEBASE OFFSPRING, WHAT DID I DO WRONG IN MY CODE?");
            return null;
        }
        int p1Color = this.getColor();
        int p2Color = ((SnakeBase)otherEntity).getColor();
        int p1Pattern = this.getPattern();
        int p2Pattern = ((SnakeBase)otherEntity).getPattern();
        snake.setColor(this.getOffspringColor(p1Color, p2Color));
        snake.setPattern(this.getOffspringPattern(p1Pattern, p2Pattern));
        return snake;
    }

    public int getOffspringColor(int p1Color, int p2Color) {
        return colorGenetics[p1Color][p2Color].getGene(this.field_5974.method_43048(100));
    }

    public int getOffspringPattern(int p1Pattern, int p2Pattern) {
        return patternGenetics[p1Pattern][p2Pattern].getGene(this.field_5974.method_43048(100));
    }

    protected class_3414 method_6002() {
        return SoundInit.SNEK_HURT;
    }

    protected class_3414 method_6011(class_1282 damageSource) {
        return SoundInit.SNEK_HURT;
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(COLOR, (Object)0);
        this.field_6011.method_12784(PATTERN, (Object)0);
        this.field_6011.method_12784(HAS_EGG, (Object)false);
        this.field_6011.method_12784(LAYING_EGG, (Object)false);
        this.field_6011.method_12784(RESTING, (Object)false);
    }

    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10569(NBT_KEY_COLOR, this.getColor());
        compound.method_10569(NBT_KEY_PATTERN, this.getPattern());
        compound.method_10569(NBT_KEY_SHED_TIME, this.shedTime);
        compound.method_10556(NBT_KEY_HAS_EGG, this.hasEgg());
        compound.method_10556(NBT_KEY_RESTING, this.isResting());
    }

    public abstract void addSpeciesSaveData(class_2487 var1);

    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.setColor(compound.method_10550(NBT_KEY_COLOR));
        this.setPattern(compound.method_10550(NBT_KEY_PATTERN));
        if (compound.method_10545(NBT_KEY_SHED_TIME)) {
            this.shedTime = compound.method_10550(NBT_KEY_SHED_TIME);
        }
        this.setHasEgg(compound.method_10577(NBT_KEY_HAS_EGG));
        this.setResting(compound.method_10577(NBT_KEY_RESTING));
    }

    public void method_5848() {
        this.setSittingOnShoulder(false);
        super.method_5848();
    }

    public abstract class_2248 getEggType();

    public int getColor() {
        return (Integer)this.field_6011.method_12789(COLOR);
    }

    public void setColor(int color) {
        this.field_6011.method_12778(COLOR, (Object)color);
    }

    public int getPattern() {
        return (Integer)this.field_6011.method_12789(PATTERN);
    }

    public void setPattern(int pattern) {
        this.field_6011.method_12778(PATTERN, (Object)pattern);
    }

    public boolean isResting() {
        return (Boolean)this.field_6011.method_12789(RESTING);
    }

    public void setResting(boolean resting) {
        this.field_6011.method_12778(RESTING, (Object)resting);
    }

    public boolean method_6482() {
        return super.method_6482() && !this.hasEgg();
    }

    public boolean hasEgg() {
        return (Boolean)this.field_6011.method_12789(HAS_EGG);
    }

    public void setHasEgg(boolean hasEgg) {
        this.field_6011.method_12778(HAS_EGG, (Object)hasEgg);
    }

    public boolean isLayingEgg() {
        return (Boolean)this.field_6011.method_12789(LAYING_EGG);
    }

    public void setLayingEgg(boolean isLayingEgg) {
        this.layEggCounter = isLayingEgg ? 1 : 0;
        this.field_6011.method_12778(LAYING_EGG, (Object)isLayingEgg);
    }

    public void setSittingOnShoulder(boolean isSittingOnShoulder) {
        this.isSittingOnShoulder = isSittingOnShoulder;
        if (isSittingOnShoulder) {
            this.method_18380(class_4050.field_18081);
        } else {
            this.method_18380(class_4050.field_18076);
        }
    }

    public boolean isSittingOnShoulder() {
        return this.isSittingOnShoulder;
    }

    public void method_5842() {
        super.method_5842();
        class_1297 class_12972 = this.method_5854();
        if (class_12972 instanceof class_1657) {
            class_1657 player = (class_1657)class_12972;
            this.updateRiding(player);
        }
    }

    public void updateRiding(class_1657 player) {
        int i = player.method_5685().indexOf((Object)this);
        float radius = (i == 0 ? 0.0f : 0.4f) + (float)(player.method_6128() ? 2 : 0);
        float angle = 1.7453293E9f * player.field_6283 + (i == 2 ? -92.5f : (i == 1 ? 92.5f : 0.0f));
        double extraX = (double)radius * Math.sin((float)(Math.PI + (double)angle));
        double extraY = player.method_18276() ? 1.1 : 1.4;
        double extraZ = (double)radius * Math.cos(angle);
        class_243 vec3 = new class_243(-0.2, 0.0, 0.0).method_1024(-player.field_6283 * ((float)Math.PI / 180) - 1.5707964f);
        this.method_5636(player.field_6241);
        this.field_6241 = player.field_6241;
        this.field_6220 = player.field_6241;
        this.method_23327(player.method_23317() + extraX + vec3.field_1352, player.method_23318() + extraY, player.method_23321() + extraZ + vec3.field_1350);
    }

    @NotNull
    public class_4048 method_18377(class_4050 pose) {
        if (pose == class_4050.field_18081) {
            return class_4048.method_18384((float)0.1f, (float)0.1f);
        }
        return this.size;
    }

    public void method_5773() {
        if (this.method_37908().method_8608()) {
            if (this.isSittingOnShoulder) {
                this.shoulderAnimationState.method_41322(this.field_6012);
            } else {
                this.shoulderAnimationState.method_41325();
            }
            if (this.isResting() && !this.isSittingOnShoulder()) {
                this.hideAnimationState.method_41322(this.field_6012);
            } else {
                this.hideAnimationState.method_41325();
            }
            if (this.bleleleTime <= 0) {
                this.bleleleTime = this.field_5974.method_43048(500) + 500;
                this.bleleleAnimationState.method_41322(this.field_6012);
            } else {
                --this.bleleleTime;
            }
            if (this.field_6252) {
                this.method_5783(SoundInit.SNEK_HURT, 1.0f, 1.0f);
                this.strikeAnimationState.method_41324(this.field_6012);
            } else {
                this.strikeAnimationState.method_41325();
            }
            this.slitherAnimationState.method_45317(!this.isResting() && !this.isSittingOnShoulder() && this.field_42108.method_48571(), this.field_6012);
            this.idleAnimationState.method_45317(!this.isResting() && !this.isSittingOnShoulder() && !this.strikeAnimationState.method_41327(), this.field_6012);
        }
        super.method_5773();
    }

    public void tickBypass() {
        super.method_5773();
    }

    private int getCurAdditionalSwingDur() {
        if (class_1292.method_5576((class_1309)this)) {
            return 6 - (1 + class_1292.method_5575((class_1309)this));
        }
        return this.method_6059(class_1294.field_5901) ? 6 + (1 + this.method_6112(class_1294.field_5901).method_5578()) * 2 : 6;
    }

    public void method_6104(class_1268 hand) {
        this.method_23667(hand, false);
    }

    public void method_23667(class_1268 hand, boolean updateSelf) {
        class_1799 itemStack = this.method_5998(hand);
        if (!itemStack.method_7960() || this.field_6279 >= this.getCurAdditionalSwingDur() / 2 || this.field_6279 < 0) {
            this.field_6279 = -1;
            this.field_6252 = true;
            this.field_6266 = hand;
            class_1937 class_19372 = this.method_37908();
            if (class_19372 instanceof class_3218) {
                class_3218 serverWorld = (class_3218)class_19372;
                class_2616 entityAnimationPacket = new class_2616((class_1297)this, hand == class_1268.field_5808 ? 0 : 3);
                class_3215 serverChunkManager = serverWorld.method_14178();
                if (updateSelf) {
                    serverChunkManager.method_18751((class_1297)this, (class_2596)entityAnimationPacket);
                } else {
                    serverChunkManager.method_18754((class_1297)this, (class_2596)entityAnimationPacket);
                }
            }
        }
    }

    public abstract String getSpeciesName(int var1, int var2);
}

