/*
 * Decompiled with CFR 0.152.
 */
package com.raspix.snekcraft;

import com.mojang.logging.LogUtils;
import com.raspix.snekcraft.Config;
import com.raspix.snekcraft.blocks.BlockInit;
import com.raspix.snekcraft.blocks.entity.BlockEntityInit;
import com.raspix.snekcraft.entity.ModEntityTypes;
import com.raspix.snekcraft.entity.ball_python.BallPythonEntity;
import com.raspix.snekcraft.entity.ball_python.BallPythonModel;
import com.raspix.snekcraft.entity.ball_python.BallPythonRenderer;
import com.raspix.snekcraft.entity.corn.CornSnakeEntity;
import com.raspix.snekcraft.entity.corn.CornSnakeModel;
import com.raspix.snekcraft.entity.corn.CornSnakeRenderer;
import com.raspix.snekcraft.entity.hognose.HognoseEntity;
import com.raspix.snekcraft.entity.hognose.HognoseModel;
import com.raspix.snekcraft.entity.hognose.HognoseRenderer;
import com.raspix.snekcraft.items.ItemInit;
import com.raspix.snekcraft.items.SnakeBagItem;
import com.raspix.snekcraft.loot.ModLootModifiers;
import com.raspix.snekcraft.packets.PacketHandler;
import com.raspix.snekcraft.sounds.SoundInit;
import com.raspix.snekcraft.util.KeyInit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.SpawnPlacementRegisterEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import org.slf4j.Logger;

@Mod(value="snekcraft")
public class SnekCraft {
    public static final String MOD_ID = "snekcraft";
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"snekcraft");

    public SnekCraft() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        BlockInit.BLOCKS.register(modEventBus);
        ItemInit.ITEMS.register(modEventBus);
        CREATIVE_MODE_TABS.register(modEventBus);
        SoundInit.SOUNDS.register(modEventBus);
        ModEntityTypes.ENTITIES.register(modEventBus);
        ModLootModifiers.register(modEventBus);
        BlockEntityInit.BLOCK_ENTITIES.register(modEventBus);
        MinecraftForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(this::addCreative);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("HELLO from server starting");
    }

    @Mod.EventBusSubscriber(modid="snekcraft", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class CommonModEvents {
        @SubscribeEvent
        public static void entityAttributes(EntityAttributeCreationEvent event) {
            event.put((EntityType)ModEntityTypes.HOGNOSE.get(), HognoseEntity.m_21183_().m_22265_());
            event.put((EntityType)ModEntityTypes.BALLPYTHON.get(), BallPythonEntity.m_21183_().m_22265_());
            event.put((EntityType)ModEntityTypes.CORNSNAKE.get(), BallPythonEntity.m_21183_().m_22265_());
        }

        @SubscribeEvent
        public static void commonSetup(FMLCommonSetupEvent event) {
            event.enqueueWork(PacketHandler::init);
        }

        @SubscribeEvent
        public static void registerSpawnPlacements(SpawnPlacementRegisterEvent event) {
            event.register((EntityType)ModEntityTypes.HOGNOSE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.WORLD_SURFACE, HognoseEntity::canSpawnThis, SpawnPlacementRegisterEvent.Operation.OR);
            event.register((EntityType)ModEntityTypes.BALLPYTHON.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.WORLD_SURFACE, BallPythonEntity::canSpawn, SpawnPlacementRegisterEvent.Operation.OR);
            event.register((EntityType)ModEntityTypes.CORNSNAKE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.WORLD_SURFACE, CornSnakeEntity::canSpawn, SpawnPlacementRegisterEvent.Operation.OR);
        }
    }

    @Mod.EventBusSubscriber(modid="snekcraft", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            LOGGER.info("HELLO FROM CLIENT SETUP");
            LOGGER.info("MINECRAFT NAME >> {}", (Object)Minecraft.m_91087_().m_91094_().m_92546_());
            ItemProperties.register((Item)((Item)ItemInit.SNAKE_BAG.get()), (ResourceLocation)new ResourceLocation("snake_count"), (stack, p_239428_1_, p_239428_2_, other) -> Math.min(1, SnakeBagItem.getSnakesInStack(stack)));
        }

        @SubscribeEvent
        public static void registerKeys(RegisterKeyMappingsEvent event) {
            event.register(KeyInit.shoulderKey);
        }

        @SubscribeEvent
        public static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
            event.registerEntityRenderer((EntityType)ModEntityTypes.HOGNOSE.get(), HognoseRenderer::new);
            event.registerEntityRenderer((EntityType)ModEntityTypes.BALLPYTHON.get(), BallPythonRenderer::new);
            event.registerEntityRenderer((EntityType)ModEntityTypes.CORNSNAKE.get(), CornSnakeRenderer::new);
        }

        @SubscribeEvent
        public static void registerLayerDefinition(EntityRenderersEvent.RegisterLayerDefinitions event) {
            event.registerLayerDefinition(HognoseModel.LAYER_LOCATION, HognoseModel::createBodyLayer);
            event.registerLayerDefinition(BallPythonModel.LAYER_LOCATION, BallPythonModel::createBodyLayer);
            event.registerLayerDefinition(CornSnakeModel.LAYER_LOCATION, CornSnakeModel::createBodyLayer);
        }
    }

    @Mod.EventBusSubscriber(modid="snekcraft", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public class ClientEventBusSubscriber {
        @SubscribeEvent
        public static void clientSetup(FMLClientSetupEvent event) {
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)BlockInit.WIRE_CAGE.get()), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)BlockInit.AQUARIUM.get()), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)BlockInit.TERRARIUM.get()), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)BlockInit.LAVAQUARIUM.get()), (RenderType)RenderType.m_110466_());
        }
    }
}

