/*
 * Decompiled with CFR 0.152.
 */
package com.raspix.snekcraft.blocks.entity.eggs;

import com.raspix.snekcraft.blocks.entity.SnakeEggBlockEntity;
import com.raspix.snekcraft.entity.generics.SnakeBase;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public abstract class SnakeEggBlock
extends BaseEntityBlock {
    public static final int MAX_HATCH_LEVEL = 2;
    public static final int MIN_EGGS = 1;
    public static final int MAX_EGGS = 4;
    protected final Random random = new Random();
    private static final VoxelShape ONE_EGG_AABB = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)12.0, (double)7.0, (double)12.0);
    private static final VoxelShape MULTIPLE_EGGS_AABB = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)7.0, (double)15.0);
    public static final IntegerProperty HATCH = BlockStateProperties.f_61416_;
    public static final IntegerProperty EGGS = BlockStateProperties.f_61415_;

    public SnakeEggBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)HATCH, (Comparable)Integer.valueOf(0))).m_61124_((Property)EGGS, (Comparable)Integer.valueOf(1)));
    }

    public void m_141947_(Level pLevel, BlockPos pPos, BlockState pState, Entity pEntity) {
        super.m_141947_(pLevel, pPos, pState, pEntity);
    }

    public void m_142072_(Level pLevel, BlockState pState, BlockPos pPos, Entity pEntity, float pFallDistance) {
        if (!(pEntity instanceof Zombie)) {
            // empty if block
        }
        super.m_142072_(pLevel, pState, pPos, pEntity, pFallDistance);
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        CompoundTag compoundTag;
        if (pLevel.m_5776_() || pHand != InteractionHand.MAIN_HAND || (compoundTag = pLevel.m_7702_(pPos).getPersistentData()) != null) {
            // empty if block
        }
        return super.m_6227_(pState, pLevel, pPos, pPlayer, pHand, pHit);
    }

    private void decreaseEggs(Level pLevel, BlockPos pPos, BlockState pState) {
        pLevel.m_5594_((Player)null, pPos, SoundEvents.f_12533_, SoundSource.BLOCKS, 0.7f, 0.9f + pLevel.f_46441_.m_188501_() * 0.2f);
        int i = (Integer)pState.m_61143_((Property)EGGS);
        if (i <= 1) {
            pLevel.m_46961_(pPos, false);
        } else {
            CompoundTag oldTag = ((SnakeEggBlockEntity)pLevel.m_7702_(pPos)).getPersistentData();
            pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)EGGS, (Comparable)Integer.valueOf(i - 1)), 2);
            pLevel.m_46796_(2001, pPos, Block.m_49956_((BlockState)pState));
            SnakeEggBlockEntity tile = (SnakeEggBlockEntity)pLevel.m_7702_(pPos);
            tile.setStats(oldTag.m_128451_("color"), oldTag.m_128451_("color_p2"), oldTag.m_128451_("pattern"), oldTag.m_128451_("pattern_p2"));
        }
    }

    public void m_213898_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (this.shouldUpdateHatchLevel((Level)pLevel) && SnakeEggBlock.onSand((BlockGetter)pLevel, pPos)) {
            int i = (Integer)pState.m_61143_((Property)HATCH);
            if (i < 2) {
                pLevel.m_5594_((Player)null, pPos, SoundEvents.f_12534_, SoundSource.BLOCKS, 0.7f, 0.9f + pRandom.m_188501_() * 0.2f);
                pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)HATCH, (Comparable)Integer.valueOf(i + 1)), 2);
            } else {
                pLevel.m_5594_((Player)null, pPos, SoundEvents.f_12535_, SoundSource.BLOCKS, 0.7f, 0.9f + pRandom.m_188501_() * 0.2f);
                CompoundTag compoundTag = pLevel.m_7702_(pPos).getPersistentData();
                pLevel.m_7471_(pPos, false);
                for (int j = 0; j < (Integer)pState.m_61143_((Property)EGGS); ++j) {
                    pLevel.m_46796_(2001, pPos, Block.m_49956_((BlockState)pState));
                    SnakeBase snake = (SnakeBase)this.GetSnakeType().m_20615_((Level)pLevel);
                    snake.m_146762_(-24000);
                    snake.m_7678_((double)pPos.m_123341_() + 0.3 + (double)j * 0.2, pPos.m_123342_(), (double)pPos.m_123343_() + 0.3, 0.0f, 0.0f);
                    snake.setColor(this.getOffspringColor(compoundTag));
                    snake.setPattern(this.getOffspringPattern(compoundTag));
                    pLevel.m_7967_((Entity)snake);
                }
            }
        }
    }

    public abstract EntityType<?> GetSnakeType();

    public static boolean onSand(BlockGetter pLevel, BlockPos pPos) {
        return SnakeEggBlock.isSand(pLevel, pPos.m_7495_());
    }

    public static boolean isSand(BlockGetter pReader, BlockPos pPos) {
        return pReader.m_8055_(pPos).m_204336_(BlockTags.f_144274_) || pReader.m_8055_(pPos).m_204336_(BlockTags.f_13029_);
    }

    public void m_6807_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        if (SnakeEggBlock.onSand((BlockGetter)pLevel, pPos) && !pLevel.f_46443_) {
            pLevel.m_46796_(2005, pPos, 0);
        }
    }

    private boolean shouldUpdateHatchLevel(Level pLevel) {
        float f = pLevel.m_46942_(1.0f);
        if ((double)f < 0.69 && (double)f > 0.65) {
            return true;
        }
        return pLevel.f_46441_.m_188503_(4) == 0;
    }

    public void m_6240_(Level pLevel, Player pPlayer, BlockPos pPos, BlockState pState, @javax.annotation.Nullable BlockEntity pTe, ItemStack pStack) {
        if (!pLevel.f_46443_ && pLevel.m_46469_().m_46207_(GameRules.f_46136_) && EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44985_, (ItemStack)pStack) != 0) {
            ItemStack itemstack = new ItemStack((ItemLike)this);
            CompoundTag compoundTagBlock = pTe.getPersistentData();
            int c1 = compoundTagBlock.m_128451_("color");
            int c2 = compoundTagBlock.m_128451_("color_p2");
            int p1 = compoundTagBlock.m_128451_("pattern");
            int p2 = compoundTagBlock.m_128451_("pattern_p2");
            CompoundTag compoundtag = new CompoundTag();
            if (c1 > 0) {
                compoundtag.m_128405_("color", c1);
            }
            if (c2 > 0) {
                compoundtag.m_128405_("color_p2", c2);
            }
            if (p1 > 0) {
                compoundtag.m_128405_("pattern", p1);
            }
            if (p2 > 0) {
                compoundtag.m_128405_("pattern_p2", p2);
            }
            itemstack.m_41700_("BlockStateTag", (Tag)compoundtag);
            ItemEntity itementity = new ItemEntity(pLevel, (double)pPos.m_123341_(), (double)pPos.m_123342_(), (double)pPos.m_123343_(), itemstack);
            itementity.m_32060_();
            pLevel.m_7967_((Entity)itementity);
        }
        super.m_6240_(pLevel, pPlayer, pPos, pState, pTe, pStack);
    }

    public boolean m_6864_(BlockState pState, BlockPlaceContext pUseContext) {
        ItemStack handItem = pUseContext.m_43722_();
        CompoundTag tag = handItem.m_41783_();
        boolean isSameEggType = handItem.m_150930_(this.m_5456_());
        boolean areSameValues = false;
        if (isSameEggType && handItem.m_41783_() != null && !pUseContext.m_43725_().f_46443_) {
            BlockPos pos = pUseContext.m_8083_();
            CompoundTag blockTag = pUseContext.m_43725_().m_7702_(pos).getPersistentData();
            for (String tagInfo : tag.m_128431_()) {
                if (!tagInfo.contains("BlockStateTag")) continue;
                CompoundTag compoundTag = tag.m_128469_("BlockStateTag");
                areSameValues = this.areGeneticsSame(blockTag, compoundTag);
            }
        }
        return !pUseContext.m_7078_() && isSameEggType && areSameValues && (Integer)pState.m_61143_((Property)EGGS) < 4 ? true : super.m_6864_(pState, pUseContext);
    }

    public boolean areGeneticsSame(CompoundTag blockTag, CompoundTag itemTag) {
        boolean colorMatch = blockTag.m_128451_("color") == itemTag.m_128451_("color");
        boolean colorMatch2 = blockTag.m_128451_("color_p2") == itemTag.m_128451_("color_p2");
        boolean patternMatch = blockTag.m_128451_("pattern") == itemTag.m_128451_("pattern");
        boolean patternMatch2 = blockTag.m_128451_("pattern_p2") == itemTag.m_128451_("pattern_p2");
        return colorMatch && colorMatch2 && patternMatch && patternMatch2;
    }

    @javax.annotation.Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        BlockState blockstate = pContext.m_43725_().m_8055_(pContext.m_8083_());
        return blockstate.m_60713_((Block)this) ? (BlockState)blockstate.m_61124_((Property)EGGS, (Comparable)Integer.valueOf(Math.min(4, (Integer)blockstate.m_61143_((Property)EGGS) + 1))) : super.m_5573_(pContext);
    }

    public void m_6402_(Level pLevel, BlockPos pPos, BlockState pState, @Nullable LivingEntity pPlacer, ItemStack pStack) {
        CompoundTag compoundTag;
        super.m_6402_(pLevel, pPos, pState, pPlacer, pStack);
        CompoundTag tag1 = pStack.m_41783_();
        if (tag1 != null && (compoundTag = tag1.m_128469_("BlockStateTag")) != null) {
            int c1 = compoundTag.m_128451_("color");
            int c2 = compoundTag.m_128451_("color_p2");
            int p1 = compoundTag.m_128451_("pattern");
            int p2 = compoundTag.m_128451_("pattern_p2");
            SnakeEggBlockEntity sebe = (SnakeEggBlockEntity)pLevel.m_7702_(pPos);
            if (sebe != null) {
                CompoundTag tag = sebe.getPersistentData();
                tag.m_128405_("color", c1);
                tag.m_128405_("color_p2", c2);
                tag.m_128405_("pattern", p1);
                tag.m_128405_("pattern_p2", p2);
            }
        }
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return (Integer)pState.m_61143_((Property)EGGS) > 1 ? MULTIPLE_EGGS_AABB : ONE_EGG_AABB;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{HATCH, EGGS});
    }

    public void m_5707_(Level pLevel, BlockPos pPos, BlockState pState, Player pPlayer) {
        super.m_5707_(pLevel, pPos, pState, pPlayer);
    }

    public abstract int getOffspringColor(CompoundTag var1);

    public abstract int getOffspringPattern(CompoundTag var1);

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new SnakeEggBlockEntity(pPos, pState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return super.m_142354_(pLevel, pState, pBlockEntityType);
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        if (!(!pState.m_155947_() || pState.m_60713_(pNewState.m_60734_()) && pNewState.m_155947_())) {
            pLevel.m_46747_(pPos);
        }
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        this.m_5707_(level, pos, state, player);
        this.decreaseEggs(level, pos, state);
        return true;
    }
}

