/*
 * Decompiled with CFR 0.152.
 */
package com.raspix.snekcraft.blocks.terrariums;

import com.raspix.snekcraft.blocks.SnekBlockStateProperties;
import com.raspix.snekcraft.items.ItemInit;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.GlassBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class TerrariumBlock
extends GlassBlock {
    public static final IntegerProperty UP = SnekBlockStateProperties.UP;
    public static final IntegerProperty DOWN = SnekBlockStateProperties.DOWN;
    public static final IntegerProperty NORTH = SnekBlockStateProperties.NORTH;
    public static final IntegerProperty EAST = SnekBlockStateProperties.EAST;
    public static final IntegerProperty SOUTH = SnekBlockStateProperties.SOUTH;
    public static final IntegerProperty WEST = SnekBlockStateProperties.WEST;
    public static final BooleanProperty PATHFIND = BooleanProperty.m_61465_((String)"pathfind");
    private static final VoxelShape TOP_AABB = Block.m_49796_((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape BOTTOM_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    private static final VoxelShape NORTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
    private static final VoxelShape SOUTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape EAST_AABB = Block.m_49796_((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape WEST_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);

    public TerrariumBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)NORTH, (Comparable)Integer.valueOf(0))).m_61124_((Property)EAST, (Comparable)Integer.valueOf(0))).m_61124_((Property)SOUTH, (Comparable)Integer.valueOf(0))).m_61124_((Property)WEST, (Comparable)Integer.valueOf(0))).m_61124_((Property)UP, (Comparable)Integer.valueOf(0))).m_61124_((Property)DOWN, (Comparable)Integer.valueOf(0)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{NORTH, EAST, SOUTH, WEST, UP, DOWN, PATHFIND});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Level iblockreader = context.m_43725_();
        BlockPos blockpos = context.m_8083_();
        BlockState thisState = iblockreader.m_8055_(blockpos);
        BlockPos blockposN = blockpos.m_122012_();
        BlockPos blockposE = blockpos.m_122029_();
        BlockPos blockposS = blockpos.m_122019_();
        BlockPos blockposW = blockpos.m_122024_();
        BlockState blockstateN = iblockreader.m_8055_(blockposN);
        BlockState blockstateE = iblockreader.m_8055_(blockposE);
        BlockState blockstateS = iblockreader.m_8055_(blockposS);
        BlockState blockstateW = iblockreader.m_8055_(blockposW);
        return (BlockState)((BlockState)((BlockState)((BlockState)Objects.requireNonNull(super.m_5573_(context)).m_61124_((Property)NORTH, (Comparable)Integer.valueOf(this.canFenceConnectTo(blockstateN, thisState, Direction.SOUTH, null)))).m_61124_((Property)EAST, (Comparable)Integer.valueOf(this.canFenceConnectTo(blockstateE, thisState, Direction.WEST, null)))).m_61124_((Property)SOUTH, (Comparable)Integer.valueOf(this.canFenceConnectTo(blockstateS, thisState, Direction.NORTH, null)))).m_61124_((Property)WEST, (Comparable)Integer.valueOf(this.canFenceConnectTo(blockstateW, thisState, Direction.EAST, null)));
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        BlockState ans = (BlockState)this.updateBlockShape(state, facing, facingState, level, currentPos, facingPos).m_61124_((Property)PATHFIND, (Comparable)Boolean.valueOf(this.updatePathfinding(state, level, currentPos)));
        return ans;
    }

    public boolean updatePathfinding(BlockState state, LevelAccessor level, BlockPos pos) {
        return (Integer)state.m_61143_((Property)NORTH) != 0 && (Integer)state.m_61143_((Property)EAST) != 0 && (Integer)state.m_61143_((Property)SOUTH) != 0 && (Integer)state.m_61143_((Property)WEST) != 0;
    }

    public BlockState updateBlockShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        switch (facing) {
            case NORTH: {
                return (BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)Integer.valueOf(this.isWallConnectedTo(facingState, state, NORTH, level, Direction.NORTH, currentPos)))).m_61124_((Property)WEST, (Comparable)Integer.valueOf(this.isWallConnectedTo(level.m_8055_(currentPos.m_122024_()), state, WEST, level, Direction.WEST, currentPos)));
            }
            case SOUTH: {
                return (BlockState)((BlockState)state.m_61124_((Property)SOUTH, (Comparable)Integer.valueOf(this.isWallConnectedTo(facingState, state, SOUTH, level, Direction.SOUTH, currentPos)))).m_61124_((Property)EAST, (Comparable)Integer.valueOf(this.isWallConnectedTo(level.m_8055_(currentPos.m_122029_()), state, EAST, level, Direction.EAST, currentPos)));
            }
            case EAST: {
                return (BlockState)((BlockState)state.m_61124_((Property)EAST, (Comparable)Integer.valueOf(this.isWallConnectedTo(facingState, state, EAST, level, Direction.EAST, currentPos)))).m_61124_((Property)NORTH, (Comparable)Integer.valueOf(this.isWallConnectedTo(level.m_8055_(currentPos.m_122012_()), state, NORTH, level, Direction.NORTH, currentPos)));
            }
            case WEST: {
                return (BlockState)((BlockState)state.m_61124_((Property)WEST, (Comparable)Integer.valueOf(this.isWallConnectedTo(facingState, state, WEST, level, Direction.WEST, currentPos)))).m_61124_((Property)SOUTH, (Comparable)Integer.valueOf(this.isWallConnectedTo(level.m_8055_(currentPos.m_122019_()), state, SOUTH, level, Direction.SOUTH, currentPos)));
            }
            case DOWN: {
                return (BlockState)state.m_61124_((Property)DOWN, (Comparable)Integer.valueOf(this.canFenceConnectTo(facingState, state, facing.m_122424_(), DOWN)));
            }
        }
        return (BlockState)state.m_61124_((Property)UP, (Comparable)Integer.valueOf(this.canFenceConnectTo(facingState, state, facing.m_122424_(), UP)));
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (!pLevel.m_5776_() && pHand == InteractionHand.MAIN_HAND) {
            ItemStack heldItem = pPlayer.m_21120_(pHand);
            if (heldItem.m_150930_(Items.f_42398_)) {
                // empty if block
            }
            if (!heldItem.m_150930_((Item)ItemInit.TERRARIUM_KEY.get())) {
                return InteractionResult.FAIL;
            }
            this.setSideEntrance(pState, pLevel, pPos, pPlayer, pHand, pHit);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public void setSideEntrance(BlockState state, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        Direction hitWall = pHit.m_82434_();
        int sideValue = (Integer)state.m_61143_((Property)this.getDirStateFromDir(hitWall));
        if (sideValue == 1 || sideValue == 3) {
            hitWall = hitWall.m_122424_();
        }
        if (hitWall == null) {
            return;
        }
        if (hitWall.equals((Object)Direction.NORTH) && (Integer)state.m_61143_((Property)NORTH) != 1) {
            pLevel.m_7731_(pPos, (BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)NORTH) == 2 ? 0 : 2))).m_61124_((Property)PATHFIND, (Comparable)Boolean.valueOf(this.updatePathfinding(state, (LevelAccessor)pLevel, pPos))), 3);
        } else if (hitWall.equals((Object)Direction.SOUTH) && (Integer)state.m_61143_((Property)SOUTH) != 1) {
            pLevel.m_7731_(pPos, (BlockState)((BlockState)state.m_61124_((Property)SOUTH, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)SOUTH) == 2 ? 0 : 2))).m_61124_((Property)PATHFIND, (Comparable)Boolean.valueOf(this.updatePathfinding(state, (LevelAccessor)pLevel, pPos))), 3);
        } else if (hitWall.equals((Object)Direction.EAST) && (Integer)state.m_61143_((Property)EAST) != 1) {
            pLevel.m_7731_(pPos, (BlockState)((BlockState)state.m_61124_((Property)EAST, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)EAST) == 2 ? 0 : 2))).m_61124_((Property)PATHFIND, (Comparable)Boolean.valueOf(this.updatePathfinding(state, (LevelAccessor)pLevel, pPos))), 3);
        } else if (hitWall.equals((Object)Direction.WEST) && (Integer)state.m_61143_((Property)WEST) != 1) {
            pLevel.m_7731_(pPos, (BlockState)((BlockState)state.m_61124_((Property)WEST, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)WEST) == 2 ? 0 : 2))).m_61124_((Property)PATHFIND, (Comparable)Boolean.valueOf(this.updatePathfinding(state, (LevelAccessor)pLevel, pPos))), 3);
        } else if (hitWall.equals((Object)Direction.UP) && (Integer)state.m_61143_((Property)UP) != 1) {
            pLevel.m_7731_(pPos, (BlockState)state.m_61124_((Property)UP, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)UP) == 2 ? 0 : 2)), 3);
        } else if (hitWall.equals((Object)Direction.DOWN) && (Integer)state.m_61143_((Property)DOWN) != 1) {
            pLevel.m_7731_(pPos, (BlockState)state.m_61124_((Property)DOWN, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)DOWN) == 2 ? 0 : 2)), 3);
        }
    }

    public void updateCornerOnChangeDelete(BlockState pState, Level pLevel, Direction wallChanged, BlockPos pPos) {
        switch (wallChanged) {
            case NORTH: {
                BlockState eastState = pLevel.m_8055_(pPos.m_122029_());
                pLevel.m_7731_(pPos.m_122029_(), (BlockState)eastState.m_61124_((Property)SOUTH, (Comparable)Integer.valueOf(this.isWallConnectedTo(pLevel.m_8055_(pPos.m_122029_().m_122019_()), eastState, SOUTH, (LevelAccessor)pLevel, Direction.SOUTH, pPos.m_122029_()))), 3);
                break;
            }
            case EAST: {
                break;
            }
            case SOUTH: {
                break;
            }
            case WEST: {
                break;
            }
        }
    }

    public IntegerProperty getDirStateFromDir(Direction dir) {
        switch (dir) {
            case NORTH: {
                return NORTH;
            }
            case SOUTH: {
                return SOUTH;
            }
            case EAST: {
                return EAST;
            }
            case WEST: {
                return WEST;
            }
            case UP: {
                return UP;
            }
            case DOWN: {
                return DOWN;
            }
        }
        System.out.println("something went wrong");
        return NORTH;
    }

    public int canFenceConnectTo(BlockState sideState, BlockState thisState, Direction facing, IntegerProperty prop) {
        if (sideState.m_60734_() instanceof TerrariumBlock) {
            return 1;
        }
        if (thisState != null && prop != null && (Integer)thisState.m_61143_((Property)prop) == 2) {
            return 2;
        }
        return 0;
    }

    public int isWallConnectedTo(BlockState facingState, BlockState thisState, IntegerProperty prop, LevelAccessor level, Direction facing, BlockPos currentPos) {
        if (facingState.m_60734_() instanceof TerrariumBlock) {
            if (this.areSiliconeSidesSolid(level, facing, currentPos)) {
                return 3;
            }
            return 1;
        }
        if (thisState != null && prop != null && (Integer)thisState.m_61143_((Property)prop) == 2) {
            return 2;
        }
        return 0;
    }

    public boolean areSiliconeSidesSolid(LevelAccessor level, Direction facing, BlockPos currentPos) {
        IntegerProperty clockwiseWallDir;
        IntegerProperty facingWallDir;
        BlockState diagState;
        BlockState clockwiseState;
        BlockState facingState;
        switch (facing) {
            case NORTH: {
                facingState = level.m_8055_(currentPos.m_122012_());
                clockwiseState = level.m_8055_(currentPos.m_122029_());
                diagState = level.m_8055_(currentPos.m_122012_().m_122029_());
                facingWallDir = EAST;
                clockwiseWallDir = NORTH;
                break;
            }
            case EAST: {
                facingState = level.m_8055_(currentPos.m_122029_());
                clockwiseState = level.m_8055_(currentPos.m_122019_());
                diagState = level.m_8055_(currentPos.m_122029_().m_122019_());
                facingWallDir = SOUTH;
                clockwiseWallDir = EAST;
                break;
            }
            case SOUTH: {
                facingState = level.m_8055_(currentPos.m_122019_());
                clockwiseState = level.m_8055_(currentPos.m_122024_());
                diagState = level.m_8055_(currentPos.m_122019_().m_122024_());
                facingWallDir = WEST;
                clockwiseWallDir = SOUTH;
                break;
            }
            case WEST: {
                facingState = level.m_8055_(currentPos.m_122024_());
                clockwiseState = level.m_8055_(currentPos.m_122012_());
                diagState = level.m_8055_(currentPos.m_122024_().m_122012_());
                facingWallDir = NORTH;
                clockwiseWallDir = WEST;
                break;
            }
            default: {
                return false;
            }
        }
        return facingState.m_60734_() instanceof TerrariumBlock && clockwiseState.m_60734_() instanceof TerrariumBlock && !(diagState.m_60734_() instanceof TerrariumBlock) && ((Integer)facingState.m_61143_((Property)facingWallDir) != 2 || (Integer)clockwiseState.m_61143_((Property)clockwiseWallDir) != 2);
    }

    public int hasInnerCorner(BlockState stateDiag, BlockState stateSide1, BlockState stateSide2) {
        if (stateDiag.m_60734_() instanceof TerrariumBlock || !(stateSide1.m_60734_() instanceof TerrariumBlock) || !(stateSide2.m_60734_() instanceof TerrariumBlock)) {
            return 1;
        }
        return 0;
    }

    @NotNull
    public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        VoxelShape shape1 = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
        if (state.m_60734_() instanceof TerrariumBlock) {
            if ((Integer)state.m_61143_((Property)UP) == 0) {
                shape1 = Shapes.m_83113_((VoxelShape)shape1, (VoxelShape)TOP_AABB, (BooleanOp)BooleanOp.f_82695_);
            }
            if ((Integer)state.m_61143_((Property)DOWN) == 0) {
                shape1 = Shapes.m_83113_((VoxelShape)shape1, (VoxelShape)BOTTOM_AABB, (BooleanOp)BooleanOp.f_82695_);
            }
            if ((Integer)state.m_61143_((Property)NORTH) == 0) {
                shape1 = Shapes.m_83113_((VoxelShape)shape1, (VoxelShape)NORTH_AABB, (BooleanOp)BooleanOp.f_82695_);
            }
            if ((Integer)state.m_61143_((Property)SOUTH) == 0) {
                shape1 = Shapes.m_83113_((VoxelShape)shape1, (VoxelShape)SOUTH_AABB, (BooleanOp)BooleanOp.f_82695_);
            }
            if ((Integer)state.m_61143_((Property)EAST) == 0) {
                shape1 = Shapes.m_83113_((VoxelShape)shape1, (VoxelShape)EAST_AABB, (BooleanOp)BooleanOp.f_82695_);
            }
            if ((Integer)state.m_61143_((Property)WEST) == 0) {
                shape1 = Shapes.m_83113_((VoxelShape)shape1, (VoxelShape)WEST_AABB, (BooleanOp)BooleanOp.f_82695_);
            }
        }
        return shape1;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        VoxelShape shape1 = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
        boolean hasItem = pContext.m_7142_((Item)ItemInit.TERRARIUM_KEY.get());
        if (state.m_60734_() instanceof TerrariumBlock) {
            if ((Integer)state.m_61143_((Property)UP) == 0 || (Integer)state.m_61143_((Property)UP) == 2 && hasItem) {
                shape1 = Shapes.m_83113_((VoxelShape)shape1, (VoxelShape)TOP_AABB, (BooleanOp)BooleanOp.f_82695_);
            }
            if ((Integer)state.m_61143_((Property)DOWN) == 0 || (Integer)state.m_61143_((Property)DOWN) == 2 && hasItem) {
                shape1 = Shapes.m_83113_((VoxelShape)shape1, (VoxelShape)BOTTOM_AABB, (BooleanOp)BooleanOp.f_82695_);
            }
            if ((Integer)state.m_61143_((Property)NORTH) == 0 || (Integer)state.m_61143_((Property)NORTH) == 2 && hasItem) {
                shape1 = Shapes.m_83113_((VoxelShape)shape1, (VoxelShape)NORTH_AABB, (BooleanOp)BooleanOp.f_82695_);
            }
            if ((Integer)state.m_61143_((Property)SOUTH) == 0 || (Integer)state.m_61143_((Property)SOUTH) == 2 && hasItem) {
                shape1 = Shapes.m_83113_((VoxelShape)shape1, (VoxelShape)SOUTH_AABB, (BooleanOp)BooleanOp.f_82695_);
            }
            if ((Integer)state.m_61143_((Property)WEST) == 0 || (Integer)state.m_61143_((Property)WEST) == 2 && hasItem) {
                shape1 = Shapes.m_83113_((VoxelShape)shape1, (VoxelShape)WEST_AABB, (BooleanOp)BooleanOp.f_82695_);
            }
            if ((Integer)state.m_61143_((Property)EAST) == 0 || (Integer)state.m_61143_((Property)EAST) == 2 && hasItem) {
                shape1 = Shapes.m_83113_((VoxelShape)shape1, (VoxelShape)EAST_AABB, (BooleanOp)BooleanOp.f_82695_);
            }
        }
        return shape1;
    }

    @NotNull
    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    public boolean m_180643_(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return false;
    }

    protected boolean isEntityInsideContent(BlockState pState, BlockPos pPos, Entity pEntity) {
        return pEntity.m_20186_() < (double)pPos.m_123342_() + this.getContentHeight(pState) && pEntity.m_20191_().f_82292_ > (double)pPos.m_123342_() + 0.25;
    }

    protected double getContentHeight(BlockState pState) {
        return 0.0;
    }

    public boolean m_7357_(BlockState blockState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        if (pType == PathComputationType.WATER) {
            return super.m_7357_(blockState, pLevel, pPos, pType);
        }
        return (Boolean)blockState.m_61143_((Property)PATHFIND);
    }
}

