/*
 * Decompiled with CFR 0.152.
 */
package com.raspix.snekcraft.entity.generics;

import com.raspix.snekcraft.Config;
import com.raspix.snekcraft.blocks.CaveHideBlock;
import com.raspix.snekcraft.blocks.HeatLampBlock;
import com.raspix.snekcraft.blocks.MediumHideBlock;
import com.raspix.snekcraft.blocks.TunnelHideBlock;
import com.raspix.snekcraft.blocks.entity.SnakeEggBlockEntity;
import com.raspix.snekcraft.blocks.entity.eggs.SnakeEggBlock;
import com.raspix.snekcraft.entity.generics.GenePool;
import com.raspix.snekcraft.items.ItemInit;
import com.raspix.snekcraft.items.SnakeBagItem;
import com.raspix.snekcraft.sounds.SoundInit;
import com.raspix.snekcraft.util.KeyInit;
import java.util.EnumSet;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAnimatePacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public abstract class SnakeBase
extends Animal {
    public final AnimationState slitherAnimationState = new AnimationState();
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState bleleleAnimationState = new AnimationState();
    public final AnimationState strikeAnimationState = new AnimationState();
    public final AnimationState hideAnimationState = new AnimationState();
    public final AnimationState shoulderAnimationState = new AnimationState();
    private static final Ingredient FOOD_ITEMS = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42581_, Items.f_42521_, Items.f_42697_});
    private static final EntityDataAccessor<Integer> COLOR = SynchedEntityData.m_135353_(SnakeBase.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> PATTERN = SynchedEntityData.m_135353_(SnakeBase.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> RESTING = SynchedEntityData.m_135353_(SnakeBase.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> HAS_EGG = SynchedEntityData.m_135353_(SnakeBase.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> LAYING_EGG = SynchedEntityData.m_135353_(SnakeBase.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final int BREEDING_RANGE = 100;
    int layEggCounter;
    private int partnerColor = 0;
    private int partnerPattern = 0;
    public int shedTime = this.f_19796_.m_188503_(24000) + 12000;
    public int bleleleTime = this.f_19796_.m_188503_(500) + 500;
    private boolean isSittingOnShoulder;
    private final EntityDimensions size;
    private static GenePool[][] colorGenetics;
    private static GenePool[][] patternGenetics;

    protected SnakeBase(EntityType<? extends Animal> pEntityType, Level pLevel, EntityDimensions size) {
        super(pEntityType, pLevel);
        this.size = size;
    }

    public AttributeMap m_21204_() {
        return super.m_21204_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(1, (Goal)new SnakeBreedGoal(this, 1.0));
        this.f_21345_.m_25352_(1, (Goal)new SnakeLayEggGoal(this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(6, (Goal)new FindRestSpotGoal(this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new CurlGoal(this));
        this.f_21345_.m_25352_(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public static AttributeSupplier.Builder m_21183_() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22283_, 1.0).m_22268_(Attributes.f_22279_, 0.25);
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (itemstack.m_41720_() == ItemInit.SNAKE_BAG.get()) {
            CompoundTag compound = itemstack.m_41783_();
            if (compound == null) {
                compound = new CompoundTag();
                itemstack.m_41751_(compound);
            }
            CompoundTag snakeTag = new CompoundTag();
            this.m_7380_(snakeTag);
            this.addSpeciesSaveData(snakeTag);
            int numSnakesInSack = SnakeBagItem.getSnakesInStack(itemstack);
            if (numSnakesInSack > 0) {
                return InteractionResult.FAIL;
            }
            int currentSnake = numSnakesInSack + 1;
            compound.m_128365_("Snake_" + currentSnake, (Tag)snakeTag);
            this.m_146870_();
            player.m_6674_(hand);
            return InteractionResult.SUCCESS;
        }
        if (this.m_6898_(itemstack) && this.m_21223_() < this.m_21233_()) {
            this.m_5634_(itemstack.getFoodProperties((LivingEntity)this).m_38744_());
            if (!player.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            this.m_146852_(GameEvent.f_157806_, (Entity)this);
            return InteractionResult.SUCCESS;
        }
        if (player.m_36341_() && !this.m_20159_()) {
            if (player.m_20197_().size() < 1) {
                this.m_7998_((Entity)player, true);
                if (player.m_9236_().m_5776_()) {
                    player.m_5661_((Component)Component.m_237110_((String)"component.snekcraft.drop_instructions", (Object[])new Object[]{KeyInit.shoulderKey.getKey().m_84875_()}), true);
                }
                this.setSittingOnShoulder(true);
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        }
        return super.m_6071_(player, hand);
    }

    public void m_8107_() {
        super.m_8107_();
        this.m_21203_();
        if (!this.m_9236_().f_46443_ && Config.snakesDropItems && this.m_6084_() && --this.shedTime <= 0) {
            this.m_19998_((ItemLike)ItemInit.SNAKE_SKIN.get());
            if (this.f_19796_.m_188503_(5) == 0) {
                this.m_19998_((ItemLike)ItemInit.SNAKE_TOOTH.get());
            }
            this.shedTime = !this.m_6162_() ? this.f_19796_.m_188503_(24000) + 24000 : this.f_19796_.m_188503_(480000) + 48000;
        }
    }

    public static boolean canSpawn(EntityType entity, LevelAccessor levelAccess, MobSpawnType spawnType, BlockPos pos, Random random) {
        return SnakeBase.checkSnakeSpawnRules(entity, levelAccess, spawnType, pos, random);
    }

    public static boolean checkSnakeSpawnRules(EntityType entity, LevelAccessor pLevel, MobSpawnType pSpawnType, BlockPos pPos, Random pRandom) {
        return pLevel.m_8055_(pPos.m_7495_()).m_204336_(BlockTags.f_198157_) && SnakeBase.m_186209_((BlockAndTintGetter)pLevel, (BlockPos)pPos);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        this.setColor(0);
        this.setPattern(0);
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    @org.jetbrains.annotations.Nullable
    public AgeableMob m_142606_(ServerLevel level, AgeableMob otherParent) {
        SnakeBase snake = (SnakeBase)this.m_6095_().m_20615_((Level)level);
        if (snake == null) {
            System.out.println("FAILED TO GET SNAKEBASE OFFSPRING, WHAT DID I DO WRONG IN MY CODE?");
            return null;
        }
        int p1Color = this.getColor();
        int p2Color = ((SnakeBase)otherParent).getColor();
        int p1Pattern = this.getPattern();
        int p2Pattern = ((SnakeBase)otherParent).getPattern();
        snake.setColor(this.getOffspringColor(p1Color, p2Color));
        snake.setPattern(this.getOffspringPattern(p1Pattern, p2Pattern));
        return snake;
    }

    public int getOffspringColor(int p1Color, int p2Color) {
        return colorGenetics[p1Color][p2Color].GetGene(this.f_19796_.m_188503_(100));
    }

    public int getOffspringPattern(int p1Pattern, int p2Pattern) {
        return patternGenetics[p1Pattern][p2Pattern].GetGene(this.f_19796_.m_188503_(100));
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)SoundInit.SNEK_HURT.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)SoundInit.SNEK_HURT.get();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(COLOR, (Object)0);
        this.f_19804_.m_135372_(PATTERN, (Object)0);
        this.f_19804_.m_135372_(HAS_EGG, (Object)false);
        this.f_19804_.m_135372_(LAYING_EGG, (Object)false);
        this.f_19804_.m_135372_(RESTING, (Object)false);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Color", this.getColor());
        compound.m_128405_("Pattern", this.getPattern());
        compound.m_128405_("ShedTime", this.shedTime);
        compound.m_128379_("HasEgg", this.hasEgg());
        compound.m_128379_("Resting", this.isResting());
    }

    public abstract void addSpeciesSaveData(CompoundTag var1);

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setColor(compound.m_128451_("Color"));
        this.setPattern(compound.m_128451_("Pattern"));
        if (compound.m_128441_("ShedTime")) {
            this.shedTime = compound.m_128451_("ShedTime");
        }
        this.setHasEgg(compound.m_128471_("HasEgg"));
        this.setResting(compound.m_128471_("Resting"));
    }

    public void m_8127_() {
        this.setSittingOnShoulder(false);
        super.m_8127_();
    }

    public abstract Block GetEggType();

    public int getColor() {
        return (Integer)this.f_19804_.m_135370_(COLOR);
    }

    public void setColor(int colorNum) {
        this.f_19804_.m_135381_(COLOR, (Object)colorNum);
    }

    public int getPattern() {
        return (Integer)this.f_19804_.m_135370_(PATTERN);
    }

    public void setPattern(int patternNum) {
        this.f_19804_.m_135381_(PATTERN, (Object)patternNum);
    }

    public boolean isResting() {
        return (Boolean)this.f_19804_.m_135370_(RESTING);
    }

    public void setResting(boolean setRest) {
        this.f_19804_.m_135381_(RESTING, (Object)setRest);
    }

    public boolean m_5957_() {
        boolean loveSet = super.m_5957_() && !this.hasEgg();
        return loveSet;
    }

    public boolean hasEgg() {
        return (Boolean)this.f_19804_.m_135370_(HAS_EGG);
    }

    void setHasEgg(boolean pHasEgg) {
        this.f_19804_.m_135381_(HAS_EGG, (Object)pHasEgg);
    }

    public boolean isLayingEgg() {
        return (Boolean)this.f_19804_.m_135370_(LAYING_EGG);
    }

    void setLayingEgg(boolean pIsLayingEgg) {
        this.layEggCounter = pIsLayingEgg ? 1 : 0;
        this.f_19804_.m_135381_(LAYING_EGG, (Object)pIsLayingEgg);
    }

    void setSittingOnShoulder(boolean shoulder) {
        this.isSittingOnShoulder = shoulder;
        if (this.isSittingOnShoulder) {
            this.m_20124_(Pose.CROUCHING);
        } else {
            this.m_20124_(Pose.STANDING);
        }
    }

    public boolean isSittingOnShoulder() {
        return this.isSittingOnShoulder;
    }

    public void m_6083_() {
        super.m_6083_();
        Entity entity = this.m_20202_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            this.updateRiding(player);
        }
    }

    public void updateRiding(Player riding) {
        int i = riding.m_20197_().indexOf((Object)this);
        float radius = (i == 0 ? 0.0f : 0.4f) + (float)(riding.m_21255_() ? 2 : 0);
        float angle = (float)Math.PI / 180 * riding.f_20883_ + (i == 2 ? -92.5f : (i == 1 ? 92.5f : 0.0f));
        double extraX = radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * Mth.m_14089_((float)angle);
        double extraY = riding.m_6047_() ? 1.1 : 1.4;
        Vec3 vec3 = new Vec3((double)-0.2f, 0.0, 0.0).m_82524_(-riding.f_20883_ * ((float)Math.PI / 180) - 1.5707964f);
        this.m_146922_(riding.f_20885_);
        this.f_20885_ = riding.f_20885_;
        this.f_19859_ = riding.f_20885_;
        this.m_6034_(riding.m_20185_() + extraX + vec3.f_82479_, riding.m_20186_() + extraY, riding.m_20189_() + extraZ + vec3.f_82481_);
    }

    @NotNull
    public EntityDimensions m_6972_(Pose pPose) {
        if (pPose == Pose.CROUCHING) {
            return EntityDimensions.m_20395_((float)0.1f, (float)0.1f);
        }
        return this.size;
    }

    public void m_8119_() {
        if (this.m_9236_().m_5776_()) {
            if (this.isSittingOnShoulder()) {
                this.shoulderAnimationState.m_216977_(this.f_19797_);
            } else {
                this.shoulderAnimationState.m_216973_();
            }
            if (this.isResting() && !this.isSittingOnShoulder()) {
                this.hideAnimationState.m_216977_(this.f_19797_);
            } else {
                this.hideAnimationState.m_216973_();
            }
            if (this.bleleleTime <= 0) {
                this.bleleleTime = this.f_19796_.m_188503_(500) + 500;
                this.bleleleAnimationState.m_216977_(this.f_19797_);
            } else {
                --this.bleleleTime;
            }
            if (this.f_20911_) {
                this.m_5496_((SoundEvent)SoundInit.SNEK_HURT.get(), 1.0f, 1.0f);
                this.strikeAnimationState.m_216982_(this.f_19797_);
            } else {
                this.strikeAnimationState.m_216973_();
            }
            this.slitherAnimationState.m_246184_(!this.isResting() && !this.isSittingOnShoulder() && this.f_267362_.m_267780_(), this.f_19797_);
            this.idleAnimationState.m_246184_(!this.isResting() && !this.isSittingOnShoulder() && !this.strikeAnimationState.m_216984_(), this.f_19797_);
        }
        super.m_8119_();
    }

    public void tickBypass() {
        super.m_8119_();
    }

    private int getCurAdditionalSwingDur() {
        if (MobEffectUtil.m_19584_((LivingEntity)this)) {
            return 6 - (1 + MobEffectUtil.m_19586_((LivingEntity)this));
        }
        return this.m_21023_(MobEffects.f_19599_) ? 6 + (1 + this.m_21124_(MobEffects.f_19599_).m_19564_()) * 2 : 6;
    }

    public void m_6674_(InteractionHand pHand) {
        this.m_21011_(pHand, false);
    }

    public void m_21011_(InteractionHand pHand, boolean pUpdateSelf) {
        ItemStack stack = this.m_21120_(pHand);
        if (!stack.m_41619_() && stack.onEntitySwing((LivingEntity)this)) {
            return;
        }
        if (!this.f_20911_ || this.f_20913_ >= this.getCurAdditionalSwingDur() / 2 || this.f_20913_ < 0) {
            this.f_20913_ = -1;
            this.f_20911_ = true;
            this.f_20912_ = pHand;
            if (this.m_9236_() instanceof ServerLevel) {
                ClientboundAnimatePacket clientboundanimatepacket = new ClientboundAnimatePacket((Entity)this, pHand == InteractionHand.MAIN_HAND ? 0 : 3);
                ServerChunkCache serverchunkcache = ((ServerLevel)this.m_9236_()).m_7726_();
                if (pUpdateSelf) {
                    serverchunkcache.m_8394_((Entity)this, (Packet)clientboundanimatepacket);
                } else {
                    serverchunkcache.m_8445_((Entity)this, (Packet)clientboundanimatepacket);
                }
            }
        }
    }

    public abstract String getSpeciesName(int var1, int var2);

    static class SnakeBreedGoal
    extends BreedGoal {
        private final SnakeBase snake;

        public SnakeBreedGoal(SnakeBase pSnake, double pSpeedModifier) {
            super((Animal)pSnake, pSpeedModifier);
            this.snake = pSnake;
        }

        public boolean m_8036_() {
            return super.m_8036_() && !this.snake.hasEgg();
        }

        protected void m_8026_() {
            ServerPlayer serverplayer = this.f_25113_.m_27592_();
            if (serverplayer == null && this.f_25115_.m_27592_() != null) {
                serverplayer = this.f_25115_.m_27592_();
            }
            if (serverplayer != null) {
                serverplayer.m_36220_(Stats.f_12937_);
                CriteriaTriggers.f_10581_.m_147278_(serverplayer, this.f_25113_, this.f_25115_, (AgeableMob)null);
            }
            this.snake.setHasEgg(true);
            this.f_25113_.m_146762_(6000);
            this.f_25115_.m_146762_(6000);
            this.f_25113_.m_27594_();
            this.f_25115_.m_27594_();
            ((SnakeBase)this.f_25113_).partnerColor = ((SnakeBase)this.f_25115_).getColor();
            ((SnakeBase)this.f_25113_).partnerPattern = ((SnakeBase)this.f_25115_).getPattern();
            RandomSource random = this.f_25113_.m_217043_();
            if (this.f_25114_.m_46469_().m_46207_(GameRules.f_46135_)) {
                this.f_25114_.m_7967_((Entity)new ExperienceOrb(this.f_25114_, this.f_25113_.m_20185_(), this.f_25113_.m_20186_(), this.f_25113_.m_20189_(), random.m_188503_(7) + 1));
            }
        }
    }

    static class SnakeLayEggGoal
    extends MoveToBlockGoal {
        private final SnakeBase snake;

        SnakeLayEggGoal(SnakeBase pSnake, double pSpeedModifier) {
            super((PathfinderMob)pSnake, pSpeedModifier, 16);
            this.snake = pSnake;
        }

        public boolean m_8036_() {
            return this.snake.hasEgg() && super.m_8036_();
        }

        public boolean m_8045_() {
            return super.m_8045_() && this.snake.hasEgg();
        }

        public void m_8037_() {
            super.m_8037_();
            BlockPos blockpos = this.snake.m_20183_();
            if (!this.snake.m_20069_() && this.m_25625_()) {
                if (this.snake.layEggCounter < 1) {
                    this.snake.setLayingEgg(true);
                } else if (this.snake.layEggCounter > this.m_183277_(200)) {
                    Level level = this.snake.m_9236_();
                    level.m_5594_((Player)null, blockpos, (SoundEvent)SoundInit.SNEK_LAY.get(), SoundSource.BLOCKS, 0.3f, 0.9f + level.f_46441_.m_188501_() * 0.2f);
                    this.CreateEgg2(level);
                    this.snake.setHasEgg(false);
                    this.snake.setLayingEgg(false);
                }
                if (this.snake.isLayingEgg()) {
                    ++this.snake.layEggCounter;
                }
            }
        }

        public void CreateEgg2(Level level) {
            level.m_7731_(this.f_25602_.m_7494_(), (BlockState)this.snake.GetEggType().m_49966_().m_61124_((Property)SnakeEggBlock.EGGS, (Comparable)Integer.valueOf(this.snake.f_19796_.m_188503_(4) + 1)), 3);
            SnakeEggBlockEntity tile = (SnakeEggBlockEntity)level.m_7702_(this.f_25602_.m_7494_());
            CompoundTag compoundtag = tile.getPersistentData();
            if (compoundtag != null) {
                compoundtag.m_128405_("color", ((SnakeBase)this.f_25598_).getColor());
                compoundtag.m_128405_("color_p2", ((SnakeBase)this.f_25598_).partnerColor);
                compoundtag.m_128405_("pattern", ((SnakeBase)this.f_25598_).getPattern());
                compoundtag.m_128405_("pattern_p2", ((SnakeBase)this.f_25598_).partnerPattern);
                tile.setStats(((SnakeBase)this.f_25598_).getColor(), ((SnakeBase)this.f_25598_).partnerColor, ((SnakeBase)this.f_25598_).getPattern(), ((SnakeBase)this.f_25598_).partnerPattern);
            } else {
                System.out.println("Compoundtag not found");
            }
        }

        protected boolean m_6465_(LevelReader level, BlockPos pPos) {
            if (level.m_46859_(pPos.m_7494_())) {
                BlockState state = level.m_8055_(pPos);
                return state.m_204336_(BlockTags.f_144274_) || state.m_204336_(BlockTags.f_13029_);
            }
            return false;
        }
    }

    class FindRestSpotGoal
    extends MoveToBlockGoal {
        private final SnakeBase snake;
        private static final int REST_CHANCE = 10;

        public FindRestSpotGoal(SnakeBase snake, double pSpeedModifier) {
            super((PathfinderMob)snake, pSpeedModifier, 8);
            this.snake = snake;
        }

        public boolean m_8036_() {
            return !this.snake.isResting() && this.snake.m_217043_().m_188503_(10) == 1 && super.m_8036_();
        }

        public boolean m_8045_() {
            return !this.snake.isResting() && super.m_8045_();
        }

        protected boolean m_6465_(LevelReader level, BlockPos pPos) {
            Block block = level.m_8055_(pPos).m_60734_();
            if (block instanceof CaveHideBlock || block instanceof TunnelHideBlock || block instanceof MediumHideBlock) {
                return true;
            }
            if (!level.m_45527_(pPos)) {
                BlockPos abovePos = pPos.m_7494_();
                for (int i = 0; i < 5; ++i) {
                    if (level.m_8055_(abovePos).m_60734_() instanceof HeatLampBlock) {
                        return true;
                    }
                    abovePos = abovePos.m_7494_();
                }
            }
            return false;
        }

        public void m_8056_() {
            super.m_8056_();
            this.snake.setResting(false);
        }

        public void m_8041_() {
            super.m_8041_();
        }

        public void m_8037_() {
            super.m_8037_();
            if (this.m_25625_()) {
                this.snake.setResting(true);
            }
        }

        public double m_8052_() {
            return 2.0;
        }
    }

    class CurlGoal
    extends Goal {
        private static final int REST_TIME = CurlGoal.m_186073_((int)300);
        private int countdown;
        private final SnakeBase snake;

        public CurlGoal(SnakeBase snake) {
            this.snake = snake;
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return this.snake.isResting();
        }

        public boolean m_8045_() {
            return this.snake.isResting() && super.m_8045_();
        }

        public void m_8056_() {
            this.countdown = this.snake.m_217043_().m_188503_(REST_TIME) + 300;
            super.m_8056_();
        }

        public void m_8041_() {
            super.m_8041_();
            this.snake.setResting(false);
        }

        public void m_8037_() {
            super.m_8037_();
            if (this.countdown > 0) {
                --this.countdown;
            } else {
                this.snake.setResting(false);
            }
        }
    }

    class SnakeShoulderGoal
    extends Goal {
        public SnakeShoulderGoal(SnakeBase snake) {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return SnakeBase.this.isSittingOnShoulder;
        }

        public boolean m_8045_() {
            return super.m_8045_() && this.m_8036_();
        }
    }

    class SnakeWanderGoal
    extends WaterAvoidingRandomStrollGoal {
        public SnakeWanderGoal(PathfinderMob pMob, double pSpeedModifier) {
            super(pMob, pSpeedModifier);
        }

        public boolean m_8036_() {
            return !((SnakeBase)this.f_25725_).isResting() && super.m_8036_();
        }

        public boolean m_8045_() {
            return !((SnakeBase)this.f_25725_).isResting() && super.m_8045_();
        }
    }
}

