/*
 * Decompiled with CFR 0.152.
 */
package com.raspix.snekcraft.items;

import com.raspix.snekcraft.entity.generics.SnakeBase;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class SnakeBagItem
extends Item {
    public SnakeBagItem(Item.Properties properties) {
        super(properties);
    }

    public static int getSnakesInStack(ItemStack stack) {
        int snakeCount = 0;
        if (stack.m_41783_() != null) {
            for (String tagInfo : stack.m_41783_().m_128431_()) {
                if (!tagInfo.contains("Snake")) continue;
                ++snakeCount;
            }
        }
        return snakeCount;
    }

    public static Entity getEntityFromNBT(CompoundTag nbt, Level world, boolean withInfo) {
        Entity entity = ((EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(SnakeBagItem.getEntityID(nbt)))).m_20615_(world);
        if (withInfo) {
            entity.m_20258_(nbt);
        }
        return entity;
    }

    public static String getEntityID(CompoundTag nbt) {
        return nbt.m_128461_("id");
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        Level world = context.m_43725_();
        if (player == null || world.f_46443_) {
            return InteractionResult.FAIL;
        }
        ItemStack stack = context.m_43722_();
        if (SnakeBagItem.getSnakesInStack(stack) < 1) {
            return InteractionResult.FAIL;
        }
        int snakeCount = 0;
        if (stack.m_41783_() != null) {
            for (String tagInfo : stack.m_41783_().m_128431_()) {
                if (!tagInfo.contains("Snake")) continue;
                ++snakeCount;
                CompoundTag snakeTag = stack.m_41783_().m_128469_(tagInfo);
                SnakeBase snake = null;
                try {
                    snake = (SnakeBase)SnakeBagItem.getEntityFromNBT(snakeTag, world, true);
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
                if (snake == null) continue;
                BlockPos blockPos = context.m_8083_();
                snake.m_19890_((double)blockPos.m_123341_() + 0.5, blockPos.m_123342_() + 1, (double)blockPos.m_123343_() + 0.5, 0.0f, 0.0f);
                world.m_7967_((Entity)snake);
            }
        }
        if (snakeCount > 0) {
            stack.m_41751_(new CompoundTag());
            if (player != null && player.f_20912_ != null) {
                player.m_6674_(player.f_20912_);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
        int snakeNum = SnakeBagItem.getSnakesInStack(pStack);
        if (snakeNum > 0) {
            for (String tagInfo : pStack.m_41783_().m_128431_()) {
                if (!tagInfo.contains("Snake")) continue;
                CompoundTag snakeTag = pStack.m_41783_().m_128469_(tagInfo);
                SnakeBase snake = null;
                try {
                    snake = (SnakeBase)SnakeBagItem.getEntityFromNBT(snakeTag, pLevel, true);
                    String snakeType = snake.getSpeciesName(snakeTag.m_128451_("Color"), snakeTag.m_128451_("Pattern"));
                    pTooltipComponents.add((Component)Component.m_237110_((String)"tooltip.snekcraft.snake_bag.tooltip.snake_type", (Object[])new Object[]{snakeType}).m_130940_(ChatFormatting.GRAY));
                }
                catch (ClassCastException classCastException) {}
            }
        }
    }
}

