/*
 * Decompiled with CFR 0.152.
 */
package com.raspix.snekcraft.packets;

import com.raspix.snekcraft.blocks.entity.SnakeEggBlockEntity;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class ServerboundEggUpdate {
    private final BlockPos pos;
    private final int color;
    private final int color_p2;
    private final int pattern;
    private final int pattern_p2;

    public ServerboundEggUpdate(BlockPos pos, int color, int color_p2, int pattern, int pattern_p2) {
        this.pos = pos;
        this.color = color;
        this.color_p2 = color_p2;
        this.pattern = pattern;
        this.pattern_p2 = pattern_p2;
    }

    public static ServerboundEggUpdate decode(FriendlyByteBuf buf) {
        return new ServerboundEggUpdate(buf.m_130135_(), buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt());
    }

    public static void encode(ServerboundEggUpdate packet, FriendlyByteBuf buf) {
        buf.m_130064_(packet.pos);
        buf.writeInt(packet.color);
        buf.writeInt(packet.color_p2);
        buf.writeInt(packet.pattern);
        buf.writeInt(packet.pattern_p2);
    }

    public static class Handler {
        public static void handle(ServerboundEggUpdate packet, Supplier<NetworkEvent.Context> context) {
            context.get().enqueueWork(() -> {
                ServerPlayer player = ((NetworkEvent.Context)context.get()).getSender();
                if (player != null) {
                    SnakeEggBlockEntity egg = (SnakeEggBlockEntity)player.m_9236_().m_7702_(packet.pos);
                    egg.setStats(packet.color, packet.color_p2, packet.pattern, packet.pattern_p2);
                }
            });
            context.get().setPacketHandled(true);
        }
    }
}

