/*
 * Decompiled with CFR 0.152.
 */
package uk.regressia.vppf;

import com.mojang.logging.LogUtils;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import org.slf4j.Logger;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class RegisterDarkMode {
    private static final Logger LOGGER = LogUtils.getLogger();

    @SubscribeEvent
    public static void onSetup(FMLCommonSetupEvent event) {
        Path resourcePacksDir = Paths.get("resourcepacks", new String[0]);
        Path targetPack = resourcePacksDir.resolve("pulpe_faction_darkmode.zip");
        if (!Files.exists(targetPack, new LinkOption[0])) {
            try (InputStream is = RegisterDarkMode.class.getResourceAsStream("/pulpe_faction_darkmode.zip");){
                if (is != null) {
                    Files.createDirectories(resourcePacksDir, new FileAttribute[0]);
                    Files.copy(is, targetPack, new CopyOption[0]);
                    LOGGER.info("Copying Pulpe Faction Dark Mode resource pack...");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                LOGGER.error("Copying Pulpe Faction Dark Mode resource pack...", (Throwable)e);
            }
        }
    }
}

