/*
 * Decompiled with CFR 0.152.
 */
package uk.regressia.vppf.init;

import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.crafting.RecipeMap;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLConstructModEvent;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.RecipesReceivedEvent;
import net.neoforged.neoforge.event.OnDatapackSyncEvent;
import net.neoforged.neoforge.registries.DeferredRegister;
import uk.regressia.vppf.recipe.PulperRecipe;

@EventBusSubscriber(modid="vppf", bus=EventBusSubscriber.Bus.MOD)
public class VppfModRecipeTypes {
    public static final DeferredRegister<RecipeType<?>> RECIPE_TYPES = DeferredRegister.create((Registry)BuiltInRegistries.RECIPE_TYPE, (String)"vppf");
    public static final DeferredRegister<RecipeSerializer<?>> SERIALIZERS = DeferredRegister.create((Registry)BuiltInRegistries.RECIPE_SERIALIZER, (String)"vppf");
    public static RecipeMap recipeMap = null;

    @SubscribeEvent
    public static void register(FMLConstructModEvent event) {
        IEventBus bus = ((ModContainer)ModList.get().getModContainerById("vppf").get()).getEventBus();
        event.enqueueWork(() -> {
            RECIPE_TYPES.register(bus);
            SERIALIZERS.register(bus);
            RECIPE_TYPES.register("pulper", () -> PulperRecipe.Type.INSTANCE);
            SERIALIZERS.register("pulper", () -> PulperRecipe.Serializer.INSTANCE);
        });
    }

    @EventBusSubscriber
    private static class RecipeSync {
        private RecipeSync() {
        }

        @SubscribeEvent
        public static void sync(OnDatapackSyncEvent event) {
            event.sendRecipes(new RecipeType[]{PulperRecipe.Type.INSTANCE});
        }

        @OnlyIn(value=Dist.CLIENT)
        @SubscribeEvent
        public static void receive(RecipesReceivedEvent event) {
            recipeMap = event.getRecipeMap();
        }

        @OnlyIn(value=Dist.CLIENT)
        @SubscribeEvent
        public static void clear(ClientPlayerNetworkEvent.LoggingOut event) {
            recipeMap = null;
        }
    }
}

