/*
 * Decompiled with CFR 0.152.
 */
package uk.regressia.vppf.recipe;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;

public class RecipeUtils {
    private RecipeUtils() {
        throw new AssertionError((Object)"Recipe Utils should NEVER be initialized");
    }

    public static List<ItemStack> getItemStacks(Object in) {
        ArrayList<ItemStack> stacks;
        block5: {
            Optional opt;
            block7: {
                block6: {
                    block4: {
                        stacks = new ArrayList<ItemStack>();
                        if (!(in instanceof SizedIngredient)) break block4;
                        SizedIngredient sized = (SizedIngredient)in;
                        for (int i = 0; i < sized.ingredient().getValues().size(); ++i) {
                            stacks.add(new ItemStack(sized.ingredient().getValues().get(i), sized.count()));
                        }
                        break block5;
                    }
                    if (!(in instanceof Ingredient)) break block6;
                    Ingredient ingre = (Ingredient)in;
                    for (int i = 0; i < ingre.getValues().size(); ++i) {
                        stacks.add(new ItemStack(ingre.getValues().get(i)));
                    }
                    break block5;
                }
                if (!(in instanceof Optional) || !(opt = (Optional)in).isPresent()) break block5;
                Object t = opt.get();
                if (!(t instanceof SizedIngredient)) break block7;
                SizedIngredient sizedO = (SizedIngredient)t;
                for (int i = 0; i < sizedO.ingredient().getValues().size(); ++i) {
                    stacks.add(new ItemStack(sizedO.ingredient().getValues().get(i), sizedO.count()));
                }
                break block5;
            }
            Object i = opt.get();
            if (!(i instanceof Ingredient)) break block5;
            Ingredient ingreO = (Ingredient)i;
            for (int i2 = 0; i2 < ingreO.getValues().size(); ++i2) {
                stacks.add(new ItemStack(ingreO.getValues().get(i2)));
            }
        }
        return stacks;
    }

    public static List<FluidStack> getFluidStacks(Object in) {
        ArrayList<FluidStack> stacks;
        block3: {
            Object t;
            Optional opt;
            block2: {
                stacks = new ArrayList<FluidStack>();
                if (!(in instanceof SizedFluidIngredient)) break block2;
                SizedFluidIngredient sized = (SizedFluidIngredient)in;
                for (int i = 0; i < sized.ingredient().fluids().size(); ++i) {
                    stacks.add(new FluidStack((Fluid)((Holder)sized.ingredient().fluids().get(i)).value(), sized.amount()));
                }
                break block3;
            }
            if (!(in instanceof Optional) || !(opt = (Optional)in).isPresent() || !((t = opt.get()) instanceof SizedFluidIngredient)) break block3;
            SizedFluidIngredient sizedO = (SizedFluidIngredient)t;
            for (int i = 0; i < sizedO.ingredient().fluids().size(); ++i) {
                stacks.add(new FluidStack((Fluid)((Holder)sizedO.ingredient().fluids().get(i)).value(), sizedO.amount()));
            }
        }
        return stacks;
    }

    public static boolean validate(Object given, Object recipe) {
        if (given instanceof ItemStack) {
            ItemStack item = (ItemStack)given;
            if (recipe instanceof SizedIngredient) {
                SizedIngredient sIngre = (SizedIngredient)recipe;
                return sIngre.test(item);
            }
            if (recipe instanceof Ingredient) {
                Ingredient ingre = (Ingredient)recipe;
                return ingre.test(item);
            }
            if (recipe instanceof Optional) {
                Optional opt = (Optional)recipe;
                if (item.isEmpty()) {
                    return opt.isEmpty();
                }
                if (opt.isPresent()) {
                    Object t = opt.get();
                    if (t instanceof SizedIngredient) {
                        SizedIngredient sIngred = (SizedIngredient)t;
                        return sIngred.test(item);
                    }
                    t = opt.get();
                    if (t instanceof Ingredient) {
                        Ingredient ingred = (Ingredient)t;
                        return ingred.test(item);
                    }
                }
                return false;
            }
        }
        if (given instanceof FluidStack) {
            FluidStack fluid = (FluidStack)given;
            if (recipe instanceof SizedFluidIngredient) {
                SizedFluidIngredient ingre = (SizedFluidIngredient)recipe;
                return ingre.test(fluid);
            }
            if (recipe instanceof Optional) {
                Object t;
                Optional opt = (Optional)recipe;
                if (fluid.isEmpty()) {
                    return opt.isEmpty();
                }
                if (opt.isPresent() && (t = opt.get()) instanceof SizedFluidIngredient) {
                    SizedFluidIngredient ingred = (SizedFluidIngredient)t;
                    return ingred.test(fluid);
                }
                return false;
            }
        }
        if (given instanceof Boolean) {
            Boolean bool = (Boolean)given;
            if (recipe instanceof Boolean) {
                Boolean rec = (Boolean)recipe;
                return bool.equals(rec);
            }
        }
        if (given instanceof double[]) {
            double[] doub = (double[])given;
            if (recipe instanceof Double) {
                Double rec = (Double)recipe;
                return doub[0] >= rec;
            }
        }
        if (given instanceof String) {
            String str = (String)given;
            if (recipe instanceof String) {
                String rec = (String)recipe;
                return str.equals(rec);
            }
        }
        return false;
    }

    public static int amount(Object recipe) {
        Object t;
        Optional opt;
        if (recipe instanceof SizedIngredient) {
            SizedIngredient sized = (SizedIngredient)recipe;
            return sized.count();
        }
        if (recipe instanceof Ingredient) {
            return 1;
        }
        if (recipe instanceof Optional && (opt = (Optional)recipe).isPresent()) {
            t = opt.get();
            if (t instanceof SizedIngredient) {
                SizedIngredient sizedO = (SizedIngredient)t;
                return sizedO.count();
            }
            if (opt.get() instanceof Ingredient) {
                return 1;
            }
        }
        if (recipe instanceof SizedFluidIngredient) {
            SizedFluidIngredient sizedF = (SizedFluidIngredient)recipe;
            return sizedF.amount();
        }
        if (recipe instanceof Optional && (opt = (Optional)recipe).isPresent() && (t = opt.get()) instanceof SizedFluidIngredient) {
            SizedFluidIngredient sizedFO = (SizedFluidIngredient)t;
            return sizedFO.amount();
        }
        if (recipe instanceof Double) {
            Double doub = (Double)recipe;
            return doub.intValue();
        }
        return 0;
    }
}

