/*
 * Decompiled with CFR 0.152.
 */
package uk.regressia.vppf.client.gui;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import uk.regressia.vppf.init.VppfModScreens;
import uk.regressia.vppf.procedures.ImageOffProcedure;
import uk.regressia.vppf.procedures.ImageOnProcedure;
import uk.regressia.vppf.world.inventory.AutoPulperGUIMenu;

public class AutoPulperGUIScreen
extends AbstractContainerScreen<AutoPulperGUIMenu>
implements VppfModScreens.ScreenAccessor {
    private final Level world;
    private final int x;
    private final int y;
    private final int z;
    private final Player entity;
    private boolean menuStateUpdateActive = false;
    private static final ResourceLocation texture = ResourceLocation.parse((String)"vppf:textures/screens/auto_pulper_gui.png");

    public AutoPulperGUIScreen(AutoPulperGUIMenu container, Inventory inventory, Component text) {
        super((AbstractContainerMenu)container, inventory, text);
        this.world = container.world;
        this.x = container.x;
        this.y = container.y;
        this.z = container.z;
        this.entity = container.entity;
        this.imageWidth = 176;
        this.imageHeight = 166;
    }

    @Override
    public void updateMenuState(int elementType, String name, Object elementState) {
        this.menuStateUpdateActive = true;
        this.menuStateUpdateActive = false;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        boolean customTooltipShown = false;
        if (ImageOnProcedure.execute((LevelAccessor)this.world, this.x, this.y, this.z) && mouseX > this.leftPos + 82 && mouseX < this.leftPos + 93 && mouseY > this.topPos + 35 && mouseY < this.topPos + 45) {
            guiGraphics.setTooltipForNextFrame(this.font, (Component)Component.translatable((String)"gui.vppf.auto_pulper_gui.tooltip_redstone_powered"), mouseX, mouseY);
            customTooltipShown = true;
        }
        if (ImageOffProcedure.execute((LevelAccessor)this.world, this.x, this.y, this.z) && mouseX > this.leftPos + 82 && mouseX < this.leftPos + 93 && mouseY > this.topPos + 35 && mouseY < this.topPos + 45) {
            guiGraphics.setTooltipForNextFrame(this.font, (Component)Component.translatable((String)"gui.vppf.auto_pulper_gui.tooltip_redstone_off"), mouseX, mouseY);
            customTooltipShown = true;
        }
        if (!customTooltipShown) {
            this.renderTooltip(guiGraphics, mouseX, mouseY);
        }
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, texture, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, this.imageWidth, this.imageHeight);
        if (ImageOffProcedure.execute((LevelAccessor)this.world, this.x, this.y, this.z)) {
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, ResourceLocation.parse((String)"vppf:textures/screens/gui_power_off.png"), this.leftPos + 83, this.topPos + 36, 0.0f, 0.0f, 8, 8, 8, 8);
        }
        if (ImageOnProcedure.execute((LevelAccessor)this.world, this.x, this.y, this.z)) {
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, ResourceLocation.parse((String)"vppf:textures/screens/gui_power_on.png"), this.leftPos + 83, this.topPos + 36, 0.0f, 0.0f, 8, 8, 8, 8);
        }
    }

    public boolean keyPressed(int key, int b, int c) {
        if (key == 256) {
            this.minecraft.player.closeContainer();
            return true;
        }
        return super.keyPressed(key, b, c);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.vppf.auto_pulper_gui.label_inventory"), 6, 70, -10592674, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.vppf.auto_pulper_gui.label_pulper"), 6, 7, -10066330, false);
    }

    public void init() {
        super.init();
    }
}

