/*
 * Decompiled with CFR 0.152.
 */
package uk.regressia.vppf.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeBookCategories;
import net.minecraft.world.item.crafting.RecipeBookCategory;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public record PulperRecipe(SizedIngredient inputItemInput, ItemStack outputItemOutput) implements Recipe<RecipeInput>
{
    @NotNull
    public ItemStack getItemStackResult(String output) {
        if (output.equals("output")) {
            return this.outputItemOutput;
        }
        return ItemStack.EMPTY;
    }

    @NotNull
    public FluidStack getFluidStackResult(String output) {
        return FluidStack.EMPTY;
    }

    @NotNull
    public boolean getBooleanResult(String output) {
        return false;
    }

    @NotNull
    public double getDoubleResult(String output) {
        return 0.0;
    }

    @NotNull
    public String getStringResult(String output) {
        return "";
    }

    @NotNull
    public RecipeSerializer<? extends Recipe<RecipeInput>> getSerializer() {
        return Serializer.INSTANCE;
    }

    @NotNull
    public RecipeType<? extends Recipe<RecipeInput>> getType() {
        return Type.INSTANCE;
    }

    public boolean matches(@NotNull RecipeInput pContainer, @NotNull Level Level2) {
        return false;
    }

    public ItemStack assemble(@NotNull RecipeInput input, @NotNull HolderLookup.Provider holder) {
        return ItemStack.EMPTY;
    }

    public PlacementInfo placementInfo() {
        ArrayList<Optional<SizedIngredient>> sized = new ArrayList<Optional<SizedIngredient>>();
        sized.add(Optional.of(this.inputItemInput()));
        if (!sized.isEmpty()) {
            List<Optional> ingre = sized.stream().map(opt -> opt.map(SizedIngredient::ingredient)).toList();
            return PlacementInfo.createFromOptionals(ingre);
        }
        return PlacementInfo.NOT_PLACEABLE;
    }

    public RecipeBookCategory recipeBookCategory() {
        return RecipeBookCategories.CRAFTING_MISC;
    }

    public static class Serializer
    implements RecipeSerializer<PulperRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public final MapCodec<PulperRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)SizedIngredient.NESTED_CODEC.fieldOf("input").forGetter(PulperRecipe::inputItemInput), (App)ItemStack.CODEC.fieldOf("output").forGetter(PulperRecipe::outputItemOutput)).apply((Applicative)instance, Serializer::createPulperRecipe));
        private static final StreamCodec<RegistryFriendlyByteBuf, PulperRecipe> STREAM_CODEC = StreamCodec.of(Serializer::write, Serializer::read);

        @NotNull
        public MapCodec<PulperRecipe> codec() {
            return this.CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, PulperRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static PulperRecipe read(RegistryFriendlyByteBuf buffer) {
            SizedIngredient inputItemInput = (SizedIngredient)SizedIngredient.STREAM_CODEC.decode((Object)buffer);
            ItemStack outputItemOutput = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            return new PulperRecipe(inputItemInput, outputItemOutput);
        }

        private static void write(RegistryFriendlyByteBuf buffer, PulperRecipe recipe) {
            SizedIngredient.STREAM_CODEC.encode((Object)buffer, (Object)recipe.inputItemInput());
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.outputItemOutput());
        }

        static PulperRecipe createPulperRecipe(SizedIngredient inputItemInput, ItemStack outputItemOutput) {
            return new PulperRecipe(inputItemInput, outputItemOutput);
        }
    }

    public static class Type
    implements RecipeType<PulperRecipe> {
        public static final RecipeType<PulperRecipe> INSTANCE = new Type();

        private Type() {
        }
    }
}

