/*
 * Decompiled with CFR 0.152.
 */
package uk.regressia.vppf.integration.jei;

import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import uk.regressia.vppf.init.VppfModBlocks;
import uk.regressia.vppf.init.VppfModJeiPlugin;
import uk.regressia.vppf.recipe.PulperRecipe;
import uk.regressia.vppf.recipe.RecipeUtils;

public class PulperJeiCategory
implements IRecipeCategory<RecipeHolder<PulperRecipe>> {
    public static final ResourceLocation UID = ResourceLocation.parse((String)"vppf:pulper");
    public static final ResourceLocation TEXTURE = ResourceLocation.parse((String)"vppf:textures/screens/pulper_jei.png");
    private final IDrawable background;
    private final IDrawable icon;

    public PulperJeiCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 0, 0, 175, 80);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)VppfModBlocks.PULPER_BLOCK.get()));
    }

    public RecipeType<RecipeHolder<PulperRecipe>> getRecipeType() {
        return VppfModJeiPlugin.PulperCategoryType;
    }

    public Component getTitle() {
        return Component.translatable((String)"jei.vppf.pulper");
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public int getWidth() {
        return this.background.getWidth();
    }

    public int getHeight() {
        return this.background.getHeight();
    }

    public void draw(RecipeHolder<PulperRecipe> recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.background.draw(guiGraphics);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RecipeHolder<PulperRecipe> recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 80, 16).addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, RecipeUtils.getItemStacks(((PulperRecipe)recipe.value()).inputItemInput()));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 80, 49).addItemStack(((PulperRecipe)recipe.value()).getItemStackResult("output"));
    }
}

