/*
 * Decompiled with CFR 0.152.
 */
package uk.regressia.vppf.recipe;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;

public class RecipeUtils {
    private RecipeUtils() {
        throw new AssertionError((Object)"Recipe Utils should NEVER be initialized");
    }

    public static List<ItemStack> getItemStacks(Object in) {
        Optional opt;
        if (in instanceof SizedIngredient) {
            SizedIngredient sized = (SizedIngredient)in;
            return Arrays.asList(sized.getItems());
        }
        if (in instanceof Ingredient) {
            Ingredient ingre = (Ingredient)in;
            return Arrays.asList(ingre.getItems());
        }
        if (in instanceof Optional && (opt = (Optional)in).isPresent()) {
            Object t = opt.get();
            if (t instanceof SizedIngredient) {
                SizedIngredient sizedO = (SizedIngredient)t;
                return Arrays.asList(sizedO.getItems());
            }
            t = opt.get();
            if (t instanceof Ingredient) {
                Ingredient ingreO = (Ingredient)t;
                return Arrays.asList(ingreO.getItems());
            }
        }
        return new ArrayList<ItemStack>();
    }

    public static List<FluidStack> getFluidStacks(Object in) {
        Object t;
        Optional opt;
        if (in instanceof SizedFluidIngredient) {
            SizedFluidIngredient sized = (SizedFluidIngredient)in;
            return Arrays.asList(sized.getFluids());
        }
        if (in instanceof Optional && (opt = (Optional)in).isPresent() && (t = opt.get()) instanceof SizedFluidIngredient) {
            SizedFluidIngredient sizedO = (SizedFluidIngredient)t;
            return Arrays.asList(sizedO.getFluids());
        }
        return new ArrayList<FluidStack>();
    }

    public static boolean validate(Object given, Object recipe) {
        if (given instanceof ItemStack) {
            ItemStack item = (ItemStack)given;
            if (recipe instanceof SizedIngredient) {
                SizedIngredient sIngre = (SizedIngredient)recipe;
                return sIngre.test(item);
            }
            if (recipe instanceof Ingredient) {
                Ingredient ingre = (Ingredient)recipe;
                return ingre.test(item);
            }
            if (recipe instanceof Optional) {
                Optional opt = (Optional)recipe;
                if (item.isEmpty()) {
                    return opt.isEmpty();
                }
                if (opt.isPresent()) {
                    Object t = opt.get();
                    if (t instanceof SizedIngredient) {
                        SizedIngredient sIngred = (SizedIngredient)t;
                        return sIngred.test(item);
                    }
                    t = opt.get();
                    if (t instanceof Ingredient) {
                        Ingredient ingred = (Ingredient)t;
                        return ingred.test(item);
                    }
                }
                return false;
            }
        }
        if (given instanceof FluidStack) {
            FluidStack fluid = (FluidStack)given;
            if (recipe instanceof SizedFluidIngredient) {
                SizedFluidIngredient ingre = (SizedFluidIngredient)recipe;
                return ingre.test(fluid);
            }
            if (recipe instanceof Optional) {
                Object t;
                Optional opt = (Optional)recipe;
                if (fluid.isEmpty()) {
                    return opt.isEmpty();
                }
                if (opt.isPresent() && (t = opt.get()) instanceof SizedFluidIngredient) {
                    SizedFluidIngredient ingred = (SizedFluidIngredient)t;
                    return ingred.test(fluid);
                }
                return false;
            }
        }
        if (given instanceof Boolean) {
            Boolean bool = (Boolean)given;
            if (recipe instanceof Boolean) {
                Boolean rec = (Boolean)recipe;
                return bool.equals(rec);
            }
        }
        if (given instanceof double[]) {
            double[] doub = (double[])given;
            if (recipe instanceof Double) {
                Double rec = (Double)recipe;
                return doub[0] >= rec;
            }
        }
        if (given instanceof String) {
            String str = (String)given;
            if (recipe instanceof String) {
                String rec = (String)recipe;
                return str.equals(rec);
            }
        }
        return false;
    }

    public static int amount(Object recipe) {
        Object t;
        Optional opt;
        if (recipe instanceof SizedIngredient) {
            SizedIngredient sized = (SizedIngredient)recipe;
            return sized.count();
        }
        if (recipe instanceof Ingredient) {
            return 1;
        }
        if (recipe instanceof Optional && (opt = (Optional)recipe).isPresent()) {
            t = opt.get();
            if (t instanceof SizedIngredient) {
                SizedIngredient sizedO = (SizedIngredient)t;
                return sizedO.count();
            }
            if (opt.get() instanceof Ingredient) {
                return 1;
            }
        }
        if (recipe instanceof SizedFluidIngredient) {
            SizedFluidIngredient sizedF = (SizedFluidIngredient)recipe;
            return sizedF.amount();
        }
        if (recipe instanceof Optional && (opt = (Optional)recipe).isPresent() && (t = opt.get()) instanceof SizedFluidIngredient) {
            SizedFluidIngredient sizedFO = (SizedFluidIngredient)t;
            return sizedFO.amount();
        }
        if (recipe instanceof Double) {
            Double doub = (Double)recipe;
            return doub.intValue();
        }
        return 0;
    }
}

