/*
 * Decompiled with CFR 0.152.
 */
package com.parad.alienfirstperson;

import com.parad.alienfirstperson.AlienFirstPersonMod;
import com.parad.alienfirstperson.AlienOffsetManager;
import com.parad.alienfirstperson.AlienStateHandler;
import com.parad.alienfirstperson.config.AlienFirstPersonConfig;
import com.parad.alienfirstperson.config.ConfigChangeManager;
import dev.tr7zw.firstperson.FirstPersonModelCore;
import dev.tr7zw.firstperson.api.ActivationHandler;
import dev.tr7zw.firstperson.versionless.config.VanillaHands;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.Scoreboard;
import net.threetag.palladium.entity.FlightHandler;
import net.threetag.palladium.entity.PalladiumPlayerExtension;
import net.threetag.palladium.power.ability.AbilityInstance;
import net.threetag.palladium.power.ability.AbilityUtil;
import net.threetag.palladium.power.ability.AnimationTimerAbility;

public class AlienActivationHandler
implements ActivationHandler {
    private static boolean isPyroniteFlying = false;
    private static boolean isLepidopterranFlying = false;
    private static boolean isEctonuriteFlying = false;
    private static boolean isGalvanFlying = false;
    private static boolean isPisccissVolannBiting = false;
    private static int biteAnimationBuffer = 0;
    private static boolean isBothHandsActive = false;
    private static boolean isGalvanicMechamorphGliding = false;
    private static boolean isKineceleranSkating = false;
    private static boolean vanillaHandsDisabledForPyronite = false;
    private static VanillaHands originalVanillaHandsMode = null;
    private static String lastPetrosapienState = null;
    private static String lastKineceleranState = null;
    private static String lastGalvanState = null;
    private static String lastGalvanicMechamorphState = null;
    private static int kineceleranTransitionBuffer = 0;
    private static int flightTransitionBuffer = 0;
    private static int glideTransitionBuffer = 0;
    private static final float EXTREME_SWIM_ANGLE_THRESHOLD = 58.0f;
    private static boolean isKineceleranSpeedActive = false;

    public static boolean isPisccissVolannCurrentlyBiting() {
        return isPisccissVolannBiting || biteAnimationBuffer > 0;
    }

    public static boolean isPyroniteCurrentlyFlying() {
        return isPyroniteFlying;
    }

    public static boolean isKineceleranCurrentlySkating() {
        return isKineceleranSkating;
    }

    public static boolean isKineceleranCurrentlySpeedBoosted() {
        return isKineceleranSpeedActive;
    }

    public static boolean isKineceleranInTransition() {
        return kineceleranTransitionBuffer > 0;
    }

    public static boolean isFlightInTransition() {
        return flightTransitionBuffer > 0;
    }

    public static boolean isGlideInTransition() {
        return glideTransitionBuffer > 0;
    }

    public boolean preventFirstperson() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            float pitch;
            if (player.m_6067_() && !player.m_6069_() && !player.m_20069_() && !player.m_5842_()) {
                return true;
            }
            if ((player.m_6069_() || player.m_6067_()) && player.m_20069_() && Math.abs(pitch = player.m_146909_()) > 58.0f) {
                AlienFirstPersonMod.LOGGER.debug("Preventing first person due to extreme swim angle: {}", (Object)Float.valueOf(pitch));
                return true;
            }
        }
        return false;
    }

    public static boolean shouldDisableForAlienConfig(String alienForm) {
        if (alienForm == null) {
            return false;
        }
        ConfigChangeManager manager = ConfigChangeManager.getInstance();
        switch (alienForm) {
            case "pyronite": {
                return (Boolean)manager.getPendingOrCurrentValue("pyronite.firstPersonEnabled", AlienFirstPersonConfig.PYRONITE_FIRST_PERSON_ENABLED) == false;
            }
            case "vulpimancer": {
                return (Boolean)manager.getPendingOrCurrentValue("vulpimancer.firstPersonEnabled", AlienFirstPersonConfig.VULPIMANCER_FIRST_PERSON_ENABLED) == false;
            }
            case "petrosapien": {
                if (Minecraft.m_91087_().f_91074_ != null) {
                    try {
                        boolean hasBattle = false;
                        boolean hasShield = false;
                        Collection allAbilities = AbilityUtil.getInstances((LivingEntity)Minecraft.m_91087_().f_91074_);
                        if (allAbilities != null) {
                            for (AbilityInstance ability : allAbilities) {
                                if (ability == null || !ability.isEnabled()) continue;
                                String abilityId = ability.getConfiguration().getId();
                                if ("battle_mode".equals(abilityId)) {
                                    hasBattle = true;
                                }
                                if (!"shield_activate".equals(abilityId)) continue;
                                hasShield = true;
                            }
                        }
                        if (hasShield) {
                            return (Boolean)manager.getPendingOrCurrentValue("petrosapien.shield.firstPersonEnabled", AlienFirstPersonConfig.PETROSAPIEN_SHIELD_FIRST_PERSON_ENABLED) == false;
                        }
                        if (hasBattle) {
                            return (Boolean)manager.getPendingOrCurrentValue("petrosapien.battleMode.firstPersonEnabled", AlienFirstPersonConfig.PETROSAPIEN_BATTLE_MODE_FIRST_PERSON_ENABLED) == false;
                        }
                    }
                    catch (Exception e) {
                        AlienFirstPersonMod.LOGGER.debug("Error checking Petrosapien state in shouldDisableForAlienConfig: {}", (Object)e.getMessage());
                    }
                }
                return (Boolean)manager.getPendingOrCurrentValue("petrosapien.firstPersonEnabled", AlienFirstPersonConfig.PETROSAPIEN_FIRST_PERSON_ENABLED) == false;
            }
            case "kineceleran": {
                if (Minecraft.m_91087_().f_91074_ != null) {
                    try {
                        boolean hasSpeed = false;
                        boolean hasSkate = false;
                        Collection allAbilities = AbilityUtil.getInstances((LivingEntity)Minecraft.m_91087_().f_91074_);
                        if (allAbilities != null) {
                            for (AbilityInstance ability : allAbilities) {
                                if (ability == null || !ability.isEnabled()) continue;
                                String abilityId = ability.getConfiguration().getId();
                                if ("speed_1".equals(abilityId) || "speed_2".equals(abilityId) || "speed_3".equals(abilityId) || "speed_4".equals(abilityId) || "speed_5".equals(abilityId)) {
                                    hasSpeed = true;
                                }
                                if (!"skate".equals(abilityId)) continue;
                                hasSkate = true;
                            }
                        }
                        if (hasSkate) {
                            return (Boolean)manager.getPendingOrCurrentValue("kineceleran.skate.firstPersonEnabled", AlienFirstPersonConfig.KINECELERAN_SKATE_FIRST_PERSON_ENABLED) == false;
                        }
                        if (hasSpeed) {
                            return (Boolean)manager.getPendingOrCurrentValue("kineceleran.speed.firstPersonEnabled", AlienFirstPersonConfig.KINECELERAN_SPEED_FIRST_PERSON_ENABLED) == false;
                        }
                        return (Boolean)manager.getPendingOrCurrentValue("kineceleran.firstPersonEnabled", AlienFirstPersonConfig.KINECELERAN_FIRST_PERSON_ENABLED) == false;
                    }
                    catch (Exception e) {
                        AlienFirstPersonMod.LOGGER.debug("Error checking Kineceleran state in shouldDisableForAlienConfig: {}", (Object)e.getMessage());
                    }
                }
                return (Boolean)manager.getPendingOrCurrentValue("kineceleran.firstPersonEnabled", AlienFirstPersonConfig.KINECELERAN_FIRST_PERSON_ENABLED) == false;
            }
            case "galvan": {
                if (Minecraft.m_91087_().f_91074_ != null) {
                    try {
                        boolean hasGalvanSuit = false;
                        boolean hasGalvanLimbs = false;
                        Collection allAbilities = AbilityUtil.getInstances((LivingEntity)Minecraft.m_91087_().f_91074_);
                        if (allAbilities != null) {
                            for (AbilityInstance ability : allAbilities) {
                                if (ability == null || !ability.isEnabled()) continue;
                                String abilityId = ability.getConfiguration().getId();
                                if ("galvan_suit".equals(abilityId)) {
                                    hasGalvanSuit = true;
                                }
                                if (!"galvan_limbs".equals(abilityId)) continue;
                                hasGalvanLimbs = true;
                            }
                        }
                        if (hasGalvanSuit) {
                            return (Boolean)manager.getPendingOrCurrentValue("galvan.suit.firstPersonEnabled", AlienFirstPersonConfig.GALVAN_SUIT_FIRST_PERSON_ENABLED) == false;
                        }
                        if (hasGalvanLimbs) {
                            return (Boolean)manager.getPendingOrCurrentValue("galvan.limbs.firstPersonEnabled", AlienFirstPersonConfig.GALVAN_LIMBS_FIRST_PERSON_ENABLED) == false;
                        }
                    }
                    catch (Exception e) {
                        AlienFirstPersonMod.LOGGER.debug("Error checking Galvan state in shouldDisableForAlienConfig: {}", (Object)e.getMessage());
                    }
                }
                return (Boolean)manager.getPendingOrCurrentValue("galvan.firstPersonEnabled", AlienFirstPersonConfig.GALVAN_FIRST_PERSON_ENABLED) == false;
            }
            case "tetramand": {
                return (Boolean)manager.getPendingOrCurrentValue("tetramand.firstPersonEnabled", AlienFirstPersonConfig.TETRAMAND_FIRST_PERSON_ENABLED) == false;
            }
            case "lepidopterran": {
                return (Boolean)manager.getPendingOrCurrentValue("lepidopterran.firstPersonEnabled", AlienFirstPersonConfig.LEPIDOPTERRAN_FIRST_PERSON_ENABLED) == false;
            }
            case "piscciss_volann": {
                return (Boolean)manager.getPendingOrCurrentValue("piscciss_volann.firstPersonEnabled", AlienFirstPersonConfig.PISCCISS_VOLANN_FIRST_PERSON_ENABLED) == false;
            }
            case "galvanic_mechamorph": {
                if (Minecraft.m_91087_().f_91074_ != null) {
                    try {
                        boolean hasLightningPro = false;
                        Collection allAbilities = AbilityUtil.getInstances((LivingEntity)Minecraft.m_91087_().f_91074_);
                        if (allAbilities != null) {
                            for (AbilityInstance ability : allAbilities) {
                                String abilityId;
                                if (ability == null || !ability.isEnabled() || !"lightningpro".equals(abilityId = ability.getConfiguration().getId())) continue;
                                hasLightningPro = true;
                            }
                        }
                        if (hasLightningPro) {
                            return (Boolean)manager.getPendingOrCurrentValue("galvanic_mechamorph.rod.firstPersonEnabled", AlienFirstPersonConfig.GALVANIC_MECHAMORPH_ROD_FIRST_PERSON_ENABLED) == false;
                        }
                    }
                    catch (Exception e) {
                        AlienFirstPersonMod.LOGGER.debug("Error checking Galvanic Mechamorph state in shouldDisableForAlienConfig: {}", (Object)e.getMessage());
                    }
                }
                return (Boolean)manager.getPendingOrCurrentValue("galvanic_mechamorph.firstPersonEnabled", AlienFirstPersonConfig.GALVANIC_MECHAMORPH_FIRST_PERSON_ENABLED) == false;
            }
            case "ectonurite": {
                return (Boolean)manager.getPendingOrCurrentValue("ectonurite.firstPersonEnabled", AlienFirstPersonConfig.ECTONURITE_FIRST_PERSON_ENABLED) == false;
            }
            case "arburian_pelarota": {
                return (Boolean)manager.getPendingOrCurrentValue("arburian_pelarota.firstPersonEnabled", AlienFirstPersonConfig.ARBURIAN_PELAROTA_FIRST_PERSON_ENABLED) == false;
            }
        }
        return false;
    }

    public static boolean shouldForceDisableFirstPerson() {
        if (AlienOffsetManager.isUnsupportedAlienActive()) {
            return true;
        }
        String currentAlien = AlienOffsetManager.getCurrentAlienForm();
        if (currentAlien != null && AlienActivationHandler.shouldDisableForAlienConfig(currentAlien)) {
            return true;
        }
        return isPyroniteFlying || isLepidopterranFlying || isEctonuriteFlying || isGalvanFlying || isBothHandsActive || isGalvanicMechamorphGliding || flightTransitionBuffer > 0 || glideTransitionBuffer > 0;
    }

    public static void updateAlienStates(LocalPlayer player) {
        if (player == null) {
            AlienActivationHandler.resetAllStates();
            return;
        }
        String currentAlien = AlienOffsetManager.getCurrentAlienForm();
        AlienFirstPersonMod.LOGGER.debug("Current alien form: {}", (Object)(currentAlien != null ? currentAlien : "human"));
        if ("pyronite".equals(currentAlien) || AlienActivationHandler.hasAlienAbility(player, "pyronite")) {
            AlienActivationHandler.updatePyroniteFlightState(player);
        } else {
            AlienActivationHandler.resetPyroniteState();
        }
        if ("lepidopterran".equals(currentAlien) || AlienActivationHandler.hasAlienAbility(player, "lepidopterran")) {
            AlienActivationHandler.updateLepidopterranFlightState(player);
        } else {
            AlienActivationHandler.resetLepidopterranState();
        }
        if ("ectonurite".equals(currentAlien) || AlienActivationHandler.hasAlienAbility(player, "ectonurite")) {
            AlienActivationHandler.updateEctonuriteFlightState(player);
        } else {
            AlienActivationHandler.resetEctonuriteState();
        }
        if ("galvan".equals(currentAlien) || AlienActivationHandler.hasAlienAbility(player, "galvan")) {
            AlienActivationHandler.updateGalvanState(player);
            AlienActivationHandler.updateGalvanFlightState(player);
        } else {
            AlienActivationHandler.resetGalvanState();
        }
        if ("tetramand".equals(currentAlien) || AlienActivationHandler.hasAlienAbility(player, "tetramand")) {
            AlienActivationHandler.updateTetramandState(player);
        }
        if ("piscciss_volann".equals(currentAlien) || AlienActivationHandler.hasAlienAbility(player, "piscciss_volann") || AlienActivationHandler.hasAlienAbility(player, "pisccissvolann")) {
            AlienActivationHandler.updatePisccissVolannBiteState(player);
        } else {
            AlienActivationHandler.resetPisccissVolannBiteState();
        }
        if ("galvanic_mechamorph".equals(currentAlien) || AlienActivationHandler.hasAlienAbility(player, "galvanic_mechamorph") || AlienActivationHandler.hasAlienAbility(player, "galvanicmechamorph")) {
            AlienActivationHandler.updateGalvanicMechamorphState(player);
            AlienActivationHandler.updateGalvanicMechamorphGlideState(player);
        } else {
            AlienActivationHandler.resetGalvanicMechamorphState();
        }
        if ("kineceleran".equals(currentAlien) || AlienActivationHandler.hasAlienAbility(player, "kineceleran")) {
            AlienActivationHandler.updateKineceleranSkateState(player);
        } else {
            AlienActivationHandler.resetKineceleranState();
        }
        if ("petrosapien".equals(currentAlien) || AlienActivationHandler.hasAlienAbility(player, "petrosapien")) {
            AlienActivationHandler.updatePetrosapienState(player);
        }
        if (AlienActivationHandler.hasAlienAbility(player, "both_hands")) {
            AlienActivationHandler.updateBothHandsState(player);
        } else {
            AlienActivationHandler.resetBothHandsState();
        }
        if (biteAnimationBuffer > 0) {
            AlienFirstPersonMod.LOGGER.debug("Bite animation buffer: {}", (Object)(--biteAnimationBuffer));
        }
        if (kineceleranTransitionBuffer > 0) {
            AlienFirstPersonMod.LOGGER.debug("Kineceleran transition buffer: {}", (Object)(--kineceleranTransitionBuffer));
        }
        if (flightTransitionBuffer > 0) {
            AlienFirstPersonMod.LOGGER.debug("Flight transition buffer: {}", (Object)(--flightTransitionBuffer));
        }
        if (glideTransitionBuffer > 0) {
            AlienFirstPersonMod.LOGGER.debug("Glide transition buffer: {}", (Object)(--glideTransitionBuffer));
        }
    }

    private static boolean hasAlienAbility(LocalPlayer player, String alienName) {
        try {
            Collection allAbilities = AbilityUtil.getInstances((LivingEntity)player);
            if (allAbilities != null && !allAbilities.isEmpty()) {
                String alienNameNoUnderscore = alienName.replace("_", "");
                for (AbilityInstance ability : allAbilities) {
                    String lowerAbilityId;
                    String abilityId;
                    if (ability == null || !ability.isEnabled() || (abilityId = ability.getConfiguration().getId()) == null || !(lowerAbilityId = abilityId.toLowerCase()).equals(alienName) && !lowerAbilityId.startsWith(alienName + "_") && !lowerAbilityId.equals(alienNameNoUnderscore) && !lowerAbilityId.startsWith(alienNameNoUnderscore + "_")) continue;
                    return true;
                }
            }
        }
        catch (Exception e) {
            AlienFirstPersonMod.LOGGER.debug("Error checking alien ability {}: {}", (Object)alienName, (Object)e.getMessage());
        }
        return false;
    }

    private static boolean hasAlienPower(LocalPlayer player, String powerId) {
        try {
            ResourceLocation powerLocation = new ResourceLocation(powerId);
            Collection abilities = AbilityUtil.getInstances((LivingEntity)player, (ResourceLocation)powerLocation);
            if (abilities != null && !abilities.isEmpty()) {
                for (AbilityInstance ability : abilities) {
                    if (ability == null || !ability.isEnabled()) continue;
                    return true;
                }
            }
        }
        catch (Exception e) {
            AlienFirstPersonMod.LOGGER.debug("Error checking alien power {}: {}", (Object)powerId, (Object)e.getMessage());
        }
        return false;
    }

    private static void updateBothHandsState(LocalPlayer player) {
        boolean configEnabled = (Boolean)AlienFirstPersonConfig.DISABLE_FIRST_PERSON_ON_OMNITRIX.get();
        if (configEnabled) {
            if (!isBothHandsActive) {
                if (!AlienFirstPersonMod.isOmnitrixControlling) {
                    AlienFirstPersonMod.savedStateBeforeOmnitrix = FirstPersonModelCore.instance.isEnabled();
                    AlienFirstPersonMod.isOmnitrixControlling = true;
                }
                if (FirstPersonModelCore.instance.isEnabled()) {
                    FirstPersonModelCore.instance.setEnabled(false);
                }
                isBothHandsActive = true;
                AlienFirstPersonMod.LOGGER.debug("Disabled first person for both_hands ability (saved state: {})", (Object)AlienFirstPersonMod.savedStateBeforeOmnitrix);
            }
        } else {
            VanillaHands mode;
            boolean shouldDisable = false;
            if (FirstPersonModelCore.instance != null && FirstPersonModelCore.instance.getConfig() != null && ((mode = FirstPersonModelCore.instance.getConfig().vanillaHandsMode) == VanillaHands.ITEMS || mode == VanillaHands.ALL || mode == VanillaHands.ALL_DOUBLE)) {
                shouldDisable = true;
            }
            if (shouldDisable && !isBothHandsActive) {
                if (!AlienFirstPersonMod.isOmnitrixControlling) {
                    AlienFirstPersonMod.savedStateBeforeOmnitrix = FirstPersonModelCore.instance.isEnabled();
                    AlienFirstPersonMod.isOmnitrixControlling = true;
                }
                if (FirstPersonModelCore.instance.isEnabled()) {
                    FirstPersonModelCore.instance.setEnabled(false);
                }
                isBothHandsActive = true;
                AlienFirstPersonMod.LOGGER.debug("Disabled first person for both_hands with vanilla hands");
            } else if (!shouldDisable && isBothHandsActive) {
                AlienActivationHandler.resetBothHandsState();
            }
        }
    }

    private static void updatePisccissVolannBiteState(LocalPlayer player) {
        block9: {
            try {
                boolean hasPisccissVolann = false;
                boolean hasBiteActive = false;
                Collection allAbilities = AbilityUtil.getInstances((LivingEntity)player);
                if (allAbilities != null && !allAbilities.isEmpty()) {
                    for (AbilityInstance ability : allAbilities) {
                        if (ability == null || !ability.isEnabled()) continue;
                        String abilityId = ability.getConfiguration().getId();
                        if ("piscciss_volann".equals(abilityId) || "pisccissvolann".equals(abilityId)) {
                            hasPisccissVolann = true;
                            AlienFirstPersonMod.LOGGER.debug("Piscciss Volann ability detected");
                        }
                        if (!"bite".equals(abilityId)) continue;
                        hasBiteActive = true;
                        AlienFirstPersonMod.LOGGER.debug("Bite ability is active");
                        if (!(ability.getConfiguration().getAbility() instanceof AnimationTimerAbility)) continue;
                        Integer currentValue = (Integer)ability.getProperty(AnimationTimerAbility.VALUE);
                        Integer maxValue = (Integer)ability.getProperty(AnimationTimerAbility.MAX_VALUE);
                        AlienFirstPersonMod.LOGGER.debug("Bite timer: {}/{}", (Object)currentValue, (Object)maxValue);
                    }
                }
                if (hasPisccissVolann && hasBiteActive) {
                    if (!isPisccissVolannBiting) {
                        isPisccissVolannBiting = true;
                        biteAnimationBuffer = 10;
                        AlienFirstPersonMod.LOGGER.debug("Piscciss Volann bite detected - moving camera forward");
                    }
                } else if (isPisccissVolannBiting) {
                    isPisccissVolannBiting = false;
                    biteAnimationBuffer = 10;
                    AlienFirstPersonMod.LOGGER.debug("Piscciss Volann bite ended, restoring camera position");
                }
            }
            catch (Exception e) {
                AlienFirstPersonMod.LOGGER.error("Error checking Piscciss Volann bite state", (Throwable)e);
                if (!isPisccissVolannBiting) break block9;
                AlienActivationHandler.resetPisccissVolannBiteState();
            }
        }
    }

    private static void updatePetrosapienState(LocalPlayer player) {
        try {
            String currentAlien;
            boolean hasBattleMode = false;
            boolean hasShieldActivate = false;
            Collection allAbilities = AbilityUtil.getInstances((LivingEntity)player);
            if (allAbilities != null && !allAbilities.isEmpty()) {
                for (AbilityInstance ability : allAbilities) {
                    if (ability == null || !ability.isEnabled()) continue;
                    String abilityId = ability.getConfiguration().getId();
                    if ("battle_mode".equals(abilityId)) {
                        hasBattleMode = true;
                    }
                    if (!"shield_activate".equals(abilityId)) continue;
                    hasShieldActivate = true;
                }
            }
            if ("petrosapien".equals(currentAlien = AlienOffsetManager.getCurrentAlienForm())) {
                boolean stateChanged;
                String currentState;
                ConfigChangeManager manager = ConfigChangeManager.getInstance();
                boolean shouldDisable = false;
                if (hasShieldActivate) {
                    currentState = "shield";
                    shouldDisable = (Boolean)manager.getPendingOrCurrentValue("petrosapien.shield.firstPersonEnabled", AlienFirstPersonConfig.PETROSAPIEN_SHIELD_FIRST_PERSON_ENABLED) == false;
                } else if (hasBattleMode) {
                    currentState = "battle";
                    shouldDisable = (Boolean)manager.getPendingOrCurrentValue("petrosapien.battleMode.firstPersonEnabled", AlienFirstPersonConfig.PETROSAPIEN_BATTLE_MODE_FIRST_PERSON_ENABLED) == false;
                } else {
                    currentState = "base";
                    shouldDisable = (Boolean)manager.getPendingOrCurrentValue("petrosapien.firstPersonEnabled", AlienFirstPersonConfig.PETROSAPIEN_FIRST_PERSON_ENABLED) == false;
                }
                boolean bl = stateChanged = !currentState.equals(lastPetrosapienState);
                if (stateChanged) {
                    AlienFirstPersonMod.LOGGER.debug("Petrosapien state changed: {} -> {}", (Object)lastPetrosapienState, (Object)currentState);
                    lastPetrosapienState = currentState;
                    if (FirstPersonModelCore.instance != null && FirstPersonModelCore.instance.isEnabled() && !shouldDisable) {
                        AlienStateHandler.applyAlienFPMSettings("petrosapien");
                        AlienFirstPersonMod.LOGGER.debug("Applied FPM settings immediately for state change");
                    }
                }
                if (FirstPersonModelCore.instance != null) {
                    boolean currentlyEnabled = FirstPersonModelCore.instance.isEnabled();
                    if (shouldDisable && currentlyEnabled) {
                        FirstPersonModelCore.instance.setEnabled(false);
                        AlienFirstPersonMod.LOGGER.debug("Forcing first person DISABLED for Petrosapien state (battle={}, shield={})", (Object)hasBattleMode, (Object)hasShieldActivate);
                    } else if (!(shouldDisable || currentlyEnabled || AlienActivationHandler.shouldForceDisableFirstPerson())) {
                        FirstPersonModelCore.instance.setEnabled(true);
                        AlienStateHandler.applyAlienFPMSettings("petrosapien");
                        AlienFirstPersonMod.LOGGER.debug("Forcing first person ENABLED for Petrosapien state (battle={}, shield={})", (Object)hasBattleMode, (Object)hasShieldActivate);
                    }
                }
            } else {
                lastPetrosapienState = null;
            }
        }
        catch (Exception e) {
            AlienFirstPersonMod.LOGGER.error("Error checking Petrosapien state", (Throwable)e);
        }
    }

    private static void updateGalvanicMechamorphState(LocalPlayer player) {
        try {
            String currentAlien;
            boolean hasLightningPro = false;
            Collection allAbilities = AbilityUtil.getInstances((LivingEntity)player);
            if (allAbilities != null && !allAbilities.isEmpty()) {
                for (AbilityInstance ability : allAbilities) {
                    String abilityId;
                    if (ability == null || !ability.isEnabled() || !"lightningpro".equals(abilityId = ability.getConfiguration().getId())) continue;
                    hasLightningPro = true;
                }
            }
            if ("galvanic_mechamorph".equals(currentAlien = AlienOffsetManager.getCurrentAlienForm())) {
                boolean stateChanged;
                String currentState;
                ConfigChangeManager manager = ConfigChangeManager.getInstance();
                boolean shouldDisable = false;
                if (hasLightningPro) {
                    currentState = "rod";
                    shouldDisable = (Boolean)manager.getPendingOrCurrentValue("galvanic_mechamorph.rod.firstPersonEnabled", AlienFirstPersonConfig.GALVANIC_MECHAMORPH_ROD_FIRST_PERSON_ENABLED) == false;
                } else {
                    currentState = "base";
                    shouldDisable = (Boolean)manager.getPendingOrCurrentValue("galvanic_mechamorph.firstPersonEnabled", AlienFirstPersonConfig.GALVANIC_MECHAMORPH_FIRST_PERSON_ENABLED) == false;
                }
                boolean bl = stateChanged = !currentState.equals(lastGalvanicMechamorphState);
                if (stateChanged) {
                    AlienFirstPersonMod.LOGGER.debug("Galvanic Mechamorph state changed: {} -> {}", (Object)lastGalvanicMechamorphState, (Object)currentState);
                    lastGalvanicMechamorphState = currentState;
                    if (FirstPersonModelCore.instance != null && FirstPersonModelCore.instance.isEnabled() && !shouldDisable) {
                        AlienStateHandler.applyAlienFPMSettings("galvanic_mechamorph");
                        AlienFirstPersonMod.LOGGER.debug("Applied FPM settings immediately for Galvanic Mechamorph state change");
                    }
                }
                if (FirstPersonModelCore.instance != null) {
                    boolean currentlyEnabled = FirstPersonModelCore.instance.isEnabled();
                    if (shouldDisable && currentlyEnabled) {
                        FirstPersonModelCore.instance.setEnabled(false);
                        AlienFirstPersonMod.LOGGER.debug("Forcing first person DISABLED for Galvanic Mechamorph state (rod={})", (Object)hasLightningPro);
                    } else if (!(shouldDisable || currentlyEnabled || AlienActivationHandler.shouldForceDisableFirstPerson())) {
                        FirstPersonModelCore.instance.setEnabled(true);
                        AlienStateHandler.applyAlienFPMSettings("galvanic_mechamorph");
                        AlienFirstPersonMod.LOGGER.debug("Forcing first person ENABLED for Galvanic Mechamorph state (rod={})", (Object)hasLightningPro);
                    }
                }
            } else {
                lastGalvanicMechamorphState = null;
            }
        }
        catch (Exception e) {
            AlienFirstPersonMod.LOGGER.error("Error checking Galvanic Mechamorph state", (Throwable)e);
        }
    }

    private static void updatePyroniteFlightState(LocalPlayer player) {
        if (player instanceof PalladiumPlayerExtension) {
            boolean isFlying;
            boolean hasPyroSurf;
            FlightHandler flightHandler;
            block12: {
                PalladiumPlayerExtension extension = (PalladiumPlayerExtension)player;
                flightHandler = extension.palladium$getFlightHandler();
                if (AlienActivationHandler.isPyroniteExtinguished(player)) {
                    AlienActivationHandler.resetPyroniteState();
                    return;
                }
                if (player.m_6069_() || player.m_5842_() || player.m_20069_()) {
                    AlienActivationHandler.resetPyroniteState();
                    return;
                }
                hasPyroSurf = false;
                try {
                    Collection allAbilities = AbilityUtil.getInstances((LivingEntity)player);
                    if (allAbilities == null || allAbilities.isEmpty()) break block12;
                    for (AbilityInstance ability : allAbilities) {
                        String abilityId;
                        if (ability == null || !ability.isEnabled() || !"pyro_surf".equals(abilityId = ability.getConfiguration().getId()) && !"pyrosurf".equals(abilityId)) continue;
                        hasPyroSurf = true;
                        AlienFirstPersonMod.LOGGER.debug("Pyro surf ability detected");
                        break;
                    }
                }
                catch (Exception e) {
                    AlienFirstPersonMod.LOGGER.debug("Error checking pyro surf: {}", (Object)e.getMessage());
                }
            }
            boolean isActivelyFlying = flightHandler.getFlightType() == FlightHandler.FlightType.NORMAL || hasPyroSurf;
            float flightAnimation = flightHandler.getFlightAnimation(1.0f);
            float hoveringAnimation = flightHandler.getHoveringAnimation(1.0f);
            boolean isHovering = (isActivelyFlying || hasPyroSurf) && !player.m_20096_();
            boolean bl = isFlying = (isActivelyFlying || hasPyroSurf) && (flightAnimation > 0.1f || hoveringAnimation > 0.1f || isHovering || !player.m_20096_());
            if (isFlying && !isPyroniteFlying) {
                if (FirstPersonModelCore.instance.isEnabled()) {
                    FirstPersonModelCore.instance.setEnabled(false);
                    isPyroniteFlying = true;
                    AlienFirstPersonMod.LOGGER.debug("Disabled first person for Pyronite flight/surf");
                    AlienActivationHandler.handlePyroniteVanillaHands(true);
                }
            } else if (!isFlying && isPyroniteFlying) {
                AlienActivationHandler.resetPyroniteState();
            }
            if (isPyroniteFlying) {
                AlienActivationHandler.ensureVanillaHandsDisabled();
            }
        } else {
            AlienActivationHandler.resetPyroniteState();
        }
    }

    private static void handlePyroniteVanillaHands(boolean isFlying) {
        if (FirstPersonModelCore.instance != null && FirstPersonModelCore.instance.getConfig() != null) {
            if (isFlying) {
                VanillaHands currentMode = FirstPersonModelCore.instance.getConfig().vanillaHandsMode;
                if (currentMode != VanillaHands.OFF && !vanillaHandsDisabledForPyronite) {
                    originalVanillaHandsMode = currentMode;
                    FirstPersonModelCore.instance.getConfig().vanillaHandsMode = VanillaHands.OFF;
                    vanillaHandsDisabledForPyronite = true;
                    AlienFirstPersonMod.LOGGER.debug("Temporarily disabled vanilla hands for Pyronite flight");
                }
            } else if (vanillaHandsDisabledForPyronite && originalVanillaHandsMode != null) {
                FirstPersonModelCore.instance.getConfig().vanillaHandsMode = originalVanillaHandsMode;
                vanillaHandsDisabledForPyronite = false;
                originalVanillaHandsMode = null;
                AlienFirstPersonMod.LOGGER.debug("Restored vanilla hands mode after Pyronite flight");
            }
        }
    }

    private static void ensureVanillaHandsDisabled() {
        VanillaHands currentMode;
        if (FirstPersonModelCore.instance != null && FirstPersonModelCore.instance.getConfig() != null && (currentMode = FirstPersonModelCore.instance.getConfig().vanillaHandsMode) != VanillaHands.OFF) {
            if (!vanillaHandsDisabledForPyronite) {
                originalVanillaHandsMode = currentMode;
                vanillaHandsDisabledForPyronite = true;
            }
            FirstPersonModelCore.instance.getConfig().vanillaHandsMode = VanillaHands.OFF;
            AlienFirstPersonMod.LOGGER.debug("Forced vanilla hands to OFF during Pyronite flight");
        }
    }

    private static void updateLepidopterranFlightState(LocalPlayer player) {
        if (player instanceof PalladiumPlayerExtension) {
            boolean isFlying;
            PalladiumPlayerExtension extension = (PalladiumPlayerExtension)player;
            FlightHandler flightHandler = extension.palladium$getFlightHandler();
            boolean wingsDisabled = AlienActivationHandler.isLepidopterranWingsDisabled(player);
            if (player.m_6069_() || player.m_5842_() || player.m_20069_() || wingsDisabled) {
                AlienActivationHandler.resetLepidopterranState();
                return;
            }
            boolean isActivelyFlying = flightHandler.getFlightType() == FlightHandler.FlightType.LEVITATION;
            float hoveringAnimation = flightHandler.getHoveringAnimation(1.0f);
            float flightAnimation = flightHandler.getFlightAnimation(1.0f);
            boolean bl = isFlying = isActivelyFlying && (hoveringAnimation > 0.1f || flightAnimation > 0.1f);
            if (isFlying && !isLepidopterranFlying) {
                if (FirstPersonModelCore.instance.isEnabled()) {
                    FirstPersonModelCore.instance.setEnabled(false);
                    isLepidopterranFlying = true;
                    AlienFirstPersonMod.LOGGER.debug("Disabled first person for Lepidopterran flight (Explicit detection)");
                }
            } else if (!isFlying && isLepidopterranFlying) {
                AlienActivationHandler.resetLepidopterranState();
            }
        } else {
            AlienActivationHandler.resetLepidopterranState();
        }
    }

    private static void updateEctonuriteFlightState(LocalPlayer player) {
        if (player instanceof PalladiumPlayerExtension) {
            boolean isFlying;
            PalladiumPlayerExtension extension = (PalladiumPlayerExtension)player;
            FlightHandler flightHandler = extension.palladium$getFlightHandler();
            boolean isActivelyFlying = flightHandler.getFlightType() == FlightHandler.FlightType.LEVITATION;
            float hoveringAnimation = flightHandler.getHoveringAnimation(1.0f);
            float flightAnimation = flightHandler.getFlightAnimation(1.0f);
            boolean bl = isFlying = isActivelyFlying && (hoveringAnimation > 0.1f || flightAnimation > 0.1f);
            if (isFlying && !isEctonuriteFlying) {
                if (FirstPersonModelCore.instance.isEnabled()) {
                    FirstPersonModelCore.instance.setEnabled(false);
                    isEctonuriteFlying = true;
                    AlienFirstPersonMod.LOGGER.debug("Disabled first person for Ectonurite flight (Explicit detection)");
                }
            } else if (!isFlying && isEctonuriteFlying) {
                AlienActivationHandler.resetEctonuriteState();
            }
        } else {
            AlienActivationHandler.resetEctonuriteState();
        }
    }

    private static void updateGalvanFlightState(LocalPlayer player) {
        if (player instanceof PalladiumPlayerExtension) {
            boolean isFlying;
            boolean hasGalvanArmor;
            FlightHandler flightHandler;
            block10: {
                PalladiumPlayerExtension extension = (PalladiumPlayerExtension)player;
                flightHandler = extension.palladium$getFlightHandler();
                hasGalvanArmor = false;
                try {
                    Collection allAbilities = AbilityUtil.getInstances((LivingEntity)player);
                    if (allAbilities == null || allAbilities.isEmpty()) break block10;
                    for (AbilityInstance ability : allAbilities) {
                        String abilityId;
                        if (ability == null || !ability.isEnabled() || !"galvan_armor".equals(abilityId = ability.getConfiguration().getId())) continue;
                        hasGalvanArmor = true;
                        break;
                    }
                }
                catch (Exception e) {
                    AlienFirstPersonMod.LOGGER.debug("Error checking galvan_armor: {}", (Object)e.getMessage());
                }
            }
            if (!hasGalvanArmor) {
                AlienActivationHandler.resetGalvanState();
                return;
            }
            boolean isActivelyFlying = flightHandler.getFlightType() == FlightHandler.FlightType.NORMAL;
            float flightAnimation = flightHandler.getFlightAnimation(1.0f);
            boolean isHovering = isActivelyFlying && !player.m_20096_();
            boolean bl = isFlying = isActivelyFlying && (flightAnimation > 0.1f || isHovering);
            if (isFlying && !isGalvanFlying) {
                if (FirstPersonModelCore.instance.isEnabled()) {
                    FirstPersonModelCore.instance.setEnabled(false);
                    isGalvanFlying = true;
                    AlienFirstPersonMod.LOGGER.debug("Disabled first person for Galvan armor flight");
                }
            } else if (!isFlying && isGalvanFlying) {
                AlienActivationHandler.resetGalvanState();
            }
        } else {
            AlienActivationHandler.resetGalvanState();
        }
    }

    private static void updateGalvanState(LocalPlayer player) {
        try {
            String currentAlien;
            boolean hasGalvanSuit = false;
            boolean hasGalvanLimbs = false;
            Collection allAbilities = AbilityUtil.getInstances((LivingEntity)player);
            if (allAbilities != null && !allAbilities.isEmpty()) {
                for (AbilityInstance ability : allAbilities) {
                    if (ability == null || !ability.isEnabled()) continue;
                    String abilityId = ability.getConfiguration().getId();
                    if ("galvan_suit".equals(abilityId)) {
                        hasGalvanSuit = true;
                        continue;
                    }
                    if (!"galvan_limbs".equals(abilityId)) continue;
                    hasGalvanLimbs = true;
                }
            }
            if ("galvan".equals(currentAlien = AlienOffsetManager.getCurrentAlienForm())) {
                boolean stateChanged;
                String currentState;
                ConfigChangeManager manager = ConfigChangeManager.getInstance();
                boolean shouldDisable = false;
                if (hasGalvanSuit) {
                    currentState = "suit";
                    shouldDisable = (Boolean)manager.getPendingOrCurrentValue("galvan.suit.firstPersonEnabled", AlienFirstPersonConfig.GALVAN_SUIT_FIRST_PERSON_ENABLED) == false;
                } else if (hasGalvanLimbs) {
                    currentState = "limbs";
                    shouldDisable = (Boolean)manager.getPendingOrCurrentValue("galvan.limbs.firstPersonEnabled", AlienFirstPersonConfig.GALVAN_LIMBS_FIRST_PERSON_ENABLED) == false;
                } else {
                    currentState = "base";
                    shouldDisable = (Boolean)manager.getPendingOrCurrentValue("galvan.firstPersonEnabled", AlienFirstPersonConfig.GALVAN_FIRST_PERSON_ENABLED) == false;
                }
                boolean bl = stateChanged = !currentState.equals(lastGalvanState);
                if (stateChanged) {
                    AlienFirstPersonMod.LOGGER.debug("Galvan state changed: {} -> {}", (Object)lastGalvanState, (Object)currentState);
                    lastGalvanState = currentState;
                    if (FirstPersonModelCore.instance != null && FirstPersonModelCore.instance.isEnabled() && !shouldDisable) {
                        AlienStateHandler.applyAlienFPMSettings("galvan");
                        AlienFirstPersonMod.LOGGER.debug("Applied FPM settings immediately for Galvan state change");
                    }
                }
                if (FirstPersonModelCore.instance != null) {
                    boolean currentlyEnabled = FirstPersonModelCore.instance.isEnabled();
                    if (shouldDisable && currentlyEnabled) {
                        FirstPersonModelCore.instance.setEnabled(false);
                        AlienFirstPersonMod.LOGGER.debug("Forcing first person DISABLED for Galvan state (suit={}, limbs={})", (Object)hasGalvanSuit, (Object)hasGalvanLimbs);
                    } else if (!(shouldDisable || currentlyEnabled || AlienActivationHandler.shouldForceDisableFirstPerson())) {
                        FirstPersonModelCore.instance.setEnabled(true);
                        AlienStateHandler.applyAlienFPMSettings("galvan");
                        AlienFirstPersonMod.LOGGER.debug("Forcing first person ENABLED for Galvan state (suit={}, limbs={})", (Object)hasGalvanSuit, (Object)hasGalvanLimbs);
                    }
                }
            } else {
                lastGalvanState = null;
            }
        }
        catch (Exception e) {
            AlienFirstPersonMod.LOGGER.error("Error checking Galvan state", (Throwable)e);
        }
    }

    private static void updateTetramandState(LocalPlayer player) {
        try {
            String currentAlien;
            boolean hasTetramandSlam = false;
            boolean hasSonicClap = false;
            Collection allAbilities = AbilityUtil.getInstances((LivingEntity)player);
            if (allAbilities != null && !allAbilities.isEmpty()) {
                for (AbilityInstance ability : allAbilities) {
                    if (ability == null || !ability.isEnabled()) continue;
                    String abilityId = ability.getConfiguration().getId();
                    if ("slam_fall".equals(abilityId)) {
                        hasTetramandSlam = true;
                    }
                    if (!"sonic_clap".equals(abilityId)) continue;
                    hasSonicClap = true;
                }
            }
            if ("tetramand".equals(currentAlien = AlienOffsetManager.getCurrentAlienForm())) {
                ConfigChangeManager manager = ConfigChangeManager.getInstance();
                boolean shouldDisable = false;
                if (hasTetramandSlam && !((Boolean)manager.getPendingOrCurrentValue("tetramand.slamFirstPersonEnabled", AlienFirstPersonConfig.TETRAMAND_SLAM_FIRST_PERSON_ENABLED)).booleanValue()) {
                    shouldDisable = true;
                } else if (!hasTetramandSlam && !((Boolean)manager.getPendingOrCurrentValue("tetramand.firstPersonEnabled", AlienFirstPersonConfig.TETRAMAND_FIRST_PERSON_ENABLED)).booleanValue()) {
                    shouldDisable = true;
                }
                if (shouldDisable && FirstPersonModelCore.instance.isEnabled()) {
                    FirstPersonModelCore.instance.setEnabled(false);
                    AlienFirstPersonMod.LOGGER.debug("Disabled first person for Tetramand state");
                } else if (!(shouldDisable || FirstPersonModelCore.instance.isEnabled() || AlienActivationHandler.shouldForceDisableFirstPerson())) {
                    FirstPersonModelCore.instance.setEnabled(true);
                    AlienFirstPersonMod.LOGGER.debug("Enabled first person for Tetramand state");
                }
            }
        }
        catch (Exception e) {
            AlienFirstPersonMod.LOGGER.error("Error checking Tetramand state", (Throwable)e);
        }
    }

    private static void updateGalvanicMechamorphGlideState(LocalPlayer player) {
        block8: {
            try {
                boolean shouldDisable;
                boolean hasGlideActive = false;
                Collection allAbilities = AbilityUtil.getInstances((LivingEntity)player);
                if (allAbilities != null && !allAbilities.isEmpty()) {
                    for (AbilityInstance ability : allAbilities) {
                        String abilityId;
                        if (ability == null || !ability.isEnabled() || !"glide".equals(abilityId = ability.getConfiguration().getId())) continue;
                        hasGlideActive = true;
                        AlienFirstPersonMod.LOGGER.debug("Glide ability is active for Galvanic Mechamorph");
                        break;
                    }
                }
                ConfigChangeManager manager = ConfigChangeManager.getInstance();
                boolean bl = shouldDisable = hasGlideActive && (Boolean)manager.getPendingOrCurrentValue("galvanic_mechamorph.glideFirstPersonEnabled", AlienFirstPersonConfig.GALVANIC_MECHAMORPH_GLIDE_FIRST_PERSON_ENABLED) == false;
                if (hasGlideActive && shouldDisable && !isGalvanicMechamorphGliding) {
                    if (FirstPersonModelCore.instance.isEnabled()) {
                        FirstPersonModelCore.instance.setEnabled(false);
                        isGalvanicMechamorphGliding = true;
                        AlienFirstPersonMod.LOGGER.debug("Disabled first person for Galvanic Mechamorph glide");
                    }
                } else if (!hasGlideActive && isGalvanicMechamorphGliding) {
                    AlienActivationHandler.resetGalvanicMechamorphState();
                }
            }
            catch (Exception e) {
                AlienFirstPersonMod.LOGGER.error("Error checking Galvanic Mechamorph glide state", (Throwable)e);
                if (!isGalvanicMechamorphGliding) break block8;
                AlienActivationHandler.resetGalvanicMechamorphState();
            }
        }
    }

    private static void updateKineceleranSkateState(LocalPlayer player) {
        block24: {
            try {
                String currentAlien;
                boolean hasSpeedActive = false;
                boolean hasSkateActive = false;
                Collection allAbilities = AbilityUtil.getInstances((LivingEntity)player);
                if (allAbilities != null && !allAbilities.isEmpty()) {
                    for (AbilityInstance ability : allAbilities) {
                        if (ability == null || !ability.isEnabled()) continue;
                        String abilityId = ability.getConfiguration().getId();
                        if ("skate".equals(abilityId)) {
                            hasSkateActive = true;
                            AlienFirstPersonMod.LOGGER.debug("Kineceleran skate ability active");
                            continue;
                        }
                        if (!"speed_1".equals(abilityId) && !"speed_2".equals(abilityId) && !"speed_3".equals(abilityId) && !"speed_4".equals(abilityId) && !"speed_5".equals(abilityId)) continue;
                        hasSpeedActive = true;
                        AlienFirstPersonMod.LOGGER.debug("Kineceleran speed ability active: {}", (Object)abilityId);
                    }
                }
                if ("kineceleran".equals(currentAlien = AlienOffsetManager.getCurrentAlienForm())) {
                    boolean stateChanged;
                    String currentState;
                    ConfigChangeManager manager = ConfigChangeManager.getInstance();
                    boolean shouldDisable = false;
                    if (hasSkateActive) {
                        currentState = "skate";
                        shouldDisable = (Boolean)manager.getPendingOrCurrentValue("kineceleran.skate.firstPersonEnabled", AlienFirstPersonConfig.KINECELERAN_SKATE_FIRST_PERSON_ENABLED) == false;
                    } else if (hasSpeedActive) {
                        currentState = "speed";
                        shouldDisable = (Boolean)manager.getPendingOrCurrentValue("kineceleran.speed.firstPersonEnabled", AlienFirstPersonConfig.KINECELERAN_SPEED_FIRST_PERSON_ENABLED) == false;
                    } else {
                        currentState = "base";
                        shouldDisable = (Boolean)manager.getPendingOrCurrentValue("kineceleran.firstPersonEnabled", AlienFirstPersonConfig.KINECELERAN_FIRST_PERSON_ENABLED) == false;
                    }
                    boolean bl = stateChanged = !currentState.equals(lastKineceleranState);
                    if (stateChanged) {
                        AlienFirstPersonMod.LOGGER.debug("Kineceleran state changed: {} -> {}", (Object)lastKineceleranState, (Object)currentState);
                        lastKineceleranState = currentState;
                        if (FirstPersonModelCore.instance != null && FirstPersonModelCore.instance.isEnabled() && !shouldDisable) {
                            AlienStateHandler.applyAlienFPMSettings("kineceleran");
                            AlienFirstPersonMod.LOGGER.debug("Applied FPM settings immediately for Kineceleran state change");
                        }
                    }
                    if (FirstPersonModelCore.instance != null) {
                        boolean currentlyEnabled = FirstPersonModelCore.instance.isEnabled();
                        if (shouldDisable && currentlyEnabled) {
                            FirstPersonModelCore.instance.setEnabled(false);
                            AlienFirstPersonMod.LOGGER.debug("Forcing first person DISABLED for Kineceleran state (speed={}, skate={})", (Object)hasSpeedActive, (Object)hasSkateActive);
                        } else if (!(shouldDisable || currentlyEnabled || AlienActivationHandler.shouldForceDisableFirstPerson())) {
                            FirstPersonModelCore.instance.setEnabled(true);
                            AlienStateHandler.applyAlienFPMSettings("kineceleran");
                            AlienFirstPersonMod.LOGGER.debug("Forcing first person ENABLED for Kineceleran state (speed={}, skate={})", (Object)hasSpeedActive, (Object)hasSkateActive);
                        }
                    }
                } else {
                    lastKineceleranState = null;
                }
                if (hasSkateActive && !isKineceleranSkating) {
                    isKineceleranSkating = true;
                    kineceleranTransitionBuffer = 0;
                    AlienFirstPersonMod.LOGGER.debug("Kineceleran skate detected - moving camera forward");
                } else if (!hasSkateActive && isKineceleranSkating) {
                    isKineceleranSkating = false;
                    kineceleranTransitionBuffer = 6;
                    AlienFirstPersonMod.LOGGER.debug("Kineceleran skate ended - starting transition");
                }
                if (hasSpeedActive && !isKineceleranSpeedActive) {
                    isKineceleranSpeedActive = true;
                    AlienFirstPersonMod.LOGGER.debug("Kineceleran speed boost detected - moving camera forward slightly");
                } else if (!hasSpeedActive && isKineceleranSpeedActive) {
                    isKineceleranSpeedActive = false;
                    AlienFirstPersonMod.LOGGER.debug("Kineceleran speed boost ended");
                }
            }
            catch (Exception e) {
                AlienFirstPersonMod.LOGGER.error("Error checking Kineceleran movement state", (Throwable)e);
                if (isKineceleranSkating) {
                    isKineceleranSkating = false;
                }
                if (!isKineceleranSpeedActive) break block24;
                isKineceleranSpeedActive = false;
            }
        }
    }

    private static void resetAllStates() {
        AlienActivationHandler.resetPyroniteState();
        AlienActivationHandler.resetEctonuriteState();
        AlienActivationHandler.resetLepidopterranState();
        AlienActivationHandler.resetGalvanState();
        AlienActivationHandler.resetPisccissVolannBiteState();
        AlienActivationHandler.resetBothHandsState();
        AlienActivationHandler.resetGalvanicMechamorphState();
        AlienActivationHandler.resetKineceleranState();
    }

    private static void resetPyroniteState() {
        if (isPyroniteFlying) {
            isPyroniteFlying = false;
            flightTransitionBuffer = 3;
            AlienFirstPersonMod.LOGGER.debug("Pyronite no longer flying - starting transition");
            AlienActivationHandler.handlePyroniteVanillaHands(false);
        }
    }

    private static void resetLepidopterranState() {
        if (isLepidopterranFlying) {
            isLepidopterranFlying = false;
            flightTransitionBuffer = 3;
            AlienFirstPersonMod.LOGGER.debug("Lepidopterran no longer flying - starting transition");
        }
    }

    private static void resetEctonuriteState() {
        if (isEctonuriteFlying) {
            isEctonuriteFlying = false;
            flightTransitionBuffer = 3;
            AlienFirstPersonMod.LOGGER.debug("Ectonurite no longer flying - starting transition");
        }
    }

    private static void resetGalvanState() {
        if (isGalvanFlying) {
            isGalvanFlying = false;
            flightTransitionBuffer = 3;
            AlienFirstPersonMod.LOGGER.debug("Galvan no longer flying - starting transition");
        }
        lastGalvanState = null;
    }

    private static void resetPisccissVolannBiteState() {
        if (isPisccissVolannBiting || biteAnimationBuffer > 0) {
            isPisccissVolannBiting = false;
            biteAnimationBuffer = 0;
            AlienFirstPersonMod.LOGGER.debug("Piscciss Volann bite state reset");
        }
    }

    private static void resetBothHandsState() {
        if (isBothHandsActive) {
            isBothHandsActive = false;
            if (AlienFirstPersonMod.isOmnitrixControlling) {
                AlienFirstPersonMod.isOmnitrixControlling = false;
                FirstPersonModelCore.instance.setEnabled(AlienFirstPersonMod.savedStateBeforeOmnitrix);
                AlienFirstPersonMod.LOGGER.debug("Both hands deactivated - restored first person to: {}", (Object)AlienFirstPersonMod.savedStateBeforeOmnitrix);
            }
        }
    }

    private static void resetGalvanicMechamorphState() {
        if (isGalvanicMechamorphGliding) {
            isGalvanicMechamorphGliding = false;
            glideTransitionBuffer = 4;
            AlienFirstPersonMod.LOGGER.debug("Galvanic Mechamorph no longer gliding - starting transition");
        }
        lastGalvanicMechamorphState = null;
    }

    private static void resetKineceleranState() {
        if (isKineceleranSkating) {
            isKineceleranSkating = false;
            AlienFirstPersonMod.LOGGER.debug("Kineceleran skate state reset");
        }
        if (isKineceleranSpeedActive) {
            isKineceleranSpeedActive = false;
            AlienFirstPersonMod.LOGGER.debug("Kineceleran speed state reset");
        }
        lastKineceleranState = null;
    }

    private static boolean isLepidopterranWingsDisabled(LocalPlayer player) {
        try {
            Scoreboard scoreboard = player.m_36329_();
            Objective noWingsObj = scoreboard.m_83477_("AlienEvo.NoWings");
            if (noWingsObj != null) {
                int score = scoreboard.m_83471_(player.m_6302_(), noWingsObj).m_83400_();
                return score > 0;
            }
        }
        catch (Exception e) {
            AlienFirstPersonMod.LOGGER.debug("Error checking AlienEvo.NoWings: {}", (Object)e.getMessage());
        }
        return false;
    }

    private static boolean isPyroniteExtinguished(LocalPlayer player) {
        try {
            Scoreboard scoreboard = player.m_36329_();
            Objective extinguishObj = scoreboard.m_83477_("Pyronite.Extinguish");
            if (extinguishObj != null) {
                int score = scoreboard.m_83471_(player.m_6302_(), extinguishObj).m_83400_();
                return score > 0;
            }
        }
        catch (Exception e) {
            AlienFirstPersonMod.LOGGER.debug("Error checking Pyronite.Extinguish: {}", (Object)e.getMessage());
        }
        return false;
    }
}

