/*
 * Decompiled with CFR 0.152.
 */
package com.parad.alienfirstperson;

import com.mojang.blaze3d.platform.InputConstants;
import com.parad.alienfirstperson.AlienActivationHandler;
import com.parad.alienfirstperson.AlienFirstPersonMod;
import com.parad.alienfirstperson.AlienOffsetManager;
import com.parad.alienfirstperson.config.AlienFirstPersonConfig;
import dev.tr7zw.firstperson.FirstPersonModelCore;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="alien_first_person", value={Dist.CLIENT})
public class AlienFirstPersonKeybinds {
    public static KeyMapping toggleFirstPersonKey;

    public static void register(RegisterKeyMappingsEvent event) {
        toggleFirstPersonKey = new KeyMapping("key.alien_first_person.toggle_current_form", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM, 295, "key.categories.alien_first_person");
        event.register(toggleFirstPersonKey);
        MinecraftForge.EVENT_BUS.register((Object)new KeyInputHandler());
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class KeyInputHandler {
        @SubscribeEvent
        public void onKeyInput(InputEvent.Key event) {
            if (Minecraft.m_91087_().f_91074_ == null || Minecraft.m_91087_().f_91080_ != null) {
                return;
            }
            if (toggleFirstPersonKey.m_90859_()) {
                String currentAlien = AlienOffsetManager.getCurrentAlienForm();
                if (currentAlien == null) {
                    AlienFirstPersonMod.LOGGER.debug("Human form detected - letting First Person Model handle F6");
                    return;
                }
                if ("custom_alien".equals(currentAlien) || !AlienOffsetManager.SUPPORTED_ALIENS.contains(currentAlien)) {
                    AlienFirstPersonMod.LOGGER.debug("Custom/unsupported alien ({}) - F7 toggle disabled", (Object)currentAlien);
                    return;
                }
                this.toggleCurrentFormFirstPerson();
            }
        }

        private void toggleCurrentFormFirstPerson() {
            String currentAlien = AlienOffsetManager.getCurrentAlienForm();
            if (currentAlien == null) {
                return;
            }
            boolean newValue = this.toggleAlienConfig(currentAlien);
            AlienFirstPersonMod.LOGGER.debug("Toggled first person for {} form: {}", (Object)currentAlien, (Object)newValue);
            if (!newValue && FirstPersonModelCore.instance.isEnabled()) {
                FirstPersonModelCore.instance.setEnabled(false);
            } else if (newValue && !FirstPersonModelCore.instance.isEnabled() && !AlienActivationHandler.shouldForceDisableFirstPerson()) {
                FirstPersonModelCore.instance.setEnabled(true);
            }
            try {
                AlienFirstPersonConfig.CLIENT_SPEC.save();
            }
            catch (Exception e) {
                AlienFirstPersonMod.LOGGER.error("Failed to save config after toggle", (Throwable)e);
            }
        }

        private boolean toggleAlienConfig(String alienForm) {
            boolean newValue = true;
            switch (alienForm) {
                case "pyronite": {
                    newValue = (Boolean)AlienFirstPersonConfig.PYRONITE_FIRST_PERSON_ENABLED.get() == false;
                    AlienFirstPersonConfig.PYRONITE_FIRST_PERSON_ENABLED.set((Object)newValue);
                    break;
                }
                case "vulpimancer": {
                    newValue = (Boolean)AlienFirstPersonConfig.VULPIMANCER_FIRST_PERSON_ENABLED.get() == false;
                    AlienFirstPersonConfig.VULPIMANCER_FIRST_PERSON_ENABLED.set((Object)newValue);
                    break;
                }
                case "petrosapien": {
                    newValue = (Boolean)AlienFirstPersonConfig.PETROSAPIEN_FIRST_PERSON_ENABLED.get() == false;
                    AlienFirstPersonConfig.PETROSAPIEN_FIRST_PERSON_ENABLED.set((Object)newValue);
                    break;
                }
                case "kineceleran": {
                    newValue = (Boolean)AlienFirstPersonConfig.KINECELERAN_FIRST_PERSON_ENABLED.get() == false;
                    AlienFirstPersonConfig.KINECELERAN_FIRST_PERSON_ENABLED.set((Object)newValue);
                    break;
                }
                case "galvan": {
                    newValue = (Boolean)AlienFirstPersonConfig.GALVAN_FIRST_PERSON_ENABLED.get() == false;
                    AlienFirstPersonConfig.GALVAN_FIRST_PERSON_ENABLED.set((Object)newValue);
                    break;
                }
                case "tetramand": {
                    newValue = (Boolean)AlienFirstPersonConfig.TETRAMAND_FIRST_PERSON_ENABLED.get() == false;
                    AlienFirstPersonConfig.TETRAMAND_FIRST_PERSON_ENABLED.set((Object)newValue);
                    break;
                }
                case "lepidopterran": {
                    newValue = (Boolean)AlienFirstPersonConfig.LEPIDOPTERRAN_FIRST_PERSON_ENABLED.get() == false;
                    AlienFirstPersonConfig.LEPIDOPTERRAN_FIRST_PERSON_ENABLED.set((Object)newValue);
                    break;
                }
                case "piscciss_volann": {
                    newValue = (Boolean)AlienFirstPersonConfig.PISCCISS_VOLANN_FIRST_PERSON_ENABLED.get() == false;
                    AlienFirstPersonConfig.PISCCISS_VOLANN_FIRST_PERSON_ENABLED.set((Object)newValue);
                    break;
                }
                case "galvanic_mechamorph": {
                    newValue = (Boolean)AlienFirstPersonConfig.GALVANIC_MECHAMORPH_FIRST_PERSON_ENABLED.get() == false;
                    AlienFirstPersonConfig.GALVANIC_MECHAMORPH_FIRST_PERSON_ENABLED.set((Object)newValue);
                    break;
                }
                case "ectonurite": {
                    newValue = (Boolean)AlienFirstPersonConfig.ECTONURITE_FIRST_PERSON_ENABLED.get() == false;
                    AlienFirstPersonConfig.ECTONURITE_FIRST_PERSON_ENABLED.set((Object)newValue);
                    break;
                }
                case "arburian_pelarota": {
                    newValue = (Boolean)AlienFirstPersonConfig.ARBURIAN_PELAROTA_FIRST_PERSON_ENABLED.get() == false;
                    AlienFirstPersonConfig.ARBURIAN_PELAROTA_FIRST_PERSON_ENABLED.set((Object)newValue);
                    break;
                }
                case "methanosian": 
                case "sonorosian": 
                case "vaxasaurian": 
                case "aerophibian": 
                case "necrofriggian": 
                case "crystalsapien": 
                case "nucleonix": 
                case "dragonoid": 
                case "custom_alien": {
                    newValue = (Boolean)AlienFirstPersonConfig.CUSTOM_ALIENS_FIRST_PERSON_ENABLED.get() == false;
                    AlienFirstPersonConfig.CUSTOM_ALIENS_FIRST_PERSON_ENABLED.set((Object)newValue);
                    break;
                }
                default: {
                    newValue = (Boolean)AlienFirstPersonConfig.CUSTOM_ALIENS_FIRST_PERSON_ENABLED.get() == false;
                    AlienFirstPersonConfig.CUSTOM_ALIENS_FIRST_PERSON_ENABLED.set((Object)newValue);
                }
            }
            return newValue;
        }
    }
}

