/*
 * Decompiled with CFR 0.152.
 */
package com.parad.alienfirstperson;

import com.parad.alienfirstperson.AlienActivationHandler;
import com.parad.alienfirstperson.AlienFirstPersonKeybinds;
import com.parad.alienfirstperson.AlienOffsetManager;
import com.parad.alienfirstperson.AlienSoundEvents;
import com.parad.alienfirstperson.AlienStateHandler;
import com.parad.alienfirstperson.NEAConfigManager;
import com.parad.alienfirstperson.PaperDollKeybindKiller;
import com.parad.alienfirstperson.PaperDollToggleManager;
import com.parad.alienfirstperson.config.AlienFirstPersonConfig;
import com.parad.alienfirstperson.config.AlienFirstPersonConfigScreen;
import dev.tr7zw.firstperson.FirstPersonModelCore;
import dev.tr7zw.firstperson.api.FirstPersonAPI;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="alien_first_person")
public class AlienFirstPersonMod {
    public static final String MODID = "alien_first_person";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"alien_first_person");
    private static boolean forcingDisabled = false;
    private static boolean paperDollInitialized = false;
    private static String lastWarnedAlien = null;
    private static String previousAlienForm = null;
    private static boolean isInAlienForm = false;
    private static boolean previousFirstPersonEnabled = false;
    public static boolean savedStateBeforeOmnitrix = true;
    public static boolean isOmnitrixControlling = false;
    private static int tickCounter = 0;
    private static int loginGracePeriod = 0;
    private static int transformGracePeriod = 0;

    public AlienFirstPersonMod() {
        if (FMLEnvironment.dist == Dist.CLIENT) {
            LOGGER.info("Alien First Person Mod initializing...");
            IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
            AlienSoundEvents.register(modEventBus);
            LOGGER.info("Sound events registered");
            AlienFirstPersonConfig.register();
            LOGGER.info("Config registered");
            AlienFirstPersonConfigScreen.register();
            modEventBus.addListener(this::onClientSetup);
            modEventBus.addListener(AlienFirstPersonKeybinds::register);
            modEventBus.register(PaperDollKeybindKiller.ModBusEvents.class);
            MinecraftForge.EVENT_BUS.register((Object)this);
            MinecraftForge.EVENT_BUS.register(PaperDollToggleManager.class);
            MinecraftForge.EVENT_BUS.register(PaperDollKeybindKiller.class);
            MinecraftForge.EVENT_BUS.register(NEAConfigManager.class);
        }
    }

    private void onClientSetup(FMLClientSetupEvent event) {
        LOGGER.info("Alien First Person Mod client setup");
        FirstPersonAPI.registerPlayerHandler((Object)new AlienOffsetManager());
        FirstPersonAPI.registerPlayerHandler((Object)new AlienActivationHandler());
        NEAConfigManager.onClientSetup(event);
        try {
            Class.forName("virtuoel.pehkui.api.ScaleTypes");
            LOGGER.info("Pehkui detected - using scale-based offsets");
        }
        catch (ClassNotFoundException e) {
            LOGGER.info("Pehkui not found - using default offsets");
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && Minecraft.m_91087_().f_91074_ != null) {
            boolean alienToAlienTransform;
            boolean isActuallyInAlienForm;
            ++tickCounter;
            if (!paperDollInitialized) {
                PaperDollToggleManager.ensurePaperDollInvisibleByDefault();
                paperDollInitialized = true;
            }
            AlienOffsetManager.updateAlienState((AbstractClientPlayer)Minecraft.m_91087_().f_91074_, Minecraft.m_91087_().getPartialTick());
            Object currentAlien = AlienOffsetManager.getCurrentAlienForm();
            if (FirstPersonModelCore.instance != null) {
                boolean currentlyEnabled = FirstPersonModelCore.instance.isEnabled();
                if (currentlyEnabled && !previousFirstPersonEnabled && currentAlien != null && ((Boolean)AlienFirstPersonConfig.HAS_STORED_HUMAN_SETTINGS.get()).booleanValue()) {
                    LOGGER.info("First person manually enabled - applying alien settings immediately for: {}", currentAlien);
                    AlienStateHandler.applyAlienFPMSettings((String)currentAlien);
                }
                previousFirstPersonEnabled = currentlyEnabled;
            }
            if ((isActuallyInAlienForm = AlienOffsetManager.isInAlienForm()) && previousAlienForm == null && transformGracePeriod == 0) {
                transformGracePeriod = 8;
                LOGGER.debug("Started transform grace period for human-to-alien transformation");
            }
            if (currentAlien == null && isActuallyInAlienForm) {
                currentAlien = previousAlienForm != null && tickCounter % 20 < 10 ? previousAlienForm : (loginGracePeriod > 0 ? null : (transformGracePeriod > 0 ? null : "custom_alien"));
            }
            if (loginGracePeriod > 0) {
                --loginGracePeriod;
            }
            if (transformGracePeriod > 0) {
                --transformGracePeriod;
            }
            boolean justTransformedToAlien = currentAlien != null && previousAlienForm == null;
            boolean justTransformedToHuman = currentAlien == null && previousAlienForm != null;
            boolean bl = alienToAlienTransform = currentAlien != null && previousAlienForm != null && !((String)currentAlien).equals(previousAlienForm);
            if (justTransformedToAlien) {
                isInAlienForm = true;
                transformGracePeriod = 0;
                if (!isOmnitrixControlling) {
                    AlienStateHandler.storeHumanSettings();
                }
                AlienStateHandler.applyAlienFPMSettings((String)currentAlien);
                LOGGER.info("Transformed to alien: {}", currentAlien);
            } else if (alienToAlienTransform) {
                transformGracePeriod = 0;
                AlienStateHandler.applyAlienFPMSettings((String)currentAlien);
                LOGGER.info("Transformed from {} to {}", (Object)previousAlienForm, currentAlien);
            } else if (justTransformedToHuman) {
                isInAlienForm = false;
                transformGracePeriod = 0;
                AlienStateHandler.restoreHumanSettings();
                LOGGER.info("Transformed back to human - settings restored");
            }
            AlienActivationHandler.updateAlienStates(Minecraft.m_91087_().f_91074_);
            boolean isUnsupportedAlien = false;
            if (currentAlien != null) {
                boolean treatAsCustomAlien = "custom_alien".equals(currentAlien) || !AlienOffsetManager.SUPPORTED_ALIENS.contains(currentAlien);
                boolean bl2 = isUnsupportedAlien = treatAsCustomAlien && (Boolean)AlienFirstPersonConfig.CUSTOM_ALIENS_FIRST_PERSON_ENABLED.get() == false;
            }
            if (isUnsupportedAlien && !Objects.equals(currentAlien, lastWarnedAlien)) {
                lastWarnedAlien = currentAlien;
                LOGGER.warn("Unsupported alien detected: {} - disabling first person model for compatibility.", currentAlien);
                if (Minecraft.m_91087_().f_91074_ != null) {
                    Minecraft.m_91087_().f_91074_.m_213846_((Component)Component.m_237113_((String)("\u00a7e[Alien First Person] \u00a7fUnsupported alien detected: " + (String)currentAlien + " - first person disabled for compatibility. Custom Alien compatibility coming soon!")));
                }
            } else if (!isUnsupportedAlien) {
                lastWarnedAlien = null;
            }
            if (currentAlien != null) {
                if (isUnsupportedAlien) {
                    if (FirstPersonModelCore.instance != null && FirstPersonModelCore.instance.isEnabled()) {
                        FirstPersonModelCore.instance.setEnabled(false);
                        if (tickCounter % 20 == 0) {
                            LOGGER.debug("Enforcing first person DISABLED for unsupported alien: {}", currentAlien);
                        }
                    }
                    forcingDisabled = true;
                } else {
                    boolean wantFirstPersonOn;
                    boolean shouldForceDisable = AlienActivationHandler.shouldForceDisableFirstPerson();
                    boolean shouldBeEnabled = AlienStateHandler.getAlienFirstPersonEnabled((String)currentAlien);
                    boolean bl3 = wantFirstPersonOn = !shouldForceDisable && shouldBeEnabled;
                    if (FirstPersonModelCore.instance != null) {
                        boolean currentlyOn = FirstPersonModelCore.instance.isEnabled();
                        if (wantFirstPersonOn && !currentlyOn) {
                            FirstPersonModelCore.instance.setEnabled(true);
                            AlienStateHandler.applyAlienFPMSettings((String)currentAlien);
                            if (tickCounter % 20 == 0) {
                                LOGGER.debug("Enforcing first person ENABLED for {}", currentAlien);
                            }
                        } else if (!wantFirstPersonOn && currentlyOn) {
                            FirstPersonModelCore.instance.setEnabled(false);
                            if (tickCounter % 20 == 0) {
                                LOGGER.debug("Enforcing first person DISABLED for {}", currentAlien);
                            }
                        } else if (wantFirstPersonOn && currentlyOn && tickCounter % 100 == 0) {
                            AlienStateHandler.applyAlienFPMSettings((String)currentAlien);
                        }
                    }
                    forcingDisabled = !wantFirstPersonOn;
                }
            } else if (!isInAlienForm) {
                if (isOmnitrixControlling) {
                    if (((Boolean)AlienFirstPersonConfig.DISABLE_FIRST_PERSON_ON_OMNITRIX.get()).booleanValue() && FirstPersonModelCore.instance != null && FirstPersonModelCore.instance.isEnabled()) {
                        FirstPersonModelCore.instance.setEnabled(false);
                        LOGGER.debug("Omnitrix active - first person disabled");
                    }
                } else if (FirstPersonModelCore.instance != null && ((Boolean)AlienFirstPersonConfig.HAS_STORED_HUMAN_SETTINGS.get()).booleanValue()) {
                    AlienStateHandler.checkAndUpdateHumanSettings();
                }
                forcingDisabled = false;
            }
            previousAlienForm = currentAlien;
        }
    }

    @SubscribeEvent
    public void onPlayerLogin(ClientPlayerNetworkEvent.LoggingIn event) {
        LOGGER.info("Player joining world");
        AlienOffsetManager.resetDetectionState();
        forcingDisabled = false;
        isInAlienForm = false;
        previousAlienForm = null;
        isOmnitrixControlling = false;
        tickCounter = 0;
        previousFirstPersonEnabled = false;
        loginGracePeriod = 30;
        Minecraft.m_91087_().execute(() -> {
            if (Minecraft.m_91087_().f_91074_ != null) {
                String currentAlien = AlienOffsetManager.getCurrentAlienForm();
                if (currentAlien == null) {
                    if (!((Boolean)AlienFirstPersonConfig.HAS_STORED_HUMAN_SETTINGS.get()).booleanValue()) {
                        AlienStateHandler.storeHumanSettings();
                        LOGGER.info("First login as human - stored baseline FPM settings");
                    } else {
                        AlienStateHandler.restoreHumanSettings();
                        LOGGER.info("Logged in as human - restored settings (omnitrix state cleared)");
                    }
                } else {
                    AlienStateHandler.restoreHumanSettings();
                    AlienStateHandler.applyAlienFPMSettings(currentAlien);
                    isInAlienForm = true;
                    previousAlienForm = currentAlien;
                    LOGGER.info("Logged in as alien {} - applied alien settings", (Object)currentAlien);
                }
            }
        });
    }

    @SubscribeEvent
    public void onPlayerLogout(ClientPlayerNetworkEvent.LoggingOut event) {
        LOGGER.info("Player leaving world");
        if (isInAlienForm && event.getPlayer() != null) {
            AlienStateHandler.restoreHumanSettings();
            LOGGER.info("Logging out as alien - restored human settings to FPM config before save");
        }
        if (event.getPlayer() != null) {
            AlienOffsetManager.resetScaling((AbstractClientPlayer)event.getPlayer());
            AlienOffsetManager.resetDetectionState();
        }
        forcingDisabled = false;
        paperDollInitialized = false;
        isInAlienForm = false;
        previousAlienForm = null;
        isOmnitrixControlling = false;
        tickCounter = 0;
        lastWarnedAlien = null;
        previousFirstPersonEnabled = false;
        loginGracePeriod = 0;
        transformGracePeriod = 0;
    }
}

