/*
 * Decompiled with CFR 0.152.
 */
package com.parad.alienfirstperson;

import com.parad.alienfirstperson.AlienActivationHandler;
import com.parad.alienfirstperson.AlienFirstPersonMod;
import com.parad.alienfirstperson.config.AlienFirstPersonConfig;
import com.parad.alienfirstperson.config.ConfigChangeManager;
import dev.tr7zw.firstperson.api.PlayerOffsetHandler;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.Scoreboard;
import net.threetag.palladium.power.ability.AbilityInstance;
import net.threetag.palladium.power.ability.AbilityUtil;
import net.threetag.palladium.power.ability.NameChangeAbility;
import virtuoel.pehkui.api.ScaleData;
import virtuoel.pehkui.api.ScaleTypes;

public class AlienOffsetManager
implements PlayerOffsetHandler {
    private static final float BASE_OFFSET = 0.25f;
    private static final float SNEAK_OFFSET = 0.25f;
    private static final float SWIM_UP_OFFSET = 0.6f;
    private static final float SWIM_DOWN_OFFSET = 0.65f;
    private static final Map<String, Float> FORCED_SCALES = new HashMap<String, Float>();
    public static final Set<String> SUPPORTED_ALIENS = new HashSet<String>(Arrays.asList("pyronite", "vulpimancer", "petrosapien", "kineceleran", "galvan", "tetramand", "lepidopterran", "piscciss_volann", "galvanic_mechamorph", "ectonurite", "arburian_pelarota"));
    private static final Map<String, Float> EXTRA_FORWARD_MULTIPLIER = new HashMap<String, Float>();
    private static final Map<String, Float> SWIMMING_FORWARD_MULTIPLIER = new HashMap<String, Float>();
    private static final float BITE_FORWARD_OFFSET = 1.2f;
    private static final float PYRONITE_FLIGHT_FORWARD_OFFSET = 1.6f;
    private static final float KINECELERAN_SKATE_FORWARD_OFFSET = 0.8f;
    private static final float KINECELERAN_SPEED_FORWARD_OFFSET = 0.8f;
    private static float currentBiteOffset = 0.0f;
    private static final float BITE_SMOOTHING_SPEED = 0.45f;
    private static float currentKineceleranOffset = 0.0f;
    private static final float KINECELERAN_SMOOTHING_SPEED = 0.75f;
    public static final Map<Integer, String> ALIEN_ID_MAP = new HashMap<Integer, String>();
    public static final Map<String, String> TAG_TO_ALIEN_MAP = new HashMap<String, String>();
    private static final Map<String, String> POWER_TO_ALIEN_MAP = new HashMap<String, String>();
    private static final Map<UUID, PlayerState> playerStates = new HashMap<UUID, PlayerState>();

    private static PlayerState getPlayerState(UUID playerId) {
        return playerStates.computeIfAbsent(playerId, k -> new PlayerState());
    }

    private static float smoothBiteOffset(boolean isBiting, float targetOffset, float normalOffset) {
        float target;
        float f = target = isBiting ? targetOffset : normalOffset;
        currentBiteOffset = Math.abs(currentBiteOffset - target) > 0.01f ? (currentBiteOffset += (target - currentBiteOffset) * 0.45f) : target;
        return currentBiteOffset;
    }

    private static float smoothKineceleranOffset(float targetOffset) {
        currentKineceleranOffset = Math.abs(currentKineceleranOffset - targetOffset) > 0.01f ? (currentKineceleranOffset += (targetOffset - currentKineceleranOffset) * 0.75f) : targetOffset;
        return currentKineceleranOffset;
    }

    public static boolean isFirstPersonEnabledForAlien(String alienForm) {
        if (alienForm == null) {
            return true;
        }
        switch (alienForm) {
            case "pyronite": {
                return (Boolean)AlienFirstPersonConfig.PYRONITE_FIRST_PERSON_ENABLED.get();
            }
            case "vulpimancer": {
                return (Boolean)AlienFirstPersonConfig.VULPIMANCER_FIRST_PERSON_ENABLED.get();
            }
            case "petrosapien": {
                return (Boolean)AlienFirstPersonConfig.PETROSAPIEN_FIRST_PERSON_ENABLED.get();
            }
        }
        return true;
    }

    public Vec3 applyOffset(AbstractClientPlayer entity, float delta, Vec3 original, Vec3 current) {
        if (entity != Minecraft.m_91087_().f_91074_) {
            return current;
        }
        AlienOffsetManager.updateAlienState(entity, delta);
        PlayerState state = AlienOffsetManager.getPlayerState(entity.m_20148_());
        float pehkuiScale = 1.0f;
        try {
            ScaleData scaleData = ScaleTypes.BASE.getScaleData((Entity)entity);
            pehkuiScale = scaleData.getScale(delta);
        }
        catch (Exception scaleData) {
            // empty catch block
        }
        boolean isTransformed = AlienOffsetManager.isInAlienForm();
        if (!isTransformed) {
            if (state.currentAlienForm != null) {
                state.currentAlienForm = null;
            }
            return current;
        }
        if (!isTransformed && state.currentAlienForm == null && Math.abs(pehkuiScale - 1.0f) < 0.01f) {
            return current;
        }
        if ((state.currentAlienForm != null || isTransformed || this.hasPehkuiScaling(entity)) && (Math.abs(pehkuiScale - 1.0f) > 0.01f || state.currentAlienForm != null)) {
            boolean isStillSmoothing;
            float bodyOffset = 0.25f;
            if (entity.m_6047_() || entity.m_20089_() == Pose.CROUCHING) {
                bodyOffset = 0.25f;
            }
            bodyOffset *= pehkuiScale;
            boolean isSwimming = entity.m_6069_() || entity.m_6067_();
            boolean isBiting = false;
            boolean bl = isStillSmoothing = Math.abs(currentBiteOffset) > 0.01f;
            if ("piscciss_volann".equals(state.currentAlienForm) && (AlienActivationHandler.isPisccissVolannCurrentlyBiting() || isStillSmoothing)) {
                isBiting = AlienActivationHandler.isPisccissVolannCurrentlyBiting();
            }
            boolean isPyroniteFlying = false;
            if ("pyronite".equals(state.currentAlienForm) && AlienActivationHandler.isPyroniteCurrentlyFlying()) {
                isPyroniteFlying = true;
                AlienFirstPersonMod.LOGGER.debug("Applying flight forward offset for Pyronite");
            }
            boolean isKineceleranSkating = false;
            if ("kineceleran".equals(state.currentAlienForm) && (AlienActivationHandler.isKineceleranCurrentlySkating() || AlienActivationHandler.isKineceleranInTransition())) {
                isKineceleranSkating = true;
                AlienFirstPersonMod.LOGGER.debug("Applying skate forward offset for Kineceleran (active or transitioning)");
            }
            boolean isKineceleranSpeedBoosted = false;
            if ("kineceleran".equals(state.currentAlienForm) && AlienActivationHandler.isKineceleranCurrentlySpeedBoosted()) {
                isKineceleranSpeedBoosted = true;
                AlienFirstPersonMod.LOGGER.debug("Applying speed forward offset for Kineceleran");
            }
            if (state.currentAlienForm != null) {
                float normalAlienOffset = bodyOffset;
                if (!isSwimming && EXTRA_FORWARD_MULTIPLIER.containsKey(state.currentAlienForm)) {
                    normalAlienOffset *= EXTRA_FORWARD_MULTIPLIER.get(state.currentAlienForm).floatValue();
                }
                if ("piscciss_volann".equals(state.currentAlienForm) && isStillSmoothing && !isBiting) {
                    float smoothedOffset;
                    ConfigChangeManager manager = ConfigChangeManager.getInstance();
                    float normalOffsetWithConfig = bodyOffset;
                    if (EXTRA_FORWARD_MULTIPLIER.containsKey(state.currentAlienForm)) {
                        int xAdjustment = entity.m_6047_() ? ((Integer)manager.getPendingOrCurrentValue("piscciss_volann.sneakingXOffset", AlienFirstPersonConfig.PISCCISS_VOLANN_SNEAKING_X_OFFSET)).intValue() : ((Integer)manager.getPendingOrCurrentValue("piscciss_volann.standingXOffset", AlienFirstPersonConfig.PISCCISS_VOLANN_STANDING_X_OFFSET)).intValue();
                        float multiplier = EXTRA_FORWARD_MULTIPLIER.get(state.currentAlienForm).floatValue() + (float)xAdjustment * 0.03f;
                        normalOffsetWithConfig *= multiplier;
                    }
                    bodyOffset = smoothedOffset = AlienOffsetManager.smoothBiteOffset(false, 0.0f, normalOffsetWithConfig);
                    AlienFirstPersonMod.LOGGER.debug("Bite smoothing back: current={}", (Object)Float.valueOf(smoothedOffset));
                } else if (isBiting) {
                    float smoothedOffset;
                    ConfigChangeManager manager = ConfigChangeManager.getInstance();
                    float baseBiteOffset = 1.2f * pehkuiScale;
                    int xAdjustment = entity.m_6047_() ? ((Integer)manager.getPendingOrCurrentValue("piscciss_volann.sneakingXOffset", AlienFirstPersonConfig.PISCCISS_VOLANN_SNEAKING_X_OFFSET)).intValue() : ((Integer)manager.getPendingOrCurrentValue("piscciss_volann.standingXOffset", AlienFirstPersonConfig.PISCCISS_VOLANN_STANDING_X_OFFSET)).intValue();
                    float targetBiteOffset = baseBiteOffset + (float)xAdjustment * 0.03f;
                    float normalOffsetWithConfig = bodyOffset;
                    if (EXTRA_FORWARD_MULTIPLIER.containsKey(state.currentAlienForm)) {
                        float multiplier = EXTRA_FORWARD_MULTIPLIER.get(state.currentAlienForm).floatValue() + (float)xAdjustment * 0.03f;
                        normalOffsetWithConfig *= multiplier;
                    }
                    bodyOffset = smoothedOffset = AlienOffsetManager.smoothBiteOffset(true, targetBiteOffset, normalOffsetWithConfig);
                    AlienFirstPersonMod.LOGGER.debug("Bite offset with config: current={}, target={}", (Object)Float.valueOf(smoothedOffset), (Object)Float.valueOf(targetBiteOffset));
                } else if (isPyroniteFlying) {
                    bodyOffset = 1.6f * pehkuiScale;
                } else if (isKineceleranSkating) {
                    float smoothedOffset;
                    float baseSkateOffset = 0.8f * pehkuiScale;
                    ConfigChangeManager manager = ConfigChangeManager.getInstance();
                    int xAdjustment = entity.m_6047_() ? ((Integer)manager.getPendingOrCurrentValue("kineceleran.skate.sneakingXOffset", AlienFirstPersonConfig.KINECELERAN_SKATE_SNEAKING_X_OFFSET)).intValue() : ((Integer)manager.getPendingOrCurrentValue("kineceleran.skate.standingXOffset", AlienFirstPersonConfig.KINECELERAN_SKATE_STANDING_X_OFFSET)).intValue();
                    float adjustedOffset = baseSkateOffset + (float)xAdjustment * 0.03f;
                    bodyOffset = smoothedOffset = AlienOffsetManager.smoothKineceleranOffset(adjustedOffset);
                    AlienFirstPersonMod.LOGGER.debug("Kineceleran skate offset: current={}, target={}", (Object)Float.valueOf(smoothedOffset), (Object)Float.valueOf(adjustedOffset));
                } else if (isKineceleranSpeedBoosted) {
                    float smoothedOffset;
                    float baseSpeedOffset = 0.8f * pehkuiScale;
                    ConfigChangeManager manager = ConfigChangeManager.getInstance();
                    int xAdjustment = entity.m_6047_() ? ((Integer)manager.getPendingOrCurrentValue("kineceleran.speed.sneakingXOffset", AlienFirstPersonConfig.KINECELERAN_SPEED_SNEAKING_X_OFFSET)).intValue() : ((Integer)manager.getPendingOrCurrentValue("kineceleran.speed.standingXOffset", AlienFirstPersonConfig.KINECELERAN_SPEED_STANDING_X_OFFSET)).intValue();
                    float adjustedOffset = baseSpeedOffset + (float)xAdjustment * 0.03f;
                    bodyOffset = smoothedOffset = AlienOffsetManager.smoothKineceleranOffset(adjustedOffset);
                    AlienFirstPersonMod.LOGGER.debug("Kineceleran speed offset: current={}, target={}", (Object)Float.valueOf(smoothedOffset), (Object)Float.valueOf(adjustedOffset));
                } else if (isSwimming && SWIMMING_FORWARD_MULTIPLIER.containsKey(state.currentAlienForm)) {
                    float pitch = entity.m_146909_();
                    float baseSwimOffset = pitch > 0.0f ? 0.6f : 0.65f;
                    bodyOffset = baseSwimOffset * pehkuiScale * SWIMMING_FORWARD_MULTIPLIER.get(state.currentAlienForm).floatValue();
                    AlienFirstPersonMod.LOGGER.debug("Using swimming offset for {}: {} (pitch: {})", new Object[]{state.currentAlienForm, SWIMMING_FORWARD_MULTIPLIER.get(state.currentAlienForm), Float.valueOf(pitch)});
                } else if ("kineceleran".equals(state.currentAlienForm) && Math.abs(currentKineceleranOffset - bodyOffset * EXTRA_FORWARD_MULTIPLIER.get(state.currentAlienForm).floatValue()) > 0.01f) {
                    float smoothedOffset;
                    float normalOffset = bodyOffset * EXTRA_FORWARD_MULTIPLIER.get(state.currentAlienForm).floatValue();
                    bodyOffset = smoothedOffset = AlienOffsetManager.smoothKineceleranOffset(normalOffset);
                    AlienFirstPersonMod.LOGGER.debug("Kineceleran smoothing to normal: current={}", (Object)Float.valueOf(smoothedOffset));
                } else if (!isSwimming && EXTRA_FORWARD_MULTIPLIER.containsKey(state.currentAlienForm)) {
                    float multiplier = EXTRA_FORWARD_MULTIPLIER.get(state.currentAlienForm).floatValue();
                    if ("pyronite".equals(state.currentAlienForm)) {
                        ConfigChangeManager manager = ConfigChangeManager.getInstance();
                        int xAdjustment = entity.m_6047_() ? ((Integer)manager.getPendingOrCurrentValue("pyronite.sneakingXOffset", AlienFirstPersonConfig.PYRONITE_SNEAKING_X_OFFSET)).intValue() : ((Integer)manager.getPendingOrCurrentValue("pyronite.standingXOffset", AlienFirstPersonConfig.PYRONITE_STANDING_X_OFFSET)).intValue();
                        multiplier += (float)xAdjustment * 0.03f;
                    } else if ("vulpimancer".equals(state.currentAlienForm)) {
                        ConfigChangeManager manager = ConfigChangeManager.getInstance();
                        int xAdjustment = entity.m_6047_() ? ((Integer)manager.getPendingOrCurrentValue("vulpimancer.sneakingXOffset", AlienFirstPersonConfig.VULPIMANCER_SNEAKING_X_OFFSET)).intValue() : ((Integer)manager.getPendingOrCurrentValue("vulpimancer.standingXOffset", AlienFirstPersonConfig.VULPIMANCER_STANDING_X_OFFSET)).intValue();
                        multiplier += (float)xAdjustment * 0.03f;
                    } else if ("kineceleran".equals(state.currentAlienForm)) {
                        ConfigChangeManager manager = ConfigChangeManager.getInstance();
                        if (!isKineceleranSkating && !isKineceleranSpeedBoosted) {
                            int xAdjustment = entity.m_6047_() ? ((Integer)manager.getPendingOrCurrentValue("kineceleran.sneakingXOffset", AlienFirstPersonConfig.KINECELERAN_SNEAKING_X_OFFSET)).intValue() : ((Integer)manager.getPendingOrCurrentValue("kineceleran.standingXOffset", AlienFirstPersonConfig.KINECELERAN_STANDING_X_OFFSET)).intValue();
                            multiplier += (float)xAdjustment * 0.03f;
                        }
                    } else if ("petrosapien".equals(state.currentAlienForm)) {
                        boolean hasBattleMode = false;
                        boolean hasShieldActive = false;
                        try {
                            Collection allAbilities = AbilityUtil.getInstances((LivingEntity)entity);
                            if (allAbilities != null && !allAbilities.isEmpty()) {
                                for (AbilityInstance ability : allAbilities) {
                                    if (ability == null || !ability.isEnabled()) continue;
                                    String abilityId = ability.getConfiguration().getId();
                                    if ("battle_mode".equals(abilityId)) {
                                        hasBattleMode = true;
                                    }
                                    if (!"shield_activate".equals(abilityId)) continue;
                                    hasShieldActive = true;
                                }
                            }
                        }
                        catch (Exception e) {
                            AlienFirstPersonMod.LOGGER.debug("Error checking petrosapien abilities: {}", (Object)e.getMessage());
                        }
                        ConfigChangeManager manager = ConfigChangeManager.getInstance();
                        if (hasShieldActive && ((Boolean)manager.getPendingOrCurrentValue("petrosapien.shield.firstPersonEnabled", AlienFirstPersonConfig.PETROSAPIEN_SHIELD_FIRST_PERSON_ENABLED)).booleanValue()) {
                            xAdjustment = entity.m_6047_() ? ((Integer)manager.getPendingOrCurrentValue("petrosapien.sneakingXOffset", AlienFirstPersonConfig.PETROSAPIEN_SNEAKING_X_OFFSET)).intValue() : ((Integer)manager.getPendingOrCurrentValue("petrosapien.standingXOffset", AlienFirstPersonConfig.PETROSAPIEN_STANDING_X_OFFSET)).intValue();
                            multiplier += (float)xAdjustment * 0.03f;
                        } else if (hasBattleMode && ((Boolean)manager.getPendingOrCurrentValue("petrosapien.battleMode.firstPersonEnabled", AlienFirstPersonConfig.PETROSAPIEN_BATTLE_MODE_FIRST_PERSON_ENABLED)).booleanValue()) {
                            xAdjustment = entity.m_6047_() ? ((Integer)manager.getPendingOrCurrentValue("petrosapien.battleMode.sneakingXOffset", AlienFirstPersonConfig.PETROSAPIEN_BATTLE_MODE_SNEAKING_X_OFFSET)).intValue() : ((Integer)manager.getPendingOrCurrentValue("petrosapien.battleMode.standingXOffset", AlienFirstPersonConfig.PETROSAPIEN_BATTLE_MODE_STANDING_X_OFFSET)).intValue();
                            multiplier += (float)xAdjustment * 0.03f;
                        } else {
                            xAdjustment = entity.m_6047_() ? ((Integer)manager.getPendingOrCurrentValue("petrosapien.sneakingXOffset", AlienFirstPersonConfig.PETROSAPIEN_SNEAKING_X_OFFSET)).intValue() : ((Integer)manager.getPendingOrCurrentValue("petrosapien.standingXOffset", AlienFirstPersonConfig.PETROSAPIEN_STANDING_X_OFFSET)).intValue();
                            multiplier += (float)xAdjustment * 0.03f;
                        }
                    } else if ("galvan".equals(state.currentAlienForm)) {
                        boolean hasGalvanSuit = false;
                        boolean hasGalvanLimbs = false;
                        boolean hasGalvanArmor = false;
                        try {
                            Collection allAbilities = AbilityUtil.getInstances((LivingEntity)entity);
                            if (allAbilities != null && !allAbilities.isEmpty()) {
                                for (AbilityInstance ability : allAbilities) {
                                    if (ability == null || !ability.isEnabled()) continue;
                                    String abilityId = ability.getConfiguration().getId();
                                    if ("galvan_suit".equals(abilityId)) {
                                        hasGalvanSuit = true;
                                        continue;
                                    }
                                    if ("galvan_limbs".equals(abilityId)) {
                                        hasGalvanLimbs = true;
                                        continue;
                                    }
                                    if (!"galvan_armor".equals(abilityId)) continue;
                                    hasGalvanArmor = true;
                                }
                            }
                        }
                        catch (Exception e) {
                            AlienFirstPersonMod.LOGGER.debug("Error checking galvan abilities: {}", (Object)e.getMessage());
                        }
                        ConfigChangeManager manager = ConfigChangeManager.getInstance();
                        if (hasGalvanSuit) {
                            float baseSuitMultiplier = 1.45f;
                            xAdjustment = entity.m_6047_() ? ((Integer)manager.getPendingOrCurrentValue("galvan.suit.sneakingXOffset", AlienFirstPersonConfig.GALVAN_SUIT_SNEAKING_X_OFFSET)).intValue() : ((Integer)manager.getPendingOrCurrentValue("galvan.suit.standingXOffset", AlienFirstPersonConfig.GALVAN_SUIT_STANDING_X_OFFSET)).intValue();
                            float finalSuitMultiplier = baseSuitMultiplier + (float)xAdjustment * 0.03f;
                            bodyOffset *= finalSuitMultiplier;
                            AlienFirstPersonMod.LOGGER.debug("Galvan suit - base: {}, adjustment: {}, final: {}", new Object[]{Float.valueOf(baseSuitMultiplier), xAdjustment, Float.valueOf(finalSuitMultiplier)});
                        } else if (hasGalvanLimbs) {
                            float baseLimbsMultiplier = 0.45f;
                            xAdjustment = entity.m_6047_() ? ((Integer)manager.getPendingOrCurrentValue("galvan.limbs.sneakingXOffset", AlienFirstPersonConfig.GALVAN_LIMBS_SNEAKING_X_OFFSET)).intValue() : ((Integer)manager.getPendingOrCurrentValue("galvan.limbs.standingXOffset", AlienFirstPersonConfig.GALVAN_LIMBS_STANDING_X_OFFSET)).intValue();
                            float finalLimbsMultiplier = baseLimbsMultiplier + (float)xAdjustment * 0.03f;
                            bodyOffset *= finalLimbsMultiplier;
                            AlienFirstPersonMod.LOGGER.debug("Galvan limbs - base: {}, adjustment: {}, final: {}", new Object[]{Float.valueOf(baseLimbsMultiplier), xAdjustment, Float.valueOf(finalLimbsMultiplier)});
                        } else if (hasGalvanArmor) {
                            baseGalvanMultiplier = EXTRA_FORWARD_MULTIPLIER.get("galvan").floatValue();
                            xAdjustment = entity.m_6047_() ? ((Integer)manager.getPendingOrCurrentValue("galvan.sneakingXOffset", AlienFirstPersonConfig.GALVAN_SNEAKING_X_OFFSET)).intValue() : ((Integer)manager.getPendingOrCurrentValue("galvan.standingXOffset", AlienFirstPersonConfig.GALVAN_STANDING_X_OFFSET)).intValue();
                            float finalArmorMultiplier = baseGalvanMultiplier + (float)xAdjustment * 0.03f;
                            bodyOffset *= finalArmorMultiplier;
                            AlienFirstPersonMod.LOGGER.debug("Galvan armor - using base galvan config with multiplier: {}", (Object)Float.valueOf(finalArmorMultiplier));
                        } else {
                            baseGalvanMultiplier = EXTRA_FORWARD_MULTIPLIER.get("galvan").floatValue();
                            xAdjustment = entity.m_6047_() ? ((Integer)manager.getPendingOrCurrentValue("galvan.sneakingXOffset", AlienFirstPersonConfig.GALVAN_SNEAKING_X_OFFSET)).intValue() : ((Integer)manager.getPendingOrCurrentValue("galvan.standingXOffset", AlienFirstPersonConfig.GALVAN_STANDING_X_OFFSET)).intValue();
                            float finalGalvanMultiplier = baseGalvanMultiplier + (float)xAdjustment * 0.03f;
                            bodyOffset *= finalGalvanMultiplier;
                            AlienFirstPersonMod.LOGGER.debug("Regular galvan - base: {}, adjustment: {}, final: {}", new Object[]{Float.valueOf(baseGalvanMultiplier), xAdjustment, Float.valueOf(finalGalvanMultiplier)});
                        }
                    } else if ("tetramand".equals(state.currentAlienForm)) {
                        ConfigChangeManager manager = ConfigChangeManager.getInstance();
                        int xAdjustment = entity.m_6047_() ? ((Integer)manager.getPendingOrCurrentValue("tetramand.sneakingXOffset", AlienFirstPersonConfig.TETRAMAND_SNEAKING_X_OFFSET)).intValue() : ((Integer)manager.getPendingOrCurrentValue("tetramand.standingXOffset", AlienFirstPersonConfig.TETRAMAND_STANDING_X_OFFSET)).intValue();
                        multiplier += (float)xAdjustment * 0.03f;
                    } else if ("lepidopterran".equals(state.currentAlienForm)) {
                        ConfigChangeManager manager = ConfigChangeManager.getInstance();
                        int xAdjustment = entity.m_6047_() ? ((Integer)manager.getPendingOrCurrentValue("lepidopterran.sneakingXOffset", AlienFirstPersonConfig.LEPIDOPTERRAN_SNEAKING_X_OFFSET)).intValue() : ((Integer)manager.getPendingOrCurrentValue("lepidopterran.standingXOffset", AlienFirstPersonConfig.LEPIDOPTERRAN_STANDING_X_OFFSET)).intValue();
                        multiplier += (float)xAdjustment * 0.03f;
                    } else if ("piscciss_volann".equals(state.currentAlienForm)) {
                        ConfigChangeManager manager = ConfigChangeManager.getInstance();
                        int xAdjustment = entity.m_6047_() ? ((Integer)manager.getPendingOrCurrentValue("piscciss_volann.sneakingXOffset", AlienFirstPersonConfig.PISCCISS_VOLANN_SNEAKING_X_OFFSET)).intValue() : ((Integer)manager.getPendingOrCurrentValue("piscciss_volann.standingXOffset", AlienFirstPersonConfig.PISCCISS_VOLANN_STANDING_X_OFFSET)).intValue();
                        multiplier += (float)xAdjustment * 0.03f;
                    } else if ("galvanic_mechamorph".equals(state.currentAlienForm)) {
                        boolean hasLightningPro = false;
                        try {
                            Collection allAbilities = AbilityUtil.getInstances((LivingEntity)entity);
                            if (allAbilities != null && !allAbilities.isEmpty()) {
                                for (AbilityInstance ability : allAbilities) {
                                    String abilityId;
                                    if (ability == null || !ability.isEnabled() || !"lightningpro".equals(abilityId = ability.getConfiguration().getId())) continue;
                                    hasLightningPro = true;
                                }
                            }
                        }
                        catch (Exception e) {
                            AlienFirstPersonMod.LOGGER.debug("Error checking galvanic mechamorph abilities: {}", (Object)e.getMessage());
                        }
                        ConfigChangeManager manager = ConfigChangeManager.getInstance();
                        if (hasLightningPro) {
                            xAdjustment = entity.m_6047_() ? ((Integer)manager.getPendingOrCurrentValue("galvanic_mechamorph.rod.sneakingXOffset", AlienFirstPersonConfig.GALVANIC_MECHAMORPH_ROD_SNEAKING_X_OFFSET)).intValue() : ((Integer)manager.getPendingOrCurrentValue("galvanic_mechamorph.rod.standingXOffset", AlienFirstPersonConfig.GALVANIC_MECHAMORPH_ROD_STANDING_X_OFFSET)).intValue();
                            multiplier += (float)xAdjustment * 0.03f;
                        } else {
                            xAdjustment = entity.m_6047_() ? ((Integer)manager.getPendingOrCurrentValue("galvanic_mechamorph.sneakingXOffset", AlienFirstPersonConfig.GALVANIC_MECHAMORPH_SNEAKING_X_OFFSET)).intValue() : ((Integer)manager.getPendingOrCurrentValue("galvanic_mechamorph.standingXOffset", AlienFirstPersonConfig.GALVANIC_MECHAMORPH_STANDING_X_OFFSET)).intValue();
                            multiplier += (float)xAdjustment * 0.03f;
                        }
                    } else if ("ectonurite".equals(state.currentAlienForm)) {
                        ConfigChangeManager manager = ConfigChangeManager.getInstance();
                        int xAdjustment = entity.m_6047_() ? ((Integer)manager.getPendingOrCurrentValue("ectonurite.sneakingXOffset", AlienFirstPersonConfig.ECTONURITE_SNEAKING_X_OFFSET)).intValue() : ((Integer)manager.getPendingOrCurrentValue("ectonurite.standingXOffset", AlienFirstPersonConfig.ECTONURITE_STANDING_X_OFFSET)).intValue();
                        multiplier += (float)xAdjustment * 0.03f;
                    } else if ("arburian_pelarota".equals(state.currentAlienForm)) {
                        ConfigChangeManager manager = ConfigChangeManager.getInstance();
                        int xAdjustment = entity.m_6047_() ? ((Integer)manager.getPendingOrCurrentValue("arburian_pelarota.sneakingXOffset", AlienFirstPersonConfig.ARBURIAN_PELAROTA_SNEAKING_X_OFFSET)).intValue() : ((Integer)manager.getPendingOrCurrentValue("arburian_pelarota.standingXOffset", AlienFirstPersonConfig.ARBURIAN_PELAROTA_STANDING_X_OFFSET)).intValue();
                        multiplier += (float)xAdjustment * 0.03f;
                    } else if ("custom_alien".equals(state.currentAlienForm)) {
                        int xAdjustment = entity.m_6047_() ? (Integer)AlienFirstPersonConfig.CUSTOM_ALIENS_SNEAKING_X_OFFSET.get() : (Integer)AlienFirstPersonConfig.CUSTOM_ALIENS_STANDING_X_OFFSET.get();
                        float sizeMultiplier = 1.0f;
                        if (Math.abs(pehkuiScale - 1.0f) > 0.01f) {
                            sizeMultiplier = pehkuiScale > 1.5f ? 1.5f : (pehkuiScale > 1.2f ? 1.3f : (pehkuiScale < 0.5f ? 0.5f : (pehkuiScale < 0.8f ? 0.7f : 1.0f)));
                        }
                        multiplier = sizeMultiplier + (float)xAdjustment * 0.03f;
                        AlienFirstPersonMod.LOGGER.debug("Applied custom alien offset - size: {}, sizeMultiplier: {}, xAdjustment: {}, final multiplier: {}", new Object[]{Float.valueOf(pehkuiScale), Float.valueOf(sizeMultiplier), xAdjustment, Float.valueOf(multiplier)});
                    }
                    if (!"galvan".equals(state.currentAlienForm)) {
                        bodyOffset *= multiplier;
                    }
                }
            }
            float realYaw = Mth.m_14189_((float)delta, (float)entity.f_20884_, (float)entity.f_20883_);
            double x = (double)bodyOffset * Math.sin(Math.toRadians(realYaw));
            double z = (double)(-bodyOffset) * Math.cos(Math.toRadians(realYaw));
            double y = 0.0;
            if (isSwimming && (entity.m_6067_() || entity.m_6069_())) {
                float pitchOld = entity.f_19860_;
                float pitch = entity.m_146909_();
                float lerpedPitch = Mth.m_14189_((float)delta, (float)pitchOld, (float)pitch);
                y = lerpedPitch > 0.0f && entity.m_5842_() ? (y += (double)0.6f * Math.sin(Math.toRadians(lerpedPitch))) : (y += (double)0.01f * -Math.sin(Math.toRadians(lerpedPitch)));
            }
            if ("galvan".equals(state.currentAlienForm)) {
                boolean hasGalvanSuit = false;
                boolean hasGalvanLimbs = false;
                boolean hasGalvanArmor = false;
                try {
                    Collection allAbilities = AbilityUtil.getInstances((LivingEntity)entity);
                    if (allAbilities != null && !allAbilities.isEmpty()) {
                        for (AbilityInstance ability : allAbilities) {
                            if (ability == null || !ability.isEnabled()) continue;
                            String abilityId = ability.getConfiguration().getId();
                            if ("galvan_suit".equals(abilityId)) {
                                hasGalvanSuit = true;
                                continue;
                            }
                            if ("galvan_limbs".equals(abilityId)) {
                                hasGalvanLimbs = true;
                                continue;
                            }
                            if (!"galvan_armor".equals(abilityId)) continue;
                            hasGalvanArmor = true;
                        }
                    }
                }
                catch (Exception e) {
                    AlienFirstPersonMod.LOGGER.debug("Error checking galvan abilities: {}", (Object)e.getMessage());
                }
                y = hasGalvanSuit ? (y += (double)(-0.1f * pehkuiScale)) : (hasGalvanLimbs ? (y += (double)(0.25f * pehkuiScale)) : (hasGalvanArmor ? (y += (double)(0.25f * pehkuiScale)) : (y += (double)(0.25f * pehkuiScale))));
            }
            return new Vec3(x, y, z);
        }
        return current;
    }

    private boolean hasPehkuiScaling(AbstractClientPlayer entity) {
        try {
            ScaleData scaleData = ScaleTypes.BASE.getScaleData((Entity)entity);
            float scale = scaleData.getScale();
            return Math.abs(scale - 1.0f) > 0.01f;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void updateAlienState(AbstractClientPlayer player, float delta) {
        String detectedAlien;
        PlayerState state = AlienOffsetManager.getPlayerState(player.m_20148_());
        if (state.hasRecentlyJoined) {
            --state.joinCooldownTicks;
            if (state.joinCooldownTicks <= 0) {
                state.hasRecentlyJoined = false;
                AlienFirstPersonMod.LOGGER.info("Join cooldown ended for player {}", (Object)player.m_7755_().getString());
            }
        }
        if ((detectedAlien = AlienOffsetManager.detectAlienForm(player, state)) == null && state.currentAlienForm != null) {
            AlienFirstPersonMod.LOGGER.info("Detected human form but had cached alien {}, clearing for {}", (Object)state.currentAlienForm, (Object)player.m_7755_().getString());
            state.currentAlienForm = null;
            state.scalingTickCounter = 0;
            AlienOffsetManager.resetScaling(player);
        } else if (detectedAlien != null && !detectedAlien.equals(state.currentAlienForm)) {
            String detectionMethod = "unknown";
            detectionMethod = AlienOffsetManager.detectAlienByPowers(player) != null ? "abilities" : (AlienOffsetManager.detectAlienByScoreboard(player) != null ? "scoreboard" : "display name or scale");
            AlienFirstPersonMod.LOGGER.info("Alien form changed for {}: {} -> {} (detection: {})", new Object[]{player.m_7755_().getString(), state.currentAlienForm != null ? state.currentAlienForm : "human", detectedAlien, detectionMethod});
            state.currentAlienForm = detectedAlien;
            state.scalingTickCounter = 0;
        }
        if (state.currentAlienForm != null && FORCED_SCALES.containsKey(state.currentAlienForm)) {
            AlienOffsetManager.enforceScaling(player, state.currentAlienForm, state);
        }
    }

    private static void enforceScaling(AbstractClientPlayer player, String alienForm, PlayerState state) {
        ++state.scalingTickCounter;
        if (state.scalingTickCounter % 5 != 0) {
            return;
        }
        try {
            float targetScale = FORCED_SCALES.get(alienForm).floatValue();
            ScaleData baseScale = ScaleTypes.BASE.getScaleData((Entity)player);
            ScaleData heightScale = ScaleTypes.HEIGHT.getScaleData((Entity)player);
            ScaleData widthScale = ScaleTypes.WIDTH.getScaleData((Entity)player);
            if (Math.abs(baseScale.getScale() - targetScale) > 0.01f) {
                baseScale.setTargetScale(targetScale);
                heightScale.setTargetScale(targetScale);
                widthScale.setTargetScale(targetScale);
                baseScale.setScale(targetScale);
                heightScale.setScale(targetScale);
                widthScale.setScale(targetScale);
                AlienFirstPersonMod.LOGGER.debug("Enforced scale {} for {} on {} (tick {})", new Object[]{Float.valueOf(targetScale), alienForm, player.m_7755_().getString(), state.scalingTickCounter});
            }
        }
        catch (Exception e) {
            AlienFirstPersonMod.LOGGER.error("Failed to enforce scaling for " + alienForm, (Throwable)e);
        }
    }

    public static void resetScaling(AbstractClientPlayer player) {
        try {
            ScaleData baseScale = ScaleTypes.BASE.getScaleData((Entity)player);
            ScaleData heightScale = ScaleTypes.HEIGHT.getScaleData((Entity)player);
            ScaleData widthScale = ScaleTypes.WIDTH.getScaleData((Entity)player);
            baseScale.setTargetScale(1.0f);
            heightScale.setTargetScale(1.0f);
            widthScale.setTargetScale(1.0f);
            baseScale.setScale(1.0f);
            heightScale.setScale(1.0f);
            widthScale.setScale(1.0f);
            AlienFirstPersonMod.LOGGER.info("Reset scaling to normal for {}", (Object)player.m_7755_().getString());
        }
        catch (Exception e) {
            AlienFirstPersonMod.LOGGER.error("Failed to reset scaling", (Throwable)e);
        }
    }

    private static String detectAlienForm(AbstractClientPlayer player, PlayerState state) {
        String powerDetectedAlien = AlienOffsetManager.detectAlienByPowers(player);
        if (powerDetectedAlien != null) {
            if (!SUPPORTED_ALIENS.contains(powerDetectedAlien)) {
                AlienFirstPersonMod.LOGGER.debug("Detected custom alien: {}", (Object)powerDetectedAlien);
                return "custom_alien";
            }
            return powerDetectedAlien;
        }
        String scoreboardDetectedAlien = AlienOffsetManager.detectAlienByScoreboard(player);
        if (scoreboardDetectedAlien != null) {
            if (!SUPPORTED_ALIENS.contains(scoreboardDetectedAlien)) {
                return "custom_alien";
            }
            return scoreboardDetectedAlien;
        }
        if (AlienOffsetManager.isInAlienForm()) {
            return "custom_alien";
        }
        return null;
    }

    private static String detectAlienByScoreboard(AbstractClientPlayer player) {
        try {
            PlayerState state = AlienOffsetManager.getPlayerState(player.m_20148_());
            Scoreboard scoreboard = player.m_36329_();
            Objective omnitrixObj = scoreboard.m_83477_("omnitrix_cycle");
            if (omnitrixObj != null) {
                int alienId;
                state.currentOmnitrixCycle = alienId = scoreboard.m_83471_(player.m_6302_(), omnitrixObj).m_83400_();
                String alienForm = ALIEN_ID_MAP.get(alienId);
                if (alienForm != null) {
                    AlienFirstPersonMod.LOGGER.debug("Detected alien by omnitrix_cycle score {}: {}", (Object)alienId, (Object)alienForm);
                    return alienForm;
                }
                if (alienId != 0) {
                    AlienFirstPersonMod.LOGGER.warn("Unknown alien ID in omnitrix_cycle: {}", (Object)alienId);
                }
            }
        }
        catch (Exception e) {
            AlienFirstPersonMod.LOGGER.debug("Error checking omnitrix_cycle scoreboard: {}", (Object)e.getMessage());
        }
        return null;
    }

    private static String detectAlienByPowers(AbstractClientPlayer player) {
        try {
            Collection allAbilities = AbilityUtil.getInstances((LivingEntity)player);
            if (allAbilities != null && !allAbilities.isEmpty()) {
                for (AbilityInstance ability : allAbilities) {
                    if (ability == null || !ability.isEnabled()) continue;
                    String abilityId = ability.getConfiguration().getId();
                    if ("petrosapien".equals(abilityId)) {
                        return "petrosapien";
                    }
                    if ("pyronite".equals(abilityId)) {
                        return "pyronite";
                    }
                    if ("vulpimancer".equals(abilityId)) {
                        return "vulpimancer";
                    }
                    if ("kineceleran".equals(abilityId)) {
                        return "kineceleran";
                    }
                    if ("galvan".equals(abilityId)) {
                        return "galvan";
                    }
                    if ("tetramand".equals(abilityId)) {
                        return "tetramand";
                    }
                    if ("lepidopterran".equals(abilityId)) {
                        return "lepidopterran";
                    }
                    if ("ectonurite".equals(abilityId)) {
                        return "ectonurite";
                    }
                    if ("methanosian".equals(abilityId)) {
                        return "methanosian";
                    }
                    if ("sonorosian".equals(abilityId)) {
                        return "sonorosian";
                    }
                    if ("vaxasaurian".equals(abilityId)) {
                        return "vaxasaurian";
                    }
                    if ("aerophibian".equals(abilityId)) {
                        return "aerophibian";
                    }
                    if ("necrofriggian".equals(abilityId)) {
                        return "necrofriggian";
                    }
                    if ("crystalsapien".equals(abilityId)) {
                        return "crystalsapien";
                    }
                    if ("nucleonix".equals(abilityId)) {
                        return "nucleonix";
                    }
                    if ("dragonoid".equals(abilityId)) {
                        return "dragonoid";
                    }
                    if ("piscciss_volann".equals(abilityId) || "pisccissvolann".equals(abilityId)) {
                        return "piscciss_volann";
                    }
                    if ("galvanic_mechamorph".equals(abilityId) || "galvanicmechamorph".equals(abilityId)) {
                        return "galvanic_mechamorph";
                    }
                    if (!"arburian_pelarota".equals(abilityId) && !"arburianpelarota".equals(abilityId)) continue;
                    return "arburian_pelarota";
                }
                Component alienNameComponent = null;
                for (AbilityInstance ability : allAbilities) {
                    String abilityId;
                    if (ability == null || !ability.isEnabled() || !"name_change".equals(abilityId = ability.getConfiguration().getId())) continue;
                    try {
                        alienNameComponent = (Component)ability.getProperty(NameChangeAbility.NAME);
                        if (alienNameComponent == null) continue;
                        String alienDisplayName = alienNameComponent.getString();
                        AlienFirstPersonMod.LOGGER.debug("Found name_change ability with name: {}", (Object)alienDisplayName);
                        String lowerName = alienDisplayName.toLowerCase();
                        for (Map.Entry<Integer, String> entry : ALIEN_ID_MAP.entrySet()) {
                            String alienName = entry.getValue();
                            if (alienName == null || !lowerName.contains(alienName.replace("_", " "))) continue;
                            AlienFirstPersonMod.LOGGER.info("Detected alien by name_change ability: {} -> {}", (Object)alienDisplayName, (Object)alienName);
                            return alienName;
                        }
                    }
                    catch (Exception e) {
                        AlienFirstPersonMod.LOGGER.debug("Could not read NAME property from name_change ability");
                    }
                }
                AlienFirstPersonMod.LOGGER.debug("All player abilities:");
                for (AbilityInstance ability : allAbilities) {
                    if (ability == null) continue;
                    AlienFirstPersonMod.LOGGER.debug("  - {} (enabled: {})", (Object)ability.getConfiguration().getId(), (Object)ability.isEnabled());
                }
            }
        }
        catch (Exception e) {
            AlienFirstPersonMod.LOGGER.error("Error detecting alien by powers", (Throwable)e);
        }
        return null;
    }

    public static String getCurrentAlienForm() {
        LocalPlayer localPlayer = Minecraft.m_91087_().f_91074_;
        if (localPlayer != null) {
            PlayerState state = AlienOffsetManager.getPlayerState(localPlayer.m_20148_());
            return state.currentAlienForm;
        }
        return null;
    }

    public static void resetDetectionState() {
        LocalPlayer localPlayer = Minecraft.m_91087_().f_91074_;
        if (localPlayer != null) {
            PlayerState state = AlienOffsetManager.getPlayerState(localPlayer.m_20148_());
            state.currentAlienForm = null;
            state.scalingTickCounter = 0;
            state.lastOmnitrixCycle = -1;
            state.currentOmnitrixCycle = 0;
            state.hasRecentlyJoined = true;
            state.joinCooldownTicks = 60;
            state.scoreboardReliable = false;
            AlienFirstPersonMod.LOGGER.info("Reset detection state for {} - cleared alien form and marked as recently joined", (Object)localPlayer.m_7755_().getString());
        }
    }

    public static void clearPlayerState(UUID playerId) {
        playerStates.remove(playerId);
        AlienFirstPersonMod.LOGGER.info("Cleared player state for {}", (Object)playerId);
    }

    public static void cleanupPlayerStates() {
        playerStates.entrySet().removeIf(entry -> false);
    }

    public static boolean isUnsupportedAlienActive() {
        LocalPlayer localPlayer = Minecraft.m_91087_().f_91074_;
        if (localPlayer != null) {
            boolean hasNicknameAbility;
            block8: {
                if (((Boolean)AlienFirstPersonConfig.CUSTOM_ALIENS_FIRST_PERSON_ENABLED.get()).booleanValue()) {
                    AlienFirstPersonMod.LOGGER.debug("Custom aliens first person enabled - keeping first person active for all aliens");
                    return false;
                }
                hasNicknameAbility = false;
                try {
                    Collection allAbilities = AbilityUtil.getInstances((LivingEntity)localPlayer);
                    if (allAbilities == null || allAbilities.isEmpty()) break block8;
                    for (AbilityInstance ability : allAbilities) {
                        String abilityId;
                        if (ability == null || !"nickname".equals(abilityId = ability.getConfiguration().getId()) && !"name_change".equals(abilityId) && !"nameChange".equals(abilityId) && !"NameChange".equals(abilityId) && !"changename".equals(abilityId) && !"changeName".equals(abilityId) && !"slot_restriction".equals(abilityId)) continue;
                        hasNicknameAbility = true;
                        AlienFirstPersonMod.LOGGER.debug("Found transformation ability ({}) - player is in alien form", (Object)abilityId);
                        break;
                    }
                }
                catch (Exception e) {
                    AlienFirstPersonMod.LOGGER.error("Error checking for nickname ability", (Throwable)e);
                }
            }
            if (!hasNicknameAbility) {
                return false;
            }
            String currentAlien = AlienOffsetManager.getCurrentAlienForm();
            if (currentAlien == null) {
                AlienFirstPersonMod.LOGGER.info("Player has nickname ability but alien form not recognized - unsupported alien");
                return true;
            }
            if (!SUPPORTED_ALIENS.contains(currentAlien)) {
                AlienFirstPersonMod.LOGGER.info("Detected unsupported alien form: {}", (Object)currentAlien);
                return true;
            }
            return false;
        }
        return false;
    }

    public static boolean isInAlienForm() {
        LocalPlayer localPlayer = Minecraft.m_91087_().f_91074_;
        if (localPlayer != null) {
            try {
                Collection allAbilities = AbilityUtil.getInstances((LivingEntity)localPlayer);
                if (allAbilities != null && !allAbilities.isEmpty()) {
                    for (AbilityInstance ability : allAbilities) {
                        String abilityId;
                        if (ability == null || !ability.isEnabled() || !"nickname".equals(abilityId = ability.getConfiguration().getId()) && !"name_change".equals(abilityId) && !"nameChange".equals(abilityId) && !"NameChange".equals(abilityId) && !"changename".equals(abilityId) && !"changeName".equals(abilityId) && !"slot_restriction".equals(abilityId)) continue;
                        return true;
                    }
                }
            }
            catch (Exception e) {
                AlienFirstPersonMod.LOGGER.error("Error checking for alien form", (Throwable)e);
            }
        }
        return false;
    }

    static {
        TAG_TO_ALIEN_MAP.put("Pyronite", "pyronite");
        TAG_TO_ALIEN_MAP.put("Vulpimancer", "vulpimancer");
        TAG_TO_ALIEN_MAP.put("Petrosapien", "petrosapien");
        TAG_TO_ALIEN_MAP.put("Kineceleran", "kineceleran");
        TAG_TO_ALIEN_MAP.put("Galvan", "galvan");
        TAG_TO_ALIEN_MAP.put("Tetramand", "tetramand");
        TAG_TO_ALIEN_MAP.put("Lepidopterran", "lepidopterran");
        TAG_TO_ALIEN_MAP.put("PisccissVolann", "piscciss_volann");
        TAG_TO_ALIEN_MAP.put("GalvanicMechamorph", "galvanic_mechamorph");
        TAG_TO_ALIEN_MAP.put("Ectonurite", "ectonurite");
        TAG_TO_ALIEN_MAP.put("ArburianPelarota", "arburian_pelarota");
        TAG_TO_ALIEN_MAP.put("Methanosian", "methanosian");
        TAG_TO_ALIEN_MAP.put("Sonorosian", "sonorosian");
        TAG_TO_ALIEN_MAP.put("Vaxasaurian", "vaxasaurian");
        TAG_TO_ALIEN_MAP.put("Aerophibian", "aerophibian");
        TAG_TO_ALIEN_MAP.put("Necrofriggian", "necrofriggian");
        TAG_TO_ALIEN_MAP.put("Crystalsapien", "crystalsapien");
        TAG_TO_ALIEN_MAP.put("Nucleonix", "nucleonix");
        TAG_TO_ALIEN_MAP.put("Dragonoid", "dragonoid");
        ALIEN_ID_MAP.put(0, null);
        ALIEN_ID_MAP.put(1, "pyronite");
        ALIEN_ID_MAP.put(2, "vulpimancer");
        ALIEN_ID_MAP.put(3, "petrosapien");
        ALIEN_ID_MAP.put(4, "kineceleran");
        ALIEN_ID_MAP.put(5, "galvan");
        ALIEN_ID_MAP.put(6, "tetramand");
        ALIEN_ID_MAP.put(7, "lepidopterran");
        ALIEN_ID_MAP.put(8, "piscciss_volann");
        ALIEN_ID_MAP.put(9, "galvanic_mechamorph");
        ALIEN_ID_MAP.put(10, "ectonurite");
        ALIEN_ID_MAP.put(11, "arburian_pelarota");
        ALIEN_ID_MAP.put(31, "methanosian");
        ALIEN_ID_MAP.put(32, "sonorosian");
        ALIEN_ID_MAP.put(33, "vaxasaurian");
        ALIEN_ID_MAP.put(34, "aerophibian");
        ALIEN_ID_MAP.put(35, "necrofriggian");
        ALIEN_ID_MAP.put(36, "crystalsapien");
        ALIEN_ID_MAP.put(80, "nucleonix");
        ALIEN_ID_MAP.put(100, "dragonoid");
        EXTRA_FORWARD_MULTIPLIER.put("pyronite", Float.valueOf(1.0f));
        EXTRA_FORWARD_MULTIPLIER.put("vulpimancer", Float.valueOf(3.2f));
        EXTRA_FORWARD_MULTIPLIER.put("petrosapien", Float.valueOf(1.4f));
        EXTRA_FORWARD_MULTIPLIER.put("kineceleran", Float.valueOf(2.5f));
        EXTRA_FORWARD_MULTIPLIER.put("tetramand", Float.valueOf(1.2f));
        EXTRA_FORWARD_MULTIPLIER.put("lepidopterran", Float.valueOf(3.0f));
        EXTRA_FORWARD_MULTIPLIER.put("piscciss_volann", Float.valueOf(1.3f));
        EXTRA_FORWARD_MULTIPLIER.put("galvanic_mechamorph", Float.valueOf(1.2f));
        EXTRA_FORWARD_MULTIPLIER.put("ectonurite", Float.valueOf(1.3f));
        EXTRA_FORWARD_MULTIPLIER.put("galvan", Float.valueOf(1.6f));
        EXTRA_FORWARD_MULTIPLIER.put("arburian_pelarota", Float.valueOf(2.3f));
        EXTRA_FORWARD_MULTIPLIER.put("dragonoid", Float.valueOf(1.8f));
        EXTRA_FORWARD_MULTIPLIER.put("custom_alien", Float.valueOf(1.0f));
        SWIMMING_FORWARD_MULTIPLIER.put("pyronite", Float.valueOf(1.3f));
        SWIMMING_FORWARD_MULTIPLIER.put("vulpimancer", Float.valueOf(0.0f));
        SWIMMING_FORWARD_MULTIPLIER.put("petrosapien", Float.valueOf(1.3f));
        SWIMMING_FORWARD_MULTIPLIER.put("kineceleran", Float.valueOf(0.4f));
        SWIMMING_FORWARD_MULTIPLIER.put("tetramand", Float.valueOf(1.1f));
        SWIMMING_FORWARD_MULTIPLIER.put("lepidopterran", Float.valueOf(0.5f));
        SWIMMING_FORWARD_MULTIPLIER.put("piscciss_volann", Float.valueOf(1.5f));
        SWIMMING_FORWARD_MULTIPLIER.put("galvanic_mechamorph", Float.valueOf(1.3f));
        SWIMMING_FORWARD_MULTIPLIER.put("ectonurite", Float.valueOf(1.0f));
        SWIMMING_FORWARD_MULTIPLIER.put("dragonoid", Float.valueOf(1.5f));
    }

    private static class PlayerState {
        String currentAlienForm = null;
        int scalingTickCounter = 0;
        int lastOmnitrixCycle = -1;
        boolean hasRecentlyJoined = false;
        int joinCooldownTicks = 0;
        boolean scoreboardReliable = false;
        int currentOmnitrixCycle = 0;

        private PlayerState() {
        }
    }
}

