/*
 * Decompiled with CFR 0.152.
 */
package com.parad.alienfirstperson;

import com.parad.alienfirstperson.AlienOffsetManager;
import com.parad.alienfirstperson.config.AlienFirstPersonConfig;
import com.parad.alienfirstperson.config.ConfigChangeManager;
import dev.tr7zw.firstperson.FirstPersonModelCore;
import dev.tr7zw.firstperson.versionless.config.VanillaHands;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.LivingEntity;
import net.threetag.palladium.power.ability.AbilityInstance;
import net.threetag.palladium.power.ability.AbilityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlienStateHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"AlienStateHandler");

    public static void storeHumanSettings() {
        if (FirstPersonModelCore.instance == null) {
            return;
        }
        try {
            boolean currentEnabled = FirstPersonModelCore.instance.isEnabled();
            String vanillaHandsMode = "OFF";
            boolean dynamicMode = true;
            if (FirstPersonModelCore.instance.getConfig() != null) {
                vanillaHandsMode = FirstPersonModelCore.instance.getConfig().vanillaHandsMode.name();
                dynamicMode = FirstPersonModelCore.instance.getConfig().dynamicMode;
            }
            AlienFirstPersonConfig.STORED_HUMAN_FIRST_PERSON_ENABLED.set((Object)currentEnabled);
            AlienFirstPersonConfig.STORED_HUMAN_VANILLA_HANDS_MODE.set((Object)vanillaHandsMode);
            AlienFirstPersonConfig.STORED_HUMAN_DYNAMIC_MODE.set((Object)dynamicMode);
            AlienFirstPersonConfig.HAS_STORED_HUMAN_SETTINGS.set((Object)true);
            AlienFirstPersonConfig.CLIENT_SPEC.save();
            LOGGER.info("Stored human FPM settings: enabled={}, vanilla={}, dynamic={}", new Object[]{currentEnabled, vanillaHandsMode, dynamicMode});
        }
        catch (Exception e) {
            LOGGER.error("Failed to store human settings", (Throwable)e);
        }
    }

    public static void restoreHumanSettings() {
        if (FirstPersonModelCore.instance == null) {
            return;
        }
        try {
            if (!((Boolean)AlienFirstPersonConfig.HAS_STORED_HUMAN_SETTINGS.get()).booleanValue()) {
                LOGGER.info("No stored human settings yet, using FPM defaults");
                return;
            }
            boolean enabled = (Boolean)AlienFirstPersonConfig.STORED_HUMAN_FIRST_PERSON_ENABLED.get();
            String vanillaHandsStr = (String)AlienFirstPersonConfig.STORED_HUMAN_VANILLA_HANDS_MODE.get();
            boolean dynamicMode = (Boolean)AlienFirstPersonConfig.STORED_HUMAN_DYNAMIC_MODE.get();
            FirstPersonModelCore.instance.setEnabled(enabled);
            if (FirstPersonModelCore.instance.getConfig() != null) {
                try {
                    VanillaHands vanillaHands;
                    FirstPersonModelCore.instance.getConfig().vanillaHandsMode = vanillaHands = VanillaHands.valueOf((String)vanillaHandsStr);
                    FirstPersonModelCore.instance.getConfig().dynamicMode = dynamicMode;
                }
                catch (IllegalArgumentException e) {
                    LOGGER.warn("Invalid vanilla hands mode stored: {}", (Object)vanillaHandsStr);
                }
            }
            LOGGER.info("Restored human FPM settings: enabled={}, vanilla={}, dynamic={}", new Object[]{enabled, vanillaHandsStr, dynamicMode});
        }
        catch (Exception e) {
            LOGGER.error("Failed to restore human settings", (Throwable)e);
        }
    }

    public static void applyAlienFPMSettings(String alienForm) {
        if (alienForm == null || FirstPersonModelCore.instance == null || FirstPersonModelCore.instance.getConfig() == null) {
            return;
        }
        try {
            ConfigChangeManager manager = ConfigChangeManager.getInstance();
            boolean dynamicMode = true;
            String vanillaHandsStr = "OFF";
            switch (alienForm) {
                case "pyronite": {
                    dynamicMode = (Boolean)manager.getPendingOrCurrentValue("pyronite.dynamicMode", AlienFirstPersonConfig.PYRONITE_DYNAMIC_MODE);
                    vanillaHandsStr = manager.getPendingOrCurrentValue("pyronite.vanillaHandsMode", AlienFirstPersonConfig.PYRONITE_VANILLA_HANDS_MODE);
                    break;
                }
                case "vulpimancer": {
                    dynamicMode = (Boolean)manager.getPendingOrCurrentValue("vulpimancer.dynamicMode", AlienFirstPersonConfig.VULPIMANCER_DYNAMIC_MODE);
                    vanillaHandsStr = manager.getPendingOrCurrentValue("vulpimancer.vanillaHandsMode", AlienFirstPersonConfig.VULPIMANCER_VANILLA_HANDS_MODE);
                    break;
                }
                case "petrosapien": {
                    boolean hasBattleMode = false;
                    boolean hasShield = false;
                    if (Minecraft.m_91087_().f_91074_ != null) {
                        try {
                            Collection allAbilities = AbilityUtil.getInstances((LivingEntity)Minecraft.m_91087_().f_91074_);
                            if (allAbilities != null) {
                                for (AbilityInstance ability : allAbilities) {
                                    if (ability == null || !ability.isEnabled()) continue;
                                    String abilityId = ability.getConfiguration().getId();
                                    if ("battle_mode".equals(abilityId)) {
                                        hasBattleMode = true;
                                    }
                                    if (!"shield_activate".equals(abilityId)) continue;
                                    hasShield = true;
                                }
                            }
                        }
                        catch (Exception e) {
                            LOGGER.debug("Error checking Petrosapien abilities: {}", (Object)e.getMessage());
                        }
                    }
                    if (hasShield) {
                        return;
                    }
                    if (hasBattleMode) {
                        dynamicMode = (Boolean)manager.getPendingOrCurrentValue("petrosapien.battleMode.dynamicMode", AlienFirstPersonConfig.PETROSAPIEN_BATTLE_MODE_DYNAMIC_MODE);
                        vanillaHandsStr = manager.getPendingOrCurrentValue("petrosapien.battleMode.vanillaHandsMode", AlienFirstPersonConfig.PETROSAPIEN_BATTLE_MODE_VANILLA_HANDS_MODE);
                        break;
                    }
                    dynamicMode = (Boolean)manager.getPendingOrCurrentValue("petrosapien.dynamicMode", AlienFirstPersonConfig.PETROSAPIEN_DYNAMIC_MODE);
                    vanillaHandsStr = manager.getPendingOrCurrentValue("petrosapien.vanillaHandsMode", AlienFirstPersonConfig.PETROSAPIEN_VANILLA_HANDS_MODE);
                    break;
                }
                case "kineceleran": {
                    boolean hasSpeed = false;
                    boolean hasSkate = false;
                    if (Minecraft.m_91087_().f_91074_ != null) {
                        try {
                            Collection allAbilities = AbilityUtil.getInstances((LivingEntity)Minecraft.m_91087_().f_91074_);
                            if (allAbilities != null) {
                                for (AbilityInstance ability : allAbilities) {
                                    if (ability == null || !ability.isEnabled()) continue;
                                    String abilityId = ability.getConfiguration().getId();
                                    if ("speed_1".equals(abilityId) || "speed_2".equals(abilityId) || "speed_3".equals(abilityId) || "speed_4".equals(abilityId) || "speed_5".equals(abilityId)) {
                                        hasSpeed = true;
                                    }
                                    if (!"skate".equals(abilityId)) continue;
                                    hasSkate = true;
                                }
                            }
                        }
                        catch (Exception e) {
                            LOGGER.debug("Error checking Kineceleran abilities: {}", (Object)e.getMessage());
                        }
                    }
                    if (hasSkate) {
                        dynamicMode = (Boolean)manager.getPendingOrCurrentValue("kineceleran.skate.dynamicMode", AlienFirstPersonConfig.KINECELERAN_SKATE_DYNAMIC_MODE);
                        vanillaHandsStr = manager.getPendingOrCurrentValue("kineceleran.skate.vanillaHandsMode", AlienFirstPersonConfig.KINECELERAN_SKATE_VANILLA_HANDS_MODE);
                        break;
                    }
                    if (hasSpeed) {
                        dynamicMode = (Boolean)manager.getPendingOrCurrentValue("kineceleran.speed.dynamicMode", AlienFirstPersonConfig.KINECELERAN_SPEED_DYNAMIC_MODE);
                        vanillaHandsStr = manager.getPendingOrCurrentValue("kineceleran.speed.vanillaHandsMode", AlienFirstPersonConfig.KINECELERAN_SPEED_VANILLA_HANDS_MODE);
                        break;
                    }
                    dynamicMode = (Boolean)manager.getPendingOrCurrentValue("kineceleran.dynamicMode", AlienFirstPersonConfig.KINECELERAN_DYNAMIC_MODE);
                    vanillaHandsStr = manager.getPendingOrCurrentValue("kineceleran.vanillaHandsMode", AlienFirstPersonConfig.KINECELERAN_VANILLA_HANDS_MODE);
                    break;
                }
                case "galvan": {
                    boolean hasGalvanSuit = false;
                    boolean hasGalvanLimbs = false;
                    if (Minecraft.m_91087_().f_91074_ != null) {
                        try {
                            Collection allAbilities = AbilityUtil.getInstances((LivingEntity)Minecraft.m_91087_().f_91074_);
                            if (allAbilities != null) {
                                for (AbilityInstance ability : allAbilities) {
                                    if (ability == null || !ability.isEnabled()) continue;
                                    String abilityId = ability.getConfiguration().getId();
                                    if ("galvan_suit".equals(abilityId)) {
                                        hasGalvanSuit = true;
                                    }
                                    if (!"galvan_limbs".equals(abilityId)) continue;
                                    hasGalvanLimbs = true;
                                }
                            }
                        }
                        catch (Exception e) {
                            LOGGER.debug("Error checking Galvan abilities: {}", (Object)e.getMessage());
                        }
                    }
                    if (hasGalvanSuit) {
                        dynamicMode = (Boolean)manager.getPendingOrCurrentValue("galvan.suit.dynamicMode", AlienFirstPersonConfig.GALVAN_SUIT_DYNAMIC_MODE);
                        vanillaHandsStr = manager.getPendingOrCurrentValue("galvan.suit.vanillaHandsMode", AlienFirstPersonConfig.GALVAN_SUIT_VANILLA_HANDS_MODE);
                        break;
                    }
                    if (hasGalvanLimbs) {
                        dynamicMode = (Boolean)manager.getPendingOrCurrentValue("galvan.limbs.dynamicMode", AlienFirstPersonConfig.GALVAN_LIMBS_DYNAMIC_MODE);
                        vanillaHandsStr = manager.getPendingOrCurrentValue("galvan.limbs.vanillaHandsMode", AlienFirstPersonConfig.GALVAN_LIMBS_VANILLA_HANDS_MODE);
                        break;
                    }
                    dynamicMode = (Boolean)manager.getPendingOrCurrentValue("galvan.dynamicMode", AlienFirstPersonConfig.GALVAN_DYNAMIC_MODE);
                    vanillaHandsStr = manager.getPendingOrCurrentValue("galvan.vanillaHandsMode", AlienFirstPersonConfig.GALVAN_VANILLA_HANDS_MODE);
                    break;
                }
                case "tetramand": {
                    dynamicMode = (Boolean)manager.getPendingOrCurrentValue("tetramand.dynamicMode", AlienFirstPersonConfig.TETRAMAND_DYNAMIC_MODE);
                    vanillaHandsStr = manager.getPendingOrCurrentValue("tetramand.vanillaHandsMode", AlienFirstPersonConfig.TETRAMAND_VANILLA_HANDS_MODE);
                    break;
                }
                case "lepidopterran": {
                    dynamicMode = (Boolean)manager.getPendingOrCurrentValue("lepidopterran.dynamicMode", AlienFirstPersonConfig.LEPIDOPTERRAN_DYNAMIC_MODE);
                    vanillaHandsStr = manager.getPendingOrCurrentValue("lepidopterran.vanillaHandsMode", AlienFirstPersonConfig.LEPIDOPTERRAN_VANILLA_HANDS_MODE);
                    break;
                }
                case "piscciss_volann": {
                    dynamicMode = (Boolean)manager.getPendingOrCurrentValue("piscciss_volann.dynamicMode", AlienFirstPersonConfig.PISCCISS_VOLANN_DYNAMIC_MODE);
                    vanillaHandsStr = manager.getPendingOrCurrentValue("piscciss_volann.vanillaHandsMode", AlienFirstPersonConfig.PISCCISS_VOLANN_VANILLA_HANDS_MODE);
                    break;
                }
                case "galvanic_mechamorph": {
                    boolean hasLightningPro = false;
                    if (Minecraft.m_91087_().f_91074_ != null) {
                        try {
                            Collection allAbilities = AbilityUtil.getInstances((LivingEntity)Minecraft.m_91087_().f_91074_);
                            if (allAbilities != null) {
                                for (AbilityInstance ability : allAbilities) {
                                    String abilityId;
                                    if (ability == null || !ability.isEnabled() || !"lightningpro".equals(abilityId = ability.getConfiguration().getId())) continue;
                                    hasLightningPro = true;
                                }
                            }
                        }
                        catch (Exception e) {
                            LOGGER.debug("Error checking Galvanic Mechamorph abilities: {}", (Object)e.getMessage());
                        }
                    }
                    if (hasLightningPro) {
                        dynamicMode = (Boolean)manager.getPendingOrCurrentValue("galvanic_mechamorph.rod.dynamicMode", AlienFirstPersonConfig.GALVANIC_MECHAMORPH_ROD_DYNAMIC_MODE);
                        vanillaHandsStr = manager.getPendingOrCurrentValue("galvanic_mechamorph.rod.vanillaHandsMode", AlienFirstPersonConfig.GALVANIC_MECHAMORPH_ROD_VANILLA_HANDS_MODE);
                        break;
                    }
                    dynamicMode = (Boolean)manager.getPendingOrCurrentValue("galvanic_mechamorph.dynamicMode", AlienFirstPersonConfig.GALVANIC_MECHAMORPH_DYNAMIC_MODE);
                    vanillaHandsStr = manager.getPendingOrCurrentValue("galvanic_mechamorph.vanillaHandsMode", AlienFirstPersonConfig.GALVANIC_MECHAMORPH_VANILLA_HANDS_MODE);
                    break;
                }
                case "ectonurite": {
                    dynamicMode = (Boolean)manager.getPendingOrCurrentValue("ectonurite.dynamicMode", AlienFirstPersonConfig.ECTONURITE_DYNAMIC_MODE);
                    vanillaHandsStr = manager.getPendingOrCurrentValue("ectonurite.vanillaHandsMode", AlienFirstPersonConfig.ECTONURITE_VANILLA_HANDS_MODE);
                    break;
                }
                case "arburian_pelarota": {
                    dynamicMode = (Boolean)manager.getPendingOrCurrentValue("arburian_pelarota.dynamicMode", AlienFirstPersonConfig.ARBURIAN_PELAROTA_DYNAMIC_MODE);
                    vanillaHandsStr = manager.getPendingOrCurrentValue("arburian_pelarota.vanillaHandsMode", AlienFirstPersonConfig.ARBURIAN_PELAROTA_VANILLA_HANDS_MODE);
                    break;
                }
                default: {
                    return;
                }
            }
            FirstPersonModelCore.instance.getConfig().dynamicMode = dynamicMode;
            try {
                VanillaHands vanillaHands;
                FirstPersonModelCore.instance.getConfig().vanillaHandsMode = vanillaHands = VanillaHands.valueOf((String)vanillaHandsStr);
            }
            catch (IllegalArgumentException e) {
                LOGGER.warn("Invalid vanilla hands mode for {}: {}", (Object)alienForm, (Object)vanillaHandsStr);
            }
            LOGGER.debug("Applied {} FPM settings: dynamic={}, vanillaHands={}", new Object[]{alienForm, dynamicMode, vanillaHandsStr});
        }
        catch (Exception e) {
            LOGGER.error("Failed to apply alien FPM settings", (Throwable)e);
        }
    }

    public static void reapplyCurrentAlienSettings() {
        String currentAlien;
        if (Minecraft.m_91087_().f_91074_ != null && (currentAlien = AlienOffsetManager.getCurrentAlienForm()) != null && FirstPersonModelCore.instance != null && FirstPersonModelCore.instance.getConfig() != null) {
            try {
                boolean dynamicMode = true;
                String vanillaHandsStr = "OFF";
                switch (currentAlien) {
                    case "pyronite": {
                        dynamicMode = (Boolean)AlienFirstPersonConfig.PYRONITE_DYNAMIC_MODE.get();
                        vanillaHandsStr = (String)AlienFirstPersonConfig.PYRONITE_VANILLA_HANDS_MODE.get();
                        break;
                    }
                    case "vulpimancer": {
                        dynamicMode = (Boolean)AlienFirstPersonConfig.VULPIMANCER_DYNAMIC_MODE.get();
                        vanillaHandsStr = (String)AlienFirstPersonConfig.VULPIMANCER_VANILLA_HANDS_MODE.get();
                        break;
                    }
                    case "petrosapien": {
                        boolean hasBattleMode = false;
                        boolean hasShield = false;
                        if (Minecraft.m_91087_().f_91074_ != null) {
                            try {
                                Collection allAbilities = AbilityUtil.getInstances((LivingEntity)Minecraft.m_91087_().f_91074_);
                                if (allAbilities != null) {
                                    for (AbilityInstance ability : allAbilities) {
                                        if (ability == null || !ability.isEnabled()) continue;
                                        String abilityId = ability.getConfiguration().getId();
                                        if ("battle_mode".equals(abilityId)) {
                                            hasBattleMode = true;
                                        }
                                        if (!"shield_activate".equals(abilityId)) continue;
                                        hasShield = true;
                                    }
                                }
                            }
                            catch (Exception e) {
                                LOGGER.debug("Error checking Petrosapien abilities: {}", (Object)e.getMessage());
                            }
                        }
                        if (hasShield) {
                            return;
                        }
                        if (hasBattleMode) {
                            dynamicMode = (Boolean)AlienFirstPersonConfig.PETROSAPIEN_BATTLE_MODE_DYNAMIC_MODE.get();
                            vanillaHandsStr = (String)AlienFirstPersonConfig.PETROSAPIEN_BATTLE_MODE_VANILLA_HANDS_MODE.get();
                            break;
                        }
                        dynamicMode = (Boolean)AlienFirstPersonConfig.PETROSAPIEN_DYNAMIC_MODE.get();
                        vanillaHandsStr = (String)AlienFirstPersonConfig.PETROSAPIEN_VANILLA_HANDS_MODE.get();
                        break;
                    }
                    case "kineceleran": {
                        boolean hasSpeed = false;
                        boolean hasSkate = false;
                        if (Minecraft.m_91087_().f_91074_ != null) {
                            try {
                                Collection allAbilities = AbilityUtil.getInstances((LivingEntity)Minecraft.m_91087_().f_91074_);
                                if (allAbilities != null) {
                                    for (AbilityInstance ability : allAbilities) {
                                        if (ability == null || !ability.isEnabled()) continue;
                                        String abilityId = ability.getConfiguration().getId();
                                        if ("speed_1".equals(abilityId) || "speed_2".equals(abilityId) || "speed_3".equals(abilityId) || "speed_4".equals(abilityId) || "speed_5".equals(abilityId)) {
                                            hasSpeed = true;
                                        }
                                        if (!"skate".equals(abilityId)) continue;
                                        hasSkate = true;
                                    }
                                }
                            }
                            catch (Exception e) {
                                LOGGER.debug("Error checking Kineceleran abilities: {}", (Object)e.getMessage());
                            }
                        }
                        if (hasSkate) {
                            dynamicMode = (Boolean)AlienFirstPersonConfig.KINECELERAN_SKATE_DYNAMIC_MODE.get();
                            vanillaHandsStr = (String)AlienFirstPersonConfig.KINECELERAN_SKATE_VANILLA_HANDS_MODE.get();
                            break;
                        }
                        if (hasSpeed) {
                            dynamicMode = (Boolean)AlienFirstPersonConfig.KINECELERAN_SPEED_DYNAMIC_MODE.get();
                            vanillaHandsStr = (String)AlienFirstPersonConfig.KINECELERAN_SPEED_VANILLA_HANDS_MODE.get();
                            break;
                        }
                        dynamicMode = (Boolean)AlienFirstPersonConfig.KINECELERAN_DYNAMIC_MODE.get();
                        vanillaHandsStr = (String)AlienFirstPersonConfig.KINECELERAN_VANILLA_HANDS_MODE.get();
                        break;
                    }
                    case "galvan": {
                        boolean hasGalvanSuit = false;
                        boolean hasGalvanLimbs = false;
                        if (Minecraft.m_91087_().f_91074_ != null) {
                            try {
                                Collection allAbilities = AbilityUtil.getInstances((LivingEntity)Minecraft.m_91087_().f_91074_);
                                if (allAbilities != null) {
                                    for (AbilityInstance ability : allAbilities) {
                                        if (ability == null || !ability.isEnabled()) continue;
                                        String abilityId = ability.getConfiguration().getId();
                                        if ("galvan_suit".equals(abilityId)) {
                                            hasGalvanSuit = true;
                                        }
                                        if (!"galvan_limbs".equals(abilityId)) continue;
                                        hasGalvanLimbs = true;
                                    }
                                }
                            }
                            catch (Exception e) {
                                LOGGER.debug("Error checking Galvan abilities: {}", (Object)e.getMessage());
                            }
                        }
                        if (hasGalvanSuit) {
                            dynamicMode = (Boolean)AlienFirstPersonConfig.GALVAN_SUIT_DYNAMIC_MODE.get();
                            vanillaHandsStr = (String)AlienFirstPersonConfig.GALVAN_SUIT_VANILLA_HANDS_MODE.get();
                            break;
                        }
                        if (hasGalvanLimbs) {
                            dynamicMode = (Boolean)AlienFirstPersonConfig.GALVAN_LIMBS_DYNAMIC_MODE.get();
                            vanillaHandsStr = (String)AlienFirstPersonConfig.GALVAN_LIMBS_VANILLA_HANDS_MODE.get();
                            break;
                        }
                        dynamicMode = (Boolean)AlienFirstPersonConfig.GALVAN_DYNAMIC_MODE.get();
                        vanillaHandsStr = (String)AlienFirstPersonConfig.GALVAN_VANILLA_HANDS_MODE.get();
                        break;
                    }
                    case "tetramand": {
                        dynamicMode = (Boolean)AlienFirstPersonConfig.TETRAMAND_DYNAMIC_MODE.get();
                        vanillaHandsStr = (String)AlienFirstPersonConfig.TETRAMAND_VANILLA_HANDS_MODE.get();
                        break;
                    }
                    case "lepidopterran": {
                        dynamicMode = (Boolean)AlienFirstPersonConfig.LEPIDOPTERRAN_DYNAMIC_MODE.get();
                        vanillaHandsStr = (String)AlienFirstPersonConfig.LEPIDOPTERRAN_VANILLA_HANDS_MODE.get();
                        break;
                    }
                    case "piscciss_volann": {
                        dynamicMode = (Boolean)AlienFirstPersonConfig.PISCCISS_VOLANN_DYNAMIC_MODE.get();
                        vanillaHandsStr = (String)AlienFirstPersonConfig.PISCCISS_VOLANN_VANILLA_HANDS_MODE.get();
                        break;
                    }
                    case "galvanic_mechamorph": {
                        boolean hasLightningPro = false;
                        if (Minecraft.m_91087_().f_91074_ != null) {
                            try {
                                Collection allAbilities = AbilityUtil.getInstances((LivingEntity)Minecraft.m_91087_().f_91074_);
                                if (allAbilities != null) {
                                    for (AbilityInstance ability : allAbilities) {
                                        String abilityId;
                                        if (ability == null || !ability.isEnabled() || !"lightningpro".equals(abilityId = ability.getConfiguration().getId())) continue;
                                        hasLightningPro = true;
                                    }
                                }
                            }
                            catch (Exception e) {
                                LOGGER.debug("Error checking Galvanic Mechamorph abilities: {}", (Object)e.getMessage());
                            }
                        }
                        if (hasLightningPro) {
                            dynamicMode = (Boolean)AlienFirstPersonConfig.GALVANIC_MECHAMORPH_ROD_DYNAMIC_MODE.get();
                            vanillaHandsStr = (String)AlienFirstPersonConfig.GALVANIC_MECHAMORPH_ROD_VANILLA_HANDS_MODE.get();
                            break;
                        }
                        dynamicMode = (Boolean)AlienFirstPersonConfig.GALVANIC_MECHAMORPH_DYNAMIC_MODE.get();
                        vanillaHandsStr = (String)AlienFirstPersonConfig.GALVANIC_MECHAMORPH_VANILLA_HANDS_MODE.get();
                        break;
                    }
                    case "ectonurite": {
                        dynamicMode = (Boolean)AlienFirstPersonConfig.ECTONURITE_DYNAMIC_MODE.get();
                        vanillaHandsStr = (String)AlienFirstPersonConfig.ECTONURITE_VANILLA_HANDS_MODE.get();
                        break;
                    }
                    case "arburian_pelarota": {
                        dynamicMode = (Boolean)AlienFirstPersonConfig.ARBURIAN_PELAROTA_DYNAMIC_MODE.get();
                        vanillaHandsStr = (String)AlienFirstPersonConfig.ARBURIAN_PELAROTA_VANILLA_HANDS_MODE.get();
                        break;
                    }
                    default: {
                        return;
                    }
                }
                FirstPersonModelCore.instance.getConfig().dynamicMode = dynamicMode;
                try {
                    VanillaHands vanillaHands;
                    FirstPersonModelCore.instance.getConfig().vanillaHandsMode = vanillaHands = VanillaHands.valueOf((String)vanillaHandsStr);
                }
                catch (IllegalArgumentException e) {
                    LOGGER.warn("Invalid vanilla hands mode for {}: {}", (Object)currentAlien, (Object)vanillaHandsStr);
                }
                LOGGER.debug("Restored {} FPM settings to saved values: dynamic={}, vanillaHands={}", new Object[]{currentAlien, dynamicMode, vanillaHandsStr});
            }
            catch (Exception e) {
                LOGGER.error("Failed to restore alien FPM settings", (Throwable)e);
            }
        }
    }

    public static boolean getAlienFirstPersonEnabled(String alienForm) {
        if (alienForm == null) {
            return true;
        }
        ConfigChangeManager manager = ConfigChangeManager.getInstance();
        switch (alienForm) {
            case "pyronite": {
                return (Boolean)manager.getPendingOrCurrentValue("pyronite.firstPersonEnabled", AlienFirstPersonConfig.PYRONITE_FIRST_PERSON_ENABLED);
            }
            case "vulpimancer": {
                return (Boolean)manager.getPendingOrCurrentValue("vulpimancer.firstPersonEnabled", AlienFirstPersonConfig.VULPIMANCER_FIRST_PERSON_ENABLED);
            }
            case "petrosapien": {
                return (Boolean)manager.getPendingOrCurrentValue("petrosapien.firstPersonEnabled", AlienFirstPersonConfig.PETROSAPIEN_FIRST_PERSON_ENABLED);
            }
            case "kineceleran": {
                return (Boolean)manager.getPendingOrCurrentValue("kineceleran.firstPersonEnabled", AlienFirstPersonConfig.KINECELERAN_FIRST_PERSON_ENABLED);
            }
            case "galvan": {
                return (Boolean)manager.getPendingOrCurrentValue("galvan.firstPersonEnabled", AlienFirstPersonConfig.GALVAN_FIRST_PERSON_ENABLED);
            }
            case "tetramand": {
                return (Boolean)manager.getPendingOrCurrentValue("tetramand.firstPersonEnabled", AlienFirstPersonConfig.TETRAMAND_FIRST_PERSON_ENABLED);
            }
            case "lepidopterran": {
                return (Boolean)manager.getPendingOrCurrentValue("lepidopterran.firstPersonEnabled", AlienFirstPersonConfig.LEPIDOPTERRAN_FIRST_PERSON_ENABLED);
            }
            case "piscciss_volann": {
                return (Boolean)manager.getPendingOrCurrentValue("piscciss_volann.firstPersonEnabled", AlienFirstPersonConfig.PISCCISS_VOLANN_FIRST_PERSON_ENABLED);
            }
            case "galvanic_mechamorph": {
                return (Boolean)manager.getPendingOrCurrentValue("galvanic_mechamorph.firstPersonEnabled", AlienFirstPersonConfig.GALVANIC_MECHAMORPH_FIRST_PERSON_ENABLED);
            }
            case "ectonurite": {
                return (Boolean)manager.getPendingOrCurrentValue("ectonurite.firstPersonEnabled", AlienFirstPersonConfig.ECTONURITE_FIRST_PERSON_ENABLED);
            }
            case "arburian_pelarota": {
                return (Boolean)manager.getPendingOrCurrentValue("arburian_pelarota.firstPersonEnabled", AlienFirstPersonConfig.ARBURIAN_PELAROTA_FIRST_PERSON_ENABLED);
            }
            case "custom_alien": {
                return (Boolean)manager.getPendingOrCurrentValue("custom_aliens.firstPersonEnabled", AlienFirstPersonConfig.CUSTOM_ALIENS_FIRST_PERSON_ENABLED);
            }
        }
        return (Boolean)manager.getPendingOrCurrentValue("custom_aliens.firstPersonEnabled", AlienFirstPersonConfig.CUSTOM_ALIENS_FIRST_PERSON_ENABLED);
    }

    public static void checkAndUpdateHumanSettings() {
        try {
            boolean dynamicChanged;
            boolean currentEnabled = FirstPersonModelCore.instance.isEnabled();
            String currentVanillaHands = "OFF";
            boolean currentDynamic = true;
            if (FirstPersonModelCore.instance.getConfig() != null) {
                currentVanillaHands = FirstPersonModelCore.instance.getConfig().vanillaHandsMode.name();
                currentDynamic = FirstPersonModelCore.instance.getConfig().dynamicMode;
            }
            boolean enabledChanged = currentEnabled != (Boolean)AlienFirstPersonConfig.STORED_HUMAN_FIRST_PERSON_ENABLED.get();
            boolean vanillaChanged = !currentVanillaHands.equals(AlienFirstPersonConfig.STORED_HUMAN_VANILLA_HANDS_MODE.get());
            boolean bl = dynamicChanged = currentDynamic != (Boolean)AlienFirstPersonConfig.STORED_HUMAN_DYNAMIC_MODE.get();
            if (enabledChanged || vanillaChanged || dynamicChanged) {
                LOGGER.debug("Human FPM settings changed - updating stored values");
                LOGGER.debug("  Enabled: {} -> {}", AlienFirstPersonConfig.STORED_HUMAN_FIRST_PERSON_ENABLED.get(), (Object)currentEnabled);
                LOGGER.debug("  Vanilla: {} -> {}", AlienFirstPersonConfig.STORED_HUMAN_VANILLA_HANDS_MODE.get(), (Object)currentVanillaHands);
                LOGGER.debug("  Dynamic: {} -> {}", AlienFirstPersonConfig.STORED_HUMAN_DYNAMIC_MODE.get(), (Object)currentDynamic);
                AlienFirstPersonConfig.STORED_HUMAN_FIRST_PERSON_ENABLED.set((Object)currentEnabled);
                AlienFirstPersonConfig.STORED_HUMAN_VANILLA_HANDS_MODE.set((Object)currentVanillaHands);
                AlienFirstPersonConfig.STORED_HUMAN_DYNAMIC_MODE.set((Object)currentDynamic);
                AlienFirstPersonConfig.CLIENT_SPEC.save();
            }
        }
        catch (Exception e) {
            LOGGER.error("Error checking human settings", (Throwable)e);
        }
    }
}

