/*
 * Decompiled with CFR 0.152.
 */
package com.parad.alienfirstperson;

import com.parad.alienfirstperson.AlienFirstPersonMod;
import dev.tr7zw.notenoughanimations.NEAnimationsLoader;
import dev.tr7zw.notenoughanimations.versionless.NEABaseMod;
import net.minecraft.client.Minecraft;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

public class NEAConfigManager {
    private static boolean initialConfigDone = false;
    private static int configCheckTicks = 0;

    public static void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> NEAConfigManager.attemptInitialConfig());
    }

    private static void attemptInitialConfig() {
        try {
            if (NEABaseMod.config != null) {
                NEABaseMod.config.burningAnimation = false;
                NEABaseMod.config.freezingAnimation = false;
                NEABaseMod.config.enableAnimationSmoothing = false;
                if (NEAnimationsLoader.INSTANCE != null) {
                    NEAnimationsLoader.INSTANCE.writeConfig();
                    AlienFirstPersonMod.LOGGER.info("Successfully set NEA default config - disabled burning/freezing animations and animation smoothing");
                }
                initialConfigDone = true;
            }
        }
        catch (Exception e) {
            AlienFirstPersonMod.LOGGER.warn("Failed to set initial NEA config, will retry: " + e.getMessage());
        }
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (!initialConfigDone && Minecraft.m_91087_().f_91074_ != null && ++configCheckTicks >= 20) {
            configCheckTicks = 0;
            NEAConfigManager.attemptInitialConfig();
        }
        if (NEABaseMod.config != null && NEABaseMod.config.enableAnimationSmoothing) {
            NEABaseMod.config.enableAnimationSmoothing = false;
            AlienFirstPersonMod.LOGGER.debug("Forced animation smoothing back to disabled");
        }
    }
}

