/*
 * Decompiled with CFR 0.152.
 */
package com.parad.alienfirstperson;

import com.parad.alienfirstperson.AlienFirstPersonMod;
import dev.tr7zw.paperdoll.PaperDollSettings;
import dev.tr7zw.paperdoll.PaperDollShared;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class PaperDollToggleManager {
    private static boolean isVisible = false;
    private static int originalXOffset = 0;
    private static int originalYOffset = 0;
    private static int originalLookingSides = 0;
    private static int originalLookingUpDown = 0;
    private static final Path VISIBILITY_FILE = Paths.get("config", "alien_first_person_paperdoll_visibility.txt");

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            // empty if block
        }
    }

    public static void togglePaperDoll() {
        try {
            if (PaperDollShared.instance != null && PaperDollShared.instance.settings != null) {
                PaperDollSettings settings = PaperDollShared.instance.settings;
                if (isVisible) {
                    originalXOffset = settings.dollXOffset;
                    originalYOffset = settings.dollYOffset;
                    originalLookingSides = settings.dollLookingSides;
                    originalLookingUpDown = settings.dollLookingUpDown;
                    settings.dollXOffset = 5000;
                    settings.dollYOffset = 5000;
                    settings.dollLookingSides = 0;
                    settings.dollLookingUpDown = 0;
                    isVisible = false;
                    AlienFirstPersonMod.LOGGER.info("Made PaperDoll invisible");
                } else {
                    settings.dollXOffset = originalXOffset;
                    settings.dollYOffset = originalYOffset;
                    settings.dollLookingSides = originalLookingSides;
                    settings.dollLookingUpDown = originalLookingUpDown;
                    isVisible = true;
                    AlienFirstPersonMod.LOGGER.info("Made PaperDoll visible");
                }
                PaperDollToggleManager.saveVisibilityState(isVisible);
                PaperDollShared.instance.writeSettings();
            }
        }
        catch (Exception e) {
            AlienFirstPersonMod.LOGGER.error("Failed to toggle PaperDoll visibility", (Throwable)e);
        }
    }

    public static boolean isPaperDollVisible() {
        return isVisible;
    }

    public static void ensurePaperDollInvisibleByDefault() {
        try {
            if (PaperDollShared.instance != null && PaperDollShared.instance.settings != null) {
                PaperDollSettings settings = PaperDollShared.instance.settings;
                settings.dollEnabled = true;
                settings.autoHide = false;
                settings.autoHideBlacklist.clear();
                boolean savedVisibility = PaperDollToggleManager.loadVisibilityState();
                if (settings.dollXOffset < 1000) {
                    originalXOffset = settings.dollXOffset;
                    originalYOffset = settings.dollYOffset;
                    originalLookingSides = settings.dollLookingSides;
                    originalLookingUpDown = settings.dollLookingUpDown;
                    if (!savedVisibility) {
                        settings.dollXOffset = 5000;
                        settings.dollYOffset = 5000;
                        settings.dollLookingSides = 0;
                        settings.dollLookingUpDown = 0;
                        isVisible = false;
                    } else {
                        isVisible = true;
                    }
                } else if (savedVisibility) {
                    settings.dollXOffset = originalXOffset;
                    settings.dollYOffset = originalYOffset;
                    settings.dollLookingSides = originalLookingSides;
                    settings.dollLookingUpDown = originalLookingUpDown;
                    isVisible = true;
                } else {
                    isVisible = false;
                }
                PaperDollShared.instance.writeSettings();
                AlienFirstPersonMod.LOGGER.info("PaperDoll visibility set based on saved preference: " + isVisible);
            }
        }
        catch (Exception e) {
            AlienFirstPersonMod.LOGGER.error("Failed to set PaperDoll visibility", (Throwable)e);
        }
    }

    private static void saveVisibilityState(boolean visible) {
        try {
            Files.createDirectories(VISIBILITY_FILE.getParent(), new FileAttribute[0]);
            Files.write(VISIBILITY_FILE, String.valueOf(visible).getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            AlienFirstPersonMod.LOGGER.error("Failed to save visibility state", (Throwable)e);
        }
    }

    private static boolean loadVisibilityState() {
        try {
            if (Files.exists(VISIBILITY_FILE, new LinkOption[0])) {
                String content = new String(Files.readAllBytes(VISIBILITY_FILE)).trim();
                return Boolean.parseBoolean(content);
            }
        }
        catch (IOException e) {
            AlienFirstPersonMod.LOGGER.error("Failed to load visibility state", (Throwable)e);
        }
        return false;
    }
}

