/*
 * Decompiled with CFR 0.152.
 */
package com.parad.alienfirstperson.config;

import com.mojang.blaze3d.systems.RenderSystem;
import com.parad.alienfirstperson.config.AlienFirstPersonConfig;
import com.parad.alienfirstperson.config.AlienFirstPersonConfigScreen;
import com.parad.alienfirstperson.config.ConfigChangeManager;
import com.parad.alienfirstperson.config.ScrollableScreen;
import com.parad.alienfirstperson.config.aliens.ArburianPelarotaConfigScreen;
import com.parad.alienfirstperson.config.aliens.EctonuriteConfigScreen;
import com.parad.alienfirstperson.config.aliens.GalvanConfigScreen;
import com.parad.alienfirstperson.config.aliens.GalvanicMechamorphConfigScreen;
import com.parad.alienfirstperson.config.aliens.KineceleranConfigScreen;
import com.parad.alienfirstperson.config.aliens.LepidopterranConfigScreen;
import com.parad.alienfirstperson.config.aliens.PetrosapienConfigScreen;
import com.parad.alienfirstperson.config.aliens.PisccissVolannConfigScreen;
import com.parad.alienfirstperson.config.aliens.PyroniteConfigScreen;
import com.parad.alienfirstperson.config.aliens.TetramandConfigScreen;
import com.parad.alienfirstperson.config.aliens.VulpimancerConfigScreen;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AlienConfigScreens {
    public static int calculateAdaptiveButtonSize(int availableHeight, int numberOfRows, int maxSize) {
        int reservedHeight = 120;
        int usableHeight = availableHeight - reservedHeight;
        int calculatedSize = Math.min(usableHeight / numberOfRows - 30, maxSize);
        return Math.max(calculatedSize, 32);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class IntSlider
    extends AbstractSliderButton {
        private final Component prefix;
        private final Component suffix;
        private final int minValue;
        private final int maxValue;
        private final boolean showDefault;
        private final Consumer<Integer> onValueChange;
        private int intValue;

        public IntSlider(int x, int y, int width, int height, Component prefix, Component suffix, int minValue, int maxValue, int value, Consumer<Integer> onValueChange, boolean showDefault) {
            super(x, y, width, height, (Component)Component.m_237119_(), 0.0);
            this.prefix = prefix;
            this.suffix = suffix;
            this.minValue = minValue;
            this.maxValue = maxValue;
            this.intValue = value;
            this.onValueChange = onValueChange;
            this.showDefault = showDefault;
            this.f_93577_ = (double)(value - minValue) / (double)(maxValue - minValue);
            this.m_5695_();
        }

        protected void m_5695_() {
            Object valueText = this.showDefault && this.intValue == 0 ? "Default" : (this.intValue > 0 ? "+" + this.intValue : String.valueOf(this.intValue));
            this.m_93666_((Component)Component.m_237113_((String)"").m_7220_(this.prefix).m_130946_((String)valueText).m_7220_(this.suffix));
        }

        protected void m_5697_() {
            this.intValue = (int)(this.f_93577_ * (double)(this.maxValue - this.minValue) + (double)this.minValue);
            if (this.onValueChange != null) {
                this.onValueChange.accept(this.intValue);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class AlienIconButton
    extends Button {
        private final ResourceLocation iconTexture;
        private float hoverAnimation = 0.0f;
        private static final float HOVER_SPEED = 0.2f;
        private final int textOffset;
        private final double textScale;

        public AlienIconButton(int x, int y, int width, int height, ResourceLocation iconTexture, Component message, Button.OnPress onPress, int textOffset, double textScale) {
            super(x, y, width, height, message, onPress, f_252438_);
            this.iconTexture = iconTexture;
            this.textOffset = textOffset;
            this.textScale = textScale;
        }

        public AlienIconButton(int x, int y, int width, int height, ResourceLocation iconTexture, Component message, Button.OnPress onPress) {
            this(x, y, width, height, iconTexture, message, onPress, 0, 1.0);
        }

        public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            this.hoverAnimation = this.f_93622_ ? Math.min(this.hoverAnimation + 0.2f, 1.0f) : Math.max(this.hoverAnimation - 0.2f, 0.0f);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            int bgColor = 0x40000000 | (int)(this.hoverAnimation * 64.0f) << 16 | (int)(this.hoverAnimation * 64.0f) << 8;
            guiGraphics.m_280509_(this.m_252754_() - 2, this.m_252907_() - 2, this.m_252754_() + this.f_93618_ + 2, this.m_252907_() + this.f_93619_ + 2, bgColor);
            int borderColor = -16711936;
            if (this.hoverAnimation > 0.0f) {
                int alpha = (int)(255.0f * this.hoverAnimation);
                borderColor = alpha << 24 | 0xFF00;
                guiGraphics.m_280509_(this.m_252754_() - 2, this.m_252907_() - 2, this.m_252754_() + this.f_93618_ + 2, this.m_252907_() - 1, borderColor);
                guiGraphics.m_280509_(this.m_252754_() - 2, this.m_252907_() + this.f_93619_ + 1, this.m_252754_() + this.f_93618_ + 2, this.m_252907_() + this.f_93619_ + 2, borderColor);
                guiGraphics.m_280509_(this.m_252754_() - 2, this.m_252907_() - 2, this.m_252754_() - 1, this.m_252907_() + this.f_93619_ + 2, borderColor);
                guiGraphics.m_280509_(this.m_252754_() + this.f_93618_ + 1, this.m_252907_() - 2, this.m_252754_() + this.f_93618_ + 2, this.m_252907_() + this.f_93619_ + 2, borderColor);
            }
            float scale = 1.0f + this.hoverAnimation * 0.1f;
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_252880_((float)this.m_252754_() + (float)this.f_93618_ / 2.0f, (float)this.m_252907_() + (float)this.f_93619_ / 2.0f, 0.0f);
            guiGraphics.m_280168_().m_85841_(scale, scale, 1.0f);
            guiGraphics.m_280168_().m_252880_(-((float)this.m_252754_() + (float)this.f_93618_ / 2.0f), -((float)this.m_252907_() + (float)this.f_93619_ / 2.0f), 0.0f);
            guiGraphics.m_280411_(this.iconTexture, this.m_252754_(), this.m_252907_(), this.f_93618_, this.f_93619_, 0.0f, 0.0f, 16, 16, 16, 16);
            guiGraphics.m_280168_().m_85849_();
            double guiScale = Minecraft.m_91087_().m_91268_().m_85449_();
            float baseTextScale = 0.85f;
            int baseTextYOffset = 6;
            if (guiScale >= 4.0) {
                baseTextYOffset = 8;
                baseTextScale = 0.6f;
            } else if (guiScale >= 3.0) {
                baseTextYOffset = 7;
                baseTextScale = 0.65f;
            }
            int finalTextYOffset = baseTextYOffset + this.textOffset;
            float finalTextScale = (float)((double)baseTextScale * this.textScale);
            guiGraphics.m_280168_().m_85836_();
            int textX = this.m_252754_() + this.f_93618_ / 2;
            int textY = this.m_252907_() + this.f_93619_ + finalTextYOffset;
            guiGraphics.m_280168_().m_252880_((float)textX, (float)textY, 0.0f);
            guiGraphics.m_280168_().m_85841_(finalTextScale, finalTextScale, 1.0f);
            guiGraphics.m_280168_().m_252880_((float)(-textX), (float)(-textY), 0.0f);
            guiGraphics.m_280653_(Minecraft.m_91087_().f_91062_, this.m_6035_(), textX, textY, 0xFFFFFF);
            guiGraphics.m_280168_().m_85849_();
            RenderSystem.disableBlend();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class AlienSelectionScreen
    extends ScrollableScreen {
        private static final ResourceLocation ALIEN_1_ICON = new ResourceLocation("alien_first_person", "textures/gui/alien_1.png");
        private static final ResourceLocation ALIEN_2_ICON = new ResourceLocation("alien_first_person", "textures/gui/alien_2.png");
        private static final ResourceLocation ALIEN_3_ICON = new ResourceLocation("alien_first_person", "textures/gui/alien_3.png");
        private static final ResourceLocation ALIEN_4_ICON = new ResourceLocation("alien_first_person", "textures/gui/alien_4.png");

        public AlienSelectionScreen(Screen previousScreen) {
            super((Component)Component.m_237113_((String)"Alien Selection"), previousScreen);
            this.showApplyCancelButtons = false;
        }

        @Override
        protected void initScrollableContent() {
            int centerX = this.f_96543_ / 2;
            ConfigChangeManager manager = ConfigChangeManager.getInstance();
            double iconSizeMultiplier = (Double)manager.getPendingOrCurrentValue("ui_customization.iconSizeMultiplier", AlienFirstPersonConfig.UI_ICON_SIZE_MULTIPLIER);
            double iconSpacingMultiplier = (Double)manager.getPendingOrCurrentValue("ui_customization.iconSpacingMultiplier", AlienFirstPersonConfig.UI_ICON_SPACING_MULTIPLIER);
            int textOffsetFromIcons = (Integer)manager.getPendingOrCurrentValue("ui_customization.textOffsetFromIcons", AlienFirstPersonConfig.UI_TEXT_OFFSET_FROM_ICONS);
            double textScaleMultiplier = (Double)manager.getPendingOrCurrentValue("ui_customization.textScaleMultiplier", AlienFirstPersonConfig.UI_TEXT_SCALE_MULTIPLIER);
            double guiScale = this.f_96541_.m_91268_().m_85449_();
            int maxIconsPerRow = 5;
            int maxScreenWidth = Math.min(this.f_96543_ - 40, 800);
            int maxIconSize = maxScreenWidth / (maxIconsPerRow + 1);
            int baseIconSize = 56;
            if (guiScale >= 4.0) {
                baseIconSize = 40;
            } else if (guiScale >= 3.0) {
                baseIconSize = 48;
            }
            int iconSize = (int)((double)Math.min(maxIconSize, baseIconSize) * iconSizeMultiplier);
            int baseSpacing = Math.max(iconSize / 2, 30);
            int spacing = (int)((double)baseSpacing * iconSpacingMultiplier);
            int startY = 20;
            int firstRowCount = 5;
            int totalWidth = iconSize * firstRowCount + spacing * (firstRowCount - 1);
            int startX = centerX - totalWidth / 2;
            if (startX < 20) {
                startX = 20;
                int availableWidth = this.f_96543_ - 40 - iconSize * firstRowCount;
                spacing = Math.max(availableWidth / (firstRowCount - 1), 15);
            }
            this.addScrollableWidget(new AlienIconButton(startX, startY, iconSize, iconSize, ALIEN_1_ICON, (Component)Component.m_237113_((String)"Pyronite"), button -> this.openPyroniteConfig(), textOffsetFromIcons, textScaleMultiplier));
            this.addScrollableWidget(new AlienIconButton(startX + iconSize + spacing, startY, iconSize, iconSize, ALIEN_2_ICON, (Component)Component.m_237113_((String)"Vulpimancer"), button -> this.openVulpimancrConfig(), textOffsetFromIcons, textScaleMultiplier));
            this.addScrollableWidget(new AlienIconButton(startX + (iconSize + spacing) * 2, startY, iconSize, iconSize, ALIEN_3_ICON, (Component)Component.m_237113_((String)"Petrosapien"), button -> this.openPetrosapienConfig(), textOffsetFromIcons, textScaleMultiplier));
            this.addScrollableWidget(new AlienIconButton(startX + (iconSize + spacing) * 3, startY, iconSize, iconSize, ALIEN_4_ICON, (Component)Component.m_237113_((String)"Kineceleran"), button -> this.openKineceleranConfig(), textOffsetFromIcons, textScaleMultiplier));
            this.addScrollableWidget(new AlienIconButton(startX + (iconSize + spacing) * 4, startY, iconSize, iconSize, new ResourceLocation("alien_first_person", "textures/gui/alien_5.png"), (Component)Component.m_237113_((String)"Galvan"), button -> this.openGalvanConfig(), textOffsetFromIcons, textScaleMultiplier));
            int rowVerticalSpacing = iconSize + 50;
            int secondRowY = startY + rowVerticalSpacing;
            int secondRowCount = 5;
            int secondRowTotalWidth = iconSize * secondRowCount + spacing * (secondRowCount - 1);
            int secondRowStartX = centerX - secondRowTotalWidth / 2;
            this.addScrollableWidget(new AlienIconButton(secondRowStartX, secondRowY, iconSize, iconSize, new ResourceLocation("alien_first_person", "textures/gui/alien_6.png"), (Component)Component.m_237113_((String)"Tetramand"), button -> this.openTetramandConfig(), textOffsetFromIcons, textScaleMultiplier));
            this.addScrollableWidget(new AlienIconButton(secondRowStartX + iconSize + spacing, secondRowY, iconSize, iconSize, new ResourceLocation("alien_first_person", "textures/gui/alien_7.png"), (Component)Component.m_237113_((String)"Lepidopterran"), button -> this.openLepidopterranConfig(), textOffsetFromIcons, textScaleMultiplier));
            this.addScrollableWidget(new AlienIconButton(secondRowStartX + (iconSize + spacing) * 2, secondRowY, iconSize, iconSize, new ResourceLocation("alien_first_person", "textures/gui/alien_8.png"), (Component)Component.m_237113_((String)"Piscciss Volann"), button -> this.openPisccissVolannConfig(), textOffsetFromIcons, textScaleMultiplier));
            this.addScrollableWidget(new AlienIconButton(secondRowStartX + (iconSize + spacing) * 3, secondRowY, iconSize, iconSize, new ResourceLocation("alien_first_person", "textures/gui/alien_9.png"), (Component)Component.m_237113_((String)"Galvanic Mechamorph"), button -> this.openGalvanicMechamorphConfig(), textOffsetFromIcons, textScaleMultiplier));
            this.addScrollableWidget(new AlienIconButton(secondRowStartX + (iconSize + spacing) * 4, secondRowY, iconSize, iconSize, new ResourceLocation("alien_first_person", "textures/gui/alien_10.png"), (Component)Component.m_237113_((String)"Ectonurite"), button -> this.openEctonuriteConfig(), textOffsetFromIcons, textScaleMultiplier));
            int thirdRowY = secondRowY + rowVerticalSpacing;
            int thirdRowStartX = centerX - iconSize / 2;
            this.addScrollableWidget(new AlienIconButton(thirdRowStartX, thirdRowY, iconSize, iconSize, new ResourceLocation("alien_first_person", "textures/gui/alien_11.png"), (Component)Component.m_237113_((String)"Arburian Pelarota"), button -> this.openArburianPelarotaConfig(), textOffsetFromIcons, textScaleMultiplier));
            this.setContentHeight(thirdRowY + iconSize + 70);
        }

        private void openPyroniteConfig() {
            if (this.f_96541_ != null) {
                this.f_96541_.m_91152_((Screen)new PyroniteConfigScreen(this));
            }
        }

        private void openVulpimancrConfig() {
            if (this.f_96541_ != null) {
                this.f_96541_.m_91152_((Screen)new VulpimancerConfigScreen(this));
            }
        }

        private void openPetrosapienConfig() {
            if (this.f_96541_ != null) {
                this.f_96541_.m_91152_((Screen)new PetrosapienConfigScreen(this));
            }
        }

        private void openKineceleranConfig() {
            if (this.f_96541_ != null) {
                this.f_96541_.m_91152_((Screen)new KineceleranConfigScreen(this));
            }
        }

        private void openGalvanConfig() {
            if (this.f_96541_ != null) {
                this.f_96541_.m_91152_((Screen)new GalvanConfigScreen(this));
            }
        }

        private void openTetramandConfig() {
            if (this.f_96541_ != null) {
                this.f_96541_.m_91152_((Screen)new TetramandConfigScreen(this));
            }
        }

        private void openLepidopterranConfig() {
            if (this.f_96541_ != null) {
                this.f_96541_.m_91152_((Screen)new LepidopterranConfigScreen(this));
            }
        }

        private void openPisccissVolannConfig() {
            if (this.f_96541_ != null) {
                this.f_96541_.m_91152_((Screen)new PisccissVolannConfigScreen(this));
            }
        }

        private void openGalvanicMechamorphConfig() {
            if (this.f_96541_ != null) {
                this.f_96541_.m_91152_((Screen)new GalvanicMechamorphConfigScreen(this));
            }
        }

        private void openEctonuriteConfig() {
            if (this.f_96541_ != null) {
                this.f_96541_.m_91152_((Screen)new EctonuriteConfigScreen(this));
            }
        }

        private void openArburianPelarotaConfig() {
            if (this.f_96541_ != null) {
                this.f_96541_.m_91152_((Screen)new ArburianPelarotaConfigScreen(this));
            }
        }

        @Override
        protected void resetMainScreenState() {
            if (this.previousScreen instanceof AlienFirstPersonConfigScreen.MainConfigScreen) {
                AlienFirstPersonConfigScreen.MainConfigScreen mainScreen = (AlienFirstPersonConfigScreen.MainConfigScreen)this.previousScreen;
                mainScreen.isTransitioning = false;
                mainScreen.transitionAlpha = 0.0f;
                mainScreen.isRotating = false;
            }
        }
    }
}

