/*
 * Decompiled with CFR 0.152.
 */
package com.parad.alienfirstperson.config;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.math.Axis;
import com.parad.alienfirstperson.AlienFirstPersonMod;
import com.parad.alienfirstperson.AlienSoundEvents;
import com.parad.alienfirstperson.PaperDollToggleManager;
import com.parad.alienfirstperson.config.AlienConfigScreens;
import com.parad.alienfirstperson.config.AlienFirstPersonConfig;
import com.parad.alienfirstperson.config.UICustomizationScreens;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.fml.ModLoadingContext;

@OnlyIn(value=Dist.CLIENT)
public class AlienFirstPersonConfigScreen {
    public static void register() {
        try {
            ModLoadingContext.get().registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((minecraft, screen) -> new MainConfigScreen((Screen)screen)));
            AlienFirstPersonMod.LOGGER.info("Config screen registered successfully for Forge 1.20.1");
        }
        catch (Exception e) {
            AlienFirstPersonMod.LOGGER.error("Failed to register config screen", (Throwable)e);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class MainConfigScreen
    extends Screen {
        private final Screen previousScreen;
        private float currentRotation = 0.0f;
        private float targetRotation = 0.0f;
        private float rotationVelocity = 0.0f;
        private static final float ROTATION_ACCELERATION = 15.0f;
        private static final float ROTATION_DAMPING = 0.85f;
        private static final float ROTATION_MAX_SPEED = 8.0f;
        private long lastFrameTime = System.nanoTime();
        private int currentSelection = 0;
        private boolean hasRotated = false;
        boolean hasPlayedOpenSound = false;
        boolean isRotating = false;
        boolean isTransitioning = false;
        float transitionAlpha = 0.0f;
        private static final float TRANSITION_SPEED = 0.1f;
        private Screen nextScreen = null;
        private float redFlashTimer = 0.0f;
        private static final float RED_FLASH_DURATION = 0.3f;
        private static final ResourceLocation OMNI_BG = new ResourceLocation("alien_first_person", "textures/gui/omnibg.png");
        private static final ResourceLocation OMNI_BBG = new ResourceLocation("alien_first_person", "textures/gui/omnibbg.png");
        private static final ResourceLocation OMNI_LEFT = new ResourceLocation("alien_first_person", "textures/gui/omnileft.png");
        private static final ResourceLocation OMNI_RIGHT = new ResourceLocation("alien_first_person", "textures/gui/omniright.png");
        private static final ResourceLocation OMNI_RIM = new ResourceLocation("alien_first_person", "textures/gui/omnirim.png");
        private static final ResourceLocation RIM_LIGHT = new ResourceLocation("alien_first_person", "textures/gui/rimlight.png");
        private static final ResourceLocation OMNI_NEW_SHINE = new ResourceLocation("alien_first_person", "textures/gui/omninewshine.png");
        private static final ResourceLocation OMNI_NEW_RIM_LIGHT = new ResourceLocation("alien_first_person", "textures/gui/omninewrimlight.png");
        private static final ResourceLocation OMNI_BG_LINE = new ResourceLocation("alien_first_person", "textures/gui/omnibgline.png");
        private static final ResourceLocation COVER = new ResourceLocation("alien_first_person", "textures/gui/cover.png");
        private static final ResourceLocation[] OMNI_BG_LINE_GLOWS = new ResourceLocation[20];
        private float glowAnimationTimer = 0.0f;
        private float glowAnimationTimer2 = 0.0f;
        private static final float GLOW_ANIMATION_SPEED = 0.07f;
        private static final float GLOW_OFFSET = 0.3f;
        private float glowPauseTimer = 0.0f;
        private static final float GLOW_PAUSE_DURATION = 2.5f;
        private static final ResourceLocation ARROW_LEFT;
        private static final ResourceLocation ARROW_RIGHT;
        private static final ResourceLocation LEFT_BORDER;
        private static final ResourceLocation RIGHT_BORDER;
        private static final ResourceLocation GENFEAT_ICON;
        private static final ResourceLocation ALIENCONFIG_ICON;
        private static final ResourceLocation CUSTOMALIENS_ICON;
        private float leftArrowOffset = 0.0f;
        private float rightArrowOffset = 0.0f;
        private static final float ARROW_SLIDE_SPEED = 0.3f;
        private static final float MAX_ARROW_OFFSET = 50.0f;
        private float iconFlickerTimer = 0.0f;
        private static final float FLICKER_DURATION = 0.5f;
        private static final float FLICKER_SPEED = 0.13f;
        private float wiggleTimer = 0.0f;
        private static final float WIGGLE_DURATION = 1.5f;
        private static final float WIGGLE_AMPLITUDE = 8.0f;
        private static final float WIGGLE_FREQUENCY = 4.0f;
        private static final float INITIAL_GLOW_PAUSE = 1.0f;

        public MainConfigScreen(Screen previousScreen) {
            super((Component)Component.m_237113_((String)"Alien First Person Configuration"));
            this.previousScreen = previousScreen;
            this.glowAnimationTimer = 0.0f;
            this.glowAnimationTimer2 = 0.0f;
            this.glowPauseTimer = 1.0f;
            this.iconFlickerTimer = 0.5f;
            this.wiggleTimer = 1.5f;
        }

        protected void m_7856_() {
            super.m_7856_();
            if (!this.hasPlayedOpenSound && this.f_96541_ != null) {
                this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)((SoundEvent)AlienSoundEvents.PROTOTYPE_ACTIVATE.get()), (float)1.0f));
                this.hasPlayedOpenSound = true;
            }
            int centerX = this.f_96543_ / 2;
            int centerButtonWidth = 100;
            int leftButtonEnd = centerX - centerButtonWidth / 2;
            int rightButtonStart = centerX + centerButtonWidth / 2;
            this.m_142416_((GuiEventListener)new SilentInvisibleButton(0, 0, leftButtonEnd, this.f_96544_, (Component)Component.m_237119_(), button -> this.rotateLeft()));
            this.m_142416_((GuiEventListener)new SilentInvisibleButton(rightButtonStart, 0, this.f_96543_ - rightButtonStart, this.f_96544_, (Component)Component.m_237119_(), button -> this.rotateRight()));
            this.m_142416_((GuiEventListener)new SilentInvisibleButton(leftButtonEnd, 0, centerButtonWidth, this.f_96544_, (Component)Component.m_237119_(), button -> this.selectCurrentOption()));
        }

        private void rotateLeft() {
            if (this.isTransitioning || this.isRotating) {
                return;
            }
            this.isRotating = true;
            this.hasRotated = true;
            this.currentRotation = (float)Math.round(this.currentRotation / 90.0f) * 90.0f;
            this.targetRotation = this.currentRotation - 90.0f;
            this.currentSelection = (this.currentSelection - 1 + 3) % 3;
            this.iconFlickerTimer = 0.5f;
            AlienFirstPersonMod.LOGGER.debug("Rotating left: current={}, target={}", (Object)Float.valueOf(this.currentRotation), (Object)Float.valueOf(this.targetRotation));
            if (this.f_96541_ != null) {
                this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)((SoundEvent)AlienSoundEvents.PROTOTYPE_CYCLE_2.get()), (float)1.0f));
            }
        }

        private void rotateRight() {
            if (this.isTransitioning || this.isRotating) {
                return;
            }
            this.isRotating = true;
            this.hasRotated = true;
            this.currentRotation = (float)Math.round(this.currentRotation / 90.0f) * 90.0f;
            this.targetRotation = this.currentRotation + 90.0f;
            this.currentSelection = (this.currentSelection + 1) % 3;
            this.iconFlickerTimer = 0.5f;
            AlienFirstPersonMod.LOGGER.debug("Rotating right: current={}, target={}", (Object)Float.valueOf(this.currentRotation), (Object)Float.valueOf(this.targetRotation));
            if (this.f_96541_ != null) {
                this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)((SoundEvent)AlienSoundEvents.PROTOTYPE_CYCLE_1.get()), (float)1.0f));
            }
        }

        private void selectCurrentOption() {
            if (this.f_96541_ != null && !this.isTransitioning) {
                if (this.currentSelection == 2) {
                    this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)((SoundEvent)AlienSoundEvents.FEATURE_LOCKED.get()), (float)1.0f));
                    this.redFlashTimer = 0.3f;
                    return;
                }
                this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)((SoundEvent)AlienSoundEvents.PROTOTYPE_TRANSFORM.get()), (float)1.0f));
                this.isTransitioning = true;
                this.transitionAlpha = 0.0f;
                if (this.currentSelection == 0) {
                    this.nextScreen = new GeneralFeaturesScreen(this);
                } else if (this.currentSelection == 1) {
                    this.nextScreen = new AlienConfigScreens.AlienSelectionScreen(this);
                }
            }
        }

        private RenderDimensions calculateFillDimensions(int screenWidth, int screenHeight) {
            float scale;
            int offsetY;
            int offsetX;
            int renderHeight;
            int renderWidth;
            float screenAspect = (float)screenWidth / (float)screenHeight;
            float imageAspect = 1.7777778f;
            if (screenAspect > imageAspect) {
                renderWidth = screenWidth;
                renderHeight = (int)((float)screenWidth / imageAspect);
                offsetX = 0;
                offsetY = (screenHeight - renderHeight) / 2;
                scale = (float)screenWidth / 1920.0f;
            } else {
                renderHeight = screenHeight;
                renderWidth = (int)((float)screenHeight * imageAspect);
                offsetX = (screenWidth - renderWidth) / 2;
                offsetY = 0;
                scale = (float)screenHeight / 1080.0f;
            }
            return new RenderDimensions(offsetX, offsetY, renderWidth, renderHeight, scale);
        }

        public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            int arrowX;
            int arrowSize;
            this.m_280273_(guiGraphics);
            long currentTime = System.nanoTime();
            float deltaTime = (float)(currentTime - this.lastFrameTime) / 1.0E9f;
            this.lastFrameTime = currentTime;
            if (this.isRotating) {
                float rotationDiff = this.targetRotation - this.currentRotation;
                float distanceToTarget = Math.abs(rotationDiff);
                if (distanceToTarget < 1.0f) {
                    this.currentRotation = this.targetRotation;
                    this.rotationVelocity = 0.0f;
                    this.isRotating = false;
                } else {
                    float acceleration = Math.signum(rotationDiff) * 15.0f;
                    if (distanceToTarget < 45.0f) {
                        acceleration *= distanceToTarget / 45.0f;
                        this.rotationVelocity *= 0.85f;
                    }
                    this.rotationVelocity += acceleration;
                    this.rotationVelocity = Mth.m_14036_((float)this.rotationVelocity, (float)-8.0f, (float)8.0f);
                    float newRotation = this.currentRotation + this.rotationVelocity;
                    if (rotationDiff > 0.0f && newRotation > this.targetRotation || rotationDiff < 0.0f && newRotation < this.targetRotation) {
                        this.currentRotation = this.targetRotation;
                        this.rotationVelocity = 0.0f;
                        this.isRotating = false;
                    } else {
                        this.currentRotation = newRotation;
                    }
                }
            }
            if (this.glowPauseTimer > 0.0f) {
                this.glowPauseTimer -= deltaTime;
                if (this.glowPauseTimer <= 0.0f) {
                    this.glowAnimationTimer = 0.0f;
                    this.glowAnimationTimer2 = 0.3f;
                }
            } else {
                this.glowAnimationTimer += 0.07f;
                this.glowAnimationTimer2 = this.glowAnimationTimer + 0.3f;
                if (this.glowAnimationTimer2 >= 20.0f) {
                    this.glowAnimationTimer2 -= 20.0f;
                }
                if (this.glowAnimationTimer >= 19.1f) {
                    this.glowPauseTimer = 2.5f;
                    this.glowAnimationTimer = 19.1f;
                }
            }
            if (this.wiggleTimer > 0.0f) {
                this.wiggleTimer -= deltaTime;
                if (this.wiggleTimer < 0.0f) {
                    this.wiggleTimer = 0.0f;
                }
            }
            if (this.iconFlickerTimer > 0.0f) {
                this.iconFlickerTimer -= deltaTime;
                if (this.iconFlickerTimer < 0.0f) {
                    this.iconFlickerTimer = 0.0f;
                }
            }
            if (this.redFlashTimer > 0.0f) {
                this.redFlashTimer -= deltaTime;
                if (this.redFlashTimer < 0.0f) {
                    this.redFlashTimer = 0.0f;
                }
            }
            if (this.isTransitioning) {
                this.transitionAlpha = Math.min(this.transitionAlpha + 0.1f, 1.0f);
                if (this.transitionAlpha >= 1.0f && this.nextScreen != null && this.f_96541_ != null) {
                    this.f_96541_.m_91152_(this.nextScreen);
                    return;
                }
            }
            int centerX = this.f_96543_ / 2;
            int centerButtonWidth = 100;
            int leftButtonEnd = centerX - centerButtonWidth / 2;
            int rightButtonStart = centerX + centerButtonWidth / 2;
            boolean hoveringLeft = mouseX < leftButtonEnd;
            boolean hoveringRight = mouseX > rightButtonStart;
            this.leftArrowOffset = hoveringLeft ? Math.min(this.leftArrowOffset + 6.0f, 50.0f) : Math.max(this.leftArrowOffset - 6.0f, 0.0f);
            this.rightArrowOffset = hoveringRight ? Math.min(this.rightArrowOffset + 6.0f, 50.0f) : Math.max(this.rightArrowOffset - 6.0f, 0.0f);
            super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
            RenderDimensions dims = this.calculateFillDimensions(this.f_96543_, this.f_96544_);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (dims.y > 0) {
                guiGraphics.m_280163_(COVER, 0, 0, 0.0f, 0.0f, this.f_96543_, dims.y, 16, 16);
            }
            if (dims.y + dims.height < this.f_96544_) {
                guiGraphics.m_280163_(COVER, 0, dims.y + dims.height, 0.0f, 0.0f, this.f_96543_, this.f_96544_ - (dims.y + dims.height), 16, 16);
            }
            if (dims.x > 0) {
                guiGraphics.m_280163_(COVER, 0, 0, 0.0f, 0.0f, dims.x, this.f_96544_, 16, 16);
            }
            if (dims.x + dims.width < this.f_96543_) {
                guiGraphics.m_280163_(COVER, dims.x + dims.width, 0, 0.0f, 0.0f, this.f_96543_ - (dims.x + dims.width), this.f_96544_, 16, 16);
            }
            guiGraphics.m_280411_(OMNI_BBG, dims.x, dims.y, dims.width, dims.height, 0.0f, 0.0f, 1920, 1080, 1920, 1080);
            if (this.redFlashTimer > 0.0f) {
                float redIntensity = this.redFlashTimer / 0.3f;
                RenderSystem.setShaderColor((float)1.0f, (float)0.0f, (float)0.0f, (float)(redIntensity * 0.7f));
                guiGraphics.m_280411_(OMNI_BBG, dims.x, dims.y, dims.width, dims.height, 0.0f, 0.0f, 1920, 1080, 1920, 1080);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            guiGraphics.m_280411_(OMNI_BG_LINE, dims.x, dims.y, dims.width, dims.height, 0.0f, 0.0f, 1920, 1080, 1920, 1080);
            if (this.glowPauseTimer <= 0.0f) {
                int glowFrame1 = (int)this.glowAnimationTimer;
                float glowAlpha1 = this.glowAnimationTimer - (float)glowFrame1;
                int nextGlowFrame1 = (glowFrame1 + 1) % 20;
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(1.0f - glowAlpha1));
                guiGraphics.m_280411_(OMNI_BG_LINE_GLOWS[glowFrame1], dims.x, dims.y, dims.width, dims.height, 0.0f, 0.0f, 1920, 1080, 1920, 1080);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)glowAlpha1);
                guiGraphics.m_280411_(OMNI_BG_LINE_GLOWS[nextGlowFrame1], dims.x, dims.y, dims.width, dims.height, 0.0f, 0.0f, 1920, 1080, 1920, 1080);
                int glowFrame2 = (int)this.glowAnimationTimer2;
                float glowAlpha2 = this.glowAnimationTimer2 - (float)glowFrame2;
                int nextGlowFrame2 = (glowFrame2 + 1) % 20;
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)((1.0f - glowAlpha2) * 0.5f));
                guiGraphics.m_280411_(OMNI_BG_LINE_GLOWS[glowFrame2], dims.x, dims.y, dims.width, dims.height, 0.0f, 0.0f, 1920, 1080, 1920, 1080);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(glowAlpha2 * 0.5f));
                guiGraphics.m_280411_(OMNI_BG_LINE_GLOWS[nextGlowFrame2], dims.x, dims.y, dims.width, dims.height, 0.0f, 0.0f, 1920, 1080, 1920, 1080);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            guiGraphics.m_280411_(RIM_LIGHT, dims.x, dims.y, dims.width, dims.height, 0.0f, 0.0f, 1920, 1080, 1920, 1080);
            float wiggleOffset = 0.0f;
            if (this.wiggleTimer > 0.0f) {
                float progress = 1.0f - this.wiggleTimer / 1.5f;
                float decay = 1.0f - progress;
                wiggleOffset = (float)(Math.sin((double)progress * Math.PI * 2.0 * 4.0) * 8.0 * (double)decay);
            }
            guiGraphics.m_280411_(OMNI_LEFT, dims.x - (int)(wiggleOffset * dims.scale), dims.y, dims.width, dims.height, 0.0f, 0.0f, 1920, 1080, 1920, 1080);
            guiGraphics.m_280411_(OMNI_RIGHT, dims.x + (int)(wiggleOffset * dims.scale), dims.y, dims.width, dims.height, 0.0f, 0.0f, 1920, 1080, 1920, 1080);
            guiGraphics.m_280411_(OMNI_BG, dims.x, dims.y, dims.width, dims.height, 0.0f, 0.0f, 1920, 1080, 1920, 1080);
            if (!this.isTransitioning) {
                float iconAlpha = 1.0f;
                if (this.iconFlickerTimer > 0.0f) {
                    float flickerProgress = 1.0f - this.iconFlickerTimer / 0.5f;
                    float flickerFrequency = 30.0f * (1.0f - flickerProgress);
                    float flicker = (float)Math.sin(this.iconFlickerTimer * flickerFrequency) * 0.5f + 0.5f;
                    iconAlpha = Mth.m_14179_((float)flickerProgress, (float)(flicker * 0.8f), (float)1.0f);
                }
                if (this.currentSelection == 0) {
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)iconAlpha);
                    guiGraphics.m_280411_(GENFEAT_ICON, dims.x, dims.y, dims.width, dims.height, 0.0f, 0.0f, 1920, 1080, 1920, 1080);
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                } else if (this.currentSelection == 1) {
                    guiGraphics.m_280168_().m_85836_();
                    float iconCenterX = (float)dims.x + (float)dims.width / 2.0f;
                    float iconCenterY = (float)dims.y + (float)dims.height / 2.0f;
                    guiGraphics.m_280168_().m_252880_(iconCenterX, iconCenterY, 0.0f);
                    guiGraphics.m_280168_().m_252781_(Axis.f_252403_.m_252977_(-45.0f));
                    guiGraphics.m_280168_().m_252880_(-iconCenterX, -iconCenterY, 0.0f);
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)iconAlpha);
                    guiGraphics.m_280411_(ALIENCONFIG_ICON, dims.x, dims.y, dims.width, dims.height, 0.0f, 0.0f, 1920, 1080, 1920, 1080);
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    guiGraphics.m_280168_().m_85849_();
                } else if (this.currentSelection == 2) {
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)iconAlpha);
                    guiGraphics.m_280411_(CUSTOMALIENS_ICON, dims.x, dims.y, dims.width, dims.height, 0.0f, 0.0f, 1920, 1080, 1920, 1080);
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                }
            }
            guiGraphics.m_280411_(OMNI_NEW_SHINE, dims.x, dims.y, dims.width, dims.height, 0.0f, 0.0f, 1920, 1080, 1920, 1080);
            guiGraphics.m_280168_().m_85836_();
            float imageCenterX = (float)dims.x + (float)dims.width / 2.0f;
            float imageCenterY = (float)dims.y + (float)dims.height / 2.0f;
            guiGraphics.m_280168_().m_252880_(imageCenterX, imageCenterY, 0.0f);
            guiGraphics.m_280168_().m_252781_(Axis.f_252403_.m_252977_(this.currentRotation));
            guiGraphics.m_280168_().m_252880_(-imageCenterX, -imageCenterY, 0.0f);
            guiGraphics.m_280411_(OMNI_RIM, dims.x, dims.y, dims.width, dims.height, 0.0f, 0.0f, 1920, 1080, 1920, 1080);
            guiGraphics.m_280168_().m_85849_();
            guiGraphics.m_280411_(OMNI_NEW_RIM_LIGHT, dims.x, dims.y, dims.width, dims.height, 0.0f, 0.0f, 1920, 1080, 1920, 1080);
            if (hoveringLeft || hoveringRight) {
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                if (hoveringLeft) {
                    guiGraphics.m_280411_(LEFT_BORDER, 0, 0, leftButtonEnd, this.f_96544_, 0.0f, 0.0f, 1920, 1080, 1920, 1080);
                } else if (hoveringRight) {
                    int rightWidth = this.f_96543_ - rightButtonStart;
                    guiGraphics.m_280411_(RIGHT_BORDER, rightButtonStart, 0, rightWidth, this.f_96544_, 0.0f, 0.0f, 1080, 1920, 1080, 1920);
                }
                RenderSystem.disableBlend();
            }
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            if (this.leftArrowOffset > 0.0f) {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(this.leftArrowOffset / 50.0f));
                arrowSize = Math.min((int)(64.0f * dims.scale), 80);
                int arrowY = this.f_96544_ / 2 - arrowSize / 2;
                arrowX = (int)(20.0f - (50.0f - this.leftArrowOffset));
                guiGraphics.m_280411_(ARROW_LEFT, arrowX, arrowY, arrowSize, arrowSize, 0.0f, 0.0f, 256, 256, 256, 256);
            }
            if (this.rightArrowOffset > 0.0f) {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(this.rightArrowOffset / 50.0f));
                arrowSize = Math.min((int)(64.0f * dims.scale), 80);
                int arrowY = this.f_96544_ / 2 - arrowSize / 2;
                arrowX = (int)((float)(this.f_96543_ - 20 - arrowSize) + (50.0f - this.rightArrowOffset));
                guiGraphics.m_280411_(ARROW_RIGHT, arrowX, arrowY, arrowSize, arrowSize, 0.0f, 0.0f, 256, 256, 256, 256);
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableBlend();
            if (this.isTransitioning) {
                if (this.transitionAlpha < 1.0f) {
                    this.transitionAlpha = Math.min(this.transitionAlpha + 0.1f, 1.0f);
                }
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                RenderSystem.disableDepthTest();
                int greenColor = (int)(this.transitionAlpha * 0.8f * 255.0f) << 24 | 0xFF00;
                guiGraphics.m_280509_(0, 0, this.f_96543_, this.f_96544_, greenColor);
                RenderSystem.enableDepthTest();
                RenderSystem.disableBlend();
            }
        }

        public void m_7379_() {
            if (this.f_96541_ != null) {
                this.f_96541_.m_91152_(this.previousScreen);
            }
        }

        public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
            if (keyCode == 256) {
                AlienFirstPersonMod.LOGGER.debug("ESC key pressed in GeneralFeaturesScreen");
                this.m_7379_();
                return true;
            }
            return super.m_7933_(keyCode, scanCode, modifiers);
        }

        public boolean m_7043_() {
            return false;
        }

        static {
            try {
                int index = 0;
                for (int i = 1; i <= 10; ++i) {
                    ResourceLocation wholeLoc = new ResourceLocation("alien_first_person", "textures/gui/omnibgline" + i + ".png");
                    MainConfigScreen.OMNI_BG_LINE_GLOWS[index++] = wholeLoc;
                    AlienFirstPersonMod.LOGGER.debug("Loaded glow frame: omnibgline" + i + ".png");
                    ResourceLocation halfLoc = new ResourceLocation("alien_first_person", "textures/gui/omnibgline" + i + ".5.png");
                    MainConfigScreen.OMNI_BG_LINE_GLOWS[index++] = halfLoc;
                    AlienFirstPersonMod.LOGGER.debug("Loaded glow frame: omnibgline" + i + ".5.png");
                }
            }
            catch (Exception e) {
                AlienFirstPersonMod.LOGGER.error("Failed to load glow animation textures", (Throwable)e);
                for (int i = 0; i < 20; ++i) {
                    if (OMNI_BG_LINE_GLOWS[i] != null) continue;
                    MainConfigScreen.OMNI_BG_LINE_GLOWS[i] = OMNI_BG_LINE;
                }
            }
            ARROW_LEFT = new ResourceLocation("alien_first_person", "textures/gui/left.png");
            ARROW_RIGHT = new ResourceLocation("alien_first_person", "textures/gui/right.png");
            LEFT_BORDER = new ResourceLocation("alien_first_person", "textures/gui/leftbord.png");
            RIGHT_BORDER = new ResourceLocation("alien_first_person", "textures/gui/rightbord.png");
            GENFEAT_ICON = new ResourceLocation("alien_first_person", "textures/gui/genfeat.png");
            ALIENCONFIG_ICON = new ResourceLocation("alien_first_person", "textures/gui/alienconfig.png");
            CUSTOMALIENS_ICON = new ResourceLocation("alien_first_person", "textures/gui/customaliens.png");
        }

        public static class SilentInvisibleButton
        extends Button {
            public SilentInvisibleButton(int x, int y, int width, int height, Component message, Button.OnPress onPress) {
                super(x, y, width, height, message, onPress, f_252438_);
            }

            public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            }

            public void m_7435_(SoundManager soundManager) {
            }
        }

        private static class RenderDimensions {
            final int x;
            final int y;
            final int width;
            final int height;
            final float scale;

            RenderDimensions(int x, int y, int width, int height, float scale) {
                this.x = x;
                this.y = y;
                this.width = width;
                this.height = height;
                this.scale = scale;
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class GeneralFeaturesScreen
    extends Screen {
        private final Screen previousScreen;
        private float fadeInAlpha = 1.0f;
        private static final float FADE_SPEED = 0.01f;
        private boolean isClosing = false;

        public GeneralFeaturesScreen(Screen previousScreen) {
            super((Component)Component.m_237113_((String)"General Features"));
            this.previousScreen = previousScreen;
        }

        protected void m_7856_() {
            super.m_7856_();
            int centerX = this.f_96543_ / 2;
            int startY = 50;
            UICustomizationScreens.CustomizationButton customizationButton = new UICustomizationScreens.CustomizationButton(centerX - 75, startY, 150, 25, new ResourceLocation("alien_first_person", "textures/gui/customization.png"), (Component)Component.m_237113_((String)"UI Customization"), button -> this.openCustomizationScreen());
            this.m_142416_((GuiEventListener)customizationButton);
            Button omnitrixButton = Button.m_253074_((Component)Component.m_237113_((String)("Disable First Person on Omnitrix activation: " + ((Boolean)AlienFirstPersonConfig.DISABLE_FIRST_PERSON_ON_OMNITRIX.get() != false ? "ON" : "OFF"))), button -> {
                boolean newValue = (Boolean)AlienFirstPersonConfig.DISABLE_FIRST_PERSON_ON_OMNITRIX.get() == false;
                AlienFirstPersonConfig.DISABLE_FIRST_PERSON_ON_OMNITRIX.set((Object)newValue);
                button.m_93666_((Component)Component.m_237113_((String)("Disable First Person on Omnitrix activation: " + (newValue ? "ON" : "OFF"))));
                AlienFirstPersonMod.LOGGER.info("Set omnitrix config to: " + newValue);
            }).m_252987_(centerX - 150, startY += 40, 300, 20).m_257505_(Tooltip.m_257550_((Component)Component.m_237113_((String)"When enabled, first person model will be disabled when Omnitrix is active"))).m_253136_();
            this.m_142416_((GuiEventListener)omnitrixButton);
            Button paperDollButton = Button.m_253074_((Component)Component.m_237113_((String)("PaperDoll Visibility: " + (PaperDollToggleManager.isPaperDollVisible() ? "VISIBLE" : "HIDDEN"))), button -> {
                PaperDollToggleManager.togglePaperDoll();
                button.m_93666_((Component)Component.m_237113_((String)("PaperDoll Visibility: " + (PaperDollToggleManager.isPaperDollVisible() ? "VISIBLE" : "HIDDEN"))));
                AlienFirstPersonMod.LOGGER.info("Toggled PaperDoll visibility");
            }).m_252987_(centerX - 150, startY + 30, 300, 20).m_257505_(Tooltip.m_257550_((Component)Component.m_237113_((String)"Toggle the visibility of the PaperDoll character display"))).m_253136_();
            this.m_142416_((GuiEventListener)paperDollButton);
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Back"), button -> {
                AlienFirstPersonMod.LOGGER.debug("Back button clicked");
                this.m_7379_();
            }).m_252987_(this.f_96543_ / 2 - 100, this.f_96544_ - 27, 200, 20).m_253136_());
        }

        private void openCustomizationScreen() {
            if (this.f_96541_ != null) {
                this.f_96541_.m_91152_((Screen)new UICustomizationScreens.UICustomizationScreen(this));
            }
        }

        public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            this.m_280273_(guiGraphics);
            guiGraphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 20, 0xFFFFFF);
            super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
            if (this.fadeInAlpha > 0.0f && !this.isClosing) {
                this.fadeInAlpha = Math.max(this.fadeInAlpha - 0.01f, 0.0f);
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                RenderSystem.disableDepthTest();
                int greenColor = (int)(this.fadeInAlpha * 0.8f * 255.0f) << 24 | 0xFF00;
                guiGraphics.m_280509_(0, 0, this.f_96543_, this.f_96544_, greenColor);
                RenderSystem.enableDepthTest();
                RenderSystem.disableBlend();
            }
        }

        public void m_7379_() {
            AlienFirstPersonMod.LOGGER.debug("GeneralFeaturesScreen onClose called");
            try {
                AlienFirstPersonConfig.CLIENT_SPEC.save();
            }
            catch (Exception e) {
                AlienFirstPersonMod.LOGGER.error("Failed to save config", (Throwable)e);
            }
            this.isClosing = true;
            if (this.previousScreen instanceof MainConfigScreen) {
                MainConfigScreen mainScreen = (MainConfigScreen)this.previousScreen;
                mainScreen.isTransitioning = false;
                mainScreen.transitionAlpha = 0.0f;
                mainScreen.isRotating = false;
            }
            if (this.f_96541_ != null) {
                AlienFirstPersonMod.LOGGER.debug("Setting screen back to: {}", (Object)this.previousScreen);
                this.f_96541_.m_91152_(this.previousScreen);
            }
        }

        public boolean m_7043_() {
            return false;
        }
    }
}

