/*
 * Decompiled with CFR 0.152.
 */
package com.parad.alienfirstperson.config;

import com.parad.alienfirstperson.AlienFirstPersonMod;
import com.parad.alienfirstperson.config.AlienFirstPersonConfig;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.common.ForgeConfigSpec;

public class ConfigChangeManager {
    private static final ConfigChangeManager INSTANCE = new ConfigChangeManager();
    private final Map<String, PendingChange> pendingChanges = new HashMap<String, PendingChange>();
    private final Object lock = new Object();

    private ConfigChangeManager() {
    }

    public static ConfigChangeManager getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPendingValue(String configPath, Object value, ForgeConfigSpec.ConfigValue<?> configValue) {
        Object object = this.lock;
        synchronized (object) {
            this.pendingChanges.put(configPath, new PendingChange(value, configValue));
            AlienFirstPersonMod.LOGGER.debug("Pending change recorded: {} = {}", (Object)configPath, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getPendingOrCurrentValue(String configPath, ForgeConfigSpec.ConfigValue<T> configValue) {
        Object object = this.lock;
        synchronized (object) {
            PendingChange pending = this.pendingChanges.get(configPath);
            if (pending != null) {
                return (T)pending.value;
            }
            return (T)configValue.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyAllChanges() {
        Object object = this.lock;
        synchronized (object) {
            if (this.pendingChanges.isEmpty()) {
                AlienFirstPersonMod.LOGGER.debug("No pending changes to apply");
                return;
            }
            AlienFirstPersonMod.LOGGER.info("Applying {} pending config changes", (Object)this.pendingChanges.size());
            for (Map.Entry<String, PendingChange> entry : this.pendingChanges.entrySet()) {
                PendingChange change = entry.getValue();
                try {
                    if (change.configValue instanceof ForgeConfigSpec.BooleanValue) {
                        ((ForgeConfigSpec.BooleanValue)change.configValue).set((Object)((Boolean)change.value));
                        continue;
                    }
                    if (change.configValue instanceof ForgeConfigSpec.IntValue) {
                        ((ForgeConfigSpec.IntValue)change.configValue).set((Object)((Integer)change.value));
                        continue;
                    }
                    if (!(change.configValue instanceof ForgeConfigSpec.ConfigValue)) continue;
                    change.configValue.set(change.value);
                }
                catch (Exception e) {
                    AlienFirstPersonMod.LOGGER.error("Failed to apply config change for {}: {}", (Object)entry.getKey(), (Object)e.getMessage());
                }
            }
            try {
                AlienFirstPersonConfig.CLIENT_SPEC.save();
                AlienFirstPersonMod.LOGGER.info("Config saved successfully");
                this.pendingChanges.clear();
            }
            catch (Exception e) {
                AlienFirstPersonMod.LOGGER.error("Failed to save config: {}", (Object)e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void discardAllChanges() {
        Object object = this.lock;
        synchronized (object) {
            int count = this.pendingChanges.size();
            this.pendingChanges.clear();
            AlienFirstPersonMod.LOGGER.debug("Discarded {} pending changes", (Object)count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasPendingChanges() {
        Object object = this.lock;
        synchronized (object) {
            return !this.pendingChanges.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearPendingForCategory(String categoryPrefix) {
        Object object = this.lock;
        synchronized (object) {
            this.pendingChanges.entrySet().removeIf(entry -> ((String)entry.getKey()).startsWith(categoryPrefix));
        }
    }

    private static class PendingChange {
        final Object value;
        final ForgeConfigSpec.ConfigValue<?> configValue;

        PendingChange(Object value, ForgeConfigSpec.ConfigValue<?> configValue) {
            this.value = value;
            this.configValue = configValue;
        }
    }
}

