/*
 * Decompiled with CFR 0.152.
 */
package com.parad.alienfirstperson.config;

import com.mojang.blaze3d.systems.RenderSystem;
import com.parad.alienfirstperson.AlienFirstPersonMod;
import com.parad.alienfirstperson.AlienSoundEvents;
import com.parad.alienfirstperson.config.AlienConfigScreens;
import com.parad.alienfirstperson.config.AlienFirstPersonConfig;
import com.parad.alienfirstperson.config.AlienFirstPersonConfigScreen;
import com.parad.alienfirstperson.config.ScrollableScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CustomAlienConfigScreens {

    @OnlyIn(value=Dist.CLIENT)
    public static class LockedAlienIconButton
    extends AlienConfigScreens.AlienIconButton {
        private static final ResourceLocation LOCK_OVERLAY = new ResourceLocation("alien_first_person", "textures/gui/lock_overlay.png");
        private boolean hasLockTexture = true;
        private final ResourceLocation lockedIconTexture;

        public LockedAlienIconButton(int x, int y, int width, int height, ResourceLocation iconTexture, Component message, Button.OnPress onPress) {
            super(x, y, width, height, iconTexture, message, onPress);
            this.lockedIconTexture = iconTexture;
            try {
                Minecraft.m_91087_().m_91098_().m_213713_(LOCK_OVERLAY);
            }
            catch (Exception e) {
                this.hasLockTexture = false;
            }
        }

        @Override
        public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            int bgColor = 0x60000000;
            guiGraphics.m_280509_(this.m_252754_() - 2, this.m_252907_() - 2, this.m_252754_() + this.f_93618_ + 2, this.m_252907_() + this.f_93619_ + 2, bgColor);
            int borderColor = -10066330;
            guiGraphics.m_280509_(this.m_252754_() - 2, this.m_252907_() - 2, this.m_252754_() + this.f_93618_ + 2, this.m_252907_() - 1, borderColor);
            guiGraphics.m_280509_(this.m_252754_() - 2, this.m_252907_() + this.f_93619_ + 1, this.m_252754_() + this.f_93618_ + 2, this.m_252907_() + this.f_93619_ + 2, borderColor);
            guiGraphics.m_280509_(this.m_252754_() - 2, this.m_252907_() - 2, this.m_252754_() - 1, this.m_252907_() + this.f_93619_ + 2, borderColor);
            guiGraphics.m_280509_(this.m_252754_() + this.f_93618_ + 1, this.m_252907_() - 2, this.m_252754_() + this.f_93618_ + 2, this.m_252907_() + this.f_93619_ + 2, borderColor);
            RenderSystem.setShaderColor((float)0.5f, (float)0.5f, (float)0.5f, (float)0.6f);
            guiGraphics.m_280411_(this.lockedIconTexture, this.m_252754_(), this.m_252907_(), this.f_93618_, this.f_93619_, 0.0f, 0.0f, 16, 16, 16, 16);
            if (this.hasLockTexture) {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.8f);
                int lockSize = this.f_93618_ / 3;
                int lockX = this.m_252754_() + this.f_93618_ - lockSize - 2;
                int lockY = this.m_252907_() + this.f_93619_ - lockSize - 2;
                guiGraphics.m_280411_(LOCK_OVERLAY, lockX, lockY, lockSize, lockSize, 0.0f, 0.0f, 16, 16, 16, 16);
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            double guiScale = Minecraft.m_91087_().m_91268_().m_85449_();
            float baseTextScale = 0.85f;
            int baseTextYOffset = 6;
            if (guiScale >= 4.0) {
                baseTextYOffset = 8;
                baseTextScale = 0.6f;
            } else if (guiScale >= 3.0) {
                baseTextYOffset = 7;
                baseTextScale = 0.65f;
            }
            guiGraphics.m_280168_().m_85836_();
            int textX = this.m_252754_() + this.f_93618_ / 2;
            int textY = this.m_252907_() + this.f_93619_ + baseTextYOffset;
            guiGraphics.m_280168_().m_252880_((float)textX, (float)textY, 0.0f);
            guiGraphics.m_280168_().m_85841_(baseTextScale, baseTextScale, 1.0f);
            guiGraphics.m_280168_().m_252880_((float)(-textX), (float)(-textY), 0.0f);
            MutableComponent lockedLabel = Component.m_237113_((String)(this.m_6035_().getString() + " (Locked)"));
            guiGraphics.m_280653_(Minecraft.m_91087_().f_91062_, (Component)lockedLabel, textX, textY, -7829368);
            guiGraphics.m_280168_().m_85849_();
            RenderSystem.disableBlend();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class CustomAlienSelectionScreen
    extends ScrollableScreen {
        public CustomAlienSelectionScreen(Screen previousScreen) {
            super((Component)Component.m_237113_((String)"Custom Alien Selection"), previousScreen);
        }

        @Override
        protected void initScrollableContent() {
            int centerX = this.f_96543_ / 2;
            int currentY = 50;
            this.addScrollableWidget(Button.m_253074_((Component)Component.m_237113_((String)"Coming Soon"), button -> {}).m_252987_(centerX - 75, currentY, 150, 20).m_253136_());
            this.setContentHeight(currentY + 50);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class CustomAlienSettingsScreen
    extends ScrollableScreen {
        private boolean firstPersonEnabled = (Boolean)AlienFirstPersonConfig.CUSTOM_ALIENS_FIRST_PERSON_ENABLED.get();
        private int standingXOffset = (Integer)AlienFirstPersonConfig.CUSTOM_ALIENS_STANDING_X_OFFSET.get();
        private int sneakingXOffset = (Integer)AlienFirstPersonConfig.CUSTOM_ALIENS_SNEAKING_X_OFFSET.get();
        private int fovScaler = (Integer)AlienFirstPersonConfig.CUSTOM_ALIENS_FOV_SCALER.get();
        private boolean fovAffectsHands = (Boolean)AlienFirstPersonConfig.CUSTOM_ALIENS_FOV_AFFECTS_HANDS.get();

        public CustomAlienSettingsScreen(Screen previousScreen) {
            super((Component)Component.m_237113_((String)"Custom Alien Settings"), previousScreen);
        }

        @Override
        protected void initScrollableContent() {
            int centerX = this.f_96543_ / 2;
            int currentY = 20;
            int ySpacing = 40;
            int sliderWidth = 200;
            Button toggleButton = Button.m_253074_((Component)Component.m_237113_((String)("First Person Model: " + (this.firstPersonEnabled ? "ENABLED" : "DISABLED"))), button -> {
                this.firstPersonEnabled = !this.firstPersonEnabled;
                AlienFirstPersonConfig.CUSTOM_ALIENS_FIRST_PERSON_ENABLED.set((Object)this.firstPersonEnabled);
                this.saveConfig();
                button.m_93666_((Component)Component.m_237113_((String)("First Person Model: " + (this.firstPersonEnabled ? "ENABLED" : "DISABLED"))));
                this.rebuildScrollableContent();
            }).m_252987_(centerX - 100, currentY, 200, 20).m_253136_();
            this.addScrollableWidget(toggleButton);
            currentY += ySpacing;
            if (this.firstPersonEnabled) {
                this.addScrollableWidget(new AlienConfigScreens.IntSlider(centerX - sliderWidth / 2, currentY, sliderWidth, 20, (Component)Component.m_237113_((String)"Standing X Offset: "), (Component)Component.m_237113_((String)""), -60, 60, this.standingXOffset, value -> {
                    this.standingXOffset = value;
                    AlienFirstPersonConfig.CUSTOM_ALIENS_STANDING_X_OFFSET.set(value);
                    this.saveConfig();
                }, true));
                this.addScrollableWidget(new AlienConfigScreens.IntSlider(centerX - sliderWidth / 2, currentY += ySpacing, sliderWidth, 20, (Component)Component.m_237113_((String)"Sneaking X Offset: "), (Component)Component.m_237113_((String)""), -60, 60, this.sneakingXOffset, value -> {
                    this.sneakingXOffset = value;
                    AlienFirstPersonConfig.CUSTOM_ALIENS_SNEAKING_X_OFFSET.set(value);
                    this.saveConfig();
                }, true));
                currentY += ySpacing;
            }
            this.addScrollableWidget(new AlienConfigScreens.IntSlider(centerX - sliderWidth / 2, currentY, sliderWidth, 20, (Component)Component.m_237113_((String)"FOV Scaler: "), (Component)Component.m_237113_((String)""), -60, 60, this.fovScaler, value -> {
                this.fovScaler = value;
                AlienFirstPersonConfig.CUSTOM_ALIENS_FOV_SCALER.set(value);
                this.saveConfig();
            }, true));
            this.addScrollableWidget(Button.m_253074_((Component)Component.m_237113_((String)("FOV on Vanilla Hands: " + (this.fovAffectsHands ? "ENABLED" : "DISABLED"))), button -> {
                this.fovAffectsHands = !this.fovAffectsHands;
                AlienFirstPersonConfig.CUSTOM_ALIENS_FOV_AFFECTS_HANDS.set((Object)this.fovAffectsHands);
                this.saveConfig();
                button.m_93666_((Component)Component.m_237113_((String)("FOV on Vanilla Hands: " + (this.fovAffectsHands ? "ENABLED" : "DISABLED"))));
            }).m_252987_(centerX - 100, currentY += ySpacing, 200, 20).m_253136_());
            this.addScrollableWidget(Button.m_253074_((Component)Component.m_237113_((String)"Reset All"), button -> {
                this.standingXOffset = 0;
                this.sneakingXOffset = 0;
                this.fovScaler = 0;
                this.fovAffectsHands = true;
                AlienFirstPersonConfig.CUSTOM_ALIENS_STANDING_X_OFFSET.set((Object)0);
                AlienFirstPersonConfig.CUSTOM_ALIENS_SNEAKING_X_OFFSET.set((Object)0);
                AlienFirstPersonConfig.CUSTOM_ALIENS_FOV_SCALER.set((Object)0);
                AlienFirstPersonConfig.CUSTOM_ALIENS_FOV_AFFECTS_HANDS.set((Object)true);
                this.saveConfig();
                this.rebuildScrollableContent();
            }).m_252987_(centerX - 50, currentY += ySpacing, 100, 20).m_253136_());
            this.setContentHeight(currentY + 50);
        }

        private void saveConfig() {
            try {
                AlienFirstPersonConfig.CLIENT_SPEC.save();
            }
            catch (Exception e) {
                AlienFirstPersonMod.LOGGER.error("Failed to save config", (Throwable)e);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class CustomAliensScreen
    extends Screen {
        private final Screen previousScreen;
        private float fadeInAlpha = 1.0f;
        private boolean isClosing = false;
        private static final ResourceLocation CUSTOM_SETTINGS_ICON = new ResourceLocation("alien_first_person", "textures/gui/custom_settings.png");
        private static final ResourceLocation CUSTOM_SELECTION_ICON = new ResourceLocation("alien_first_person", "textures/gui/custom_selection.png");

        public CustomAliensScreen(Screen previousScreen) {
            super((Component)Component.m_237113_((String)"Custom Aliens"));
            this.previousScreen = previousScreen;
        }

        protected void m_7856_() {
            super.m_7856_();
            int centerX = this.f_96543_ / 2;
            int startY = 60;
            int iconSize = 64;
            int spacing = 80;
            int totalWidth = iconSize + spacing;
            int startX = centerX - totalWidth / 2;
            this.m_142416_((GuiEventListener)new AlienConfigScreens.AlienIconButton(startX, startY, iconSize, iconSize, CUSTOM_SETTINGS_ICON, (Component)Component.m_237113_((String)"Settings"), button -> this.openCustomSettings()));
            this.m_142416_((GuiEventListener)new LockedAlienIconButton(startX + spacing, startY, iconSize, iconSize, CUSTOM_SELECTION_ICON, (Component)Component.m_237113_((String)"Selection"), button -> this.openCustomSelection()));
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Back"), button -> this.m_7379_()).m_252987_(this.f_96543_ / 2 - 100, this.f_96544_ - 27, 200, 20).m_253136_());
        }

        private void openCustomSettings() {
            if (this.f_96541_ != null) {
                this.f_96541_.m_91152_((Screen)new CustomAlienSettingsScreen(this));
            }
        }

        private void openCustomSelection() {
            if (this.f_96541_ != null) {
                this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)((SoundEvent)AlienSoundEvents.FEATURE_LOCKED.get()), (float)1.0f));
            }
        }

        public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            this.m_280273_(guiGraphics);
            guiGraphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 20, 0xFFFFFF);
            super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
            if (this.fadeInAlpha > 0.0f && !this.isClosing) {
                this.fadeInAlpha = Math.max(this.fadeInAlpha - 0.01f, 0.0f);
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                RenderSystem.disableDepthTest();
                int greenColor = (int)(this.fadeInAlpha * 0.8f * 255.0f) << 24 | 0xFF00;
                guiGraphics.m_280509_(0, 0, this.f_96543_, this.f_96544_, greenColor);
                RenderSystem.enableDepthTest();
                RenderSystem.disableBlend();
            }
        }

        public void m_7379_() {
            this.isClosing = true;
            if (this.previousScreen instanceof AlienFirstPersonConfigScreen.MainConfigScreen) {
                AlienFirstPersonConfigScreen.MainConfigScreen mainScreen = (AlienFirstPersonConfigScreen.MainConfigScreen)this.previousScreen;
                mainScreen.isTransitioning = false;
                mainScreen.transitionAlpha = 0.0f;
                mainScreen.isRotating = false;
            }
            if (this.f_96541_ != null) {
                this.f_96541_.m_91152_(this.previousScreen);
            }
        }

        public boolean m_7043_() {
            return false;
        }
    }
}

