/*
 * Decompiled with CFR 0.152.
 */
package com.parad.alienfirstperson.config;

import com.parad.alienfirstperson.AlienFirstPersonMod;
import java.util.function.Consumer;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SafeIntSlider
extends AbstractSliderButton {
    private final Component prefix;
    private final Component suffix;
    private final int minValue;
    private final int maxValue;
    private final boolean showDefault;
    private final Consumer<Integer> onValueChange;
    private int intValue;
    private long lastUpdateTime = 0L;
    private static final long UPDATE_COOLDOWN_MS = 50L;
    private final Object valueLock = new Object();
    private boolean isDragging = false;

    public SafeIntSlider(int x, int y, int width, int height, Component prefix, Component suffix, int minValue, int maxValue, int initialValue, Consumer<Integer> onValueChange, boolean showDefault) {
        super(x, y, width, height, (Component)Component.m_237119_(), 0.0);
        this.prefix = prefix;
        this.suffix = suffix;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.intValue = initialValue;
        this.onValueChange = onValueChange;
        this.showDefault = showDefault;
        this.f_93577_ = (double)(initialValue - minValue) / (double)(maxValue - minValue);
        this.m_5695_();
    }

    protected void m_5695_() {
        Object valueText = this.showDefault && this.intValue == 0 ? "Default" : (this.intValue > 0 ? "+" + this.intValue : String.valueOf(this.intValue));
        this.m_93666_((Component)Component.m_237113_((String)"").m_7220_(this.prefix).m_130946_((String)valueText).m_7220_(this.suffix));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void m_5697_() {
        Object object = this.valueLock;
        synchronized (object) {
            int newValue = (int)Math.round(this.f_93577_ * (double)(this.maxValue - this.minValue) + (double)this.minValue);
            if (newValue != this.intValue) {
                long currentTime = System.currentTimeMillis();
                if (currentTime - this.lastUpdateTime >= 50L || !this.isDragging) {
                    this.intValue = newValue;
                    this.lastUpdateTime = currentTime;
                    if (this.onValueChange != null) {
                        try {
                            this.onValueChange.accept(this.intValue);
                            AlienFirstPersonMod.LOGGER.debug("Slider value changed to: {}", (Object)this.intValue);
                        }
                        catch (Exception e) {
                            AlienFirstPersonMod.LOGGER.error("Error in slider value change handler: {}", (Object)e.getMessage());
                        }
                    }
                } else {
                    this.intValue = newValue;
                }
            }
        }
    }

    public void m_5716_(double mouseX, double mouseY) {
        super.m_5716_(mouseX, mouseY);
        this.isDragging = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void m_7691_(double mouseX, double mouseY) {
        super.m_7691_(mouseX, mouseY);
        Object object = this.valueLock;
        synchronized (object) {
            this.isDragging = false;
            this.m_5697_();
        }
    }

    protected void m_7212_(double mouseX, double mouseY, double dragX, double dragY) {
        super.m_7212_(mouseX, mouseY, dragX, dragY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(int value) {
        Object object = this.valueLock;
        synchronized (object) {
            this.intValue = value;
            this.f_93577_ = (double)(value - this.minValue) / (double)(this.maxValue - this.minValue);
            this.m_5695_();
            if (this.onValueChange != null) {
                this.onValueChange.accept(this.intValue);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIntValue() {
        Object object = this.valueLock;
        synchronized (object) {
            return this.intValue;
        }
    }
}

